/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.util.Arrays;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.cMsg.common.cMsgMessageFull;

public class cMsgTestPayload {
    private String subject = "SUBJECT";
    private String type = "TYPE";
    private String name = "payload tester";
    private String description = "java producer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private String text;
    private char[] textChars;
    private int textSize;
    private boolean sendText;
    private byte[] binArray;
    private int binSize;
    private boolean sendBinary;
    private int delay;
    private int count = 50000;
    private boolean debug;
    private boolean useSyncSend;
    cMsg coda;

    cMsgTestPayload(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgTestPayload.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-ss")) {
                this.useSyncSend = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-text")) {
                this.text = args[i + 1];
                this.sendText = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-textsize")) {
                this.textSize = Integer.parseInt(args[i + 1]);
                this.textChars = new char[this.textSize];
                Arrays.fill(this.textChars, 'A');
                this.text = new String(this.textChars);
                System.out.println("text len = " + this.text.length());
                this.sendText = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-binsize")) {
                this.binSize = Integer.parseInt(args[i + 1]);
                this.binArray = new byte[this.binSize];
                for (int j = 0; j < this.binSize; ++j) {
                    this.binArray[j] = (byte)(j % 256);
                }
                System.out.println("binary size = " + this.binSize);
                this.sendBinary = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                this.count = Integer.parseInt(args[i + 1]);
                if (this.count < 1) {
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            cMsgTestPayload.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgTestPayload\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-c <count>]         set # of messages to send before printing output\n        [-text <text>]       set text of sent messages\n        [-textsize <size>]   set text to 'size' number of ASCII chars (bytes)\n        [-binsize <size>]    set binary array to 'size' number of bytes\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-ss]                use syncSend instead of send\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            cMsgTestPayload tp = new cMsgTestPayload(args);
            tp.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    private static String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg producer sending to:\n    subject = " + this.subject + "\n    type    = " + this.type);
        }
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        this.coda.start();
        myCallback cb3 = new myCallback();
        cMsgSubscriptionHandle unsub = this.coda.subscribe(this.subject, this.type, cb3, null);
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.setSubject(this.subject);
        msg.setType(this.type);
        msg.setText("Some test text");
        msg.setHistoryLengthMax(4);
        if (this.sendBinary) {
            msg.setByteArray(this.binArray, 10, 10);
        }
        byte[] ba = new byte[]{-128, -1, 127};
        cMsgPayloadItem item6 = new cMsgPayloadItem("BYTE_ARRAY", ba);
        msg.addPayloadItem(item6);
        byte[] binnie = new byte[256];
        for (int j = -128; j < 128; ++j) {
            binnie[j + 128] = (byte)j;
        }
        cMsgPayloadItem item12 = new cMsgPayloadItem("BINNIE", binnie, 2);
        msg.addPayloadItem(item12);
        byte[] binArray1 = new byte[]{-1, -2, -3};
        byte[] binArray2 = new byte[]{10, 20, 30};
        byte[] binArray3 = new byte[]{-7, -8, -9};
        byte[][] bb = new byte[3][];
        byte[][] bb2 = new byte[3][];
        bb[0] = binArray1;
        bb[1] = binArray2;
        bb[2] = binArray3;
        bb2[0] = binnie;
        bb2[1] = binnie;
        bb2[2] = binnie;
        cMsgPayloadItem item13 = new cMsgPayloadItem("BIN_ARRAY", bb);
        msg.addPayloadItem(item13);
        this.coda.send(msg);
        String XML = msg.toString();
        byte[] byt = msg.getByteArray();
        System.out.println("Byte Array = " + byt);
        System.out.println("Msg XML:\n" + XML);
        cMsgMessage newMsg = cMsgMessageFull.parseXml(XML);
        System.out.println("\n\n\n****************************************************\n\n\n");
        System.out.println("newMsg reconstituted text = " + newMsg.getText());
        System.out.println("newMsg subject = " + newMsg.getSubject());
        System.out.println("\n\n\n****************************************************\n\n\n");
        byt = newMsg.getByteArray();
        System.out.println("Byte Array = " + byt);
        if (byt != null) {
            for (int kk = 0; kk < byt.length; ++kk) {
                System.out.println("bin[" + kk + "] = " + byt[kk]);
            }
        }
        System.out.println("Byte Array End");
        byte[][] myBin = newMsg.getPayloadItem("BIN_ARRAY").getBinaryArray();
        for (int k = 0; k < myBin.length; ++k) {
            System.out.println("bin array #" + (k + 1) + ":");
            for (int kk = 0; kk < myBin[k].length; ++kk) {
                System.out.println("bin[" + kk + "] = " + myBin[k][kk]);
            }
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Done");
    }

    class myCallback
    extends cMsgCallbackAdapter {
        myCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            cMsgTestPayload.this.count++;
            if (msg.hasPayload()) {
                System.out.println("Received msg has payload = \n" + msg.toString());
                byte[] byt = msg.getByteArray();
                System.out.println("CB Byte Array = " + byt);
                if (byt != null) {
                    for (int kk = 0; kk < byt.length; ++kk) {
                        System.out.println("bin[" + kk + "] = " + byt[kk]);
                    }
                }
                System.out.println("CB Byte Array End");
                try {
                    byte[][] myBin = msg.getPayloadItem("BIN_ARRAY").getBinaryArray();
                    for (int k = 0; k < myBin.length; ++k) {
                        System.out.println("bin array #" + (k + 1) + ":");
                        for (int kk = 0; kk < myBin[k].length; ++kk) {
                            System.out.println("bin[" + kk + "] = " + myBin[k][kk]);
                        }
                    }
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                }
            }
            if (cMsgTestPayload.this.delay != 0) {
                try {
                    Thread.sleep(cMsgTestPayload.this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

