/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;

public class VardanClient {
    private String name = "Vardan_Client";
    private String description = "vardan client";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private boolean debug;
    private long countIn;
    private long countOut;
    private int delay;
    private int loops = 300;
    private long time1;
    private long time2;
    private cMsg coda;
    private cMsgSubscriptionHandle subHandle;

    VardanClient(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                VardanClient.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            VardanClient.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java VardanClient\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-debug]             turn on printout\n        [-delay]             time in millisec to wait between sends\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            VardanClient consumer = new VardanClient(args);
            consumer.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running Vardan client");
        }
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.setDebug(4);
        this.coda.connect();
        this.coda.start();
        System.out.println("Subscribe to " + this.name + "/start");
        startCb cb3 = new startCb();
        cMsgSubscriptionHandle subHandle2 = this.coda.subscribe(this.name, "start", cb3, null);
        System.out.println("Send message to admin/send");
        cMsgMessage msg = new cMsgMessage();
        msg.setSubject("admin");
        msg.setType("send");
        msg.setText(this.name);
        this.coda.send(msg);
        long totalT = 0L;
        long totalC = 0L;
        long period = 5000L;
        while (true) {
            this.countIn = 0L;
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            double freq = (double)this.countIn / (double)period * 1000.0;
            double freqAvg = (double)(totalC += this.countIn) / (double)(totalT += period) * 1000.0;
            if (this.debug) {
                System.out.println("count = " + this.countIn + ", " + this.doubleToString(freq, 1) + " Hz, Avg = " + this.doubleToString(freqAvg, 1) + " Hz");
            }
            System.out.println("The cue is full = " + this.subHandle.isQueueFull());
            System.out.println("Cue size = " + this.subHandle.getQueueSize());
            if (this.subHandle.isQueueFull()) {
                this.subHandle.clearQueue();
                System.out.println("Cleared cue");
            }
            if (this.coda.isConnected()) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.coda.isConnected()) continue;
            System.out.println("No longer connected to domain server, quitting");
            System.exit(-1);
        }
    }

    class receivingCb
    extends cMsgCallbackAdapter {
        receivingCb() {
        }

        @Override
        public int getMaximumQueueSize() {
            return 200;
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            System.out.println("\nReceived " + VardanClient.this.name + "/data message from server");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (VardanClient.this.countIn == 0L) {
                VardanClient.this.time1 = System.currentTimeMillis();
            }
            VardanClient.this.countIn++;
            if (VardanClient.this.countIn % (long)VardanClient.this.loops == 0L) {
                VardanClient.this.time2 = System.currentTimeMillis();
                long deltaT = VardanClient.this.time2 - VardanClient.this.time1;
                double freq = (double)VardanClient.this.loops / (double)deltaT * 1000.0;
                System.out.println("Receiving at " + VardanClient.this.doubleToString(freq, 1) + " Hz, count = " + VardanClient.this.countIn);
                VardanClient.this.time1 = VardanClient.this.time2;
            }
        }
    }

    class startCb
    extends cMsgCallbackAdapter {
        startCb() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            System.out.println("\nReceived " + VardanClient.this.name + "/start message from server");
            try {
                System.out.println("Subscribe to " + VardanClient.this.name + "/data");
                receivingCb cb3 = new receivingCb();
                VardanClient.this.subHandle = VardanClient.this.coda.subscribe(VardanClient.this.name, "data", cb3, null);
                cMsgMessage message = new cMsgMessage();
                message.setSubject(VardanClient.this.name);
                message.setType("sendone");
                message.setText(VardanClient.this.name);
                System.out.println("Send periodic msgs to " + VardanClient.this.name + "/sendone");
                while (true) {
                    VardanClient.this.coda.send(message);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (cMsgException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

