/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;

public class cMsgUtilities {
    public static int bytesToInt(byte[] b, int off) {
        return (b[off] & 0xFF) << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    public static void intToBytes(int intVal, byte[] b, int off) {
        b[off] = (byte)((intVal & 0xFF000000) >>> 24);
        b[off + 1] = (byte)((intVal & 0xFF0000) >>> 16);
        b[off + 2] = (byte)((intVal & 0xFF00) >>> 8);
        b[off + 3] = (byte)(intVal & 0xFF);
    }

    public static short bytesToShort(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) << 8 | b[off] & 0xFF);
    }

    public static void shortToBytes(short val, byte[] b, int off) {
        b[off] = (byte)((val & 0xFF00) >>> 8);
        b[off + 1] = (byte)(val & 0xFF);
    }

    public static long bytesToLong(byte[] b, int off) {
        return ((long)b[off] & 0xFFL) << 56 | ((long)b[off + 1] & 0xFFL) << 48 | ((long)b[off + 2] & 0xFFL) << 40 | ((long)b[off + 3] & 0xFFL) << 32 | ((long)b[off + 4] & 0xFFL) << 24 | ((long)b[off + 5] & 0xFFL) << 16 | ((long)b[off + 6] & 0xFFL) << 8 | (long)b[off + 7] & 0xFFL;
    }

    public static void printBuffer(ByteBuffer buf, int position, int words, String label) {
        IntBuffer ibuf;
        if (buf == null) {
            System.out.println("printBuffer: buf arg is null");
            return;
        }
        int origPos = buf.position();
        buf.position(position);
        if (label != null) {
            System.out.println(label + ":");
        }
        words = words > (ibuf = buf.asIntBuffer()).capacity() ? ibuf.capacity() : words;
        for (int i = 0; i < words; ++i) {
            if (i % 5 == 0) {
                System.out.print("\n  Buf(" + (i + 1) + "-" + (i + 5) + ") =  ");
            }
            System.out.print(String.format("%08x", ibuf.get(i)) + "  ");
        }
        System.out.println();
        System.out.println();
        buf.position(origPos);
    }

    public static void printBytes(ByteBuffer buf, int position, int bytes, String label) {
        if (buf == null) {
            System.out.println("printBuffer: buf arg is null");
            return;
        }
        int origPos = buf.position();
        buf.position(position);
        int n = bytes = bytes + position > buf.capacity() ? buf.capacity() - position : bytes;
        if (label != null) {
            System.out.println(label + ":");
        }
        for (int i = 0; i < bytes; ++i) {
            if (i % 20 == 0) {
                System.out.print("\n  Buf(" + (i + 1) + "-" + (i + 20) + ") =  ");
            } else if (i % 4 == 0) {
                System.out.print("  ");
            }
            System.out.print(String.format("%02x", buf.get(i)));
        }
        System.out.println();
        System.out.println();
        buf.position(origPos);
    }

    public static void printBytes(byte[] array, int offset, int bytes, String label) {
        int limit;
        if (array == null) {
            System.out.println("printBuffer: array arg is null");
            return;
        }
        if (offset < 0 || bytes < 0) {
            System.out.println("printBuffer: offset and bytes args must be >= 0");
            return;
        }
        int n = limit = bytes + offset > array.length ? array.length : bytes + offset;
        if (label != null) {
            System.out.println(label + ":");
        }
        for (int i = offset; i < limit; ++i) {
            if (i % 20 == 0) {
                System.out.print("\n  array[" + (i + 1) + "-" + (i + 20) + "] =  ");
            } else if (i % 4 == 0) {
                System.out.print("  ");
            }
            System.out.print(String.format("%02x", array[i]));
        }
        System.out.println();
        System.out.println();
    }

    public static Collection<String> getAllIpAddresses() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        try {
            String canonicalIP = InetAddress.getByName(InetAddress.getLocalHost().getCanonicalHostName()).getHostAddress();
            if (canonicalIP != null) {
                set.add(canonicalIP);
            }
        }
        catch (UnknownHostException canonicalIP) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : inAddrs) {
                    InetAddress addr = ifAddr.getAddress();
                    if (addr.getAddress().length != 4) continue;
                    set.add(addr.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return set;
    }

    public static Collection<String> getAllBroadcastAddresses() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : inAddrs) {
                    Inet4Address bAddr;
                    try {
                        bAddr = (Inet4Address)ifAddr.getBroadcast();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    if (bAddr == null) continue;
                    set.add(bAddr.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (set.size() < 1) {
            set.add("255.255.255.255");
        }
        return set;
    }

    public static String getBroadcastAddress(String ip) throws cMsgException {
        if (ip == null) {
            return null;
        }
        byte[] ipBytes = cMsgUtilities.isDottedDecimal(ip);
        if (ipBytes == null) {
            throw new cMsgException("arg is not in dot-decimal (textual presentation) format");
        }
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ifAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : ifAddrs) {
                    Inet4Address addrv4;
                    try {
                        addrv4 = (Inet4Address)ifAddr.getAddress();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    if (ip.equals(addrv4.getHostAddress())) {
                        return ifAddr.getBroadcast().getHostAddress();
                    }
                    if (!ip.equals(ifAddr.getBroadcast().getHostAddress())) continue;
                    return ip;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static List<InterfaceAddress> getAllIpInfo() {
        LinkedList<InterfaceAddress> ipList = new LinkedList<InterfaceAddress>();
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : inAddrs) {
                    InetAddress addr = ifAddr.getAddress();
                    if (addr.getAddress().length != 4) continue;
                    ipList.add(ifAddr);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ipList;
    }

    public static String getMatchingLocalIpAddress(String ip) throws cMsgException {
        if (ip == null) {
            return null;
        }
        byte[] ipBytes = cMsgUtilities.isDottedDecimal(ip);
        if (ipBytes == null) {
            throw new cMsgException("arg is not in dot-decimal (textual presentation) format");
        }
        try {
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                NetworkInterface ni = enumer.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ifAddrs = ni.getInterfaceAddresses();
                for (InterfaceAddress ifAddr : ifAddrs) {
                    Inet4Address addrv4;
                    try {
                        addrv4 = (Inet4Address)ifAddr.getAddress();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    if (ip.equals(addrv4.getHostAddress())) {
                        return ip;
                    }
                    if (!ip.equals(ifAddr.getBroadcast().getHostAddress())) continue;
                    return addrv4.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static List<String> orderIPAddresses(List<String> ipAddresses, List<String> broadAddresses, String preferredAddress) {
        if (ipAddresses == null) {
            return null;
        }
        LinkedList<String> ipList = new LinkedList<String>();
        LinkedList<String> preferred = new LinkedList<String>();
        String prefSubnet = null;
        try {
            prefSubnet = cMsgUtilities.getBroadcastAddress(preferredAddress);
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        block6: for (int i = 0; i < ipAddresses.size(); ++i) {
            if (broadAddresses != null && broadAddresses.size() > i) {
                String ipSubNet = broadAddresses.get(i);
                try {
                    Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                    while (enumer.hasMoreElements()) {
                        NetworkInterface ni = enumer.nextElement();
                        if (!ni.isUp() || ni.isLoopback()) continue;
                        List<InterfaceAddress> ifAddrs = ni.getInterfaceAddresses();
                        for (InterfaceAddress ifAddr : ifAddrs) {
                            try {
                                Inet4Address addrv4 = (Inet4Address)ifAddr.getAddress();
                            }
                            catch (ClassCastException e) {
                                continue;
                            }
                            String localBroadcastAddr = ifAddr.getBroadcast().getHostAddress();
                            if (prefSubnet != null && prefSubnet.equals(ipSubNet) && prefSubnet.equals(localBroadcastAddr)) {
                                preferred.add(ipAddresses.get(i));
                                continue block6;
                            }
                            if (!localBroadcastAddr.equals(ipSubNet)) continue;
                            ipList.addFirst(ipAddresses.get(i));
                            continue block6;
                        }
                    }
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
            ipList.addLast(ipAddresses.get(i));
        }
        ipList.addAll(0, preferred);
        return ipList;
    }

    public static int getNetworkAddressInt(byte[] addr, short netPrefixLen) {
        if (addr == null || netPrefixLen < 0 || netPrefixLen > 32) {
            return -1;
        }
        int intAddr = 0;
        for (int i = 0; i < 4; ++i) {
            intAddr |= (addr[i] & 0xFF) << 8 * (3 - i);
        }
        int intNetMask = 0;
        for (int j = 0; j < netPrefixLen; ++j) {
            intNetMask |= 1 << 31 - j;
        }
        return intAddr & intNetMask;
    }

    public static String getNetworkAddressString(byte[] addr, short netPrefixLen) {
        if (addr == null || netPrefixLen < 0 || netPrefixLen > 32) {
            return null;
        }
        int network = cMsgUtilities.getNetworkAddressInt(addr, netPrefixLen);
        byte[] ret = new byte[4];
        for (int j = 3; j >= 0; --j) {
            int n = j;
            ret[n] = (byte)(ret[n] | network >>> 8 * (3 - j));
        }
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < ret.length; ++i) {
            int bite = ret[i] & 0xFF;
            strBuilder.append(bite);
            if (i == ret.length - 1) continue;
            strBuilder.append(".");
        }
        return strBuilder.toString();
    }

    public static String getNetworkAddressString(String hostDottedDecimal, short netPrefixLen) {
        if (hostDottedDecimal == null || netPrefixLen < 0 || netPrefixLen > 32) {
            return null;
        }
        String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
        Pattern pattern = Pattern.compile(IP_ADDRESS);
        Matcher matcher = pattern.matcher(hostDottedDecimal);
        if (!matcher.matches()) {
            return null;
        }
        try {
            int[] hostInts = new int[4];
            for (int i = 1; i <= 4; ++i) {
                hostInts[i - 1] = Integer.parseInt(matcher.group(i));
                if (hostInts[i - 1] <= 255) continue;
                return null;
            }
            byte[] hostBytes = new byte[]{(byte)hostInts[0], (byte)hostInts[1], (byte)hostInts[2], (byte)hostInts[3]};
            return cMsgUtilities.getNetworkAddressString(hostBytes, netPrefixLen);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static byte[] isDottedDecimal(String ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
        Pattern pattern = Pattern.compile(IP_ADDRESS);
        Matcher matcher = pattern.matcher(ipAddress);
        if (!matcher.matches()) {
            return null;
        }
        int[] hostInts = new int[4];
        for (int i = 1; i <= 4; ++i) {
            hostInts[i - 1] = Integer.parseInt(matcher.group(i));
            if (hostInts[i - 1] <= 255 && hostInts[i - 1] >= 0) continue;
            return null;
        }
        byte[] hostBytes = new byte[]{(byte)hostInts[0], (byte)hostInts[1], (byte)hostInts[2], (byte)hostInts[3]};
        return hostBytes;
    }

    public static boolean isHostLocal(String hostName) {
        if (hostName == null || hostName.length() < 1) {
            return false;
        }
        if (hostName.equals("127.0.0.1")) {
            return true;
        }
        Collection<String> localIps = cMsgUtilities.getAllIpAddresses();
        try {
            InetAddress[] hostAddrs = InetAddress.getAllByName(hostName);
            for (String local : localIps) {
                for (InetAddress hAddr : hostAddrs) {
                    if (!local.equals(hAddr.getHostAddress())) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isHostSame(String hostName1, String hostName2) {
        if (hostName1 == null || hostName1.length() < 1) {
            return false;
        }
        if (hostName2 == null || hostName2.length() < 1) {
            return false;
        }
        try {
            String canonicalHost1 = InetAddress.getByName(hostName1).getCanonicalHostName();
            String canonicalHost2 = InetAddress.getByName(hostName2).getCanonicalHostName();
            if (canonicalHost1.equalsIgnoreCase(canonicalHost2)) {
                return true;
            }
            InetAddress[] hostAddrs1 = InetAddress.getAllByName(hostName1);
            InetAddress[] hostAddrs2 = InetAddress.getAllByName(hostName2);
            for (InetAddress lAddr : hostAddrs1) {
                for (InetAddress hAddr : hostAddrs2) {
                    if (!lAddr.equals(hAddr)) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static ByteChannel wrapChannel2(ByteChannel channel) {
        return channel;
    }

    public static ByteChannel wrapChannel(final ByteChannel channel) {
        return new ByteChannel(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                return channel.write(src);
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                return channel.read(dst);
            }

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        };
    }

    public static int readSocketBytesPlain(ByteBuffer buffer, SocketChannel channel, int bytes) throws IOException {
        int count;
        int n;
        buffer.clear();
        buffer.limit(bytes);
        for (count = 0; count < bytes; count += n) {
            n = channel.read(buffer);
            if (n >= 0) continue;
            throw new IOException("readSocketBytes: client's socket is dead");
        }
        return count;
    }

    public static int readSocketBytes(ByteBuffer buffer, SocketChannel channel, int bytes, int debug) throws IOException {
        int tries = 0;
        int count = 0;
        int maxTries = 200;
        buffer.clear();
        buffer.limit(bytes);
        while (count < bytes) {
            int n = channel.read(buffer);
            if (n < 0) {
                throw new IOException("readSocketBytes: client's socket is dead");
            }
            if ((count += n) >= bytes) break;
            if (tries > maxTries) {
                throw new IOException("readSocketBytes: too many tries to read " + n + " bytes");
            }
            if (debug >= 4 && ++tries == maxTries) {
                System.out.println("readSocketBytes: called read " + tries + " times, read " + n + " bytes");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return count;
    }

    public static String printError(int error, int debug) {
        String reason;
        switch (error) {
            case 0: {
                String reason2 = "action completed successfully";
                if (debug > 2) {
                    System.out.println("ok: " + reason2);
                }
                return reason2;
            }
            case 1: {
                reason = "generic error return";
                break;
            }
            case 2: {
                reason = "no response from cMsg server within timeout period";
                break;
            }
            case 3: {
                reason = "function not implemented";
                break;
            }
            case 4: {
                reason = "one or more arguments bad";
                break;
            }
            case 5: {
                reason = "one or more arguments in the wrong format";
                break;
            }
            case 6: {
                reason = "domain type not supported";
                break;
            }
            case 7: {
                reason = "another process in this domain is using this name";
                break;
            }
            case 8: {
                reason = "connection to server needs to be made";
                break;
            }
            case 9: {
                reason = "connection to server already exists";
                break;
            }
            case 10: {
                reason = "connection to cMsg server lost";
                break;
            }
            case 11: {
                reason = "error talking to cMsg server";
                break;
            }
            case 12: {
                reason = "error setting socket options";
                break;
            }
            case 13: {
                reason = "error waiting for messages to arrive";
                break;
            }
            case 14: {
                reason = "pend received illegal message type";
                break;
            }
            case 15: {
                reason = "out of memory";
                break;
            }
            case 16: {
                reason = "argument is out of range";
                break;
            }
            case 17: {
                reason = "trying to create too many of something";
                break;
            }
            case 18: {
                reason = "intVal does not match any existing domain";
                break;
            }
            case 19: {
                reason = "message is not in the correct form";
                break;
            }
            case 20: {
                reason = "UDL does not match the server type";
                break;
            }
            case 21: {
                reason = "java class cannot be found";
                break;
            }
            case 22: {
                reason = "error due to being different version";
                break;
            }
            case 23: {
                reason = "error due to wrong password";
                break;
            }
            case 24: {
                reason = "error due to server dying";
                break;
            }
            case 25: {
                reason = "error due to aborted procedure";
                break;
            }
            default: {
                String reason3 = "no such error (" + error + ")";
                if (debug > 2) {
                    System.out.println("error: " + reason3);
                }
                return reason3;
            }
        }
        if (debug > 2) {
            System.out.println("error: " + reason);
        }
        return reason;
    }

    public static String constructServerName(String s) throws cMsgException {
        int port;
        int index = s.indexOf(":");
        if (index == -1) {
            throw new cMsgException("arg is not in the \"host:port\" format");
        }
        String sName = s.substring(0, index);
        String sPort = s.substring(index + 1);
        try {
            port = Integer.parseInt(sPort);
        }
        catch (NumberFormatException e) {
            throw new cMsgException("port needs to be an integer");
        }
        if (port < 1024 || port > 65535) {
            throw new cMsgException("port needs to be an integer between 1024 & 65535");
        }
        boolean doingMulticast = false;
        InetAddress address = null;
        try {
            if (sName.equalsIgnoreCase("localhost")) {
                address = InetAddress.getLocalHost();
            } else if (sName.equalsIgnoreCase("multicast")) {
                doingMulticast = true;
            } else {
                address = InetAddress.getByName(sName);
            }
        }
        catch (UnknownHostException e) {
            throw new cMsgException("specified server is unknown");
        }
        s = doingMulticast ? "multicast:" + sPort : address.getCanonicalHostName() + ":" + sPort;
        return s;
    }
}

