/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgDomain.client.cMsgClientListeningThread;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgDomainAdapter;
import org.jlab.coda.cMsg.common.cMsgDomainInterface;
import org.jlab.coda.cMsg.common.cMsgGetHelper;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgShutdownHandlerInterface;
import org.jlab.coda.cMsg.common.cMsgSubscription;

public class cMsg
extends cMsgDomainAdapter {
    ParsedUDL currentParsedUDL;
    private List<ParsedUDL> failoverUdls;
    private volatile byte failoverIndex;
    volatile boolean useFailovers;
    private AtomicBoolean resubscriptionsComplete = new AtomicBoolean();
    private boolean haveLocalCloudServer;
    private Map<String, ParsedUDL> cloudServers;
    private MulticastSocket udpSocket;
    private DatagramSocket sendUdpSocket;
    private DatagramPacket sendUdpPacket;
    private CountDownLatch multicastResponse;
    ArrayList<String> ipList = new ArrayList(20);
    ArrayList<String> broadList = new ArrayList(20);
    String domainServerHost;
    int domainServerPort;
    private int domainServerUdpPort;
    Socket domainOutSocket;
    DataOutputStream domainOut;
    Socket keepAliveSocket;
    public String monitorXML = "";
    private String userXML;
    private final int sleepTime = 2000;
    cMsgClientListeningThread listeningThread;
    KeepAlive keepAliveThread;
    UpdateServer updateServerThread;
    public ConcurrentHashMap<cMsgSubscription, String> subscriptions;
    private Map<Object, cMsgSubscription> unsubscriptions;
    ConcurrentHashMap<Integer, cMsgSubscription> subscribeAndGets;
    ConcurrentHashMap<Integer, cMsgGetHelper> sendAndGets;
    ConcurrentHashMap<Integer, cMsgGetHelper> syncSends;
    private volatile boolean mayConnect;
    private boolean udlsParsed;
    private volatile boolean disconnectCalled;
    private final ReentrantReadWriteLock methodLock = new ReentrantReadWriteLock();
    Lock connectLock = this.methodLock.writeLock();
    Lock notConnectLock = this.methodLock.readLock();
    Lock subscribeLock = new ReentrantLock();
    Lock socketLock = new ReentrantLock();
    AtomicInteger uniqueId;
    int uniqueClientKey;
    boolean hasSend;
    boolean hasSyncSend;
    boolean hasSubscribeAndGet;
    boolean hasSendAndGet;
    boolean hasSubscribe;
    boolean hasUnsubscribe;
    boolean hasShutdown;
    private long numTcpSends;
    private long numUdpSends;
    private long numSyncSends;
    private long numSendAndGets;
    private long numSubscribeAndGets;
    private long numSubscribes;
    private long numUnsubscribes;

    public cMsg() throws cMsgException {
        this.domain = "cMsg";
        this.subscriptions = new ConcurrentHashMap(20);
        this.subscribeAndGets = new ConcurrentHashMap(20);
        this.sendAndGets = new ConcurrentHashMap(20);
        this.syncSends = new ConcurrentHashMap(10);
        this.uniqueId = new AtomicInteger();
        this.unsubscriptions = Collections.synchronizedMap(new HashMap(20));
        this.failoverUdls = Collections.synchronizedList(new ArrayList(20));
        this.cloudServers = Collections.synchronizedMap(new LinkedHashMap(20));
        this.mayConnect = true;
        try {
            this.host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new cMsgException("cMsg: cannot find host name");
        }
        class MyShutdownHandler
        implements cMsgShutdownHandlerInterface {
            cMsgDomainInterface cMsgObject;

            MyShutdownHandler(cMsgDomainInterface cMsgObject) {
                this.cMsgObject = cMsgObject;
            }

            @Override
            public void handleShutdown() {
                try {
                    this.cMsgObject.disconnect();
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
        }
        this.setShutdownHandler(new MyShutdownHandler(this));
    }

    private boolean failoverSuccessful(boolean waitForResubscribes) {
        if (!this.useFailovers) {
            return false;
        }
        for (int i = 0; i < 20; ++i) {
            this.notConnectLock.unlock();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.notConnectLock.lock();
            if (!(waitForResubscribes ? this.connected && this.resubscriptionsComplete.get() : this.connected)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUDL(String UDL) throws cMsgException {
        if (UDL == null) {
            throw new cMsgException("UDL argument is null");
        }
        this.UDL = UDL;
        String[] UDLstrings = UDL.split(";");
        if (this.debug >= 4) {
            for (int i = 0; i < UDLstrings.length; ++i) {
                System.out.println("UDL #" + i + " = " + UDLstrings[i]);
            }
        }
        ArrayList<ParsedUDL> failoverList = new ArrayList<ParsedUDL>(UDLstrings.length);
        for (String udl : UDLstrings) {
            failoverList.add(this.parseUDL(udl));
        }
        List<ParsedUDL> list = this.failoverUdls;
        synchronized (list) {
            this.failoverUdls.clear();
            for (ParsedUDL p : failoverList) {
                this.failoverUdls.add(p);
            }
            this.failoverIndex = (byte)-1;
            this.useFailovers = this.failoverUdls.size() > 1 || this.failoverUdls.get((int)0).failover == 1 || this.failoverUdls.get((int)0).failover == 2;
        }
    }

    @Override
    public String getCurrentUDL() {
        if (this.currentParsedUDL == null) {
            return null;
        }
        return this.currentParsedUDL.UDL;
    }

    @Override
    public String getServerHost() {
        if (this.currentParsedUDL == null) {
            return null;
        }
        return this.currentParsedUDL.nameServerHost;
    }

    @Override
    public int getServerPort() {
        if (this.currentParsedUDL == null) {
            return 0;
        }
        return this.currentParsedUDL.nameServerTcpPort;
    }

    @Override
    public String getInfo(String cmd) {
        if (cmd.equals("serverName")) {
            if (this.currentParsedUDL == null) {
                return null;
            }
            return this.currentParsedUDL.nameServerHost + ":" + this.currentParsedUDL.nameServerTcpPort;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void connect() throws cMsgException {
        block19: {
            this.connectLock.lock();
            if (!this.udlsParsed) {
                this.setUDL(this.UDL);
                this.udlsParsed = true;
            }
            List<ParsedUDL> list = this.failoverUdls;
            // MONITORENTER : list
            if (!this.connected) {
                if (!this.mayConnect) {
                    this.localDisconnect(false);
                }
                break block19;
            }
            if (this.currentParsedUDL != null && !this.currentParsedUDL.mustMulticast && this.currentParsedUDL.UDL.equals(this.failoverUdls.get((int)0).UDL)) {
                // MONITOREXIT : list
                this.connectLock.unlock();
                return;
            }
            this.localDisconnect(false);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.failoverIndex = (byte)-1;
        while (true) {
            this.failoverIndex = (byte)(this.failoverIndex + 1);
            this.currentParsedUDL = this.failoverUdls.get(this.failoverIndex);
            if (this.debug >= 4) {
                System.out.println("Trying to connect with UDL = " + this.currentParsedUDL.UDL);
            }
            try {
                ArrayList<String> orderedIpList;
                if (this.currentParsedUDL.mustMulticast) {
                    this.connectWithMulticast();
                    orderedIpList = cMsgUtilities.orderIPAddresses(this.ipList, this.broadList, this.currentParsedUDL.preferredSubnet);
                } else {
                    orderedIpList = new ArrayList<String>(1);
                    orderedIpList.add(this.currentParsedUDL.nameServerHost);
                }
                this.connectDirect(orderedIpList);
                this.restoreSubscriptions();
                this.mayConnect = false;
                // MONITOREXIT : list
                this.connectLock.unlock();
                return;
            }
            catch (cMsgException e) {
                try {
                    this.currentParsedUDL = null;
                    cMsgException ex = e;
                    if (this.failoverIndex < this.failoverUdls.size() - 1) continue;
                    // MONITOREXIT : list
                    throw new cMsgException("connect: all UDLs failed", ex);
                }
                catch (Throwable throwable) {
                    this.connectLock.unlock();
                    throw throwable;
                }
            }
            break;
        }
    }

    protected void connectWithMulticast() throws cMsgException {
        DatagramPacket udpPacket;
        this.multicastResponse = new CountDownLatch(1);
        InetAddress multicastAddr = null;
        try {
            multicastAddr = InetAddress.getByName("239.220.0.0");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        DataOutputStream out = new DataOutputStream(baos);
        try {
            out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
            out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
            out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
            out.writeInt(6);
            out.writeInt(1);
            out.writeInt(this.currentParsedUDL.password.length());
            try {
                out.write(this.currentParsedUDL.password.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            out.flush();
            out.close();
            this.udpSocket = new MulticastSocket();
            int tries = 20;
            while (this.udpSocket.getLocalPort() > 44999 && this.udpSocket.getLocalPort() < 46200) {
                this.udpSocket = new MulticastSocket();
                if (--tries >= 0) continue;
            }
            this.udpSocket.setSoTimeout(1000);
            this.udpSocket.setReceiveBufferSize(1024);
            this.udpSocket.setTimeToLive(32);
            byte[] buf = baos.toByteArray();
            udpPacket = new DatagramPacket(buf, buf.length, multicastAddr, this.currentParsedUDL.nameServerUdpPort);
        }
        catch (IOException e) {
            try {
                out.close();
            }
            catch (IOException buf) {
                // empty catch block
            }
            try {
                baos.close();
            }
            catch (IOException buf) {
                // empty catch block
            }
            if (this.udpSocket != null) {
                this.udpSocket.close();
            }
            throw new cMsgException("Cannot create multicast packet", e);
        }
        this.ipList.clear();
        this.broadList.clear();
        UdpReceiver receiver = new UdpReceiver();
        receiver.start();
        Multicaster sender = new Multicaster(udpPacket);
        sender.start();
        boolean response = false;
        if (this.currentParsedUDL.multicastTimeout > 0) {
            try {
                if (this.multicastResponse.await(this.currentParsedUDL.multicastTimeout, TimeUnit.MILLISECONDS)) {
                    response = true;
                }
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTING WAIT FOR MULTICAST RESPONSE, (timeout specified)");
            }
        } else {
            try {
                this.multicastResponse.await();
                response = true;
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTING WAIT FOR MULTICAST RESPONSE, (timeout NOT specified)");
            }
        }
        sender.interrupt();
        if (!response) {
            receiver.interrupt();
            throw new cMsgException("No response to UDP multicast received");
        }
        if (this.failoverIndex < this.failoverUdls.size() && this.currentParsedUDL != null) {
            this.currentParsedUDL.local = cMsgUtilities.isHostLocal(this.currentParsedUDL.nameServerHost);
        }
    }

    private void connectDirect(List<String> addrs) throws cMsgException {
        block11: {
            IOException ex = null;
            Socket nsSocket = null;
            for (String ip : addrs) {
                try {
                    nsSocket = new Socket(ip, this.currentParsedUDL.nameServerTcpPort);
                    this.currentParsedUDL.nameServerHost = ip;
                    nsSocket.setTcpNoDelay(true);
                    break;
                }
                catch (IOException e) {
                    ex = e;
                }
            }
            if (nsSocket == null) {
                throw new cMsgException("connect: cannot create socket to name server", ex);
            }
            try {
                this.talkToNameServerFromClient(nsSocket);
            }
            catch (IOException e) {
                try {
                    nsSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.debug >= 2) {
                    e.printStackTrace();
                }
                throw new cMsgException("connect: cannot talk to name server", e);
            }
            try {
                nsSocket.close();
            }
            catch (IOException e) {
                if (this.debug < 2) break block11;
                System.out.println("connect: cannot close channel to name server, continue on");
                e.printStackTrace();
            }
        }
        this.connectToDomainServer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() throws cMsgException {
        block35: {
            cMsgGetHelper cMsgGetHelper2;
            for (cMsgGetHelper cMsgGetHelper3 : this.syncSends.values()) {
                cMsgGetHelper3.setErrorCode(25);
                cMsgGetHelper2 = cMsgGetHelper3;
                synchronized (cMsgGetHelper2) {
                    cMsgGetHelper3.notify();
                }
            }
            for (cMsgGetHelper cMsgGetHelper4 : this.subscribeAndGets.values()) {
                cMsgGetHelper4.setMessage(null);
                cMsgGetHelper4.setErrorCode(24);
                cMsgGetHelper2 = cMsgGetHelper4;
                synchronized (cMsgGetHelper2) {
                    cMsgGetHelper4.notify();
                }
            }
            for (cMsgGetHelper cMsgGetHelper5 : this.sendAndGets.values()) {
                cMsgGetHelper5.setMessage(null);
                cMsgGetHelper5.setErrorCode(24);
                cMsgGetHelper2 = cMsgGetHelper5;
                synchronized (cMsgGetHelper2) {
                    cMsgGetHelper5.notify();
                }
            }
            this.syncSends.clear();
            this.sendAndGets.clear();
            this.subscribeAndGets.clear();
            try {
                this.domainOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.domainOutSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.keepAliveSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.sendUdpSocket != null) {
                this.sendUdpSocket.close();
            }
            this.listeningThread.killThread();
            Socket nsSocket = null;
            try {
                nsSocket = new Socket(this.currentParsedUDL.nameServerHost, this.currentParsedUDL.nameServerTcpPort);
                nsSocket.setTcpNoDelay(true);
            }
            catch (UnresolvedAddressException unresolvedAddressException) {
                try {
                    if (nsSocket != null) {
                        nsSocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new cMsgException("reconnect: cannot create socket to name server", unresolvedAddressException);
            }
            catch (IOException iOException) {
                try {
                    if (nsSocket != null) {
                        nsSocket.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                throw new cMsgException("reconnect: cannot create socket to name server", iOException);
            }
            try {
                this.talkToNameServerFromClient(nsSocket);
            }
            catch (IOException iOException) {
                try {
                    nsSocket.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                if (this.debug >= 2) {
                    iOException.printStackTrace();
                }
                throw new cMsgException("reconnect: cannot talk to name server", iOException);
            }
            try {
                nsSocket.close();
            }
            catch (IOException iOException) {
                if (this.debug < 2) break block35;
                System.out.println("reconnect: cannot close socket to name server, continue on");
                iOException.printStackTrace();
            }
        }
        this.connectToDomainServer(true);
    }

    private void connectToDomainServer(boolean reconnecting) throws cMsgException {
        int[] ports = new int[]{this.currentParsedUDL.domainServerTcpPort, this.currentParsedUDL.nameServerTcpPort + 1, this.domainServerPort};
        String host = this.currentParsedUDL.nameServerHost;
        boolean[] isSshTunneling = new boolean[ports.length];
        InetAddress serverAddr = null;
        try {
            serverAddr = InetAddress.getByName(this.domainServerHost);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        for (int i = 0; i < ports.length; ++i) {
            isSshTunneling[i] = false;
            if (this.currentParsedUDL.mustMulticast) {
                isSshTunneling[i] = false;
                continue;
            }
            if (i == 2) {
                isSshTunneling[i] = false;
                continue;
            }
            if (ports[i] != this.domainServerPort) {
                isSshTunneling[i] = true;
                continue;
            }
            if (serverAddr == null) {
                isSshTunneling[i] = true;
                continue;
            }
            if (cMsgUtilities.isHostSame(this.domainServerHost, host)) continue;
            isSshTunneling[i] = true;
        }
        int index = 0;
        if (this.currentParsedUDL.domainServerTcpPort < 1) {
            index = 1;
        }
        try {
            DataOutputStream kaOut;
            this.domainOutSocket = null;
            this.keepAliveSocket = null;
            for (int i = index; i < ports.length; ++i) {
                try {
                    this.domainOutSocket = new Socket(host, ports[i]);
                    this.keepAliveSocket = new Socket(host, ports[i]);
                    index = i;
                    break;
                }
                catch (IOException e2) {
                    try {
                        if (this.domainOutSocket != null) {
                            this.domainOutSocket.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (this.keepAliveSocket == null) continue;
                        this.keepAliveSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (this.domainOutSocket == null || this.keepAliveSocket == null) {
                throw new cMsgException("connectToDomainServer: cannot create channels to domain server");
            }
            try {
                this.domainOutSocket.setTcpNoDelay(true);
                this.domainOutSocket.setSendBufferSize(131072);
                this.domainOut = new DataOutputStream(new BufferedOutputStream(this.domainOutSocket.getOutputStream(), 131072));
                this.domainOut.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                this.domainOut.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                this.domainOut.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                this.domainOut.writeInt(this.uniqueClientKey);
                this.domainOut.writeInt(1);
                this.domainOut.flush();
                if (this.domainOutSocket.getInputStream().read() < 1) {
                    throw new IOException("connectToDomainServer; failed to create message channel to domain server");
                }
            }
            catch (IOException e) {
                try {
                    this.domainOutSocket.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                if (this.debug >= 2) {
                    e.printStackTrace();
                }
                throw new cMsgException("connectToDomainServer: cannot create channel to domain server", e);
            }
            try {
                this.keepAliveSocket.setTcpNoDelay(true);
                this.keepAliveSocket.setSendBufferSize(131072);
                if (reconnecting && this.keepAliveThread != null) {
                    this.keepAliveThread.changeChannels(this.keepAliveSocket);
                }
                kaOut = new DataOutputStream(new BufferedOutputStream(this.keepAliveSocket.getOutputStream()));
                kaOut.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                kaOut.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                kaOut.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                kaOut.writeInt(this.uniqueClientKey);
                kaOut.writeInt(2);
                kaOut.flush();
                if (this.keepAliveSocket.getInputStream().read() < 1) {
                    throw new IOException("connectToDomainServer; failed to create keepalive channel to domain server");
                }
                if (reconnecting && this.updateServerThread != null) {
                    this.updateServerThread.changeSockets(kaOut);
                }
            }
            catch (IOException e) {
                try {
                    this.domainOutSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.keepAliveSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.debug >= 2) {
                    e.printStackTrace();
                }
                throw new cMsgException("connectToDomainServer: cannot create keepAlive channel to domain server", e);
            }
            if (!isSshTunneling[index]) {
                try {
                    this.sendUdpSocket = new DatagramSocket();
                    this.sendUdpSocket.connect(serverAddr, this.domainServerUdpPort);
                    this.sendUdpSocket.setSendBufferSize(65536);
                    this.sendUdpPacket = new DatagramPacket(new byte[0], 0, serverAddr, this.domainServerUdpPort);
                }
                catch (SocketException e) {
                    try {
                        this.keepAliveSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.domainOutSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.sendUdpSocket != null) {
                        this.sendUdpSocket.close();
                    }
                    if (this.debug >= 2) {
                        e.printStackTrace();
                    }
                    throw new cMsgException("connectToDomainServer: cannot create udp socket to domain server", e);
                }
            }
            try {
                this.listeningThread = new cMsgClientListeningThread(this, this.domainOutSocket);
                this.listeningThread.start();
                if (!reconnecting) {
                    this.keepAliveThread = new KeepAlive(this.keepAliveSocket);
                    this.keepAliveThread.start();
                    this.updateServerThread = new UpdateServer(kaOut);
                    this.updateServerThread.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.listeningThread != null) {
                    this.listeningThread.killThread();
                }
                if (!reconnecting) {
                    if (this.keepAliveThread != null) {
                        this.keepAliveThread.killThread();
                    }
                    if (this.updateServerThread != null) {
                        this.updateServerThread.killThread();
                    }
                }
            }
        }
        catch (cMsgException e) {
            throw new cMsgException(e);
        }
        this.domainServerPort = ports[index];
        this.domainServerHost = host;
        this.connected = true;
    }

    @Override
    public void flush(int timeout) {
    }

    @Override
    public void disconnect() {
        this.disconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(boolean userCalledDisconnect) {
        if (this.debug >= 1) {
            System.out.println("Client " + this.name + " called disconnect");
        }
        if (userCalledDisconnect) {
            this.stop();
        }
        this.connectLock.lock();
        try {
            this.connected = false;
            if (this.disconnectCalled) {
                return;
            }
            this.disconnectCalled = userCalledDisconnect;
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(4);
                this.domainOut.writeInt(1);
                this.domainOut.flush();
            }
            catch (IOException e) {
                System.out.println("disconnect: IO error");
            }
            finally {
                this.socketLock.unlock();
            }
        }
        finally {
            this.connectLock.unlock();
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localDisconnect(boolean removeSubscriptions) {
        this.connectLock.lock();
        try {
            cMsgGetHelper cMsgGetHelper2;
            this.keepAliveThread.killThread();
            this.keepAliveThread.interrupt();
            this.updateServerThread.killThread();
            this.updateServerThread.interrupt();
            try {
                this.domainOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.domainOutSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.keepAliveSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.sendUdpSocket != null) {
                this.sendUdpSocket.close();
            }
            this.listeningThread.killThread();
            if (removeSubscriptions) {
                Iterator<cMsgGetHelper> iterator = this.subscriptions;
                synchronized (iterator) {
                    for (cMsgSubscription sub : this.subscriptions.keySet()) {
                        for (cMsgCallbackThread cbThread : sub.getCallbacks()) {
                            if (Thread.currentThread() == cbThread) {
                                cbThread.dieNow(false);
                                continue;
                            }
                            cbThread.dieNow(true);
                        }
                    }
                    this.subscriptions.clear();
                    this.unsubscriptions.clear();
                }
            }
            for (cMsgGetHelper cMsgGetHelper3 : this.subscribeAndGets.values()) {
                cMsgGetHelper3.setMessage(null);
                cMsgGetHelper2 = cMsgGetHelper3;
                synchronized (cMsgGetHelper2) {
                    cMsgGetHelper3.notify();
                }
            }
            for (cMsgGetHelper cMsgGetHelper4 : this.sendAndGets.values()) {
                cMsgGetHelper4.setMessage(null);
                cMsgGetHelper2 = cMsgGetHelper4;
                synchronized (cMsgGetHelper2) {
                    cMsgGetHelper4.notify();
                }
            }
            for (cMsgGetHelper cMsgGetHelper5 : this.syncSends.values()) {
                cMsgGetHelper5.setErrorCode(25);
                cMsgGetHelper2 = cMsgGetHelper5;
                synchronized (cMsgGetHelper2) {
                    cMsgGetHelper5.notify();
                }
            }
            this.subscribeAndGets.clear();
            this.sendAndGets.clear();
            this.syncSends.clear();
            this.disconnectCalled = false;
            this.mayConnect = true;
        }
        finally {
            this.connectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(cMsgMessage message) throws cMsgException {
        if (!this.hasSend) {
            throw new cMsgException("send is not implemented by this subdomain");
        }
        if (!message.getReliableSend()) {
            this.udpSend(message);
            return;
        }
        String subject = message.getSubject();
        String type = message.getType();
        if (subject == null || type == null) {
            throw new cMsgException("message subject and/or type is null");
        }
        String text = message.getText();
        int textLen = 0;
        if (text != null) {
            textLen = text.length();
        }
        long now = System.currentTimeMillis();
        int payloadLen = 0;
        String payloadTxt = message.noHistoryAdditions() ? message.getPayloadText() : message.addHistoryToPayloadText(this.name, this.host, now);
        if (payloadTxt != null) {
            payloadLen = payloadTxt.length();
        }
        int binaryLength = message.getByteArrayLength();
        while (true) {
            this.notConnectLock.lock();
            try {
                if (!this.connected) {
                    throw new IOException("not connected to server");
                }
                int size = 60 + subject.length() + type.length() + payloadLen + textLen + binaryLength;
                this.socketLock.lock();
                try {
                    this.domainOut.writeInt(size);
                    this.domainOut.writeInt(5);
                    this.domainOut.writeInt(0);
                    this.domainOut.writeInt(message.getUserInt());
                    this.domainOut.writeInt(message.getSysMsgId());
                    this.domainOut.writeInt(message.getSenderToken());
                    this.domainOut.writeInt(message.getInfo());
                    this.domainOut.writeInt((int)(now >>> 32));
                    this.domainOut.writeInt((int)(now & 0xFFFFFFFFL));
                    this.domainOut.writeInt((int)(message.getUserTime().getTime() >>> 32));
                    this.domainOut.writeInt((int)(message.getUserTime().getTime() & 0xFFFFFFFFL));
                    this.domainOut.writeInt(subject.length());
                    this.domainOut.writeInt(type.length());
                    this.domainOut.writeInt(payloadLen);
                    this.domainOut.writeInt(textLen);
                    this.domainOut.writeInt(binaryLength);
                    try {
                        this.domainOut.write(subject.getBytes("US-ASCII"));
                        this.domainOut.write(type.getBytes("US-ASCII"));
                        if (payloadLen > 0) {
                            this.domainOut.write(payloadTxt.getBytes("US-ASCII"));
                        }
                        if (textLen > 0) {
                            this.domainOut.write(text.getBytes("US-ASCII"));
                        }
                        if (binaryLength > 0) {
                            this.domainOut.write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                finally {
                    this.socketLock.unlock();
                }
                this.domainOut.flush();
                ++this.numTcpSends;
            }
            catch (IOException e) {
                if (this.failoverSuccessful(false)) continue;
                throw new cMsgException(e.getMessage());
            }
            finally {
                this.notConnectLock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void udpSend(cMsgMessage message) throws cMsgException {
        if (this.sendUdpPacket == null) {
            throw new cMsgException("udp sends not allowed when ssh tunneling to cmsg server");
        }
        String subject = message.getSubject();
        String type = message.getType();
        if (subject == null || type == null) {
            throw new cMsgException("message subject and/or type is null");
        }
        String text = message.getText();
        int textLen = 0;
        if (text != null) {
            textLen = text.length();
        }
        long now = System.currentTimeMillis();
        int payloadLen = 0;
        String payloadTxt = message.noHistoryAdditions() ? message.getPayloadText() : message.addHistoryToPayloadText(this.name, this.host, now);
        if (payloadTxt != null) {
            payloadLen = payloadTxt.length();
        }
        int binaryLength = message.getByteArrayLength();
        int totalLength = 60 + subject.length() + type.length() + payloadLen + textLen + binaryLength;
        if (totalLength > 65536) {
            throw new cMsgException("Too big a message for UDP to send");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(totalLength);
        DataOutputStream out = new DataOutputStream(baos);
        while (true) {
            this.notConnectLock.lock();
            try {
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(this.domainOutSocket.getLocalPort());
                out.writeInt(totalLength);
                out.writeInt(5);
                out.writeInt(0);
                out.writeInt(message.getUserInt());
                out.writeInt(message.getSysMsgId());
                out.writeInt(message.getSenderToken());
                out.writeInt(message.getInfo());
                out.writeInt((int)(now >>> 32));
                out.writeInt((int)(now & 0xFFFFFFFFL));
                out.writeInt((int)(message.getUserTime().getTime() >>> 32));
                out.writeInt((int)(message.getUserTime().getTime() & 0xFFFFFFFFL));
                out.writeInt(subject.length());
                out.writeInt(type.length());
                out.writeInt(payloadLen);
                out.writeInt(textLen);
                out.writeInt(binaryLength);
                try {
                    out.write(subject.getBytes("US-ASCII"));
                    out.write(type.getBytes("US-ASCII"));
                    if (payloadLen > 0) {
                        out.write(payloadTxt.getBytes("US-ASCII"));
                    }
                    if (textLen > 0) {
                        out.write(text.getBytes("US-ASCII"));
                    }
                    if (binaryLength > 0) {
                        out.write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                out.flush();
                byte[] buf = baos.toByteArray();
                DatagramPacket datagramPacket = this.sendUdpPacket;
                synchronized (datagramPacket) {
                    this.sendUdpPacket.setData(buf, 0, buf.length);
                    this.sendUdpSocket.send(this.sendUdpPacket);
                }
                ++this.numUdpSends;
            }
            catch (IOException e) {
                if (this.failoverSuccessful(false)) continue;
                throw new cMsgException("Cannot create or send message packet", e);
            }
            finally {
                this.notConnectLock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int syncSend(cMsgMessage message, int timeout) throws cMsgException {
        cMsgGetHelper helper;
        if (!this.hasSyncSend) {
            throw new cMsgException("sync send is not implemented by this subdomain");
        }
        String subject = message.getSubject();
        String type = message.getType();
        if (subject == null || type == null) {
            throw new cMsgException("message subject and/or type is null");
        }
        String text = message.getText();
        int textLen = 0;
        if (text != null) {
            textLen = text.length();
        }
        long now = System.currentTimeMillis();
        int payloadLen = 0;
        String payloadTxt = message.noHistoryAdditions() ? message.getPayloadText() : message.addHistoryToPayloadText(this.name, this.host, now);
        if (payloadTxt != null) {
            payloadLen = payloadTxt.length();
        }
        int binaryLength = message.getByteArrayLength();
        while (true) {
            this.notConnectLock.lock();
            int id = this.uniqueId.getAndIncrement();
            helper = new cMsgGetHelper();
            this.syncSends.put(id, helper);
            try {
                if (!this.connected) {
                    throw new IOException("not connected to server");
                }
                this.socketLock.lock();
                try {
                    this.domainOut.writeInt(60 + subject.length() + type.length() + payloadLen + textLen + binaryLength);
                    this.domainOut.writeInt(6);
                    this.domainOut.writeInt(id);
                    this.domainOut.writeInt(message.getUserInt());
                    this.domainOut.writeInt(message.getSysMsgId());
                    this.domainOut.writeInt(message.getSenderToken());
                    this.domainOut.writeInt(message.getInfo());
                    this.domainOut.writeInt((int)(now >>> 32));
                    this.domainOut.writeInt((int)(now & 0xFFFFFFFFL));
                    this.domainOut.writeInt((int)(message.getUserTime().getTime() >>> 32));
                    this.domainOut.writeInt((int)(message.getUserTime().getTime() & 0xFFFFFFFFL));
                    this.domainOut.writeInt(subject.length());
                    this.domainOut.writeInt(type.length());
                    this.domainOut.writeInt(payloadLen);
                    this.domainOut.writeInt(textLen);
                    this.domainOut.writeInt(binaryLength);
                    try {
                        this.domainOut.write(subject.getBytes("US-ASCII"));
                        this.domainOut.write(type.getBytes("US-ASCII"));
                        if (payloadLen > 0) {
                            this.domainOut.write(payloadTxt.getBytes("US-ASCII"));
                        }
                        if (textLen > 0) {
                            this.domainOut.write(text.getBytes("US-ASCII"));
                        }
                        if (binaryLength > 0) {
                            this.domainOut.write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                finally {
                    this.socketLock.unlock();
                }
                this.domainOut.flush();
                ++this.numSyncSends;
            }
            catch (IOException e) {
                if (this.failoverSuccessful(false)) continue;
                throw new cMsgException(e.getMessage());
            }
            finally {
                this.notConnectLock.unlock();
                continue;
            }
            break;
        }
        try {
            cMsgGetHelper cMsgGetHelper2 = helper;
            synchronized (cMsgGetHelper2) {
                if (helper.needToWait()) {
                    helper.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (helper.getErrorCode() != 0) {
            throw new cMsgException("syncSend abort", helper.getErrorCode());
        }
        return helper.getIntVal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public cMsgSubscriptionHandle subscribe(String subject, String type, cMsgCallbackInterface cb3, Object userObj) throws cMsgException {
        if (!this.hasSubscribe) {
            throw new cMsgException("subscribe is not implemented by this subdomain");
        }
        if (subject == null) throw new cMsgException("subject, type or callback argument is null");
        if (type == null) throw new cMsgException("subject, type or callback argument is null");
        if (cb3 == null) {
            throw new cMsgException("subject, type or callback argument is null");
        }
        if (subject.length() < 1) throw new cMsgException("subject or type is blank string");
        if (type.length() < 1) {
            throw new cMsgException("subject or type is blank string");
        }
        cMsgCallbackThread cbThread = null;
        while (true) {
            boolean addedHashEntry = false;
            cMsgSubscription newSub = null;
            this.notConnectLock.lock();
            this.subscribeLock.lock();
            try {
                int id;
                if (!this.connected) {
                    throw new cMsgException("not connected to server");
                }
                ConcurrentHashMap<cMsgSubscription, String> concurrentHashMap = this.subscriptions;
                synchronized (concurrentHashMap) {
                    for (cMsgSubscription sub : this.subscriptions.keySet()) {
                        if (!sub.getSubject().equals(subject) || !sub.getType().equals(type)) continue;
                        cbThread = new cMsgCallbackThread(cb3, userObj, this.domain, subject, type);
                        sub.addCallback(cbThread);
                        this.unsubscriptions.put(cbThread, sub);
                        ++this.numSubscribes;
                        cMsgCallbackThread cMsgCallbackThread2 = cbThread;
                        return cMsgCallbackThread2;
                    }
                    id = this.uniqueId.getAndIncrement();
                    cbThread = new cMsgCallbackThread(cb3, userObj, this.domain, subject, type);
                    newSub = new cMsgSubscription(subject, type, id, cbThread);
                    this.unsubscriptions.put(cbThread, newSub);
                    this.subscriptions.put(newSub, "");
                    addedHashEntry = true;
                }
                this.socketLock.lock();
                try {
                    this.domainOut.writeInt(20 + subject.length() + type.length());
                    this.domainOut.writeInt(7);
                    this.domainOut.writeInt(id);
                    this.domainOut.writeInt(subject.length());
                    this.domainOut.writeInt(type.length());
                    this.domainOut.writeInt(0);
                    try {
                        this.domainOut.write(subject.getBytes("US-ASCII"));
                        this.domainOut.write(type.getBytes("US-ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.domainOut.flush();
                    ++this.numSubscribes;
                    return cbThread;
                }
                finally {
                    this.socketLock.unlock();
                }
            }
            catch (IOException e) {
                if (addedHashEntry) {
                    this.subscriptions.remove(newSub);
                    this.unsubscriptions.remove(cbThread);
                    cbThread.dieNow(true);
                }
                if (!this.failoverSuccessful(false)) throw new cMsgException(e.getMessage());
                continue;
            }
            finally {
                this.subscribeLock.unlock();
                this.notConnectLock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unsubscribe(cMsgSubscriptionHandle obj) throws cMsgException {
        if (!this.hasUnsubscribe) {
            throw new cMsgException("unsubscribe is not implemented by this subdomain");
        }
        if (obj == null) {
            throw new cMsgException("argument is null");
        }
        cMsgSubscription sub = this.unsubscriptions.remove(obj);
        if (sub == null) {
            return;
        }
        cMsgCallbackThread cbThread = (cMsgCallbackThread)obj;
        while (true) {
            this.notConnectLock.lock();
            this.subscribeLock.lock();
            try {
                if (!this.connected) {
                    throw new cMsgException("not connected to server");
                }
                ConcurrentHashMap<cMsgSubscription, String> concurrentHashMap = this.subscriptions;
                synchronized (concurrentHashMap) {
                    if (sub.numberOfCallbacks() > 1) {
                        cbThread.dieNow(false);
                        sub.getCallbacks().remove(cbThread);
                        ++this.numUnsubscribes;
                        return;
                    }
                }
                String subject = sub.getSubject();
                String type = sub.getType();
                this.socketLock.lock();
                try {
                    this.domainOut.writeInt(20 + subject.length() + type.length());
                    this.domainOut.writeInt(8);
                    this.domainOut.writeInt(sub.getIntVal());
                    this.domainOut.writeInt(subject.length());
                    this.domainOut.writeInt(type.length());
                    this.domainOut.writeInt(0);
                    try {
                        this.domainOut.write(subject.getBytes("US-ASCII"));
                        this.domainOut.write(type.getBytes("US-ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.domainOut.flush();
                    ++this.numUnsubscribes;
                }
                finally {
                    this.socketLock.unlock();
                }
                ConcurrentHashMap<cMsgSubscription, String> concurrentHashMap2 = this.subscriptions;
                synchronized (concurrentHashMap2) {
                    cbThread.dieNow(false);
                    sub.getCallbacks().remove(cbThread);
                    this.subscriptions.remove(sub);
                    return;
                }
            }
            catch (IOException e) {
                if (!this.failoverSuccessful(true)) throw new cMsgException(e.getMessage());
                continue;
            }
            finally {
                this.subscribeLock.unlock();
                this.notConnectLock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resubscribe(String subject, String type) throws cMsgException {
        this.notConnectLock.lock();
        this.subscribeLock.lock();
        try {
            int id;
            if (!this.connected) {
                throw new cMsgException("not connected to server");
            }
            boolean gotSub = false;
            ConcurrentHashMap<cMsgSubscription, String> concurrentHashMap = this.subscriptions;
            synchronized (concurrentHashMap) {
                cMsgSubscription mySub;
                block17: {
                    mySub = null;
                    for (cMsgSubscription sub : this.subscriptions.keySet()) {
                        if (!sub.getSubject().equals(subject) || !sub.getType().equals(type)) continue;
                        mySub = sub;
                        gotSub = true;
                        break;
                    }
                    if (gotSub) break block17;
                    return;
                }
                id = this.uniqueId.getAndIncrement();
                mySub.setIntVal(id);
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(20 + subject.length() + type.length());
                this.domainOut.writeInt(7);
                this.domainOut.writeInt(id);
                this.domainOut.writeInt(subject.length());
                this.domainOut.writeInt(type.length());
                this.domainOut.writeInt(0);
                try {
                    this.domainOut.write(subject.getBytes("US-ASCII"));
                    this.domainOut.write(type.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.domainOut.flush();
            }
            finally {
                this.socketLock.unlock();
            }
        }
        catch (IOException e) {
            throw new cMsgException(e.getMessage());
        }
        finally {
            this.subscribeLock.unlock();
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public cMsgMessage subscribeAndGet(String subject, String type, int timeout) throws cMsgException, TimeoutException {
        if (!this.hasSubscribeAndGet) {
            throw new cMsgException("subscribeAndGet is not implemented by this subdomain");
        }
        if (subject == null || type == null) {
            throw new cMsgException("message subject or type is null");
        }
        if (subject.length() < 1 || type.length() < 1) {
            throw new cMsgException("message subject or type is blank string");
        }
        int id = 0;
        cMsgSubscription sub = null;
        boolean addedHashEntry = false;
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to server");
            }
            id = this.uniqueId.getAndIncrement();
            sub = new cMsgSubscription(subject, type);
            this.subscribeAndGets.put(id, sub);
            addedHashEntry = true;
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(20 + subject.length() + type.length());
                this.domainOut.writeInt(9);
                this.domainOut.writeInt(id);
                this.domainOut.writeInt(subject.length());
                this.domainOut.writeInt(type.length());
                this.domainOut.writeInt(0);
                try {
                    this.domainOut.write(subject.getBytes("US-ASCII"));
                    this.domainOut.write(type.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                ++this.numSubscribeAndGets;
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (addedHashEntry) {
                this.subscribeAndGets.remove(id);
            }
            throw new cMsgException(e.getMessage());
        }
        finally {
            this.notConnectLock.unlock();
        }
        try {
            cMsgSubscription cMsgSubscription2 = sub;
            synchronized (cMsgSubscription2) {
                if (timeout > 0) {
                    sub.wait(timeout);
                } else {
                    sub.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (sub.isTimedOut()) {
            this.subscribeAndGets.remove(id);
            this.unSubscribeAndGet(subject, type, id);
            throw new TimeoutException();
        }
        if (sub.getErrorCode() != 0) {
            throw new cMsgException("server died", sub.getErrorCode());
        }
        return sub.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unSubscribeAndGet(String subject, String type, int id) {
        if (!this.connected) {
            return;
        }
        this.socketLock.lock();
        try {
            this.domainOut.writeInt(20 + subject.length() + type.length());
            this.domainOut.writeInt(10);
            this.domainOut.writeInt(id);
            this.domainOut.writeInt(subject.length());
            this.domainOut.writeInt(type.length());
            this.domainOut.writeInt(0);
            try {
                this.domainOut.write(subject.getBytes("US-ASCII"));
                this.domainOut.write(type.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public cMsgMessage sendAndGet(cMsgMessage message, int timeout) throws cMsgException, TimeoutException {
        if (!this.hasSendAndGet) {
            throw new cMsgException("sendAndGet is not implemented by this subdomain");
        }
        String subject = message.getSubject();
        String type = message.getType();
        if (subject == null || type == null) {
            throw new cMsgException("message subject and/or type is null");
        }
        String text = message.getText();
        int textLen = 0;
        if (text != null) {
            textLen = text.length();
        }
        long now = System.currentTimeMillis();
        int payloadLen = 0;
        String payloadTxt = message.noHistoryAdditions() ? message.getPayloadText() : message.addHistoryToPayloadText(this.name, this.host, now);
        if (payloadTxt != null) {
            payloadLen = payloadTxt.length();
        }
        int id = 0;
        cMsgGetHelper helper = null;
        boolean addedHashEntry = false;
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to server");
            }
            id = this.uniqueId.getAndIncrement();
            helper = new cMsgGetHelper();
            this.sendAndGets.put(id, helper);
            addedHashEntry = true;
            int binaryLength = message.getByteArrayLength();
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(60 + subject.length() + type.length() + payloadLen + textLen + binaryLength);
                this.domainOut.writeInt(11);
                this.domainOut.writeInt(0);
                this.domainOut.writeInt(message.getUserInt());
                this.domainOut.writeInt(id);
                this.domainOut.writeInt(message.getInfo() | 1);
                this.domainOut.writeInt((int)(now >>> 32));
                this.domainOut.writeInt((int)(now & 0xFFFFFFFFL));
                this.domainOut.writeInt((int)(message.getUserTime().getTime() >>> 32));
                this.domainOut.writeInt((int)(message.getUserTime().getTime() & 0xFFFFFFFFL));
                this.domainOut.writeInt(subject.length());
                this.domainOut.writeInt(type.length());
                this.domainOut.writeInt(0);
                this.domainOut.writeInt(payloadLen);
                this.domainOut.writeInt(textLen);
                this.domainOut.writeInt(binaryLength);
                try {
                    this.domainOut.write(subject.getBytes("US-ASCII"));
                    this.domainOut.write(type.getBytes("US-ASCII"));
                    if (payloadLen > 0) {
                        this.domainOut.write(payloadTxt.getBytes("US-ASCII"));
                    }
                    if (textLen > 0) {
                        this.domainOut.write(text.getBytes("US-ASCII"));
                    }
                    if (binaryLength > 0) {
                        this.domainOut.write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                ++this.numSendAndGets;
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        catch (IOException e) {
            if (addedHashEntry) {
                this.sendAndGets.remove(id);
            }
            throw new cMsgException(e.getMessage());
        }
        finally {
            this.notConnectLock.unlock();
        }
        try {
            cMsgGetHelper cMsgGetHelper2 = helper;
            synchronized (cMsgGetHelper2) {
                if (timeout > 0) {
                    helper.wait(timeout);
                } else {
                    helper.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (helper.isTimedOut()) {
            this.sendAndGets.remove(id);
            this.unSendAndGet(id);
            throw new TimeoutException();
        }
        if (helper.getErrorCode() != 0) {
            throw new cMsgException("server died", helper.getErrorCode());
        }
        if (helper.getMessage().isNullGetServerResponse()) {
            return null;
        }
        return helper.getMessage();
    }

    private void unSendAndGet(int id) {
        if (!this.connected) {
            return;
        }
        this.socketLock.lock();
        try {
            this.domainOut.writeInt(8);
            this.domainOut.writeInt(12);
            this.domainOut.writeInt(id);
            this.domainOut.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.socketLock.unlock();
        }
    }

    @Override
    public cMsgMessage monitor(String command) {
        if (command != null) {
            this.userXML = command;
        }
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.setText(this.monitorXML);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownClients(String client, boolean includeMe) throws cMsgException {
        if (!this.hasShutdown) {
            throw new cMsgException("shutdown is not implemented by this subdomain");
        }
        if (client == null) {
            client = new String("");
        }
        int flag = includeMe ? 1 : 0;
        this.connectLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to server");
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(12 + client.length());
                this.domainOut.writeInt(3);
                this.domainOut.writeInt(flag);
                this.domainOut.writeInt(client.length());
                try {
                    this.domainOut.write(client.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        catch (IOException e) {
            throw new cMsgException(e.getMessage());
        }
        finally {
            this.connectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownServers(String server, boolean includeMyServer) throws cMsgException {
        if (!this.hasShutdown) {
            throw new cMsgException("shutdown is not implemented by this subdomain");
        }
        if (server == null) {
            server = "";
        }
        int flag = includeMyServer ? 2 : 0;
        server = cMsgUtilities.constructServerName(server);
        this.connectLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to server");
            }
            this.socketLock.lock();
            try {
                this.domainOut.writeInt(12 + server.length());
                this.domainOut.writeInt(4);
                this.domainOut.writeInt(flag);
                this.domainOut.writeInt(server.length());
                try {
                    this.domainOut.write(server.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            finally {
                this.socketLock.unlock();
            }
            this.domainOut.flush();
        }
        catch (IOException e) {
            throw new cMsgException(e.getMessage());
        }
        finally {
            this.connectLock.unlock();
        }
    }

    void talkToNameServerFromClient(Socket socket) throws IOException, cMsgException {
        byte[] buf = new byte[512];
        DataInputStream in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
        out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
        out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
        out.writeInt(0);
        out.writeInt(6);
        out.writeInt(0);
        out.writeInt(this.currentParsedUDL.regime);
        out.writeInt(this.currentParsedUDL.password.length());
        out.writeInt(this.domain.length());
        out.writeInt(this.currentParsedUDL.subdomain.length());
        out.writeInt(this.currentParsedUDL.subRemainder.length());
        out.writeInt(this.host.length());
        out.writeInt(this.name.length());
        out.writeInt(this.currentParsedUDL.UDL.length());
        out.writeInt(this.description.length());
        try {
            out.write(this.currentParsedUDL.password.getBytes("US-ASCII"));
            out.write(this.domain.getBytes("US-ASCII"));
            out.write(this.currentParsedUDL.subdomain.getBytes("US-ASCII"));
            out.write(this.currentParsedUDL.subRemainder.getBytes("US-ASCII"));
            out.write(this.host.getBytes("US-ASCII"));
            out.write(this.name.getBytes("US-ASCII"));
            out.write(this.currentParsedUDL.UDL.getBytes("US-ASCII"));
            out.write(this.description.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        out.flush();
        int error = in.readInt();
        if (error != 0) {
            int len = in.readInt();
            if (len > buf.length) {
                buf = new byte[len + 100];
            }
            in.readFully(buf, 0, len);
            String err = new String(buf, 0, len, "US-ASCII");
            throw new cMsgException("Error from server: " + err);
        }
        in.readFully(buf, 0, 7);
        this.hasSend = buf[0] == 1;
        this.hasSyncSend = buf[1] == 1;
        this.hasSubscribeAndGet = buf[2] == 1;
        this.hasSendAndGet = buf[3] == 1;
        this.hasSubscribe = buf[4] == 1;
        this.hasUnsubscribe = buf[5] == 1;
        this.hasShutdown = buf[6] == 1;
        this.uniqueClientKey = in.readInt();
        this.domainServerPort = in.readInt();
        this.domainServerUdpPort = in.readInt();
        int hostLength = in.readInt();
        if (hostLength > buf.length) {
            buf = new byte[hostLength];
        }
        in.readFully(buf, 0, hostLength);
        this.domainServerHost = new String(buf, 0, hostLength, "US-ASCII");
        if (this.debug >= 4) {
            System.out.println("        << CL: domain server host = " + this.domainServerHost + ", port = " + this.domainServerPort);
        }
    }

    ParsedUDL parseUDL(String udl) throws cMsgException {
        int tcpPort;
        int udpPort;
        boolean mustMulticast;
        boolean isLocal;
        String udlSubRemainder;
        String udlSubdomain;
        String udlHost;
        Matcher matcher;
        Pattern pattern;
        String udlRemainder;
        block53: {
            String udlPort;
            if (udl == null) {
                throw new cMsgException("invalid UDL");
            }
            String udlLowerCase = udl.toLowerCase();
            int index = udlLowerCase.indexOf("cmsg://");
            if (index < 0) {
                throw new cMsgException("invalid UDL");
            }
            udlRemainder = udl.substring(index + 7);
            pattern = Pattern.compile("([^:/]+):?(\\d+)?/?(\\w+)?/?(.*)");
            matcher = pattern.matcher(udlRemainder);
            if (matcher.find()) {
                udlHost = matcher.group(1);
                udlPort = matcher.group(2);
                udlSubdomain = matcher.group(3);
                udlSubRemainder = matcher.group(4);
                if (this.debug >= 4) {
                    System.out.println("\nparseUDL: \n  host      = " + udlHost + "\n  port      = " + udlPort + "\n  subdomain = " + udlSubdomain + "\n  remainder = " + udlSubRemainder);
                }
            } else {
                throw new cMsgException("invalid UDL");
            }
            if (udlHost == null) {
                throw new cMsgException("invalid UDL");
            }
            if (udlSubdomain == null) {
                udlSubdomain = "cMsg";
            } else {
                String[] allowedSubdomains = new String[]{"LogFile", "CA", "Database", "Queue", "FileQueue", "SmartSockets", "TcpServer", "cMsg"};
                boolean foundSubD = false;
                for (String subDom : allowedSubdomains) {
                    if (!subDom.equalsIgnoreCase(udlSubdomain)) continue;
                    foundSubD = true;
                    break;
                }
                if (!foundSubD) {
                    udlSubRemainder = udlSubRemainder == null ? udlSubdomain : udlSubdomain + "/" + udlSubRemainder;
                    udlSubdomain = "cMsg";
                }
            }
            isLocal = false;
            mustMulticast = false;
            if (udlHost.equalsIgnoreCase("multicast") || udlHost.equals("239.220.0.0")) {
                mustMulticast = true;
            } else if (udlHost.equalsIgnoreCase("localhost")) {
                try {
                    udlHost = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    throw new cMsgException("cannot find localhost", e);
                }
                isLocal = true;
                if (this.debug >= 3) {
                    System.out.println("parseUDL: name server given as \"localhost\", substituting " + udlHost);
                }
            } else {
                try {
                    InetAddress.getByName(udlHost);
                }
                catch (UnknownHostException e) {
                    throw new cMsgException("unknown host", e);
                }
                isLocal = cMsgUtilities.isHostLocal(udlHost);
            }
            if (udlPort != null && udlPort.length() > 0) {
                try {
                    int udlPortInt = Integer.parseInt(udlPort);
                    if (udlPortInt < 1024 || udlPortInt > 65535) {
                        throw new cMsgException("parseUDL: illegal port number");
                    }
                    if (mustMulticast) {
                        udpPort = udlPortInt;
                        tcpPort = 45000;
                        break block53;
                    }
                    udpPort = 45000;
                    tcpPort = udlPortInt;
                }
                catch (NumberFormatException e) {
                    udpPort = 45000;
                    tcpPort = 45000;
                }
            } else {
                udpPort = 45000;
                tcpPort = 45000;
                if (this.debug >= 3) {
                    System.out.println("parseUDL: guessing name server TCP port = " + tcpPort + ", UDP port = " + udpPort);
                }
            }
        }
        if (udlSubRemainder == null) {
            udlSubRemainder = "";
        }
        int counter = 0;
        String pswd = "";
        pattern = Pattern.compile("[\\?&]cmsgpassword=([^&]+)", 2);
        matcher = pattern.matcher(udlSubRemainder);
        while (matcher.find()) {
            pswd = matcher.group(1);
            ++counter;
        }
        if (counter > 1) {
            throw new cMsgException("parseUDL: only 1 password allowed");
        }
        counter = 0;
        int timeout = 0;
        pattern = Pattern.compile("[\\?&]multicastTO=([^&]+)", 2);
        matcher = pattern.matcher(udlSubRemainder);
        while (matcher.find()) {
            try {
                timeout = 1000 * Integer.parseInt(matcher.group(1));
                if (timeout < 0) {
                    throw new cMsgException("parseUDL: multicast timeout must be integer >= 0");
                }
                ++counter;
            }
            catch (NumberFormatException e) {
                throw new cMsgException("parseUDL: multicast timeout must be integer >= 0");
            }
        }
        if (counter > 1) {
            throw new cMsgException("parseUDL: only 1 multicast timeout allowed");
        }
        counter = 0;
        int domainPort = 0;
        pattern = Pattern.compile("[\\?&]domainPort=([^&]+)", 2);
        matcher = pattern.matcher(udlSubRemainder);
        while (matcher.find()) {
            try {
                domainPort = Integer.parseInt(matcher.group(1));
                if (domainPort < 1024 || domainPort > 65535) {
                    throw new cMsgException("parseUDL: domain server illegal port number");
                }
                ++counter;
            }
            catch (NumberFormatException e) {
                throw new cMsgException("parseUDL: domain server port must be integer > 1023 and < 65536");
            }
        }
        if (counter > 1) {
            throw new cMsgException("parseUDL: only 1 domain server port allowed");
        }
        counter = 0;
        String preferredSubnet = null;
        pattern = Pattern.compile("[\\?&]subnet=((?:[0-9]{1,3}\\.){3}[0-9]{1,3})", 2);
        matcher = pattern.matcher(udlSubRemainder);
        while (matcher.find()) {
            preferredSubnet = matcher.group(1);
            ++counter;
        }
        if (counter > 1) {
            throw new cMsgException("parseUDL: only 1 preferred subnet allowed");
        }
        counter = 0;
        int regime = 0;
        pattern = Pattern.compile("[\\?&]regime=([^&]+)", 2);
        matcher = pattern.matcher(udlSubRemainder);
        while (matcher.find()) {
            if (matcher.group(1).equalsIgnoreCase("low")) {
                regime = 1;
            } else if (matcher.group(1).equalsIgnoreCase("high")) {
                regime = 2;
            } else if (matcher.group(1).equalsIgnoreCase("medium")) {
                regime = 0;
            } else {
                throw new cMsgException("parseUDL: regime must be low, medium or high");
            }
            ++counter;
        }
        if (counter > 1) {
            throw new cMsgException("parseUDL: only 1 regime value allowed");
        }
        counter = 0;
        int failover = 0;
        pattern = Pattern.compile("[\\?&]failover=([^&]+)", 2);
        matcher = pattern.matcher(udlSubRemainder);
        while (matcher.find()) {
            failover = matcher.group(1).equalsIgnoreCase("cloud") ? 1 : (matcher.group(1).equalsIgnoreCase("cloudonly") ? 2 : 0);
            ++counter;
        }
        if (counter > 1) {
            throw new cMsgException("parseUDL: only 1 failover value allowed");
        }
        counter = 0;
        int cloud = 0;
        pattern = Pattern.compile("[\\?&]cloud=([^&]+)", 2);
        matcher = pattern.matcher(udlSubRemainder);
        while (matcher.find()) {
            cloud = matcher.group(1).equalsIgnoreCase("local") ? 1 : 0;
            ++counter;
        }
        if (counter > 1) {
            throw new cMsgException("parseUDL: only 1 cloud value allowed");
        }
        return new ParsedUDL(udl, udlRemainder, udlSubdomain, udlSubRemainder, pswd, udlHost, preferredSubnet, tcpPort, domainPort, udpPort, timeout, regime, failover, cloud, mustMulticast, isLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSubscriptions() throws cMsgException {
        ConcurrentHashMap<cMsgSubscription, String> concurrentHashMap = this.subscriptions;
        synchronized (concurrentHashMap) {
            for (cMsgSubscription sub : this.subscriptions.keySet()) {
                this.resubscribe(sub.getSubject(), sub.getType());
            }
        }
        this.resubscriptionsComplete.set(true);
    }

    static /* synthetic */ byte access$1208(cMsg x0) {
        byte by = x0.failoverIndex;
        x0.failoverIndex = (byte)(by + 1);
        return by;
    }

    class UpdateServer
    extends Thread {
        private DataOutputStream out;
        private boolean killThread;
        private boolean init = true;
        private long lastTime;

        public void killThread() {
            this.killThread = true;
        }

        public synchronized void changeSockets(DataOutputStream out) throws IOException {
            this.out = out;
        }

        public UpdateServer(DataOutputStream out) throws IOException {
            this.out = out;
            this.setDaemon(true);
            this.setName("cMsg domain client update server");
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (this.killThread) {
                        if (cMsg.this.debug >= 4) {
                            System.out.println("UpdateServer: EXITING\n");
                        }
                        return;
                    }
                    long now = System.currentTimeMillis();
                    if (!this.init) {
                        long l = now - this.lastTime;
                    } else {
                        this.init = false;
                    }
                    Thread.sleep(2000L);
                    this.lastTime = now;
                    this.sendMonitorInfo();
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (InterruptedIOException e) {
                return;
            }
            catch (IOException e) {
                return;
            }
        }

        private synchronized void sendMonitorInfo() throws IOException {
            String indent1 = "      ";
            String indent2 = "        ";
            StringBuilder xml = new StringBuilder(2048);
            for (cMsgSubscription sub : cMsg.this.subscriptions.keySet()) {
                xml.append(indent1);
                xml.append("<subscription  subject=\"");
                xml.append(sub.getSubject());
                xml.append("\"  type=\"");
                xml.append(sub.getType());
                xml.append("\">\n");
                int num = 0;
                for (cMsgCallbackThread cbThread : sub.getCallbacks()) {
                    xml.append(indent2);
                    xml.append("<callback  id=\"");
                    xml.append(num++);
                    xml.append("\"  received=\"");
                    xml.append(cbThread.getMsgCount());
                    xml.append("\"  cueSize=\"");
                    xml.append(cbThread.getQueueSize());
                    xml.append("\"/>\n");
                }
                xml.append(indent1);
                xml.append("</subscription>\n");
            }
            if (cMsg.this.userXML != null && cMsg.this.userXML.length() > 0) {
                xml.append(cMsg.this.userXML);
            }
            int size = xml.length() + 16 + 56;
            this.out.writeInt(size);
            this.out.writeInt(xml.length());
            this.out.writeInt(1);
            this.out.writeInt(cMsg.this.subscribeAndGets.size());
            this.out.writeInt(cMsg.this.sendAndGets.size());
            this.out.writeLong(cMsg.this.numTcpSends);
            this.out.writeLong(cMsg.this.numUdpSends);
            this.out.writeLong(cMsg.this.numSyncSends);
            this.out.writeLong(cMsg.this.numSendAndGets);
            this.out.writeLong(cMsg.this.numSubscribeAndGets);
            this.out.writeLong(cMsg.this.numSubscribes);
            this.out.writeLong(cMsg.this.numUnsubscribes);
            this.out.write(xml.toString().getBytes("US-ASCII"));
            this.out.flush();
        }
    }

    class KeepAlive
    extends Thread {
        private DataInputStream in;
        private boolean killThread;
        private byte[] monitorBytes = new byte[200000];

        public void killThread() {
            this.killThread = true;
        }

        public synchronized void changeChannels(Socket socket) throws IOException {
            this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        }

        public KeepAlive(Socket socket) throws IOException {
            this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            this.setDaemon(true);
            this.setName("cMsg domain client keepAlive");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (cMsg.this.debug >= 4) {
                System.out.println("********* Running Client Keep Alive Thread ************");
            }
            boolean weGotAConnection = true;
            block22: while (true) {
                if (!weGotAConnection) {
                    cMsg.this.currentParsedUDL = null;
                    cMsg.this.localDisconnect(cMsg.this.disconnectCalled);
                    return;
                }
                try {
                    while (true) {
                        try {
                            while (true) {
                                if (this.killThread) {
                                    return;
                                }
                                this.getMonitorInfo();
                            }
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    cMsg.this.connectLock.lock();
                    try {
                        if (this.isInterrupted()) {
                            return;
                        }
                        cMsg.this.mayConnect = false;
                        cMsg.this.connected = false;
                        weGotAConnection = false;
                        if (cMsg.this.disconnectCalled || !cMsg.this.useFailovers) {
                            if (cMsg.this.debug >= 1) {
                                System.out.println("\nkeepAliveThread: user called disconnect and/or server terminated connection");
                            }
                            cMsg.this.localDisconnect(cMsg.this.disconnectCalled);
                            return;
                        }
                        boolean noMoreCloudServers = false;
                        if (cMsg.this.cloudServers.size() < 1) {
                            noMoreCloudServers = true;
                        }
                        cMsg.this.resubscriptionsComplete.set(false);
                        if (!(weGotAConnection || cMsg.this.currentParsedUDL == null || cMsg.this.currentParsedUDL.failover != 1 && cMsg.this.currentParsedUDL.failover != 2)) {
                            if (cMsg.this.currentParsedUDL.cloud == 1 && !cMsg.this.haveLocalCloudServer || noMoreCloudServers) {
                                if (cMsg.this.currentParsedUDL.failover != 1) {
                                    try {
                                        cMsg.this.localDisconnect(cMsg.this.disconnectCalled);
                                        return;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                        return;
                                    }
                                }
                            } else {
                                boolean cloudOnly = cMsg.this.currentParsedUDL.failover == 2;
                                String sName = cMsg.this.currentParsedUDL.nameServerHost + ":" + cMsg.this.currentParsedUDL.nameServerTcpPort;
                                for (Map.Entry entry : cMsg.this.cloudServers.entrySet()) {
                                    String n = (String)entry.getKey();
                                    ParsedUDL pUdl = (ParsedUDL)entry.getValue();
                                    if (n.equals(sName) || cMsg.this.currentParsedUDL.cloud != 0 && !pUdl.local) continue;
                                    String newSubRemainder = cMsg.this.currentParsedUDL.subRemainder;
                                    if (cMsg.this.currentParsedUDL.password.length() > 0) {
                                        Pattern pattern = Pattern.compile("([\\?&])cmsgpassword=([^&]+)", 2);
                                        Matcher matcher = pattern.matcher(cMsg.this.currentParsedUDL.subRemainder);
                                        newSubRemainder = pUdl.password.length() > 0 ? matcher.replaceFirst("$1cmsgpassword=" + pUdl.password) : matcher.replaceFirst("");
                                    } else if (pUdl.password.length() > 0) {
                                        newSubRemainder = cMsg.this.currentParsedUDL.subRemainder.contains("?") ? cMsg.this.currentParsedUDL.subRemainder.concat("&cmsgpassword=" + pUdl.password) : cMsg.this.currentParsedUDL.subRemainder.concat("?cmsgpassword=" + pUdl.password);
                                    }
                                    cMsg.this.currentParsedUDL.UDL = "cMsg://" + n + "/" + cMsg.this.currentParsedUDL.subdomain + "/" + newSubRemainder;
                                    cMsg.this.currentParsedUDL.subRemainder = newSubRemainder;
                                    cMsg.this.currentParsedUDL.password = pUdl.password;
                                    cMsg.this.currentParsedUDL.nameServerHost = pUdl.nameServerHost;
                                    cMsg.this.currentParsedUDL.nameServerTcpPort = pUdl.nameServerTcpPort;
                                    cMsg.this.currentParsedUDL.mustMulticast = false;
                                    try {
                                        this.connectToServer();
                                        weGotAConnection = true;
                                        continue block22;
                                    }
                                    catch (cMsgException cMsgException2) {
                                    }
                                }
                                if (cloudOnly) {
                                    try {
                                        cMsg.this.localDisconnect(cMsg.this.disconnectCalled);
                                        return;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                        return;
                                    }
                                }
                            }
                        }
                        List list = cMsg.this.failoverUdls;
                        synchronized (list) {
                            byte failedFailoverIndex = cMsg.this.failoverIndex;
                            if (failedFailoverIndex != 0) {
                                cMsg.this.failoverIndex = (byte)0;
                            } else {
                                cMsg.this.failoverIndex = (byte)1;
                            }
                            while (!weGotAConnection && cMsg.this.failoverIndex < cMsg.this.failoverUdls.size()) {
                                if (cMsg.this.failoverIndex == failedFailoverIndex) {
                                    cMsg.access$1208(cMsg.this);
                                    continue;
                                }
                                cMsg.this.currentParsedUDL = (ParsedUDL)cMsg.this.failoverUdls.get(cMsg.this.failoverIndex);
                                try {
                                    this.connectToServer();
                                    weGotAConnection = true;
                                }
                                catch (cMsgException e) {
                                    cMsg.access$1208(cMsg.this);
                                }
                            }
                            continue;
                        }
                    }
                    finally {
                        cMsg.this.connectLock.unlock();
                        continue;
                    }
                }
                break;
            }
        }

        private void connectToServer() throws cMsgException {
            if (cMsg.this.currentParsedUDL.mustMulticast) {
                cMsg.this.connectWithMulticast();
            }
            cMsg.this.reconnect();
            try {
                cMsg.this.restoreSubscriptions();
            }
            catch (cMsgException e) {
                try {
                    cMsg.this.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void getMonitorInfo() throws IOException {
            int itemsToFollow;
            int len = this.in.readInt();
            if (len > 0) {
                if (len > this.monitorBytes.length) {
                    this.monitorBytes = new byte[len];
                }
                this.in.readFully(this.monitorBytes, 0, len);
                cMsg.this.monitorXML = new String(this.monitorBytes, 0, len, "US-ASCII");
            }
            if ((itemsToFollow = this.in.readInt()) > 0) {
                Map map = cMsg.this.cloudServers;
                synchronized (map) {
                    cMsg.this.cloudServers.clear();
                    cMsg.this.haveLocalCloudServer = false;
                    String passwd = null;
                    int numServers = this.in.readInt();
                    if (numServers > 0) {
                        for (int i = 0; i < numServers; ++i) {
                            String s = "";
                            boolean isLocal = false;
                            int tcpPort = this.in.readInt();
                            int udpPort = this.in.readInt();
                            int hlen = this.in.readInt();
                            int plen = this.in.readInt();
                            if (hlen > 0) {
                                if (hlen > this.monitorBytes.length) {
                                    this.monitorBytes = new byte[hlen];
                                }
                                this.in.readFully(this.monitorBytes, 0, hlen);
                                s = new String(this.monitorBytes, 0, hlen, "US-ASCII");
                                isLocal = cMsgUtilities.isHostLocal(s);
                                cMsg.this.haveLocalCloudServer = cMsg.this.haveLocalCloudServer | isLocal;
                            }
                            if (plen > 0) {
                                if (plen > this.monitorBytes.length) {
                                    this.monitorBytes = new byte[plen];
                                }
                                this.in.readFully(this.monitorBytes, 0, plen);
                                passwd = new String(this.monitorBytes, 0, plen, "US-ASCII");
                            }
                            String name = s + ":" + tcpPort;
                            ParsedUDL p = new ParsedUDL(name, passwd, s, tcpPort, udpPort, isLocal);
                            cMsg.this.cloudServers.put(name, p);
                        }
                    }
                }
            }
        }
    }

    class ParsedUDL {
        String serverName;
        String UDL;
        String UDLremainder;
        String subdomain;
        String subRemainder;
        String password;
        String preferredSubnet;
        String nameServerHost;
        int nameServerTcpPort;
        int domainServerTcpPort;
        int nameServerUdpPort;
        int multicastTimeout;
        int regime;
        int failover;
        int cloud;
        boolean mustMulticast;
        boolean local;

        ParsedUDL(String name, String pswrd, String host, int tcpPort, int udpPort, boolean isLocal) {
            this.serverName = name;
            this.password = pswrd == null ? "" : pswrd;
            this.nameServerHost = host;
            this.nameServerTcpPort = tcpPort;
            this.nameServerUdpPort = udpPort;
            this.local = isLocal;
        }

        ParsedUDL(String s1, String s2, String s3, String s4, String s5, String s6, String s7, int i1, int i2, int i3, int i4, int i5, int i6, int i7, boolean b1, boolean b2) {
            this.UDL = s1;
            this.UDLremainder = s2;
            this.subdomain = s3;
            this.subRemainder = s4;
            this.password = s5;
            this.nameServerHost = s6;
            this.preferredSubnet = s7;
            this.nameServerTcpPort = i1;
            this.domainServerTcpPort = i2;
            this.nameServerUdpPort = i3;
            this.multicastTimeout = i4;
            this.regime = i5;
            this.failover = i6;
            this.cloud = i7;
            this.mustMulticast = b1;
            this.local = b2;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("Copy from stored parsed UDL to local :");
            sb.append("  UDL                 = ");
            sb.append(this.UDL);
            sb.append("  UDLremainder        = ");
            sb.append(this.UDLremainder);
            sb.append("  subdomain           = ");
            sb.append(this.subdomain);
            sb.append("  subRemainder        = ");
            sb.append(this.subRemainder);
            sb.append("  password            = ");
            sb.append(this.password);
            sb.append("  preferredSubnet     = ");
            sb.append(this.preferredSubnet);
            sb.append("  nameServerHost      = ");
            sb.append(this.nameServerHost);
            sb.append("  nameServerTcpPort   = ");
            sb.append(this.nameServerTcpPort);
            sb.append("  domainServerTcpPort = ");
            sb.append(this.domainServerTcpPort);
            sb.append("  nameServerUdpPort   = ");
            sb.append(this.nameServerUdpPort);
            sb.append("  multicastTimeout    = ");
            sb.append(this.multicastTimeout);
            sb.append("  mustMulticast       = ");
            sb.append(this.mustMulticast);
            sb.append("  isLocal             = ");
            sb.append(this.local);
            if (this.regime == 2) {
                sb.append("  regime              = high");
            } else if (this.regime == 1) {
                sb.append("  regime              = low");
            } else {
                sb.append("  regime              = medium");
            }
            if (this.failover == 0) {
                sb.append("  failover            = any");
            } else if (this.failover == 1) {
                sb.append("  failover            = cloud");
            } else {
                sb.append("  failover            = cloud only");
            }
            if (this.cloud == 0) {
                sb.append("  cloud               = any");
            } else if (this.cloud == 1) {
                sb.append("  cloud               = local");
            } else {
                sb.append("  cloud               = local now");
            }
            return sb.toString();
        }
    }

    class Multicaster
    extends Thread {
        DatagramPacket packet;

        Multicaster(DatagramPacket udpPacket) {
            this.packet = udpPacket;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
                while (true) {
                    try {
                        Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                        while (enumer.hasMoreElements()) {
                            NetworkInterface ni = enumer.nextElement();
                            if (!ni.isUp()) continue;
                            cMsg.this.udpSocket.setNetworkInterface(ni);
                            cMsg.this.udpSocket.send(this.packet);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    class UdpReceiver
    extends Thread {
        UdpReceiver() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(200L);
                byte[] buf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(buf, 1024);
                while (true) {
                    try {
                        int listLen;
                        while (true) {
                            packet.setLength(1024);
                            try {
                                cMsg.this.udpSocket.receive(packet);
                            }
                            catch (SocketTimeoutException e) {
                                if (!Thread.interrupted()) continue;
                                return;
                            }
                            if (packet.getLength() < 24) continue;
                            int magicInt1 = cMsgUtilities.bytesToInt(buf, 0);
                            int magicInt2 = cMsgUtilities.bytesToInt(buf, 4);
                            int magicInt3 = cMsgUtilities.bytesToInt(buf, 8);
                            if (magicInt1 != cMsgNetworkConstants.magicNumbers[0] || magicInt2 != cMsgNetworkConstants.magicNumbers[1] || magicInt3 != cMsgNetworkConstants.magicNumbers[2]) continue;
                            cMsg.this.currentParsedUDL.nameServerTcpPort = cMsgUtilities.bytesToInt(buf, 12);
                            if (cMsg.this.currentParsedUDL.nameServerTcpPort < 1024 || cMsg.this.currentParsedUDL.nameServerTcpPort > 65535) continue;
                            listLen = cMsgUtilities.bytesToInt(buf, 20);
                            if (listLen >= 0 && listLen <= 50) break;
                            System.out.println("  Wrong format for multicast response packet, listLen = " + listLen);
                        }
                        int pos = 24;
                        cMsg.this.ipList.clear();
                        cMsg.this.broadList.clear();
                        for (int i = 0; i < listLen; ++i) {
                            try {
                                int stringLen = cMsgUtilities.bytesToInt(buf, pos);
                                String ss = new String(buf, pos += 4, stringLen, "US-ASCII");
                                cMsg.this.ipList.add(ss);
                                pos += stringLen;
                                stringLen = cMsgUtilities.bytesToInt(buf, pos);
                                ss = new String(buf, pos += 4, stringLen, "US-ASCII");
                                cMsg.this.broadList.add(ss);
                                pos += stringLen;
                                continue;
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
                cMsg.this.multicastResponse.countDown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

