/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import java.util.Arrays;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;

public class cMsgProducer {
    private String subject = "SUBJECT";
    private String type = "TYPE";
    private String name = "producer";
    private String description = "java producer";
    private String UDL = "cMsg://multicast/cMsg/myNameSpace";
    private String text;
    private char[] textChars;
    private int textSize;
    private boolean sendText;
    private byte[] binArray;
    private int binSize;
    private boolean sendBinary;
    private int delay;
    private int count = 50000;
    private boolean debug;
    private boolean useSyncSend;

    cMsgProducer(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgProducer.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-ss")) {
                this.useSyncSend = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-text")) {
                this.text = args[i + 1];
                this.sendText = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-textsize")) {
                this.textSize = Integer.parseInt(args[i + 1]);
                this.textChars = new char[this.textSize];
                Arrays.fill(this.textChars, 'A');
                this.text = new String(this.textChars);
                System.out.println("text len = " + this.text.length());
                this.sendText = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-binsize")) {
                this.binSize = Integer.parseInt(args[i + 1]);
                this.binArray = new byte[this.binSize];
                for (int j = 0; j < this.binSize; ++j) {
                    this.binArray[j] = (byte)(j % 255);
                }
                System.out.println("binary size = " + this.binSize);
                this.sendBinary = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                this.count = Integer.parseInt(args[i + 1]);
                if (this.count < 1) {
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            cMsgProducer.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgProducer\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-c <count>]         set # of messages to send before printing output\n        [-text <text>]       set text of sent messages\n        [-textsize <size>]   set text to 'size' number of ASCII chars (bytes)\n        [-binsize <size>]    set binary array to 'size' number of bytes\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-ss]                use syncSend instead of send\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            cMsgProducer producer = new cMsgProducer(args);
            producer.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    private static String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg producer sending to:\n    subject = " + this.subject + "\n    type    = " + this.type + "\n    UDL     = " + this.UDL);
        }
        cMsg coda = new cMsg(this.UDL, this.name, this.description);
        try {
            coda.connect();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("We are connected to host " + coda.getServerHost() + " on port " + coda.getServerPort());
        cMsgMessage msg = new cMsgMessage();
        msg.setSubject(this.subject);
        msg.setType(this.type);
        msg.setHistoryLengthMax(0);
        if (this.sendText) {
            msg.setText(this.text);
        }
        if (this.sendBinary) {
            msg.setByteArrayNoCopy(this.binArray);
        }
        double freq = 0.0;
        double freqAvg = 0.0;
        long totalT = 0L;
        long totalC = 0L;
        long ignore = 0L;
        while (true) {
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < this.count; ++i) {
                if (this.useSyncSend) {
                    int n = coda.syncSend(msg, 1000);
                } else {
                    msg.setUserInt(i);
                    coda.send(msg);
                }
                coda.flush(0);
                if (this.delay == 0) continue;
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            long t2 = System.currentTimeMillis();
            if (ignore == 0L) {
                long deltaT = t2 - t1;
                freq = (double)this.count / (double)deltaT * 1000.0;
                freqAvg = (double)(totalC += (long)this.count) / (double)(totalT += deltaT) * 1000.0;
                if (!this.debug) continue;
                System.out.println(cMsgProducer.doubleToString(freq, 1) + " Hz, Avg = " + cMsgProducer.doubleToString(freqAvg, 1) + " Hz");
                continue;
            }
            --ignore;
        }
    }

    class myCallback
    extends cMsgCallbackAdapter {
        myCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            System.out.println("Received msg: ");
            System.out.println(msg.toString(true, false, true));
        }
    }
}

