/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.RCDomain;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.RCDomain.rcListeningThread;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgDomainAdapter;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubscription;

public class RunControl
extends cMsgDomainAdapter {
    private rcListeningThread listeningThread;
    private String expid;
    private int connectTimeout = 30000;
    private String specifiedLocalIp;
    private String specifiedLocalSubnet;
    volatile boolean abandonConnection;
    volatile InetAddress rcServerAddress;
    volatile int rcUdpServerPort;
    volatile int rcTcpServerPort;
    private InetAddress rcMulticastServerAddress;
    private int rcMulticastServerPort;
    private DatagramPacket sendUdpPacket;
    private MulticastSocket multicastUdpSocket;
    private DatagramSocket udpSocket;
    Socket tcpSocket;
    DataOutputStream domainOut;
    public Set<cMsgSubscription> subscriptions;
    private Map<Object, cMsgSubscription> unsubscriptions;
    private final ReentrantReadWriteLock methodLock = new ReentrantReadWriteLock();
    private Lock connectLock = this.methodLock.writeLock();
    private Lock notConnectLock = this.methodLock.readLock();
    private Lock subscribeLock = new ReentrantLock();
    private Lock socketLock = new ReentrantLock();
    private AtomicInteger uniqueId;
    private CountDownLatch multicastResponse;
    CountDownLatch connectCompletion;

    public RunControl() {
        this.domain = "rc";
        this.subscriptions = new HashSet<cMsgSubscription>(20);
        this.uniqueId = new AtomicInteger();
        this.unsubscriptions = Collections.synchronizedMap(new HashMap(20));
    }

    @Override
    public String getServerHost() {
        return this.rcServerAddress.getHostAddress();
    }

    @Override
    public int getServerPort() {
        return this.rcTcpServerPort;
    }

    @Override
    public void flush(int timeout) throws cMsgException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws cMsgException {
        this.connectLock.lock();
        this.parseUDL(this.UDLremainder);
        try {
            DatagramPacket udpPacket;
            ServerSocketChannel serverChannel;
            if (this.connected) {
                return;
            }
            System.out.println("RC connect: connecting");
            this.multicastResponse = new CountDownLatch(1);
            this.connectCompletion = new CountDownLatch(1);
            int startingPort = 0;
            try {
                String env = System.getenv("CMSG_RC_CLIENT_PORT");
                if (env != null) {
                    startingPort = Integer.parseInt(env);
                }
            }
            catch (NumberFormatException env) {
                // empty catch block
            }
            if (startingPort < 1024) {
                startingPort = 45700;
            }
            try {
                serverChannel = ServerSocketChannel.open();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw new cMsgException("connect: cannot open a listening socket", ex);
            }
            int port = startingPort;
            ServerSocket listeningSocket = serverChannel.socket();
            while (true) {
                try {
                    listeningSocket.bind(new InetSocketAddress(port));
                }
                catch (IOException ex) {
                    if (port < 65535) {
                        ++port;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        serverChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ex.printStackTrace();
                    throw new cMsgException("connect: cannot find port to listen on", ex);
                }
                break;
            }
            System.out.println("RC connect: start listening thread on port " + port);
            this.listeningThread = new rcListeningThread(this, serverChannel);
            this.listeningThread.start();
            rcListeningThread ex = this.listeningThread;
            synchronized (ex) {
                if (!this.listeningThread.isAlive()) {
                    try {
                        this.listeningThread.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            System.out.println("RC connect: listening thread started, create multicast packet");
            byte[] multicastData = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                String[] broadcastAddrs;
                String[] ipAddrs;
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(6);
                out.writeInt(2);
                out.writeInt(port);
                out.writeInt((int)System.currentTimeMillis());
                out.writeInt(this.name.length());
                out.writeInt(this.expid.length());
                try {
                    out.write(this.name.getBytes("US-ASCII"));
                    out.write(this.expid.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                int i = 0;
                int addrCount = 1;
                if (this.specifiedLocalIp != null && this.specifiedLocalSubnet != null) {
                    ipAddrs = new String[]{this.specifiedLocalIp};
                    broadcastAddrs = new String[]{this.specifiedLocalSubnet};
                } else {
                    List<InterfaceAddress> ifAddrs = cMsgUtilities.getAllIpInfo();
                    addrCount = ifAddrs.size();
                    ipAddrs = new String[addrCount];
                    broadcastAddrs = new String[addrCount];
                    for (InterfaceAddress ifAddr : ifAddrs) {
                        Inet4Address bAddr;
                        try {
                            bAddr = (Inet4Address)ifAddr.getBroadcast();
                        }
                        catch (ClassCastException e) {
                            continue;
                        }
                        broadcastAddrs[i] = bAddr.getHostAddress();
                        ipAddrs[i++] = ifAddr.getAddress().getHostAddress();
                    }
                }
                out.writeInt(addrCount);
                for (int j = 0; j < addrCount; ++j) {
                    try {
                        out.writeInt(ipAddrs[j].length());
                        out.write(ipAddrs[j].getBytes("US-ASCII"));
                        out.writeInt(broadcastAddrs[j].length());
                        out.write(broadcastAddrs[j].getBytes("US-ASCII"));
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                out.writeInt(1);
                out.flush();
                out.close();
                this.multicastUdpSocket = new MulticastSocket();
                int tries = 20;
                while (this.multicastUdpSocket.getLocalPort() > 44999 && this.multicastUdpSocket.getLocalPort() < 46200) {
                    this.multicastUdpSocket = new MulticastSocket();
                    if (--tries >= 0) continue;
                }
                this.multicastUdpSocket.setTimeToLive(32);
                multicastData = baos.toByteArray();
                udpPacket = new DatagramPacket(multicastData, multicastData.length, this.rcMulticastServerAddress, this.rcMulticastServerPort);
                baos.close();
            }
            catch (IOException e) {
                this.listeningThread.killThread();
                try {
                    out.close();
                }
                catch (IOException addrCount) {
                    // empty catch block
                }
                try {
                    baos.close();
                }
                catch (IOException addrCount) {
                    // empty catch block
                }
                if (this.multicastUdpSocket != null) {
                    this.multicastUdpSocket.close();
                }
                if (this.debug >= 2) {
                    System.out.println("I/O Error: " + e);
                }
                throw new cMsgException(e.getMessage(), e);
            }
            System.out.println("RC connect: RC client " + this.name + ": will start multicast sender thread");
            Multicaster sender = new Multicaster(udpPacket, multicastData);
            sender.start();
            boolean completed = false;
            if (this.connectTimeout > 0) {
                try {
                    System.out.println("RC connect: waiting for a response to final connection (with timeout)");
                    if (this.connectCompletion.await(this.connectTimeout, TimeUnit.MILLISECONDS)) {
                        completed = true;
                    }
                }
                catch (InterruptedException ipAddrs) {}
            } else {
                System.out.println("RC connect: waiting for a response to final connection (no timeout)");
                try {
                    this.connectCompletion.await();
                    completed = true;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.abandonConnection) {
                sender.interrupt();
                this.listeningThread.killThread();
                throw new cMsgException("RC Multicast server says to abort the connect attempt");
            }
            if (!completed) {
                System.out.println("RC connect: Did NOT complete the connection within timeout");
                sender.interrupt();
                this.listeningThread.killThread();
                throw new cMsgException("No connect from the RC server received");
            }
            System.out.println("RC connect: Completed the connection from RC server");
            this.multicastUdpSocket.close();
            sender.interrupt();
            boolean gotTcpConnection = false;
            IOException ioex = null;
            try {
                System.out.println("RC connect: Try making tcp connection to RC server (host = " + this.rcServerAddress.getHostName() + ", " + this.rcServerAddress.getHostAddress() + "; port = " + this.rcTcpServerPort + ")");
                this.tcpSocket = new Socket();
                this.tcpSocket.connect(new InetSocketAddress(this.rcServerAddress, this.rcTcpServerPort), 2000);
                this.tcpSocket.setTcpNoDelay(true);
                this.tcpSocket.setSendBufferSize(131072);
                this.domainOut = new DataOutputStream(new BufferedOutputStream(this.tcpSocket.getOutputStream(), 131072));
                System.out.println("RC connect: made tcp connection to host " + this.rcServerAddress + ", port " + this.rcTcpServerPort);
                gotTcpConnection = true;
            }
            catch (SocketTimeoutException e) {
                System.out.println("RC connect: connection TIMEOUT");
                ioex = e;
            }
            catch (IOException e) {
                System.out.println("RC connect: connection failed");
                ioex = e;
            }
            if (!gotTcpConnection) {
                this.listeningThread.killThread();
                if (this.domainOut != null) {
                    try {
                        this.domainOut.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.tcpSocket != null) {
                    try {
                        this.tcpSocket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw new cMsgException("Cannot make TCP connection to RC server", ioex);
            }
            try {
                this.udpSocket = new DatagramSocket();
                this.udpSocket.setReceiveBufferSize(131072);
            }
            catch (SocketException e) {
                this.listeningThread.killThread();
                if (this.udpSocket != null) {
                    this.udpSocket.close();
                }
                e.printStackTrace();
            }
            this.udpSocket.connect(this.rcServerAddress, this.rcUdpServerPort);
            this.sendUdpPacket = new DatagramPacket(new byte[0], 0, this.rcServerAddress, this.rcUdpServerPort);
            this.connected = true;
        }
        finally {
            this.connectLock.unlock();
        }
        System.out.println("RC connect: SUCCESSFUL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public cMsgMessage monitor(String command) throws cMsgException {
        final CountDownLatch startLatch = new CountDownLatch(1);
        this.connectLock.lock();
        if (this.expid == null) {
            this.parseUDL(this.UDLremainder);
        }
        int sleepTime = 1000;
        if (command != null) {
            try {
                int t = Integer.parseInt(command);
                if (t > -1) {
                    sleepTime = t;
                }
            }
            catch (NumberFormatException t) {
                // empty catch block
            }
        }
        try {
            byte[] buffer;
            DatagramSocket socket = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(6);
                out.writeInt(16);
                out.writeInt(0);
                out.writeInt(0);
                out.writeInt(this.name.length());
                out.writeInt(this.expid.length());
                try {
                    out.write(this.name.getBytes("US-ASCII"));
                    out.write(this.expid.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                out.flush();
                out.close();
                socket = new MulticastSocket();
                int tries = 20;
                while (socket.getLocalPort() > 44999 && socket.getLocalPort() < 46200) {
                    socket = new MulticastSocket();
                    if (--tries >= 0) continue;
                }
                socket.setReceiveBufferSize(1024);
                socket.setSoTimeout(sleepTime);
                ((MulticastSocket)socket).setTimeToLive(32);
                baos.close();
                buffer = baos.toByteArray();
            }
            catch (IOException e) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    baos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (socket != null) {
                    socket.close();
                }
                System.out.println("Cannot create rc multicast packet");
                cMsgMessage cMsgMessage2 = null;
                this.connectLock.unlock();
                return cMsgMessage2;
            }
            class RcMulticastReceiver
            extends Thread {
                String host;
                DatagramSocket socket;
                volatile cMsgMessageFull msg;

                RcMulticastReceiver(DatagramSocket socket) {
                    this.socket = socket;
                }

                public cMsgMessage getMsg() {
                    return this.msg;
                }

                public String getMsgHost() {
                    String name = null;
                    try {
                        name = Inet4Address.getByName(this.host).getCanonicalHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    return name;
                }

                @Override
                public void run() {
                    byte[] buf = new byte[1024];
                    DatagramPacket packet = new DatagramPacket(buf, 1024);
                    startLatch.countDown();
                    while (true) {
                        packet.setLength(1024);
                        try {
                            this.socket.receive(packet);
                            if (packet.getLength() < 24) {
                                if (RunControl.this.debug < 3) continue;
                                System.out.println("monitor: got packet that's too small");
                                continue;
                            }
                            int magic1 = cMsgUtilities.bytesToInt(buf, 0);
                            int magic2 = cMsgUtilities.bytesToInt(buf, 4);
                            int magic3 = cMsgUtilities.bytesToInt(buf, 8);
                            if (magic1 != cMsgNetworkConstants.magicNumbers[0] || magic2 != cMsgNetworkConstants.magicNumbers[1] || magic3 != cMsgNetworkConstants.magicNumbers[2]) {
                                if (RunControl.this.debug < 3) continue;
                                System.out.println("monitor: got bad magic # response to multicast");
                                continue;
                            }
                            int version = cMsgUtilities.bytesToInt(buf, 12);
                            int port = cMsgUtilities.bytesToInt(buf, 16);
                            int hostLen = cMsgUtilities.bytesToInt(buf, 20);
                            int expidLen = cMsgUtilities.bytesToInt(buf, 24);
                            if (packet.getLength() < 24 + hostLen + expidLen) {
                                if (RunControl.this.debug < 3) continue;
                                System.out.println("monitor: got packet that's too small");
                                continue;
                            }
                            int index = 28;
                            this.host = "";
                            if (hostLen > 0) {
                                this.host = new String(buf, index, hostLen, "US-ASCII");
                                index += hostLen;
                            }
                            if (expidLen > 0) {
                                String serverExpid = new String(buf, index, expidLen, "US-ASCII");
                                index += expidLen;
                                if (!RunControl.this.expid.equals(serverExpid)) {
                                    if (RunControl.this.debug < 3) continue;
                                    System.out.println("monitor: ignore response from expid = " + serverExpid);
                                    continue;
                                }
                            }
                            int ipCount = cMsgUtilities.bytesToInt(buf, index);
                            index += 4;
                            if (ipCount < 0 || ipCount > 50) {
                                if (RunControl.this.debug < 3) continue;
                                System.out.println("monitor: bad ip address count (" + ipCount + ")");
                                continue;
                            }
                            String[] ipAddrs = new String[ipCount];
                            for (int i = 0; i < ipCount; ++i) {
                                int ipLen = cMsgUtilities.bytesToInt(buf, index);
                                index += 4;
                                if (ipLen > 0) {
                                    ipAddrs[i] = new String(buf, index, ipLen, "US-ASCII");
                                    index += ipLen;
                                }
                                ipLen = cMsgUtilities.bytesToInt(buf, index);
                                index += 4 + ipLen;
                            }
                            this.msg = new cMsgMessageFull();
                            this.msg.setSenderHost(this.host);
                            if (ipCount <= 0) break;
                            try {
                                this.msg.addPayloadItem(new cMsgPayloadItem("IpAddresses", ipAddrs));
                            }
                            catch (cMsgException cMsgException2) {}
                        }
                        catch (InterruptedIOException e) {
                            return;
                        }
                        catch (IOException e) {
                            return;
                        }
                        catch (Exception e) {
                            continue;
                        }
                        break;
                    }
                }
            }
            RcMulticastReceiver receiver = new RcMulticastReceiver(socket);
            receiver.start();
            try {
                startLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DatagramPacket packet = null;
            try {
                InetAddress addr = InetAddress.getByName("239.210.0.0");
                packet = new DatagramPacket(buffer, buffer.length, addr, this.rcMulticastServerPort);
            }
            catch (UnknownHostException addr) {
                // empty catch block
            }
            int waitTime = 0;
            try {
                Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                while (enumer.hasMoreElements()) {
                    NetworkInterface ni = enumer.nextElement();
                    if (!ni.isUp()) continue;
                    ((MulticastSocket)socket).setNetworkInterface(ni);
                    socket.send(packet);
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            while (receiver.getMsg() == null && waitTime < sleepTime) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                waitTime += 500;
            }
            cMsgMessage cMsgMessage3 = receiver.getMsg();
            return cMsgMessage3;
        }
        finally {
            this.connectLock.unlock();
        }
    }

    void parseUDL(String udlRemainder) throws cMsgException {
        String remainder;
        String udlExpid;
        String udlPort;
        String udlHost;
        if (udlRemainder == null) {
            throw new cMsgException("invalid UDL");
        }
        Pattern pattern = Pattern.compile("([^:/?]+):?(\\d+)?/([^?&]+)(.*)");
        Matcher matcher = pattern.matcher(udlRemainder);
        if (matcher.find()) {
            udlHost = matcher.group(1);
            udlPort = matcher.group(2);
            udlExpid = matcher.group(3);
            remainder = matcher.group(4);
            if (this.debug >= 4) {
                System.out.println("\nparseUDL: \n  host      = " + udlHost + "\n  port      = " + udlPort + "\n  expid     = " + udlExpid + "\n  remainder = " + remainder);
            }
        } else {
            throw new cMsgException("invalid UDL");
        }
        if (udlHost == null) {
            throw new cMsgException("parseUDL: must specify a host (or multicast, localhost)");
        }
        if (udlHost.equalsIgnoreCase("multicast")) {
            udlHost = "239.210.0.0";
        } else if (udlHost.equalsIgnoreCase("localhost")) {
            try {
                udlHost = InetAddress.getLocalHost().getCanonicalHostName();
                if (this.debug >= 3) {
                    System.out.println("parseUDL: codaComponent host given as \"localhost\", substituting " + udlHost);
                }
            }
            catch (UnknownHostException e) {
                udlHost = "239.210.0.0";
            }
        } else {
            try {
                if (!InetAddress.getByName(udlHost).isMulticastAddress()) {
                    udlHost = InetAddress.getByName(udlHost).getCanonicalHostName();
                }
            }
            catch (UnknownHostException e) {
                udlHost = "239.210.0.0";
            }
        }
        try {
            this.rcMulticastServerAddress = InetAddress.getByName(udlHost);
        }
        catch (UnknownHostException e) {
            throw new cMsgException("parseUDL: cannot find host", e);
        }
        if (udlPort != null && udlPort.length() > 0) {
            try {
                this.rcMulticastServerPort = Integer.parseInt(udlPort);
            }
            catch (NumberFormatException e) {
                this.rcMulticastServerPort = 45200;
                if (this.debug >= 3) {
                    System.out.println("parseUDL: non-integer port, guessing codaComponent port is " + this.rcMulticastServerPort);
                }
            }
        } else {
            this.rcMulticastServerPort = 45200;
            if (this.debug >= 3) {
                System.out.println("parseUDL: guessing codaComponent port is " + this.rcMulticastServerPort);
            }
        }
        if (this.rcMulticastServerPort < 1024 || this.rcMulticastServerPort > 65535) {
            throw new cMsgException("parseUDL: illegal port number");
        }
        if (udlExpid == null) {
            throw new cMsgException("parseUDL: must specify the EXPID");
        }
        this.expid = udlExpid;
        if (remainder == null) {
            return;
        }
        pattern = Pattern.compile("[\\?&]connectTO=([0-9]+)", 2);
        matcher = pattern.matcher(remainder);
        if (matcher.find()) {
            try {
                this.connectTimeout = 1000 * Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]ip=((?:[0-9]{1,3}\\.){3}[0-9]{1,3})", 2)).matcher(remainder)).find()) {
            this.specifiedLocalIp = matcher.group(1);
            if (!cMsgUtilities.isHostLocal(this.specifiedLocalIp)) {
                throw new cMsgException("parseUDL: " + this.specifiedLocalIp + " must be a valid local IP address");
            }
            try {
                this.specifiedLocalSubnet = cMsgUtilities.getBroadcastAddress(this.specifiedLocalIp);
            }
            catch (cMsgException e) {
                throw new cMsgException("parseUDL: ip address not in dot-decimal format");
            }
            if (this.specifiedLocalSubnet == null) {
                throw new cMsgException("parseUDL: cannot find the subnet address corresponding to " + this.specifiedLocalIp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.connectLock.lock();
        try {
            if (!this.connected) {
                return;
            }
            this.connected = false;
            this.multicastUdpSocket.close();
            this.udpSocket.close();
            try {
                this.tcpSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.domainOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.listeningThread.killThread();
            Set<cMsgSubscription> set = this.subscriptions;
            synchronized (set) {
                for (cMsgSubscription sub : this.subscriptions) {
                    for (cMsgCallbackThread cbThread : sub.getCallbacks()) {
                        if (Thread.currentThread() == cbThread) {
                            cbThread.dieNow(false);
                            continue;
                        }
                        cbThread.dieNow(true);
                    }
                }
                this.subscriptions.clear();
                this.unsubscriptions.clear();
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public void send(cMsgMessage message) throws cMsgException {
        if (!message.getReliableSend()) {
            this.udpSend(message);
            return;
        }
        String subject = message.getSubject();
        String type = message.getType();
        if (subject == null || type == null) {
            throw new cMsgException("message subject and/or type is null");
        }
        String text = message.getText();
        int textLen = 0;
        if (text != null) {
            textLen = text.length();
        }
        String payloadTxt = message.getPayloadText();
        int payloadLen = 0;
        if (payloadTxt != null) {
            payloadLen = payloadTxt.length();
        }
        int msgType = 21;
        if (message.isGetResponse()) {
            msgType = 20;
        }
        int binaryLength = message.getByteArrayLength();
        this.notConnectLock.lock();
        this.socketLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            int totalLength = 60 + this.name.length() + subject.length() + type.length() + payloadLen + textLen + binaryLength;
            this.domainOut.writeInt(totalLength);
            this.domainOut.writeInt(msgType);
            this.domainOut.writeInt(6);
            this.domainOut.writeInt(message.getUserInt());
            this.domainOut.writeInt(message.getInfo());
            this.domainOut.writeInt(message.getSenderToken());
            long now = new Date().getTime();
            this.domainOut.writeInt((int)(now >>> 32));
            this.domainOut.writeInt((int)(now & 0xFFFFFFFFL));
            this.domainOut.writeInt((int)(message.getUserTime().getTime() >>> 32));
            this.domainOut.writeInt((int)(message.getUserTime().getTime() & 0xFFFFFFFFL));
            this.domainOut.writeInt(this.name.length());
            this.domainOut.writeInt(subject.length());
            this.domainOut.writeInt(type.length());
            this.domainOut.writeInt(payloadLen);
            this.domainOut.writeInt(textLen);
            this.domainOut.writeInt(binaryLength);
            try {
                this.domainOut.write(this.name.getBytes("US-ASCII"));
                this.domainOut.write(subject.getBytes("US-ASCII"));
                this.domainOut.write(type.getBytes("US-ASCII"));
                if (payloadLen > 0) {
                    this.domainOut.write(payloadTxt.getBytes("US-ASCII"));
                }
                if (textLen > 0) {
                    this.domainOut.write(text.getBytes("US-ASCII"));
                }
                if (binaryLength > 0) {
                    this.domainOut.write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.domainOut.flush();
        }
        catch (IOException e) {
            if (this.debug >= 2) {
                System.out.println("send: " + e.getMessage());
            }
            throw new cMsgException(e.getMessage());
        }
        finally {
            this.socketLock.unlock();
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void udpSend(cMsgMessage message) throws cMsgException {
        String subject = message.getSubject();
        String type = message.getType();
        if (subject == null || type == null) {
            throw new cMsgException("message subject and/or type is null");
        }
        String text = message.getText();
        int textLen = 0;
        if (text != null) {
            textLen = text.length();
        }
        String payloadTxt = message.getPayloadText();
        int payloadLen = 0;
        if (payloadTxt != null) {
            payloadLen = payloadTxt.length();
        }
        int msgType = 21;
        if (message.isGetResponse()) {
            msgType = 20;
        }
        int binaryLength = message.getByteArrayLength();
        int totalLength = 60 + this.name.length() + subject.length() + type.length() + payloadLen + textLen + binaryLength;
        if (totalLength > 8192) {
            throw new cMsgException("Too big a message for UDP to send");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        DataOutputStream out = new DataOutputStream(baos);
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new IOException("not connected to server");
            }
            out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
            out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
            out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
            out.writeInt(totalLength);
            out.writeInt(msgType);
            out.writeInt(6);
            out.writeInt(message.getUserInt());
            out.writeInt(message.getInfo());
            out.writeInt(message.getSenderToken());
            long now = new Date().getTime();
            out.writeInt((int)(now >>> 32));
            out.writeInt((int)(now & 0xFFFFFFFFL));
            out.writeInt((int)(message.getUserTime().getTime() >>> 32));
            out.writeInt((int)(message.getUserTime().getTime() & 0xFFFFFFFFL));
            out.writeInt(this.name.length());
            out.writeInt(subject.length());
            out.writeInt(type.length());
            out.writeInt(payloadLen);
            out.writeInt(textLen);
            out.writeInt(binaryLength);
            try {
                out.write(this.name.getBytes("US-ASCII"));
                out.write(subject.getBytes("US-ASCII"));
                out.write(type.getBytes("US-ASCII"));
                if (payloadLen > 0) {
                    out.write(payloadTxt.getBytes("US-ASCII"));
                }
                if (textLen > 0) {
                    out.write(text.getBytes("US-ASCII"));
                }
                if (binaryLength > 0) {
                    out.write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            out.flush();
            out.close();
            byte[] buf = baos.toByteArray();
            DatagramPacket datagramPacket = this.sendUdpPacket;
            synchronized (datagramPacket) {
                this.sendUdpPacket.setData(buf, 0, buf.length);
                this.udpSocket.send(this.sendUdpPacket);
            }
        }
        catch (IOException e) {
            throw new cMsgException("Cannot create or send message packet", e);
        }
        finally {
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public cMsgSubscriptionHandle subscribe(String subject, String type, cMsgCallbackInterface cb3, Object userObj) throws cMsgException {
        if (subject == null) throw new cMsgException("subject, type or callback argument is null");
        if (type == null) throw new cMsgException("subject, type or callback argument is null");
        if (cb3 == null) {
            throw new cMsgException("subject, type or callback argument is null");
        }
        if (subject.length() < 1) throw new cMsgException("subject or type is blank string");
        if (type.length() < 1) {
            throw new cMsgException("subject or type is blank string");
        }
        cMsgCallbackThread cbThread = null;
        this.notConnectLock.lock();
        this.subscribeLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to server");
            }
            Set<cMsgSubscription> set = this.subscriptions;
            synchronized (set) {
                for (cMsgSubscription sub : this.subscriptions) {
                    if (!sub.getSubject().equals(subject) || !sub.getType().equals(type)) continue;
                    cbThread = new cMsgCallbackThread(cb3, userObj, this.domain, subject, type);
                    sub.addCallback(cbThread);
                    this.unsubscriptions.put(cbThread, sub);
                    cMsgCallbackThread cMsgCallbackThread2 = cbThread;
                    return cMsgCallbackThread2;
                }
                int id = this.uniqueId.getAndIncrement();
                cbThread = new cMsgCallbackThread(cb3, userObj, this.domain, subject, type);
                cMsgSubscription newSub = new cMsgSubscription(subject, type, id, cbThread);
                this.unsubscriptions.put(cbThread, newSub);
                this.subscriptions.add(newSub);
                return cbThread;
            }
        }
        finally {
            this.subscribeLock.unlock();
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(cMsgSubscriptionHandle obj) throws cMsgException {
        if (obj == null) {
            throw new cMsgException("argument is null");
        }
        cMsgSubscription sub = this.unsubscriptions.remove(obj);
        if (sub == null) {
            return;
        }
        cMsgCallbackThread cbThread = (cMsgCallbackThread)obj;
        this.notConnectLock.lock();
        this.subscribeLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to server");
            }
            Set<cMsgSubscription> set = this.subscriptions;
            synchronized (set) {
                block11: {
                    if (sub.numberOfCallbacks() <= 1) break block11;
                    cbThread.dieNow(false);
                    sub.getCallbacks().remove(cbThread);
                    return;
                }
                cbThread.dieNow(false);
                sub.getCallbacks().remove(cbThread);
                this.subscriptions.remove(sub);
            }
        }
        finally {
            this.subscribeLock.unlock();
            this.notConnectLock.unlock();
        }
    }

    class Multicaster
    extends Thread {
        int counter = 1;
        int counterOffset;
        byte[] data;
        DatagramPacket packet;

        Multicaster(DatagramPacket udpPacket, byte[] multicastData) {
            this.packet = udpPacket;
            this.data = multicastData;
            this.counterOffset = this.data.length - 4;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
                while (true) {
                    try {
                        Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                        while (enumer.hasMoreElements()) {
                            NetworkInterface ni = enumer.nextElement();
                            if (!ni.isUp()) continue;
                            System.out.println("RC client: sending packet #" + this.counter + " over " + ni.getName());
                            RunControl.this.multicastUdpSocket.setNetworkInterface(ni);
                            RunControl.this.multicastUdpSocket.send(this.packet);
                            ++this.counter;
                            this.data[this.counterOffset] = (byte)(this.counter >> 24);
                            this.data[this.counterOffset + 1] = (byte)(this.counter >> 16);
                            this.data[this.counterOffset + 2] = (byte)(this.counter >> 8);
                            this.data[this.counterOffset + 3] = (byte)this.counter;
                            this.packet.setData(this.data);
                            Thread.sleep(200L);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

