/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.cMsg.common.cMsgMessageFull;

public class DoubleTestSender {
    private String subject1 = "doubleSender";
    private String type1 = "type";
    private String subject2 = "doubleReceiver";
    private String type2 = "type";
    private String name = "payload test sender";
    private String description = "java producer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private int delay = 2000;
    private boolean debug;
    cMsg coda;

    DoubleTestSender(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                DoubleTestSender.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            DoubleTestSender.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java DoubleTest\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            DoubleTestSender dts = new DoubleTestSender(args);
            dts.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg double sending test sender");
        }
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        this.coda.start();
        DoubleSendingCallback cb_s = new DoubleSendingCallback();
        cMsgSubscriptionHandle unsub_s = this.coda.subscribe(this.subject1, this.type1, cb_s, null);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    class DoubleSendingCallback
    extends cMsgCallbackAdapter {
        DoubleSendingCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            cMsgMessageFull message = new cMsgMessageFull();
            message.setSubject(DoubleTestSender.this.subject2);
            message.setType(DoubleTestSender.this.type2);
            double d = 0.3333333333333333;
            int i = 2;
            try {
                cMsgPayloadItem item = new cMsgPayloadItem("int", i);
                message.addPayloadItem(item);
                System.out.println("q1 " + msg.getContext().getQueueSize());
                DoubleTestSender.this.coda.send(message);
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }
    }
}

