/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;

public class FileHelper {
    private static final int BUFFER_SIZE = 1024;

    public static void move(File from, File to) throws IOException {
        FileHelper.move(from, to, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move(File from, File to, boolean overwrite) throws IOException {
        if (to.exists()) {
            if (overwrite) {
                if (!to.delete()) {
                    throw new IOException(MessageFormat.format("{0} could not be deleted.", to.toString()));
                }
            } else {
                throw new IOException(MessageFormat.format("{0} already exists.", to.toString()));
            }
        }
        if (from.renameTo(to)) {
            return;
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            FileHelper.copy(in, out);
            ((InputStream)in).close();
            in = null;
            out.flush();
            out.close();
            out = null;
            if (!from.delete()) {
                throw new IOException(MessageFormat.format("{0} copied to {1} but original could not be deleted.", from.toString(), to.toString()));
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
                in = null;
            }
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }
}

