/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.common.Base64;
import org.jlab.coda.cMsg.common.cMsgMessageContextDefault;
import org.jlab.coda.cMsg.common.cMsgMessageContextInterface;

public class cMsgMessage
implements Cloneable,
Serializable {
    public static final int isGetRequest = 1;
    public static final int isGetResponse = 2;
    public static final int isNullGetResponse = 4;
    public static final int isBigEndian = 8;
    public static final int wasSent = 16;
    public static final int hasPayload = 32;
    public static final int expandedPayload = 64;
    public static final int nullGetServerResponse = 128;
    public static final int systemFieldsOnly = 0;
    public static final int payloadFieldsOnly = 1;
    public static final int allFields = 2;
    private static final String timeFormat = "EE MMM dd kk:mm:ss zz yyyy";
    protected static final transient SimpleDateFormat dateFormatter = new SimpleDateFormat("EE MMM dd kk:mm:ss zz yyyy");
    private static final int[] toByte = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};
    private static final int historyLengthAbsoluteMax = 200;
    private static final int historyLengthInit = 20;
    boolean byteArrayCopied = true;
    private int historyLengthMax;
    protected int sysMsgId;
    protected String domain;
    protected int info;
    protected int version;
    protected int reserved;
    protected String subject;
    protected String type;
    protected String text;
    protected int userInt;
    protected long userTime;
    protected byte[] bytes;
    protected int offset;
    protected int length;
    protected transient ConcurrentHashMap<String, cMsgPayloadItem> items = new ConcurrentHashMap();
    private transient StringBuilder buffer = new StringBuilder(512);
    protected String payloadText;
    protected transient boolean noHistoryAdditions;
    protected String sender;
    protected String senderHost;
    protected long senderTime;
    protected int senderToken;
    protected String receiver;
    protected String receiverHost;
    protected long receiverTime;
    protected boolean reliableSend = true;
    protected transient cMsgMessageContextInterface context = new cMsgMessageContextDefault();

    public Object clone() {
        try {
            cMsgMessage result = (cMsgMessage)super.clone();
            result.context = new cMsgMessageContextDefault();
            if (this.bytes != null) {
                result.bytes = (byte[])this.bytes.clone();
                this.byteArrayCopied = true;
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public cMsgMessage() {
        this.version = 6;
        this.info |= 0x48;
        this.historyLengthMax = 20;
    }

    public cMsgMessage(cMsgMessage msg) {
        cMsgMessage.copy(msg, this);
    }

    public static void copy(cMsgMessage src, cMsgMessage dst) {
        dst.sysMsgId = src.sysMsgId;
        dst.domain = src.domain;
        dst.info = src.info;
        dst.version = src.version;
        dst.reserved = src.reserved;
        dst.historyLengthMax = src.historyLengthMax;
        dst.subject = src.subject;
        dst.type = src.type;
        dst.text = src.text;
        dst.userInt = src.userInt;
        dst.userTime = src.userTime;
        dst.byteArrayCopied = src.byteArrayCopied;
        if (src.bytes != null) {
            dst.bytes = src.byteArrayCopied ? (byte[])src.bytes.clone() : src.bytes;
        }
        dst.offset = src.offset;
        dst.length = src.length;
        dst.payloadText = src.payloadText;
        for (Map.Entry<String, cMsgPayloadItem> entry : src.items.entrySet()) {
            dst.items.put(entry.getKey(), (cMsgPayloadItem)entry.getValue().clone());
        }
        dst.sender = src.sender;
        dst.senderHost = src.senderHost;
        dst.senderTime = src.senderTime;
        dst.senderToken = src.senderToken;
        dst.receiver = src.receiver;
        dst.receiverHost = src.receiverHost;
        dst.receiverTime = src.receiverTime;
        dst.context = src.context;
    }

    public cMsgMessage copy() {
        return (cMsgMessage)this.clone();
    }

    public cMsgMessage response() throws cMsgException {
        if (!this.isGetRequest()) {
            throw new cMsgException("this message not sent by client calling sendAndGet");
        }
        cMsgMessage msg = new cMsgMessage();
        msg.subject = "dummy";
        msg.type = "dummy";
        msg.sysMsgId = this.sysMsgId;
        msg.senderToken = this.senderToken;
        msg.info = 2;
        return msg;
    }

    public cMsgMessage nullResponse() throws cMsgException {
        if (!this.isGetRequest()) {
            throw new cMsgException("this message not sent by client calling sendAndGet");
        }
        cMsgMessage msg = new cMsgMessage();
        msg.sysMsgId = this.sysMsgId;
        msg.senderToken = this.senderToken;
        msg.info = 6;
        return msg;
    }

    public void makeResponse(cMsgMessage msg) {
        this.sysMsgId = msg.getSysMsgId();
        this.senderToken = msg.getSenderToken();
        this.info = 2;
    }

    public void makeNullResponse(cMsgMessage msg) {
        this.sysMsgId = msg.getSysMsgId();
        this.senderToken = msg.getSenderToken();
        this.info = 6;
    }

    public boolean noHistoryAdditions() {
        return this.noHistoryAdditions;
    }

    public int getHistoryLengthMax() {
        return this.historyLengthMax;
    }

    public void setHistoryLengthMax(int historyLengthMax) throws cMsgException {
        if (historyLengthMax < 0) {
            throw new cMsgException("historyLengthMax must >= 0");
        }
        if (historyLengthMax > 200) {
            throw new cMsgException("historyLengthMax must <= 200");
        }
        this.historyLengthMax = historyLengthMax;
    }

    public int getSysMsgId() {
        return this.sysMsgId;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isGetResponse() {
        return (this.info & 2) == 2;
    }

    public void setGetResponse(boolean getResponse) {
        this.info = getResponse ? this.info | 2 : this.info & 0xFFFFFFFD;
    }

    public boolean isNullGetResponse() {
        return (this.info & 4) == 4;
    }

    public void setNullGetResponse(boolean nullGetResponse) {
        this.info = nullGetResponse ? this.info | 4 : this.info & 0xFFFFFFFB;
    }

    public boolean isGetRequest() {
        return (this.info & 1) == 1;
    }

    public int getInfo() {
        return this.info;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getUserInt() {
        return this.userInt;
    }

    public void setUserInt(int userInt) {
        this.userInt = userInt;
    }

    public Date getUserTime() {
        return new Date(this.userTime);
    }

    public void setUserTime(Date time) {
        this.userTime = time.getTime();
    }

    public void setUserTime(long time) {
        if (time < 0L) {
            return;
        }
        this.userTime = time;
    }

    public byte[] getByteArray() {
        return this.bytes;
    }

    public void setByteArray(byte[] b) {
        if (b == null || b.length == 0) {
            this.bytes = null;
            this.offset = 0;
            this.length = 0;
            return;
        }
        this.bytes = (byte[])b.clone();
        this.offset = 0;
        this.length = b.length;
        this.byteArrayCopied = true;
    }

    public void setByteArray(byte[] b, int offset, int length) throws cMsgException {
        if (b == null || length == 0) {
            this.bytes = null;
            this.offset = 0;
            this.length = 0;
            return;
        }
        if (length < 0 || length > b.length) {
            throw new cMsgException("length is out of array bounds");
        }
        if (offset < 0 || offset > b.length - 1) {
            throw new cMsgException("offset is out of array bounds");
        }
        if (offset + length > b.length) {
            throw new cMsgException("offset + length is out of array bounds");
        }
        if (offset == 0 && length == b.length) {
            this.setByteArray(b);
            return;
        }
        this.offset = 0;
        this.length = length;
        if (this.bytes == null || length > this.bytes.length) {
            this.bytes = new byte[length];
        }
        this.byteArrayCopied = true;
        System.arraycopy(b, offset, this.bytes, 0, length);
    }

    public void setByteArray(ByteBuffer buf) throws cMsgException {
        if (buf == null || buf.remaining() == 0) {
            this.bytes = null;
            this.offset = 0;
            this.length = 0;
            return;
        }
        int len = buf.remaining();
        if (this.bytes == null || len > this.bytes.length) {
            this.bytes = new byte[len];
        }
        this.offset = 0;
        this.length = len;
        this.byteArrayCopied = true;
        if (buf.hasArray()) {
            System.arraycopy(buf.array(), buf.arrayOffset(), this.bytes, 0, len);
        } else {
            int pos = buf.position();
            buf.get(this.bytes, 0, len);
            buf.position(pos);
        }
    }

    public void setByteArrayNoCopy(byte[] b) {
        if (b == null || b.length == 0) {
            this.bytes = null;
            this.offset = 0;
            this.length = 0;
            return;
        }
        this.bytes = b;
        this.offset = 0;
        this.length = b.length;
        this.byteArrayCopied = false;
    }

    public void setByteArrayNoCopy(byte[] b, int offset, int length) throws cMsgException {
        if (b == null || length == 0) {
            this.bytes = null;
            this.offset = 0;
            this.length = 0;
            return;
        }
        if (length < 0 || length > b.length) {
            throw new cMsgException("length is out of array bounds");
        }
        if (offset < 0 || offset > b.length - 1) {
            throw new cMsgException("offset is out of array bounds");
        }
        if (offset + length > b.length) {
            throw new cMsgException("offset + length is out of array bounds");
        }
        this.bytes = b;
        this.offset = offset;
        this.length = length;
        this.byteArrayCopied = false;
    }

    public int getByteArrayLength() {
        return this.length;
    }

    public int getByteArrayLengthFull() {
        if (this.bytes == null) {
            return 0;
        }
        return this.bytes.length;
    }

    public void setByteArrayLength(int length) throws cMsgException {
        if (length < 0) {
            throw new cMsgException("length is out of array bounds");
        }
        if (this.bytes == null) {
            this.length = length;
            return;
        }
        if (length > this.bytes.length) {
            throw new cMsgException("length is out of array bounds");
        }
        if (this.offset + length > this.bytes.length) {
            throw new cMsgException("offset + length is out of array bounds");
        }
        this.length = length;
    }

    public void resetByteArrayLength() {
        if (this.bytes == null) {
            this.length = 0;
            return;
        }
        this.length = this.bytes.length;
    }

    public int getByteArrayOffset() {
        return this.offset;
    }

    public void setByteArrayOffset(int offset) throws cMsgException {
        if (offset < 0) {
            throw new cMsgException("offset is out of array bounds");
        }
        if (this.bytes == null) {
            this.offset = offset;
            return;
        }
        if (offset > this.bytes.length - 1) {
            throw new cMsgException("offset is out of array bounds");
        }
        if (offset + this.length > this.bytes.length) {
            throw new cMsgException("offset + length is out of array bounds");
        }
        this.offset = offset;
    }

    public int getByteArrayEndian() {
        if ((this.info & 8) > 1) {
            return 0;
        }
        return 1;
    }

    public void setByteArrayEndian(int endian) throws cMsgException {
        if (endian != 0 && endian != 1 && endian != 2 && endian != 3 && endian != 4) {
            throw new cMsgException("improper endian value");
        }
        this.info = endian == 0 || endian == 2 ? (this.info |= 8) : (endian == 4 ? ((this.info & 8) > 1 ? (this.info &= 0xFFFFFFF7) : (this.info |= 8)) : (this.info &= 0xFFFFFFF7));
    }

    public boolean needToSwap() {
        return (this.info & 8) <= 1;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSenderHost() {
        return this.senderHost;
    }

    public Date getSenderTime() {
        return new Date(this.senderTime);
    }

    public int getSenderToken() {
        return this.senderToken;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public String getReceiverHost() {
        return this.receiverHost;
    }

    public Date getReceiverTime() {
        return new Date(this.receiverTime);
    }

    public void setReliableSend(boolean b) {
        this.reliableSend = b;
    }

    public boolean getReliableSend() {
        return this.reliableSend;
    }

    public cMsgMessageContextInterface getContext() {
        return this.context;
    }

    static String escapeAllForXML(String s) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '<') {
                sb.replace(i, i + 1, "&lt;");
                i += 3;
                continue;
            }
            if (sb.charAt(i) == '>') {
                sb.replace(i, i + 1, "&gt;");
                i += 3;
                continue;
            }
            if (sb.charAt(i) != '\"') continue;
            sb.replace(i, i + 1, "&#34;");
            i += 4;
        }
        return sb.toString();
    }

    static String escapeQuotesForXML(String s) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\"') continue;
            sb.replace(i, i + 1, "&#34;");
            i += 4;
        }
        return sb.toString();
    }

    static String escapeCdataForXML(String s) {
        int index1 = s.indexOf("]]>");
        if (index1 < 0) {
            return s;
        }
        int index2 = s.indexOf("<![CDATA[");
        if (index2 < 0 || index1 < index2) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        String sub = "<![CDATA[]]]]><![CDATA[>";
        index1 = index2;
        while (index1 < sb.length()) {
            int index = sb.indexOf("<![CDATA[", index1);
            if (index < 0) {
                index2 = sb.indexOf("]]>", index1);
                if (index2 <= -1) break;
                return s;
            }
            index2 = sb.indexOf("]]>", index + 9);
            if (index2 < 0) {
                return s;
            }
            sb.insert(index2 + 3, sub);
            index1 = index2 + 3 + sub.length();
        }
        return sb.toString();
    }

    public String toString() {
        return this.toStringImpl(0, true, false, false, false, false, null);
    }

    public String toString(boolean binary, boolean compact, boolean noSystemFields) {
        return this.toStringImpl(0, binary, compact, false, false, noSystemFields, null);
    }

    private String toStringImpl(int margin, boolean binary, boolean compact, boolean compactPayload, boolean hasName, boolean noSystemFields, String pItemName) {
        char[] c;
        StringBuilder sb = new StringBuilder(2048);
        String indent = "";
        if (margin < 1) {
            margin = 0;
            indent = "";
        } else {
            c = new char[margin];
            Arrays.fill(c, ' ');
            indent = new String(c);
        }
        c = new char[margin + 5];
        Arrays.fill(c, ' ');
        String offsett = new String(c);
        if (hasName) {
            sb.append(indent);
            sb.append("<cMsgMessage name=\"");
            sb.append(pItemName);
            sb.append("\"\n");
        } else {
            sb.append(indent);
            sb.append("<cMsgMessage\n");
        }
        sb.append(offsett);
        sb.append("version           = \"");
        sb.append(this.version);
        sb.append("\"\n");
        sb.append(offsett);
        sb.append("userInt           = \"");
        sb.append(this.userInt);
        sb.append("\"\n");
        if ((this.info & 1) != 0) {
            sb.append(offsett);
            sb.append("getRequest        = \"true\"\n");
        } else if ((this.info & 4) != 0) {
            sb.append(offsett);
            sb.append("nullGetResponse   = \"true\"\n");
        } else {
            sb.append(offsett);
            sb.append("getResponse       = \"");
            sb.append((this.info & 2) != 0 ? "true" : "false");
            sb.append("\"\n");
        }
        if (this.domain != null) {
            sb.append(offsett);
            sb.append("domain            = \"");
            sb.append(this.domain);
            sb.append("\"\n");
        } else if (!compact) {
            sb.append(offsett);
            sb.append("domain            = \"(null)\"\n");
        }
        if (this.sender != null) {
            sb.append(offsett);
            sb.append("sender            = \"");
            sb.append(cMsgMessage.escapeQuotesForXML(this.sender));
            sb.append("\"\n");
        } else if (!compact) {
            sb.append(offsett);
            sb.append("sender            = \"(null)\"\n");
        }
        if (this.senderHost != null) {
            sb.append(offsett);
            sb.append("senderHost        = \"");
            sb.append(cMsgMessage.escapeQuotesForXML(this.senderHost));
            sb.append("\"\n");
        } else if (!compact) {
            sb.append(offsett);
            sb.append("senderHost        = \"(null)\"\n");
        }
        if (!compact || this.senderTime > 0L) {
            sb.append(offsett);
            sb.append("senderTime        = \"");
            sb.append(dateFormatter.format(new Date(this.senderTime)));
            sb.append("\"\n");
        }
        if (this.receiver != null) {
            sb.append(offsett);
            sb.append("receiver          = \"");
            sb.append(cMsgMessage.escapeQuotesForXML(this.receiver));
            sb.append("\"\n");
        } else if (!compact) {
            sb.append(offsett);
            sb.append("receiver          = \"(null)\"\n");
        }
        if (this.receiverHost != null) {
            sb.append(offsett);
            sb.append("receiverHost      = \"");
            sb.append(cMsgMessage.escapeQuotesForXML(this.receiverHost));
            sb.append("\"\n");
        } else if (!compact) {
            sb.append(offsett);
            sb.append("receiverHost      = \"(null)\"\n");
        }
        if (!compact || this.receiverTime > 0L) {
            sb.append(offsett);
            sb.append("receiverTime      = \"");
            sb.append(dateFormatter.format(new Date(this.receiverTime)));
            sb.append("\"\n");
        }
        if (!compact || this.userTime > 0L) {
            sb.append(offsett);
            sb.append("userTime          = \"");
            sb.append(dateFormatter.format(new Date(this.userTime)));
            sb.append("\"\n");
        }
        if (this.subject != null) {
            sb.append(offsett);
            sb.append("subject           = \"");
            sb.append(cMsgMessage.escapeQuotesForXML(this.subject));
            sb.append("\"\n");
        } else if (!compact) {
            sb.append(offsett);
            sb.append("subject           = \"(null)\"\n");
        }
        if (this.type != null) {
            sb.append(offsett);
            sb.append("type              = \"");
            sb.append(cMsgMessage.escapeQuotesForXML(this.type));
            sb.append("\"\n");
        } else if (!compact) {
            sb.append(offsett);
            sb.append("type              = \"(null)\"\n");
        }
        if (this.hasPayload() && this.isExpandedPayload()) {
            sb.append(offsett);
            sb.append("payloadItemCount  = \"");
            sb.append(this.items.size());
            sb.append("\"\n");
        }
        sb.deleteCharAt(sb.lastIndexOf("\n"));
        sb.append(">\n");
        if (this.text != null) {
            sb.append(offsett);
            sb.append("<text><![CDATA[");
            sb.append(cMsgMessage.escapeCdataForXML(this.text));
            sb.append("]]></text>\n");
        }
        if (binary && this.bytes != null && this.length > 0) {
            int endian = this.getByteArrayEndian();
            String endianTxt = endian == 0 ? "big" : "little";
            sb.append(offsett);
            sb.append("<binary endian=\"");
            sb.append(endianTxt);
            sb.append("\" nbytes=\"");
            sb.append(this.length);
            if (this.length > 57) {
                sb.append("\">\n");
                sb.append(Base64.encodeToString(this.bytes, this.offset, this.length, true));
                sb.append("\n");
                sb.append(offsett);
                sb.append("</binary>\n");
            } else {
                sb.append("\">");
                sb.append(Base64.encodeToString(this.bytes, this.offset, this.length, false));
                sb.append("</binary>\n");
            }
        }
        if (this.hasPayload()) {
            if (compactPayload) {
                sb.append(offsett);
                sb.append("<payload compact=\"true\">\n");
                sb.append(this.payloadText);
                sb.append(offsett);
                sb.append("</payload>\n");
            } else {
                try {
                    sb.append((CharSequence)this.payloadToStringImpl(margin + 5, binary, compact, noSystemFields));
                }
                catch (cMsgException e) {
                    sb.append(offsett);
                    sb.append("<payload expanded=\"false\">\n");
                    sb.append(this.payloadText);
                    sb.append(offsett);
                    sb.append("</payload>\n");
                }
            }
        }
        sb.append(indent);
        sb.append("</cMsgMessage>\n");
        return sb.toString();
    }

    public String payloadToString() throws cMsgException {
        return this.payloadToStringImpl(0, true, false, false).toString();
    }

    private StringBuilder payloadToStringImpl(int margin, boolean binary, boolean compact, boolean noSystemFields) throws cMsgException {
        char[] c;
        String indent;
        if (!this.hasPayload()) {
            return null;
        }
        if (!this.isExpandedPayload()) {
            throw new cMsgException("payload must be expanded before converting to XML");
        }
        StringWriter sw = new StringWriter(2048);
        PrintWriter wr = new PrintWriter(sw);
        StringBuilder sb = new StringBuilder(2048);
        if (margin < 1) {
            margin = 0;
            indent = "";
        } else {
            c = new char[margin];
            Arrays.fill(c, ' ');
            indent = new String(c);
        }
        c = new char[5];
        Arrays.fill(c, ' ');
        String offsett = new String(c);
        sb.append(indent);
        sb.append("<payload compact=\"false\">\n");
        try {
            for (Map.Entry<String, cMsgPayloadItem> entry : this.items.entrySet()) {
                String name = entry.getKey();
                cMsgPayloadItem item = entry.getValue();
                int typ = item.getType();
                if (noSystemFields && name.length() > 4 && name.substring(0, 4).equalsIgnoreCase("cmsg")) continue;
                switch (typ) {
                    case 13: {
                        byte i = item.getByte();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<int8 name=\"");
                        sb.append(name);
                        sb.append("\"> ");
                        sb.append(i);
                        sb.append(" </int8>\n");
                        break;
                    }
                    case 14: {
                        short i = item.getShort();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<int16 name=\"");
                        sb.append(name);
                        sb.append("\"> ");
                        sb.append(i);
                        sb.append(" </int16>\n");
                        break;
                    }
                    case 15: {
                        int i = item.getInt();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<int32 name=\"");
                        sb.append(name);
                        sb.append("\"> ");
                        sb.append(i);
                        sb.append(" </int32>\n");
                        break;
                    }
                    case 16: {
                        long i = item.getLong();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<int64 name=\"");
                        sb.append(name);
                        sb.append("\"> ");
                        sb.append(i);
                        sb.append(" </int64>\n");
                        break;
                    }
                    case 20: {
                        BigInteger i = item.getBigInt();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<uint64 name=\"");
                        sb.append(name);
                        sb.append("\"> ");
                        sb.append(i);
                        sb.append(" </uint64>\n");
                        break;
                    }
                    case 12: {
                        double d = item.getDouble();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<double name=\"");
                        sb.append(name);
                        sb.append("\"> ");
                        sb.append(d);
                        sb.append(" </double>\n");
                        break;
                    }
                    case 11: {
                        float f = item.getFloat();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<float name=\"");
                        sb.append(name);
                        sb.append("\"> ");
                        sb.append(f);
                        sb.append(" </float>\n");
                        break;
                    }
                    case 10: {
                        String s = item.getString();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<string name=\"");
                        sb.append(name);
                        sb.append("\">");
                        sb.append("<![CDATA[");
                        sb.append(cMsgMessage.escapeCdataForXML(s));
                        sb.append("]]></string>\n");
                        break;
                    }
                    case 22: {
                        byte[] b = item.getBinary();
                        int endian = item.getEndian();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<binary name=\"");
                        sb.append(name);
                        if (endian == 0) {
                            sb.append("\" endian=\"big\"");
                        } else {
                            sb.append("\" endian=\"little\"");
                        }
                        sb.append(" nbytes=\"");
                        sb.append(b.length);
                        if (!binary) {
                            sb.append("\" />\n");
                            break;
                        }
                        if (b.length > 57) {
                            sb.append("\">\n");
                            sb.append(Base64.encodeToString(b, true));
                            sb.append(indent);
                            sb.append(offsett);
                            sb.append("</binary>\n");
                            break;
                        }
                        sb.append("\">");
                        sb.append(Base64.encodeToString(b, false));
                        sb.append("</binary>\n");
                        break;
                    }
                    case 21: {
                        cMsgMessage m = item.getMessage();
                        sb.append(m.toStringImpl(margin + offsett.length(), binary, compact, false, true, noSystemFields, item.name));
                        break;
                    }
                    case 34: {
                        cMsgMessage[] msgs = item.getMessageArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<cMsgMessage_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(msgs.length);
                        sb.append("\">\n");
                        for (cMsgMessage m : msgs) {
                            sb.append(m.toStringImpl(margin + 5 + offsett.length(), binary, compact, false, false, noSystemFields, null));
                        }
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</cMsgMessage_array>\n");
                        break;
                    }
                    case 26: {
                        byte[] b = item.getByteArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<int8_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(b.length);
                        sb.append("\">\n");
                        for (int j = 0; j < b.length; ++j) {
                            if (j % 5 == 0) {
                                wr.printf("%s%s%s%4d", indent, offsett, offsett, b[j]);
                            } else {
                                wr.printf(" %4d", b[j]);
                            }
                            if (j % 5 != 4 && j != b.length - 1) continue;
                            wr.printf("\n", new Object[0]);
                        }
                        wr.flush();
                        sb.append(sw.getBuffer());
                        sw.getBuffer().delete(0, sw.getBuffer().capacity());
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</int8_array>\n");
                        break;
                    }
                    case 27: {
                        short[] i = item.getShortArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<int16_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(i.length);
                        sb.append("\">\n");
                        for (int j = 0; j < i.length; ++j) {
                            if (j % 5 == 0) {
                                wr.printf("%s%s%s%6d", indent, offsett, offsett, i[j]);
                            } else {
                                wr.printf(" %6d", i[j]);
                            }
                            if (j % 5 != 4 && j != i.length - 1) continue;
                            wr.printf("\n", new Object[0]);
                        }
                        wr.flush();
                        sb.append(sw.getBuffer());
                        sw.getBuffer().delete(0, sw.getBuffer().capacity());
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</int16_array>\n");
                        break;
                    }
                    case 28: {
                        int[] i = item.getIntArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<int32_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(i.length);
                        sb.append("\">\n");
                        for (int j = 0; j < i.length; ++j) {
                            if (j % 5 == 0) {
                                sb.append(indent);
                                sb.append(offsett);
                                sb.append(offsett);
                            } else {
                                sb.append(" ");
                            }
                            sb.append(i[j]);
                            if (j % 5 != 4 && j != i.length - 1) continue;
                            sb.append("\n");
                        }
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</int32_array>\n");
                        break;
                    }
                    case 29: {
                        long[] i = item.getLongArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<int64_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(i.length);
                        sb.append("\">\n");
                        for (int j = 0; j < i.length; ++j) {
                            if (j % 5 == 0) {
                                sb.append(indent);
                                sb.append(offsett);
                                sb.append(offsett);
                            } else {
                                sb.append(" ");
                            }
                            sb.append(i[j]);
                            if (j % 5 != 4 && j != i.length - 1) continue;
                            sb.append("\n");
                        }
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</int64_array>\n");
                        break;
                    }
                    case 33: {
                        BigInteger[] i = item.getBigIntArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<uint64_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(i.length);
                        sb.append("\">\n");
                        for (int j = 0; j < i.length; ++j) {
                            if (j % 5 == 0) {
                                sb.append(indent);
                                sb.append(offsett);
                                sb.append(offsett);
                            } else {
                                sb.append(" ");
                            }
                            sb.append(i[j]);
                            if (j % 5 != 4 && j != i.length - 1) continue;
                            sb.append("\n");
                        }
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</uint64_array>\n");
                        break;
                    }
                    case 25: {
                        double[] d = item.getDoubleArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<double_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(d.length);
                        sb.append("\">\n");
                        for (int j = 0; j < d.length; ++j) {
                            if (j % 5 == 0) {
                                wr.printf("%s%s%s%.17g", indent, offsett, offsett, d[j]);
                            } else {
                                wr.printf(" %.17g", d[j]);
                            }
                            if (j % 5 != 4 && j != d.length - 1) continue;
                            wr.printf("\n", new Object[0]);
                        }
                        wr.flush();
                        sb.append(sw.getBuffer());
                        sw.getBuffer().delete(0, sw.getBuffer().capacity());
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</double_array>\n");
                        break;
                    }
                    case 24: {
                        float[] f = item.getFloatArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<float_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(f.length);
                        sb.append("\">\n");
                        for (int j = 0; j < f.length; ++j) {
                            if (j % 5 == 0) {
                                wr.printf("%s%s%s%.8g", indent, offsett, offsett, Float.valueOf(f[j]));
                            } else {
                                wr.printf(" %.8g", Float.valueOf(f[j]));
                            }
                            if (j % 5 != 4 && j != f.length - 1) continue;
                            wr.printf("\n", new Object[0]);
                        }
                        wr.flush();
                        sb.append(sw.getBuffer());
                        sw.getBuffer().delete(0, sw.getBuffer().capacity());
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</float_array>\n");
                        break;
                    }
                    case 23: {
                        String[] sa = item.getStringArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<string_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(sa.length);
                        sb.append("\">\n");
                        for (String s : sa) {
                            sb.append(indent);
                            sb.append(offsett);
                            sb.append(offsett);
                            sb.append("<string><![CDATA[");
                            sb.append(cMsgMessage.escapeCdataForXML(s));
                            sb.append("]]></string>\n");
                        }
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</string_array>\n");
                        break;
                    }
                    case 35: {
                        byte[][] b = item.getBinaryArray();
                        int[] endian = item.getEndianArray();
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("<binary_array name=\"");
                        sb.append(name);
                        sb.append("\" count=\"");
                        sb.append(b.length);
                        sb.append("\">\n");
                        for (int i = 0; i < b.length; ++i) {
                            sb.append(indent);
                            sb.append(offsett);
                            sb.append(offsett);
                            if (endian[i] == 0) {
                                sb.append("<binary endian=\"big\"");
                            } else {
                                sb.append("<binary endian=\"little\"");
                            }
                            sb.append(" nbytes=\"");
                            sb.append(b[i].length);
                            if (!binary) {
                                sb.append("\" />\n");
                                continue;
                            }
                            if (b[i].length > 57) {
                                sb.append("\">\n");
                                sb.append(Base64.encodeToString(b[i], true));
                                sb.append(indent);
                                sb.append(offsett);
                                sb.append(offsett);
                                sb.append("</binary>\n");
                                continue;
                            }
                            sb.append("\">");
                            sb.append(Base64.encodeToString(b[i], false));
                            sb.append("</binary>\n");
                        }
                        sb.append(indent);
                        sb.append(offsett);
                        sb.append("</binary_array>\n");
                        break;
                    }
                }
            }
        }
        catch (cMsgException ex) {
            return null;
        }
        sb.append(indent);
        sb.append("</payload>\n");
        return sb;
    }

    static final long hexStrToLong(String hex, boolean zeroSup) {
        if (!zeroSup) {
            return (long)toByte[hex.charAt(0)] << 60 | (long)toByte[hex.charAt(1)] << 56 | (long)toByte[hex.charAt(2)] << 52 | (long)toByte[hex.charAt(3)] << 48 | (long)toByte[hex.charAt(4)] << 44 | (long)toByte[hex.charAt(5)] << 40 | (long)toByte[hex.charAt(6)] << 36 | (long)toByte[hex.charAt(7)] << 32 | (long)toByte[hex.charAt(8)] << 28 | (long)toByte[hex.charAt(9)] << 24 | (long)toByte[hex.charAt(10)] << 20 | (long)toByte[hex.charAt(11)] << 16 | (long)toByte[hex.charAt(12)] << 12 | (long)toByte[hex.charAt(13)] << 8 | (long)toByte[hex.charAt(14)] << 4 | (long)toByte[hex.charAt(15)];
        }
        long l = 0L;
        l = (long)toByte[hex.charAt(1)] << 56 | (long)toByte[hex.charAt(2)] << 52 | (long)toByte[hex.charAt(3)] << 48 | (long)toByte[hex.charAt(4)] << 44 | (long)toByte[hex.charAt(5)] << 40 | (long)toByte[hex.charAt(6)] << 36 | (long)toByte[hex.charAt(7)] << 32 | (long)toByte[hex.charAt(8)] << 28 | (long)toByte[hex.charAt(9)] << 24 | (long)toByte[hex.charAt(10)] << 20 | (long)toByte[hex.charAt(11)] << 16 | (long)toByte[hex.charAt(12)] << 12 | (long)toByte[hex.charAt(13)] << 8 | (long)toByte[hex.charAt(14)] << 4 | (long)toByte[hex.charAt(15)];
        return l;
    }

    static final int hexStrToInt(String hex, boolean zeroSup) {
        if (!zeroSup) {
            return toByte[hex.charAt(0)] << 28 | toByte[hex.charAt(1)] << 24 | toByte[hex.charAt(2)] << 20 | toByte[hex.charAt(3)] << 16 | toByte[hex.charAt(4)] << 12 | toByte[hex.charAt(5)] << 8 | toByte[hex.charAt(6)] << 4 | toByte[hex.charAt(7)];
        }
        int i = 0;
        i = toByte[hex.charAt(1)] << 24 | toByte[hex.charAt(2)] << 20 | toByte[hex.charAt(3)] << 16 | toByte[hex.charAt(4)] << 12 | toByte[hex.charAt(5)] << 8 | toByte[hex.charAt(6)] << 4 | toByte[hex.charAt(7)];
        return i;
    }

    static final short hexStrToShort(String hex, boolean zeroSup) {
        if (!zeroSup) {
            return (short)(toByte[hex.charAt(0)] << 12 | toByte[hex.charAt(1)] << 8 | toByte[hex.charAt(2)] << 4 | toByte[hex.charAt(3)]);
        }
        short i = 0;
        i = (short)(toByte[hex.charAt(1)] << 8 | toByte[hex.charAt(2)] << 4 | toByte[hex.charAt(3)]);
        return i;
    }

    protected boolean isNullGetServerResponse() {
        return (this.info & 0x80) == 128;
    }

    protected void setNullGetServerResponse(boolean ngsr) {
        this.info = ngsr ? this.info | 0x80 : this.info & 0xFFFFFF7F;
    }

    public void copyPayload(cMsgMessage msg) {
        this.items.clear();
        for (Map.Entry<String, cMsgPayloadItem> entry : msg.getPayloadItems().entrySet()) {
            this.items.put(entry.getKey(), (cMsgPayloadItem)entry.getValue().clone());
        }
        this.payloadText = msg.payloadText;
    }

    public String getPayloadText() {
        return this.payloadText;
    }

    public boolean hasPayload() {
        return (this.info & 0x20) == 32;
    }

    protected void hasPayload(boolean hp) {
        this.info = hp ? this.info | 0x20 : this.info & 0xFFFFFFDF;
    }

    protected boolean isExpandedPayload() {
        return (this.info & 0x40) == 64;
    }

    protected void setExpandedPayload(boolean ep) {
        this.info = ep ? this.info | 0x40 : this.info & 0xFFFFFFBF;
    }

    protected void expandPayload() {
        if (this.isExpandedPayload() || this.payloadText == null) {
            this.setExpandedPayload(true);
            return;
        }
        try {
            if (this.buffer == null) {
                this.buffer = new StringBuilder(512);
            }
            if (this.items == null) {
                this.items = new ConcurrentHashMap();
            }
            if (this.context == null) {
                this.context = new cMsgMessageContextDefault();
            }
            this.setFieldsFromText(this.payloadText, 2);
            this.setExpandedPayload(true);
        }
        catch (cMsgException e) {
            this.setExpandedPayload(false);
        }
    }

    public Map<String, cMsgPayloadItem> getPayloadItems() {
        if (!this.isExpandedPayload()) {
            this.expandPayload();
        }
        return Collections.unmodifiableMap(this.items);
    }

    public void resetPayload() {
        this.items.clear();
        this.updatePayloadText();
    }

    public void clearPayload() {
        for (String name : this.items.keySet()) {
            if (cMsgPayloadItem.validSystemName(name)) continue;
            this.items.remove(name);
        }
        this.updatePayloadText();
    }

    public void addPayloadItem(cMsgPayloadItem item) {
        if (item == null) {
            return;
        }
        this.items.put(item.name, item);
        this.hasPayload(true);
        this.updatePayloadText();
    }

    public boolean removePayloadItem(cMsgPayloadItem item) {
        boolean b;
        if (cMsgPayloadItem.validSystemName(item.name)) {
            return false;
        }
        boolean bl = b = this.items.remove(item.name) != null;
        if (this.items.size() < 1) {
            this.hasPayload(false);
        }
        this.updatePayloadText();
        return b;
    }

    public boolean removePayloadItem(String name) {
        boolean b;
        if (cMsgPayloadItem.validSystemName(name)) {
            return false;
        }
        boolean bl = b = this.items.remove(name) != null;
        if (this.items.size() < 1) {
            this.hasPayload(false);
        }
        this.updatePayloadText();
        return b;
    }

    public cMsgPayloadItem getPayloadItem(String name) {
        return this.items.get(name);
    }

    public Set<String> getPayloadNames() {
        return this.items.keySet();
    }

    public int getPayloadSize() {
        return this.items.size();
    }

    public void updatePayloadText() {
        this.payloadText = this.createPayloadText(this.items);
    }

    String createPayloadText(Map<String, cMsgPayloadItem> map) {
        int count = 0;
        int totalLen = 0;
        if (map.size() < 1) {
            return null;
        }
        for (cMsgPayloadItem item : map.values()) {
            totalLen += item.text.length();
            ++count;
        }
        if (this.buffer.capacity() < (totalLen += cMsgPayloadItem.numDigits(count) + 1)) {
            this.buffer.ensureCapacity(totalLen + 512);
        }
        this.buffer.delete(0, this.buffer.capacity());
        this.buffer.append(count);
        this.buffer.append("\n");
        for (cMsgPayloadItem item : map.values()) {
            if (count-- < 1) break;
            this.buffer.append(item.text);
        }
        return this.buffer.toString();
    }

    public String addHistoryToPayloadText(String sendersName, String sendersHost, long sendersTime) {
        int count = 0;
        int totalLen = 0;
        cMsgPayloadItem[] history = new cMsgPayloadItem[3];
        if (!this.items.containsKey("cMsgCreator")) {
            try {
                cMsgPayloadItem it2 = new cMsgPayloadItem("cMsgCreator", sendersName, true);
                this.addPayloadItem(it2);
            }
            catch (cMsgException it2) {
                // empty catch block
            }
        }
        if (!this.items.containsKey("cMsgHistoryLengthMax") && this.historyLengthMax != 20) {
            try {
                cMsgPayloadItem it3 = new cMsgPayloadItem("cMsgHistoryLengthMax", this.historyLengthMax, true);
                this.addPayloadItem(it3);
            }
            catch (cMsgException it3) {
                // empty catch block
            }
        }
        if (this.historyLengthMax < 1) {
            return this.payloadText;
        }
        cMsgPayloadItem item_n = this.items.get("cMsgSenderNameHistory");
        cMsgPayloadItem item_h = this.items.get("cMsgSenderHostHistory");
        cMsgPayloadItem item_t = this.items.get("cMsgSenderTimeHistory");
        try {
            if (item_n == null) {
                String[] newNames = new String[]{sendersName};
                history[0] = new cMsgPayloadItem("cMsgSenderNameHistory", newNames, true);
                String[] stringArray = new String[]{sendersHost};
                history[1] = new cMsgPayloadItem("cMsgSenderHostHistory", stringArray, true);
                long[] newTimes = new long[]{sendersTime};
                history[2] = new cMsgPayloadItem("cMsgSenderTimeHistory", newTimes, true);
            } else {
                String[] names = item_n.getStringArray();
                String[] stringArray = item_h.getStringArray();
                long[] times = item_t.getLongArray();
                int index = 0;
                int len = names.length;
                if (names.length >= this.historyLengthMax) {
                    len = this.historyLengthMax - 1;
                    index = names.length - len;
                }
                String[] newNames = new String[len + 1];
                String[] newHosts = new String[len + 1];
                long[] newTimes = new long[len + 1];
                System.arraycopy(names, index, newNames, 0, len);
                System.arraycopy(stringArray, index, newHosts, 0, len);
                System.arraycopy(times, index, newTimes, 0, len);
                newNames[len] = sendersName;
                newHosts[len] = sendersHost;
                newTimes[len] = sendersTime;
                history[0] = new cMsgPayloadItem("cMsgSenderNameHistory", newNames, true);
                history[1] = new cMsgPayloadItem("cMsgSenderHostHistory", newHosts, true);
                history[2] = new cMsgPayloadItem("cMsgSenderTimeHistory", newTimes, true);
            }
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        for (Map.Entry<String, cMsgPayloadItem> entry : this.items.entrySet()) {
            String key = entry.getKey();
            if (key.equals("cMsgSenderNameHistory") || key.equals("cMsgSenderTimeHistory") || key.equals("cMsgSenderHostHistory")) continue;
            totalLen += entry.getValue().text.length();
            ++count;
        }
        for (cMsgPayloadItem item : history) {
            totalLen += item.text.length();
            ++count;
        }
        if (this.buffer.capacity() < (totalLen += cMsgPayloadItem.numDigits(count) + 1)) {
            this.buffer.ensureCapacity(totalLen + 512);
        }
        this.buffer.delete(0, this.buffer.capacity());
        this.buffer.append(count);
        this.buffer.append("\n");
        for (cMsgPayloadItem item : history) {
            if (count-- < 1) break;
            this.buffer.append(item.text);
        }
        for (Map.Entry entry : this.items.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("cMsgSenderNameHistory") || key.equals("cMsgSenderTimeHistory") || key.equals("cMsgSenderHostHistory")) continue;
            if (count-- < 1) break;
            this.buffer.append(((cMsgPayloadItem)entry.getValue()).text);
        }
        return this.buffer.toString();
    }

    public String getItemsText() {
        int totalLen = 0;
        if (this.items.size() < 1) {
            return null;
        }
        for (cMsgPayloadItem item : this.items.values()) {
            totalLen += item.text.length();
        }
        if (this.buffer.capacity() < totalLen) {
            this.buffer.ensureCapacity(totalLen + 512);
        }
        this.buffer.delete(0, this.buffer.capacity());
        for (cMsgPayloadItem item : this.items.values()) {
            this.buffer.append(item.text);
        }
        return this.buffer.toString();
    }

    protected int setFieldsFromText(String text, int flag) throws cMsgException {
        int index2;
        boolean debug = false;
        try {
            if (text == null) {
                throw new cMsgException("bad argument");
            }
            int index1 = 0;
            index2 = text.indexOf(10);
            if (index2 < 1) {
                throw new cMsgException("bad format1");
            }
            String sub = text.substring(index1, index2);
            int fields = Integer.parseInt(sub);
            if (fields < 1) {
                throw new cMsgException("bad format2");
            }
            if (debug) {
                System.out.println("# fields = " + fields);
            }
            this.resetPayload();
            int noHeaderLen = 0;
            for (int i = 0; i < fields; ++i) {
                int j;
                if (debug) {
                    System.out.println("index1 = " + index1 + ", index2 = " + index2);
                }
                int firstIndex = index1 = index2 + 1;
                index2 = text.indexOf(10, index1);
                if (debug) {
                    System.out.println("index1 = " + index1 + ", index2 = " + index2);
                }
                if (index2 < 1) {
                    throw new cMsgException("bad format3");
                }
                sub = text.substring(index1, index2);
                if (debug) {
                    System.out.println("Header text = " + sub);
                }
                String[] tokens = sub.split(" ");
                if (debug) {
                    System.out.println("# items on headler line = " + tokens.length);
                }
                String name = tokens[0];
                int dataType = Integer.parseInt(tokens[1]);
                int count = Integer.parseInt(tokens[2]);
                boolean isSystem = Integer.parseInt(tokens[3]) != 0;
                for (j = 4; j < tokens.length; ++j) {
                    if (tokens[j].length() < 1) continue;
                    noHeaderLen = Integer.parseInt(tokens[j]);
                }
                int headerLen = index2 - index1 + 1;
                int totalItemLen = headerLen + noHeaderLen;
                if (debug) {
                    System.out.println("FIELD #" + i + ": name = " + name + ", type = " + dataType + ", count = " + count + ", isSys = " + isSystem + ", len header = " + headerLen + ", len noheader = " + noHeaderLen + ", sub len = " + sub.length());
                }
                if (name.length() < 1 || count < 1 || noHeaderLen < 1 || dataType < 10 || dataType > 35) {
                    throw new cMsgException("bad format5");
                }
                boolean ignore = isSystem;
                if (flag == 0) {
                    ignore = !ignore;
                } else if (flag == 2) {
                    ignore = false;
                }
                if (ignore) {
                    for (j = 0; j < count; ++j) {
                        ++index2;
                        index1 = index2 + headerLen;
                        if ((index2 = text.indexOf(10, index1)) < 1 && i != fields - 1) {
                            throw new cMsgException("bad format6");
                        }
                        if (!debug) continue;
                        System.out.println("  skipped field");
                    }
                    continue;
                }
                index1 = index2 + 1;
                if (dataType == 10) {
                    this.addStringFromText(name, isSystem, text, index1, firstIndex, noHeaderLen);
                } else if (dataType == 23) {
                    this.addStringArrayFromText(name, count, isSystem, text, index1, firstIndex, noHeaderLen);
                } else if (dataType == 22) {
                    this.addBinaryFromText(name, count, isSystem, text, index1, firstIndex, noHeaderLen);
                } else if (dataType == 35) {
                    this.addBinaryArrayFromText(name, count, isSystem, text, index1, firstIndex, noHeaderLen);
                } else if (dataType == 12 || dataType == 11) {
                    this.addRealFromText(name, dataType, isSystem, text, index1, firstIndex, noHeaderLen);
                } else if (dataType == 25 || dataType == 24) {
                    this.addRealArrayFromText(name, dataType, count, isSystem, text, index1, firstIndex, noHeaderLen);
                } else if (dataType == 13 || dataType == 14 || dataType == 15 || dataType == 16 || dataType == 17 || dataType == 18 || dataType == 19 || dataType == 20) {
                    this.addIntFromText(name, dataType, isSystem, text, index1, firstIndex, noHeaderLen);
                } else if (dataType == 26 || dataType == 27 || dataType == 28 || dataType == 29 || dataType == 30 || dataType == 31 || dataType == 32 || dataType == 33) {
                    this.addIntArrayFromText(name, dataType, count, isSystem, text, index1, firstIndex, noHeaderLen);
                } else if (dataType == 21 || dataType == 34) {
                    cMsgMessage[] newMsgs = new cMsgMessage[count];
                    for (int j2 = 0; j2 < count; ++j2) {
                        newMsgs[j2] = new cMsgMessage();
                        index1 += newMsgs[j2].setFieldsFromText(text.substring(index1), 2);
                        newMsgs[j2].setExpandedPayload(true);
                    }
                    this.addMessagesFromText(name, dataType, isSystem, newMsgs, text, firstIndex, noHeaderLen, totalItemLen);
                } else {
                    throw new cMsgException("bad format7");
                }
                index2 = firstIndex + totalItemLen - 1;
            }
        }
        catch (NumberFormatException e) {
            throw new cMsgException(e);
        }
        return index2 + 1;
    }

    private void addStringFromText(String name, boolean isSystem, String txt, int index1, int fullIndex, int noHeadLen) throws cMsgException {
        int index2 = txt.indexOf(10, index1);
        if (index2 < 1) {
            throw new cMsgException("bad format");
        }
        index1 = index2 + 1;
        int secondLineLen = index2 - index1 + 1;
        if ((index2 = index1 + noHeadLen - secondLineLen - 1) < index1) {
            throw new cMsgException("bad format");
        }
        String val = txt.substring(index1, index2);
        if (isSystem) {
            boolean putInPayload = false;
            if (name.equals("cMsgText")) {
                this.text = val;
            } else if (name.equals("cMsgSubject")) {
                this.subject = val;
            } else if (name.equals("cMsgType")) {
                this.type = val;
            } else if (name.equals("cMsgDomain")) {
                this.domain = val;
            } else if (name.equals("cMsgSender")) {
                this.sender = val;
            } else if (name.equals("cMsgSenderHost")) {
                this.senderHost = val;
            } else if (name.equals("cMsgReceiver")) {
                this.receiver = val;
            } else if (name.equals("cMsgReceiverHost")) {
                this.receiverHost = val;
            } else {
                putInPayload = true;
            }
            if (!putInPayload) {
                return;
            }
        }
        String textRep = txt.substring(fullIndex, index2 + 1);
        this.addPayloadItem(new cMsgPayloadItem(name, val, textRep, noHeadLen, isSystem));
    }

    private void addStringArrayFromText(String name, int count, boolean isSystem, String txt, int index1, int fullIndex, int noHeadLen) throws cMsgException {
        String[] vals = new String[count];
        for (int i = 0; i < count; ++i) {
            int index2 = txt.indexOf(10, index1);
            if (index2 < 1) {
                throw new cMsgException("bad format");
            }
            int len = Integer.parseInt(txt.substring(index1, index2));
            if (len < 1) {
                throw new cMsgException("bad format");
            }
            index1 = index2 + 1;
            index2 = index1 + len;
            vals[i] = txt.substring(index1, index2);
            index1 = index2 + 1;
        }
        String textRep = txt.substring(fullIndex, index1);
        this.addPayloadItem(new cMsgPayloadItem(name, vals, textRep, noHeadLen, isSystem));
    }

    private void addBinaryFromText(String name, int count, boolean isSystem, String txt, int index1, int fullIndex, int noHeadLen) throws cMsgException {
        int index2 = txt.indexOf(10, index1);
        if (index2 < 1) {
            throw new cMsgException("bad format");
        }
        String[] stuff = txt.substring(index1, index2).split(" ");
        int base64StrLen = Integer.parseInt(stuff[0]);
        if (base64StrLen < 1) {
            throw new cMsgException("bad format");
        }
        int binLen = Integer.parseInt(stuff[1]);
        if (binLen < 1) {
            throw new cMsgException("bad format");
        }
        int endian = Integer.parseInt(stuff[2]);
        index1 = index2 + 1;
        index2 = index1 + base64StrLen;
        String val = txt.substring(index1, index2);
        byte[] b = null;
        try {
            b = Base64.decodeToBytes(val, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (b == null || b.length != binLen) {
            System.out.println("reconstituted binary is different length than original binary");
        }
        if (isSystem && name.equals("cMsgBinary")) {
            this.bytes = b;
            this.offset = 0;
            this.length = this.bytes.length;
            this.setByteArrayEndian(endian);
            return;
        }
        String textRep = txt.substring(fullIndex, index2);
        this.addPayloadItem(new cMsgPayloadItem(name, b, endian, textRep, noHeadLen, isSystem));
    }

    private void addBinaryArrayFromText(String name, int count, boolean isSystem, String txt, int index1, int fullIndex, int noHeadLen) throws cMsgException {
        int[] endians = new int[count];
        byte[][] vals = new byte[count][];
        for (int i = 0; i < count; ++i) {
            int index2 = txt.indexOf(10, index1);
            if (index2 < 1) {
                throw new cMsgException("bad format");
            }
            String[] stuff = txt.substring(index1, index2).split(" ");
            int base64StrLen = Integer.parseInt(stuff[0]);
            if (base64StrLen < 1) {
                throw new cMsgException("bad format");
            }
            int binLen = Integer.parseInt(stuff[1]);
            if (binLen < 1) {
                throw new cMsgException("bad format");
            }
            endians[i] = Integer.parseInt(stuff[2]);
            index1 = index2 + 1;
            index2 = index1 + base64StrLen;
            String val = txt.substring(index1, index2);
            try {
                vals[i] = Base64.decodeToBytes(val, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (vals[i] == null || vals[i].length != binLen) {
                System.out.println("reconstituted binary is different length than original binary");
            }
            index1 = index2;
        }
        String textRep = txt.substring(fullIndex, index1);
        this.addPayloadItem(new cMsgPayloadItem(name, vals, endians, textRep, noHeadLen, isSystem));
    }

    private void addRealFromText(String name, int dataType, boolean isSystem, String txt, int index1, int fullIndex, int noHeadLen) throws cMsgException {
        int index2 = txt.indexOf(10, index1);
        if (index2 < 1) {
            throw new cMsgException("bad format");
        }
        String val = txt.substring(index1, index2);
        String textRep = txt.substring(fullIndex, index2 + 1);
        if (dataType == 12) {
            long lval = cMsgMessage.hexStrToLong(val, false);
            double d = Double.longBitsToDouble(lval);
            this.addPayloadItem(new cMsgPayloadItem(name, d, textRep, noHeadLen, isSystem));
        } else {
            int ival = cMsgMessage.hexStrToInt(val, false);
            float f = Float.intBitsToFloat(ival);
            this.addPayloadItem(new cMsgPayloadItem(name, f, textRep, noHeadLen, isSystem));
        }
    }

    private void addRealArrayFromText(String name, int dataType, int count, boolean isSystem, String txt, int index1, int fullIndex, int noHeadLen) throws cMsgException {
        int index2 = txt.indexOf(10, index1);
        if (index2 < 1) {
            throw new cMsgException("bad format");
        }
        String val = txt.substring(index1, index2);
        String textRep = txt.substring(fullIndex, index2 + 1);
        if (dataType == 25) {
            int i1 = -17;
            double[] darray = new double[count];
            for (int i = 0; i < count; ++i) {
                int i2;
                String num;
                if (toByte[(num = val.substring(i1 += 17, i2 = i1 + 16)).charAt(0)] == -2) {
                    long zeros = cMsgMessage.hexStrToLong(num, true);
                    int j = 0;
                    while ((long)j < zeros) {
                        darray[i + j] = 0.0;
                        ++j;
                    }
                    i = (int)((long)i + (zeros - 1L));
                    continue;
                }
                long lval = cMsgMessage.hexStrToLong(num, false);
                darray[i] = Double.longBitsToDouble(lval);
            }
            this.addPayloadItem(new cMsgPayloadItem(name, darray, textRep, noHeadLen, isSystem));
        } else if (dataType == 24) {
            int i1 = -9;
            float[] farray = new float[count];
            for (int i = 0; i < count; ++i) {
                int i2;
                String num;
                if (toByte[(num = val.substring(i1 += 9, i2 = i1 + 8)).charAt(0)] == -2) {
                    int zeros = cMsgMessage.hexStrToInt(num, true);
                    for (int j = 0; j < zeros; ++j) {
                        farray[i + j] = 0.0f;
                    }
                    i += zeros - 1;
                    continue;
                }
                int ival = cMsgMessage.hexStrToInt(num, false);
                farray[i] = Float.intBitsToFloat(ival);
            }
            this.addPayloadItem(new cMsgPayloadItem(name, farray, textRep, noHeadLen, isSystem));
        }
    }

    private void addIntFromText(String name, int dataType, boolean isSystem, String txt, int index1, int fullIndex, int noHeadLen) throws cMsgException {
        int index2 = txt.indexOf(10, index1);
        if (index2 < 1) {
            throw new cMsgException("bad format");
        }
        String val = txt.substring(index1, index2);
        String textRep = txt.substring(fullIndex, index2 + 1);
        if (isSystem && name.equals("cMsgHistoryLengthMax")) {
            this.historyLengthMax = Integer.parseInt(val);
        }
        if (dataType == 13) {
            this.addPayloadItem(new cMsgPayloadItem(name, Byte.parseByte(val), textRep, noHeadLen, isSystem));
        } else if (dataType == 14) {
            this.addPayloadItem(new cMsgPayloadItem(name, Short.parseShort(val), textRep, noHeadLen, isSystem));
        } else if (dataType == 15) {
            this.addPayloadItem(new cMsgPayloadItem(name, Integer.parseInt(val), textRep, noHeadLen, isSystem));
        } else if (dataType == 16) {
            this.addPayloadItem(new cMsgPayloadItem(name, Long.parseLong(val), textRep, noHeadLen, isSystem));
        } else if (dataType == 17) {
            this.addPayloadItem(new cMsgPayloadItem(name, Short.parseShort(val), textRep, noHeadLen, isSystem));
        } else if (dataType == 18) {
            this.addPayloadItem(new cMsgPayloadItem(name, Integer.parseInt(val), textRep, noHeadLen, isSystem));
        } else if (dataType == 19) {
            this.addPayloadItem(new cMsgPayloadItem(name, Long.parseLong(val), textRep, noHeadLen, isSystem));
        } else if (dataType == 20) {
            this.addPayloadItem(new cMsgPayloadItem(name, new BigInteger(val), textRep, noHeadLen, isSystem));
        }
    }

    private void addIntArrayFromText(String name, int dataType, int count, boolean isSystem, String txt, int index1, int fullIndex, int noHeadLen) throws cMsgException {
        boolean unsigned8;
        int index2 = txt.indexOf(10, index1);
        if (index2 < 1) {
            throw new cMsgException("bad format");
        }
        String val = txt.substring(index1, index2);
        String textRep = txt.substring(fullIndex, index2 + 1);
        boolean bigInt = dataType == 33;
        boolean unsigned32 = dataType == 32;
        boolean unsigned16 = dataType == 31;
        boolean bl = unsigned8 = dataType == 30;
        if (dataType == 29 || bigInt) {
            int i1 = -17;
            long[] larray = null;
            BigInteger[] b = null;
            if (bigInt) {
                b = new BigInteger[count];
            } else {
                larray = new long[count];
            }
            for (int i = 0; i < count; ++i) {
                int i2;
                String num;
                if (toByte[(num = val.substring(i1 += 17, i2 = i1 + 16)).charAt(0)] == -2) {
                    long zeros = cMsgMessage.hexStrToLong(num, true);
                    int j = 0;
                    while ((long)j < zeros) {
                        if (bigInt) {
                            b[i + j] = BigInteger.ZERO;
                        } else {
                            larray[i + j] = 0L;
                        }
                        ++j;
                    }
                    i = (int)((long)i + (zeros - 1L));
                    continue;
                }
                if (bigInt) {
                    b[i] = new BigInteger(num, 16);
                    continue;
                }
                larray[i] = cMsgMessage.hexStrToLong(num, false);
            }
            if (isSystem && name.equals("cMsgTimes")) {
                if (count != 6) {
                    throw new cMsgException("bad format");
                }
                this.userTime = larray[0] * 1000L + larray[1] / 1000000L;
                this.senderTime = larray[2] * 1000L + larray[3] / 1000000L;
                this.receiverTime = larray[4] * 1000L + larray[5] / 1000000L;
                return;
            }
            if (bigInt) {
                this.addPayloadItem(new cMsgPayloadItem(name, b, textRep, noHeadLen, isSystem));
            } else {
                this.addPayloadItem(new cMsgPayloadItem(name, larray, textRep, noHeadLen, isSystem, false));
            }
        } else if (dataType == 28 || unsigned32) {
            int i1 = -9;
            int[] iarray = null;
            long[] larray = null;
            if (unsigned32) {
                larray = new long[count];
            } else {
                iarray = new int[count];
            }
            for (int i = 0; i < count; ++i) {
                int i2;
                String num;
                if (toByte[(num = val.substring(i1 += 9, i2 = i1 + 8)).charAt(0)] == -2) {
                    int zeros = cMsgMessage.hexStrToInt(num, true);
                    for (int j = 0; j < zeros; ++j) {
                        if (unsigned32) {
                            larray[i] = 0L;
                            continue;
                        }
                        iarray[i + j] = 0;
                    }
                    i += zeros - 1;
                    continue;
                }
                int ival = cMsgMessage.hexStrToInt(num, false);
                if (unsigned32) {
                    larray[i] = (long)ival & 0xFFFFFFFFL;
                    continue;
                }
                iarray[i] = ival;
            }
            if (isSystem && name.equals("cMsgInts")) {
                if (count != 5) {
                    throw new cMsgException("bad format");
                }
                this.version = iarray[0];
                this.info = iarray[1];
                this.reserved = iarray[2];
                this.length = iarray[3];
                this.userInt = iarray[4];
                return;
            }
            if (unsigned32) {
                this.addPayloadItem(new cMsgPayloadItem(name, larray, textRep, noHeadLen, isSystem, unsigned32));
            } else {
                this.addPayloadItem(new cMsgPayloadItem(name, iarray, textRep, noHeadLen, isSystem, unsigned32));
            }
        } else if (dataType == 27 || unsigned16) {
            int i1 = -5;
            short[] sarray = null;
            int[] iarray = null;
            if (unsigned16) {
                iarray = new int[count];
            } else {
                sarray = new short[count];
            }
            for (int i = 0; i < count; ++i) {
                int i2;
                String num;
                if (toByte[(num = val.substring(i1 += 5, i2 = i1 + 4)).charAt(0)] == -2) {
                    int zeros = cMsgMessage.hexStrToShort(num, true);
                    for (int j = 0; j < zeros; ++j) {
                        if (unsigned16) {
                            iarray[i] = 0;
                            continue;
                        }
                        sarray[i + j] = 0;
                    }
                    i += zeros - 1;
                    continue;
                }
                short sval = cMsgMessage.hexStrToShort(num, false);
                if (unsigned16) {
                    iarray[i] = sval & 0xFFFF;
                    continue;
                }
                sarray[i] = sval;
            }
            if (unsigned16) {
                this.addPayloadItem(new cMsgPayloadItem(name, iarray, textRep, noHeadLen, isSystem, unsigned16));
            } else {
                this.addPayloadItem(new cMsgPayloadItem(name, sarray, textRep, noHeadLen, isSystem, unsigned16));
            }
        } else if (dataType == 26 || unsigned8) {
            int i1 = -3;
            byte[] barray = null;
            short[] sarray = null;
            if (unsigned8) {
                sarray = new short[count];
            } else {
                barray = new byte[count];
            }
            for (int i = 0; i < count; ++i) {
                int i2 = (i1 += 3) + 2;
                String num = val.substring(i1, i2);
                byte bval = (byte)(toByte[num.charAt(0)] << 4 | toByte[num.charAt(1)]);
                if (unsigned8) {
                    sarray[i] = (short)(bval & 0xFF);
                    continue;
                }
                barray[i] = bval;
            }
            if (unsigned8) {
                this.addPayloadItem(new cMsgPayloadItem(name, sarray, textRep, noHeadLen, isSystem, unsigned8));
            } else {
                this.addPayloadItem(new cMsgPayloadItem(name, barray, textRep, noHeadLen, isSystem));
            }
        }
    }

    private void addMessagesFromText(String name, int dataType, boolean isSystem, cMsgMessage[] newMsgs, String txt, int fullIndex, int noHeadLen, int totalItemLen) throws cMsgException {
        String textRep = txt.substring(fullIndex, fullIndex + totalItemLen);
        if (dataType == 21) {
            this.addPayloadItem(new cMsgPayloadItem(name, newMsgs[0], textRep, noHeadLen, isSystem));
        } else {
            this.addPayloadItem(new cMsgPayloadItem(name, newMsgs, textRep, noHeadLen, isSystem));
        }
    }

    public void payloadPrintout(int level) {
        String indent = "";
        level = level < 1 ? 0 : (level %= 10);
        if (level > 0) {
            char[] c = new char[level * 5];
            Arrays.fill(c, ' ');
            indent = new String(c);
        }
        block24: for (Map.Entry<String, cMsgPayloadItem> entry : this.items.entrySet()) {
            String name = entry.getKey();
            cMsgPayloadItem item = entry.getValue();
            int typ = item.getType();
            System.out.print(indent + "FIELD " + name);
            try {
                switch (typ) {
                    case 13: {
                        byte i = item.getByte();
                        System.out.println(" (int8): " + i);
                        break;
                    }
                    case 14: {
                        short i = item.getShort();
                        System.out.println(" (int16): " + i);
                        break;
                    }
                    case 15: {
                        int i = item.getInt();
                        System.out.println(" (int32): " + i);
                        break;
                    }
                    case 16: {
                        long i = item.getLong();
                        System.out.println(" (int64): " + i);
                        break;
                    }
                    case 20: {
                        BigInteger i = item.getBigInt();
                        System.out.println(" (uint64): " + i);
                        break;
                    }
                    case 12: {
                        double d = item.getDouble();
                        System.out.println(" (double): " + d);
                        break;
                    }
                    case 11: {
                        float f = item.getFloat();
                        System.out.println(" (float): " + f);
                        break;
                    }
                    case 10: {
                        String s = item.getString();
                        System.out.println(" (string): " + s);
                        break;
                    }
                    case 26: {
                        int j;
                        byte[] i = item.getByteArray();
                        System.out.println(":");
                        for (j = 0; j < i.length; ++j) {
                            System.out.println(indent + "  int8[" + j + "] = " + i[j]);
                        }
                        continue block24;
                    }
                    case 27: {
                        int j;
                        short[] i = item.getShortArray();
                        System.out.println(":");
                        for (j = 0; j < i.length; ++j) {
                            System.out.println(indent + "  int16[" + j + "] = " + i[j]);
                        }
                        continue block24;
                    }
                    case 28: {
                        int j;
                        int[] i = item.getIntArray();
                        System.out.println(":");
                        for (j = 0; j < i.length; ++j) {
                            System.out.println(indent + "  int32[" + j + "] = " + i[j]);
                        }
                        continue block24;
                    }
                    case 29: {
                        int j;
                        long[] i = item.getLongArray();
                        System.out.println(":");
                        for (j = 0; j < i.length; ++j) {
                            System.out.println(indent + "  int64[" + j + "] = " + i[j]);
                        }
                        continue block24;
                    }
                    case 33: {
                        int j;
                        BigInteger[] i = item.getBigIntArray();
                        System.out.println(":");
                        for (j = 0; j < i.length; ++j) {
                            System.out.println(indent + "  uint16[" + j + "] = " + i[j]);
                        }
                        continue block24;
                    }
                    case 25: {
                        int j;
                        double[] i = item.getDoubleArray();
                        System.out.println(":");
                        for (j = 0; j < i.length; ++j) {
                            System.out.println(indent + "  double[" + j + "] = " + i[j]);
                        }
                        continue block24;
                    }
                    case 24: {
                        int j;
                        float[] i = item.getFloatArray();
                        System.out.println(":");
                        for (j = 0; j < i.length; ++j) {
                            System.out.println(indent + "  float[" + j + "] = " + i[j]);
                        }
                        continue block24;
                    }
                    case 23: {
                        int j;
                        String[] i = item.getStringArray();
                        System.out.println(":");
                        for (j = 0; j < i.length; ++j) {
                            System.out.println(indent + "  string[" + j + "] = " + i[j]);
                        }
                        continue block24;
                    }
                    case 22: {
                        int sb;
                        byte[] b = item.getBinary();
                        int end = item.getEndian();
                        int sz = sb = b.length;
                        if (sb > 1024) {
                            sb = 1024;
                        }
                        String enc = Base64.encodeToString(b, 0, sb, true);
                        if (end == 0) {
                            System.out.print(" (binary, big endian):\n" + indent + enc);
                        } else {
                            System.out.print(" (binary, little endian):\n" + indent + enc);
                        }
                        if (sz <= sb) continue block24;
                        System.out.println(indent + "... " + (sz - sb) + " more bytes of binary not printed here ...");
                        break;
                    }
                    case 35: {
                        int sz;
                        int j;
                        byte[][] b = item.getBinaryArray();
                        int[] end = item.getEndianArray();
                        System.out.println(":");
                        byte[] b1k = new byte[1024];
                        for (j = 0; j < b.length; ++j) {
                            int sb;
                            sz = sb = b[j].length;
                            if (sb > 1024) {
                                sb = 1024;
                            }
                            String enc = Base64.encodeToString(b[j], 0, sb, true);
                            if (end[j] == 0) {
                                System.out.print("  binary[" + j + "], big endian = \n" + indent + enc);
                            } else {
                                System.out.print("  binary[" + j + "], little endian = \n" + indent + enc);
                            }
                            if (sz <= sb) continue;
                            System.out.println(indent + "... " + (sz - sb) + " more bytes of binary not printed here ...");
                        }
                        continue block24;
                    }
                    case 21: {
                        cMsgMessage m = item.getMessage();
                        System.out.println(" (cMsg message):");
                        m.payloadPrintout(level + 1);
                        break;
                    }
                    case 34: {
                        int j;
                        cMsgMessage[] m = item.getMessageArray();
                        System.out.println(":");
                        for (j = 0; j < m.length; ++j) {
                            System.out.println(indent + "  message[" + j + "] =");
                            m[j].payloadPrintout(level + 1);
                        }
                        continue block24;
                    }
                    default: {
                        System.out.println();
                    }
                }
            }
            catch (cMsgException cMsgException2) {}
        }
    }
}

