/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgDeliverMessageInterface;

public class cMsgMessageDeliverer
implements cMsgDeliverMessageInterface {
    private SocketChannel channel;
    private DataOutputStream out;
    private cMsgClientInfo info;
    boolean blocking;
    ByteBuffer buffer;

    @Override
    public synchronized void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void deliverMessage(cMsgMessage msg, int msgType) throws IOException, cMsgException {
        if (this.blocking) {
            this.deliverMessageReal(msg, msgType);
        } else {
            this.deliverMessageRealNonblocking(msg, msgType);
        }
    }

    @Override
    public synchronized void deliverMessage(int i, int j, int msgType) throws IOException, cMsgException {
        if (this.blocking) {
            this.deliverMessageReal(i, j, msgType);
        } else {
            this.deliverMessageRealNonblocking(i, j, msgType);
        }
    }

    @Override
    public synchronized void deliverMessage(String[] strs, int msgType) throws IOException, cMsgException {
        if (this.blocking) {
            this.deliverMessageReal(strs, msgType);
        } else {
            this.deliverMessageRealNonblocking(strs, msgType);
        }
    }

    public synchronized void createClientConnection(SocketChannel channel, boolean blocking) throws IOException {
        this.blocking = blocking;
        this.channel = channel;
        this.buffer = ByteBuffer.allocateDirect(16384);
        channel.socket().setTcpNoDelay(true);
        channel.socket().setSendBufferSize(131072);
        if (blocking) {
            channel.configureBlocking(true);
            ByteChannel bc = cMsgUtilities.wrapChannel(channel);
            this.out = new DataOutputStream(new BufferedOutputStream(Channels.newOutputStream(bc), 131072));
        }
    }

    private void deliverMessageReal(int i, int j, int msgType) throws IOException, cMsgException {
        if (this.out == null || !this.channel.isOpen()) {
            throw new cMsgException("Channel to client is closed");
        }
        if (msgType == 3) {
            this.out.writeInt(4);
            this.out.writeInt(msgType);
            this.out.flush();
        } else {
            this.out.writeInt(12);
            this.out.writeInt(msgType);
            this.out.writeInt(i);
            this.out.writeInt(j);
            this.out.flush();
        }
    }

    private void deliverMessageRealNonblocking(int i, int j, int msgType) throws IOException, cMsgException {
        if (!this.channel.isOpen()) {
            throw new cMsgException("Channel to client is closed");
        }
        if (msgType == 3) {
            this.buffer.clear();
            this.buffer.putInt(4);
            this.buffer.putInt(msgType);
            this.buffer.flip();
        } else {
            this.buffer.clear();
            this.buffer.putInt(12);
            this.buffer.putInt(msgType);
            this.buffer.putInt(i);
            this.buffer.putInt(j);
            this.buffer.flip();
        }
        int bytesWritten = 0;
        int totalBytesWritten = 0;
        boolean tries = false;
        while (this.buffer.hasRemaining()) {
            bytesWritten = this.channel.write(this.buffer);
            if ((totalBytesWritten += bytesWritten) >= this.buffer.limit()) continue;
            if (!this.channel.isOpen()) {
                throw new cMsgException("Channel to client is closed");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void deliverMessageReal(String[] strs, int msgType) throws IOException, cMsgException {
        if (this.out == null || !this.channel.isOpen()) {
            throw new cMsgException("Channel to client is closed");
        }
        int size = 4 * (2 + strs.length);
        for (String s : strs) {
            size += s.length();
        }
        this.out.writeInt(size);
        this.out.writeInt(msgType);
        this.out.writeInt(strs.length);
        for (String s : strs) {
            this.out.writeInt(s.length());
        }
        try {
            for (String s : strs) {
                this.out.write(s.getBytes("US-ASCII"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.out.flush();
    }

    private void deliverMessageRealNonblocking(String[] strs, int msgType) throws IOException, cMsgException {
        if (!this.channel.isOpen()) {
            throw new cMsgException("Channel to client is closed");
        }
        int size = 4 * (2 + strs.length);
        for (String s : strs) {
            size += s.length();
        }
        if (this.buffer.capacity() < size) {
            this.buffer = ByteBuffer.allocateDirect(size + 1024);
        }
        this.buffer.clear();
        this.buffer.putInt(size);
        this.buffer.putInt(msgType);
        this.buffer.putInt(strs.length);
        for (String s : strs) {
            this.buffer.putInt(s.length());
        }
        try {
            for (String s : strs) {
                this.buffer.put(s.getBytes("US-ASCII"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.buffer.flip();
        int bytesWritten = 0;
        int totalBytesWritten = 0;
        boolean tries = false;
        while (this.buffer.hasRemaining()) {
            bytesWritten = this.channel.write(this.buffer);
            if ((totalBytesWritten += bytesWritten) >= this.buffer.limit()) continue;
            if (!this.channel.isOpen()) {
                throw new cMsgException("Channel to client is closed");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void deliverMessageRealNonblocking(cMsgMessage msg, int msgType) throws IOException, cMsgException {
        if (!this.channel.isOpen()) {
            throw new cMsgException("Channel to client is closed");
        }
        if (msgType == 25 || msgType == 39 || msgType == 41) {
            throw new cMsgException("Call deliverMessage(int,int) to send msg");
        }
        if (msgType == 3) {
            this.buffer.clear();
            this.buffer.putInt(4);
            this.buffer.putInt(msgType);
            this.buffer.flip();
        } else {
            int len1 = msg.getSender().length();
            int len2 = msg.getSenderHost().length();
            int len3 = msg.getSubject().length();
            int len4 = msg.getType().length();
            int len5 = 0;
            if (msg.getPayloadText() != null) {
                len5 = msg.getPayloadText().length();
            }
            int len6 = msg.getText().length();
            int binLength = msg.getByteArray() == null ? 0 : msg.getByteArrayLength();
            int size = len1 + len2 + len3 + len4 + len5 + len6 + binLength + 76;
            if (this.buffer.capacity() < size) {
                this.buffer = ByteBuffer.allocateDirect(size + 1024);
            }
            this.buffer.clear();
            this.buffer.putInt(size);
            this.buffer.putInt(msgType);
            this.buffer.putInt(msg.getVersion());
            this.buffer.putInt(0);
            this.buffer.putInt(msg.getUserInt());
            this.buffer.putInt(msg.getInfo());
            this.buffer.putLong(msg.getSenderTime().getTime());
            this.buffer.putLong(msg.getUserTime().getTime());
            this.buffer.putInt(msg.getSysMsgId());
            this.buffer.putInt(msg.getSenderToken());
            this.buffer.putInt(len1);
            this.buffer.putInt(len2);
            this.buffer.putInt(len3);
            this.buffer.putInt(len4);
            this.buffer.putInt(len5);
            this.buffer.putInt(len6);
            this.buffer.putInt(binLength);
            try {
                this.buffer.put(msg.getSender().getBytes("US-ASCII"));
                this.buffer.put(msg.getSenderHost().getBytes("US-ASCII"));
                this.buffer.put(msg.getSubject().getBytes("US-ASCII"));
                this.buffer.put(msg.getType().getBytes("US-ASCII"));
                if (len5 > 0) {
                    this.buffer.put(msg.getPayloadText().getBytes("US-ASCII"));
                }
                this.buffer.put(msg.getText().getBytes("US-ASCII"));
                if (binLength > 0) {
                    this.buffer.put(msg.getByteArray(), msg.getByteArrayOffset(), binLength);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.buffer.flip();
        }
        int bytesWritten = 0;
        int totalBytesWritten = 0;
        boolean tries = false;
        while (this.buffer.hasRemaining()) {
            bytesWritten = this.channel.write(this.buffer);
            if ((totalBytesWritten += bytesWritten) >= this.buffer.limit()) continue;
            if (!this.channel.isOpen()) {
                throw new cMsgException("Channel to client is closed");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void deliverMessageReal(cMsgMessage msg, int msgType) throws IOException, cMsgException {
        if (this.out == null || !this.channel.isOpen()) {
            throw new cMsgException("Channel to client is closed");
        }
        if (msgType == 3) {
            this.out.writeInt(4);
            this.out.writeInt(msgType);
            this.out.flush();
        } else if (msgType == 25) {
            this.out.writeInt(8);
            this.out.writeInt(msgType);
            this.out.writeInt(0);
            this.out.flush();
        } else {
            int len1 = msg.getSender().length();
            int len2 = msg.getSenderHost().length();
            int len3 = msg.getSubject().length();
            int len4 = msg.getType().length();
            int len5 = 0;
            if (msg.getPayloadText() != null) {
                len5 = msg.getPayloadText().length();
            }
            int len6 = msg.getText().length();
            int binLength = msg.getByteArray() == null ? 0 : msg.getByteArrayLength();
            int size = len1 + len2 + len3 + len4 + len5 + len6 + binLength + 72;
            this.out.writeInt(size);
            this.out.writeInt(msgType);
            this.out.writeInt(msg.getVersion());
            this.out.writeInt(0);
            this.out.writeInt(msg.getUserInt());
            this.out.writeInt(msg.getInfo());
            this.out.writeInt((int)(msg.getSenderTime().getTime() >>> 32));
            this.out.writeInt((int)(msg.getSenderTime().getTime() & 0xFFFFFFFFL));
            this.out.writeInt((int)(msg.getUserTime().getTime() >>> 32));
            this.out.writeInt((int)(msg.getUserTime().getTime() & 0xFFFFFFFFL));
            this.out.writeInt(msg.getSysMsgId());
            this.out.writeInt(msg.getSenderToken());
            this.out.writeInt(len1);
            this.out.writeInt(len2);
            this.out.writeInt(len3);
            this.out.writeInt(len4);
            this.out.writeInt(len5);
            this.out.writeInt(len6);
            this.out.writeInt(binLength);
            try {
                this.out.write(msg.getSender().getBytes("US-ASCII"));
                this.out.write(msg.getSenderHost().getBytes("US-ASCII"));
                this.out.write(msg.getSubject().getBytes("US-ASCII"));
                this.out.write(msg.getType().getBytes("US-ASCII"));
                if (len5 > 0) {
                    this.out.write(msg.getPayloadText().getBytes("US-ASCII"));
                }
                this.out.write(msg.getText().getBytes("US-ASCII"));
                if (binLength > 0) {
                    this.out.write(msg.getByteArray(), msg.getByteArrayOffset(), binLength);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.out.flush();
        }
    }
}

