/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgClientData;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgConnectionHandler;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgDomainServer;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgDomainServerSelect;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgMonitorClient;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgMulticastListeningThread;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerBridge;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerCloudJoiner;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerSubscribeInfo;
import org.jlab.coda.cMsg.cMsgDomain.subdomains.cMsg;
import org.jlab.coda.cMsg.cMsgDomain.subdomains.cMsgMessageDeliverer;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgSubdomainInterface;
import org.jlab.coda.cMsg.remoteExec.IExecutorThread;

public class cMsgNameServer
extends Thread
implements IExecutorThread {
    String serverName;
    private String host;
    private int port;
    private int multicastPort;
    private int clientsMax = 10;
    static int domainPortMax = 65535;
    static int domainServerPort;
    private ServerSocketChannel serverChannel;
    private MulticastSocket multicastSocket;
    private cMsgMulticastListeningThread multicastThread;
    private cMsgConnectionHandler connectionHandler;
    private cMsgMonitorClient monitorHandler;
    CountDownLatch preConnectionThreadsStartedSignal = new CountDownLatch(3);
    CountDownLatch postConnectionThreadsStartedSignal = new CountDownLatch(2);
    ConcurrentHashMap<cMsgDomainServer, String> domainServers;
    ConcurrentHashMap<cMsgDomainServerSelect, String> domainServersSelect;
    List<cMsgDomainServerSelect> availableDomainServers;
    private int debug;
    HashSet<cMsgServerSubscribeInfo> subscriptions = new HashSet(100);
    final ReentrantLock subscribeLock = new ReentrantLock();
    private boolean killAllThreads;
    private ArrayList<ClientHandler> handlerThreads;
    String fullMonitorXML;
    String nsMonitorXML;
    boolean monitoringOff;
    String clientPassword;
    String cloudPassword;
    boolean standAlone;
    private String serverToJoin;
    volatile cMsgServerBridge bridgeBeingCreated;
    CountDownLatch listeningThreadsStartedSignal = new CountDownLatch(2);
    CountDownLatch allowConnectionsCloudSignal = new CountDownLatch(1);
    static final byte INCLOUD = 0;
    static final byte NONCLOUD = 1;
    static final byte BECOMINGCLOUD = 2;
    static final byte UNKNOWNCLOUD = 3;
    ConcurrentHashMap<String, cMsgClientData> nameServers = new ConcurrentHashMap(20);
    ConcurrentHashMap<String, cMsgServerBridge> bridges = new ConcurrentHashMap(20);
    private int cloudStatus = 1;
    private ReentrantLock cloudLock = new ReentrantLock();

    private void setKillAllThreads(boolean b) {
        this.killAllThreads = b;
    }

    private boolean getKillAllThreads() {
        return this.killAllThreads;
    }

    void cloudLock() {
        this.cloudLock.lock();
    }

    boolean cloudLock(int delay) {
        try {
            return this.cloudLock.tryLock(delay, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    void cloudUnlock() {
        this.cloudLock.unlock();
    }

    public int getCloudStatus() {
        return this.cloudStatus;
    }

    void setCloudStatus(int status) {
        if (status != 0 && status != 1 && status != 2) {
            return;
        }
        this.cloudStatus = status;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getDomainPort() {
        return domainServerPort;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public cMsgNameServer(int port, int domainPort, int udpPort, boolean standAlone, boolean monitoringOff, String clientPassword, String cloudPassword, String serverToJoin, int debug, int clientsMax) {
        String env;
        this.domainServers = new ConcurrentHashMap(20);
        this.domainServersSelect = new ConcurrentHashMap(20);
        this.handlerThreads = new ArrayList(10);
        this.availableDomainServers = Collections.synchronizedList(new ArrayList(20));
        this.debug = debug;
        this.clientsMax = clientsMax;
        this.standAlone = standAlone;
        this.monitoringOff = monitoringOff;
        this.cloudPassword = cloudPassword;
        this.clientPassword = clientPassword;
        this.serverToJoin = serverToJoin;
        if (standAlone && serverToJoin != null) {
            System.out.println("\nCannot have \"serverToJoin != null\" and \"standalone = true\" simultaneously");
            System.exit(-1);
        }
        if (domainPort < 1) {
            try {
                env = System.getenv("CMSG_DOMAIN_PORT");
                if (env != null) {
                    domainPort = Integer.parseInt(env);
                }
            }
            catch (NumberFormatException ex) {
                System.out.println("Bad port number specified in CMSG_DOMAIN_PORT env variable");
                System.exit(-1);
            }
        }
        if (domainPort < 1) {
            domainPort = 45001;
        }
        if ((domainServerPort = domainPort) < 1024) {
            System.out.println("Domain server port number must be > 1023");
            System.exit(-1);
        }
        if (debug >= 4) {
            System.out.println(">> NS: Domain server port = " + domainServerPort);
        }
        if (port < 1) {
            try {
                env = System.getenv("CMSG_PORT");
                if (env != null) {
                    port = Integer.parseInt(env);
                }
            }
            catch (NumberFormatException ex) {
                System.out.println("Bad port number specified in CMSG_PORT env variable");
                System.exit(-1);
            }
        }
        if (port < 1) {
            port = 45000;
        }
        if (port < 1024) {
            System.out.println("Port number must be > 1023");
            System.exit(-1);
        }
        if (debug >= 4) {
            System.out.println(">> NS: Name server TCP port = " + port);
        }
        if (udpPort < 1) {
            try {
                env = System.getenv("CMSG_MULTICAST_PORT");
                if (env != null) {
                    udpPort = Integer.parseInt(env);
                }
            }
            catch (NumberFormatException ex) {
                System.out.println("Bad port number specified in CMSG_MULTICAST_PORT env variable");
                System.exit(-1);
            }
        }
        if (udpPort < 1) {
            udpPort = 45000;
        }
        if (udpPort < 1024) {
            System.out.println("\nPort number must be > 1023");
            System.exit(-1);
        }
        if (debug >= 4) {
            System.out.println(">> NS: Name server UDP port = " + udpPort);
        }
        try {
            this.serverChannel = ServerSocketChannel.open();
        }
        catch (IOException ex) {
            System.out.println("Exiting Server: cannot open a listening socket");
            System.exit(-1);
        }
        ServerSocket listeningSocket = this.serverChannel.socket();
        try {
            listeningSocket.setReuseAddress(true);
            listeningSocket.setPerformancePreferences(1, 2, 0);
            listeningSocket.bind(new InetSocketAddress(port));
        }
        catch (IOException ex) {
            System.out.println("TCP port number " + port + " in use.");
            System.exit(-1);
        }
        this.port = port;
        try {
            this.multicastSocket = new MulticastSocket(udpPort);
            this.multicastSocket.setReceiveBufferSize(65535);
            this.multicastSocket.setReuseAddress(true);
            this.multicastSocket.setTimeToLive(32);
            Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                try {
                    InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName("239.220.0.0"), udpPort);
                    this.multicastSocket.joinGroup(sa, enumer.nextElement());
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            System.out.println("UDP port number " + udpPort + " in use.");
            System.exit(-1);
        }
        this.multicastPort = udpPort;
        try {
            this.serverName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.serverName = this.serverName + ":" + port;
        try {
            this.host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private static void usage() {
        System.out.println("\nUsage: java [-Dport=<tcp listening port>]\n            [-DdomainPort=<domain server listening port>]\n            [-Dudp=<udp listening port>]\n            [-DsubdomainName=<className>]\n            [-Dserver=<hostname:serverport>]\n            [-Ddebug=<level>]\n            [-Dstandalone]\n            [-DmonitorOff]\n            [-Dpassword=<password>]\n            [-Dcloudpassword=<password>]\n            [-DlowRegimeSize=<size>]  cMsgNameServer\n");
        System.out.println("       port           is the TCP port this server listens on");
        System.out.println("       domainPort     is the TCP port this server listens on for connection to domain server");
        System.out.println("       udp            is the UDP port this server listens on for multicasts");
        System.out.println("       subdomainName  is the name of a subdomain and className is the");
        System.out.println("                      name of the java class used to implement the subdomain");
        System.out.println("       server         punctuation (not colon) or white space separated list of servers\n                      in host:port format to connect to in order to gain entry to cloud\n                      of servers. First successful connection used. If no connections made,\n                      no error indicated.");
        System.out.println("       debug          debug output level has acceptable values of:");
        System.out.println("                          info   for full output");
        System.out.println("                          warn   for severity of warning or greater");
        System.out.println("                          error  for severity of error or greater");
        System.out.println("                          severe for severity of \"cannot go on\"");
        System.out.println("                          none   for no debug output (default)");
        System.out.println("       standalone     means no other servers may connect or vice versa,");
        System.out.println("                      is incompatible with \"server\" option");
        System.out.println("       monitorOff     means monitoring data is NOT sent to client,");
        System.out.println("       password       is used to block clients without this password in their UDL's");
        System.out.println("       cloudpassword  is used to join a password-protected cloud or to allow");
        System.out.println("                      servers with this password to join this cloud");
        System.out.println("       lowRegimeSize  for clients of \"regime=low\" type, this sets the number of");
        System.out.println("                      clients serviced by a single thread");
        System.out.println();
    }

    public void printSizes() {
        System.out.println("     bridges        = " + this.bridges.size());
        System.out.println("     nameservers    = " + this.nameServers.size());
        System.out.println("     domainservers  = " + this.domainServers.size());
        System.out.println("     subscriptions  = " + this.subscriptions.size());
        System.out.println("     handlerThreads = " + this.handlerThreads.size());
        System.out.println();
        for (cMsgServerBridge b : this.bridges.values()) {
            System.out.println("       bridge " + b.serverName + ":");
            b.printSizes();
        }
        if (this.bridges.size() > 0) {
            System.out.println();
        }
    }

    public static void main(String[] args) {
        int debug = 0;
        int port = 0;
        int udpPort = 0;
        int domainPort = 0;
        int clientsMax = 10;
        boolean standAlone = false;
        boolean monitorOff = false;
        String serverToJoin = null;
        String cloudPassword = null;
        String clientPassword = null;
        if (args.length > 0) {
            cMsgNameServer.usage();
            System.exit(-1);
        }
        for (String string : System.getProperties().keySet()) {
            if (string.contains(".")) continue;
            if (string.equalsIgnoreCase("port")) {
                try {
                    port = Integer.parseInt(System.getProperty(string));
                }
                catch (NumberFormatException e) {
                    System.out.println("\nBad port number specified");
                    cMsgNameServer.usage();
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            if (string.equalsIgnoreCase("udp")) {
                try {
                    udpPort = Integer.parseInt(System.getProperty(string));
                }
                catch (NumberFormatException e) {
                    System.out.println("\nBad port number specified");
                    cMsgNameServer.usage();
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            if (string.equalsIgnoreCase("domainPort")) {
                try {
                    domainPort = Integer.parseInt(System.getProperty(string));
                }
                catch (NumberFormatException e) {
                    System.out.println("\nBad domain server port number specified");
                    cMsgNameServer.usage();
                    e.printStackTrace();
                    System.exit(-1);
                }
                if (domainPort > 65535 || domainPort < 1024) {
                    System.out.println("\nBad domain server port number specified");
                    cMsgNameServer.usage();
                    System.exit(-1);
                }
            }
            if (string.equalsIgnoreCase("lowRegimeSize")) {
                try {
                    clientsMax = Integer.parseInt(System.getProperty(string));
                }
                catch (NumberFormatException e) {
                    System.out.println("\nBad maximum number of clients serviced by single thread in low regime");
                }
                if (clientsMax <= 100 && clientsMax >= 2) continue;
                System.out.println("\nBad maximum number of clients serviced by single thread in low regime");
                continue;
            }
            if (string.equalsIgnoreCase("debug")) {
                String arg = System.getProperty(string);
                if (arg.equalsIgnoreCase("info")) {
                    debug = 4;
                    continue;
                }
                if (arg.equalsIgnoreCase("warn")) {
                    debug = 3;
                    continue;
                }
                if (arg.equalsIgnoreCase("error")) {
                    debug = 2;
                    continue;
                }
                if (arg.equalsIgnoreCase("severe")) {
                    debug = 1;
                    continue;
                }
                if (arg.equalsIgnoreCase("none")) {
                    debug = 0;
                    continue;
                }
                System.out.println("\nBad debug value");
                cMsgNameServer.usage();
                System.exit(-1);
                continue;
            }
            if (string.equalsIgnoreCase("server")) {
                if (standAlone) {
                    System.out.println("\nCannot specify \"server\" and \"standalone\" options simultaneously");
                    cMsgNameServer.usage();
                    System.exit(-1);
                }
                serverToJoin = System.getProperty(string);
                continue;
            }
            if (string.equalsIgnoreCase("standalone")) {
                if (serverToJoin != null) {
                    System.out.println("\nCannot specify \"server\" and \"standalone\" options simultaneously");
                    cMsgNameServer.usage();
                    System.exit(-1);
                }
                standAlone = true;
                continue;
            }
            if (string.equalsIgnoreCase("monitorOff")) {
                monitorOff = true;
                continue;
            }
            if (string.equalsIgnoreCase("cloudpassword")) {
                cloudPassword = System.getProperty(string);
                continue;
            }
            if (!string.equalsIgnoreCase("password")) continue;
            clientPassword = System.getProperty(string);
        }
        cMsgNameServer server = new cMsgNameServer(port, domainPort, udpPort, standAlone, monitorOff, clientPassword, cloudPassword, serverToJoin, debug, clientsMax);
        server.startServer();
    }

    @Override
    public void startItUp() {
        this.startServer();
    }

    @Override
    public void shutItDown() {
        this.shutdown();
    }

    @Override
    public void waitUntilDone() throws InterruptedException {
        this.join();
    }

    public void startServer() {
        if (this.debug >= 4) {
            System.out.println(">> NS: Start keepalive/monitoring thread ");
        }
        try {
            this.monitorHandler = new cMsgMonitorClient(this, this.debug);
            this.monitorHandler.start();
        }
        catch (IOException e) {
            if (this.debug >= 4) {
                System.out.println(">> NS: Cannot start up selector for reading monitoring data");
            }
            this.shutdown();
            return;
        }
        if (this.debug >= 4) {
            System.out.println(">> NS: Start connection handling thread");
        }
        this.connectionHandler = new cMsgConnectionHandler(this, this.debug);
        this.connectionHandler.start();
        try {
            boolean threadsStarted = this.preConnectionThreadsStartedSignal.await(20L, TimeUnit.SECONDS);
            if (!threadsStarted) {
                System.out.println(">> **** cMsg server NOT started due to theads taking too long to start **** <<");
                this.shutdown();
                return;
            }
        }
        catch (InterruptedException e) {
            System.out.println(">> **** cMsg server NOT started due to interrupt **** <<");
            this.shutdown();
            return;
        }
        this.start();
        if (this.standAlone) {
            if (this.debug >= 4) {
                System.out.println(">> NS: Running in stand-alone mode");
            }
            this.cloudStatus = 1;
            this.allowConnectionsCloudSignal.countDown();
        } else if (this.serverToJoin != null) {
            String[] strs;
            LinkedHashSet<String> serverSet = new LinkedHashSet<String>();
            for (String s : strs = this.serverToJoin.split("[\\p{Punct}\\p{Space}&&[^:\\.]]")) {
                if (s.length() < 1) continue;
                try {
                    serverSet.add(cMsgUtilities.constructServerName(s));
                    if (this.debug < 4) continue;
                    System.out.println(">> NS: Joined server " + s + " in a cloud");
                }
                catch (cMsgException e) {
                    System.out.println("Server to join not in \"host:port\" format:\n" + e.getMessage());
                }
            }
            if (serverSet.size() < 1) {
                this.cloudStatus = 0;
                this.allowConnectionsCloudSignal.countDown();
            } else {
                new cMsgServerCloudJoiner(this, this.port, this.multicastPort, serverSet, this.debug);
            }
        } else {
            this.cloudStatus = 0;
            this.allowConnectionsCloudSignal.countDown();
        }
        if (this.debug >= 4) {
            System.out.println(">> NS: Start multicast thd on port " + this.multicastPort);
        }
        this.multicastThread = new cMsgMulticastListeningThread(this, this.port, this.multicastPort, this.multicastSocket, this.clientPassword, this.debug);
        this.multicastThread.start();
        try {
            boolean threadsStarted = this.listeningThreadsStartedSignal.await(20L, TimeUnit.SECONDS);
            if (!threadsStarted) {
                System.out.println(">> **** cMsg server NOT started due to listening theads taking too long to start **** <<");
                this.shutdown();
                return;
            }
        }
        catch (InterruptedException e) {
            System.out.println(">> **** cMsg server NOT started due to interrupt **** <<");
            this.shutdown();
            return;
        }
    }

    public void cleanUp() {
        this.shutdown();
    }

    synchronized void shutdown() {
        this.cloudLock();
        this.setKillAllThreads(true);
        this.multicastThread.killThread();
        this.connectionHandler.killThread();
        this.monitorHandler.shutdown();
        for (Thread server : this.domainServers.keySet()) {
            if (!((cMsgDomainServer)server).calledShutdown.compareAndSet(false, true)) continue;
            ((cMsgDomainServer)server).shutdown();
        }
        for (Thread server : this.domainServersSelect.keySet()) {
            if (!((cMsgDomainServerSelect)server).calledShutdown.compareAndSet(false, true)) continue;
            ((cMsgDomainServerSelect)server).shutdown();
        }
        this.cloudUnlock();
        this.bridges.clear();
        this.nameServers.clear();
        this.handlerThreads.clear();
        this.domainServers.clear();
        this.domainServersSelect.clear();
        this.subscriptions.clear();
    }

    private static cMsgSubdomainInterface createClientHandler(String subdomain) throws cMsgException {
        cMsgSubdomainInterface clientHandler;
        String clientHandlerClass = null;
        if (subdomain.equalsIgnoreCase("cMsg")) {
            clientHandlerClass = "org.jlab.coda.cMsg.cMsgDomain.subdomains.cMsg";
        }
        if (clientHandlerClass == null) {
            for (String string : System.getProperties().keySet()) {
                if (string.contains(".") || !string.equalsIgnoreCase(subdomain)) continue;
                clientHandlerClass = System.getProperty(string);
                break;
            }
        }
        if (clientHandlerClass == null) {
            clientHandlerClass = System.getenv("CMSG_SUBDOMAIN");
        }
        if (clientHandlerClass == null) {
            if (subdomain.equalsIgnoreCase("CA")) {
                clientHandlerClass = "org.jlab.coda.cMsg.cMsgDomain.subdomains.CA";
            } else if (subdomain.equalsIgnoreCase("Et")) {
                clientHandlerClass = "org.jlab.coda.cMsg.cMsgDomain.subdomains.Et";
            } else if (subdomain.equalsIgnoreCase("Database")) {
                clientHandlerClass = "org.jlab.coda.cMsg.cMsgDomain.subdomains.Database";
            } else if (subdomain.equalsIgnoreCase("LogFile")) {
                clientHandlerClass = "org.jlab.coda.cMsg.cMsgDomain.subdomains.LogFile";
            } else if (subdomain.equalsIgnoreCase("Queue")) {
                clientHandlerClass = "org.jlab.coda.cMsg.cMsgDomain.subdomains.Queue";
            } else if (subdomain.equalsIgnoreCase("SmartSockets")) {
                clientHandlerClass = "org.jlab.coda.cMsg.cMsgDomain.subdomains.SmartSockets";
            } else if (subdomain.equalsIgnoreCase("TcpServer")) {
                clientHandlerClass = "org.jlab.coda.cMsg.cMsgDomain.subdomains.TcpServer";
            } else if (subdomain.equalsIgnoreCase("FileQueue")) {
                clientHandlerClass = "org.jlab.coda.cMsg.cMsgDomain.subdomains.FileQueue";
            }
        }
        if (clientHandlerClass == null) {
            cMsgException ex2 = new cMsgException("no handler class found");
            ex2.setReturnCode(21);
            throw ex2;
        }
        try {
            clientHandler = (cMsgSubdomainInterface)Class.forName(clientHandlerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            cMsgException cMsgException2 = new cMsgException("cannot instantiate " + clientHandlerClass + " class");
            cMsgException2.setReturnCode(1);
            throw cMsgException2;
        }
        catch (IllegalAccessException e) {
            cMsgException cMsgException3 = new cMsgException("cannot access " + clientHandlerClass + " class");
            cMsgException3.setReturnCode(1);
            throw cMsgException3;
        }
        catch (InvocationTargetException e) {
            cMsgException cMsgException4 = new cMsgException("error in constructor");
            cMsgException4.setReturnCode(21);
            throw cMsgException4;
        }
        catch (NoSuchMethodException e) {
            cMsgException cMsgException5 = new cMsgException("no handler class found");
            cMsgException5.setReturnCode(21);
            throw cMsgException5;
        }
        catch (ClassNotFoundException e) {
            cMsgException cMsgException6 = new cMsgException("no handler class found");
            cMsgException6.setReturnCode(21);
            throw cMsgException6;
        }
        return clientHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block35: {
            if (this.debug >= 4) {
                System.out.println(">> NS: Running Name Server at " + new Date());
            }
            s = "wrong cMsg version";
            len = 8 + s.length();
            respond = null;
            baos = new ByteArrayOutputStream(len);
            out = new DataOutputStream(baos);
            try {
                out.writeInt(1);
                out.writeInt(s.length());
                try {
                    out.write(s.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException var6_6) {
                    // empty catch block
                }
                out.flush();
                out.close();
                respond = baos.toByteArray();
                baos.close();
            }
            catch (IOException var6_7) {
                // empty catch block
            }
            BYTES_TO_READ = 12;
            buffer = ByteBuffer.allocateDirect(BYTES_TO_READ > respond.length ? BYTES_TO_READ : respond.length);
            selector = null;
            try {
                selector = Selector.open();
                this.serverChannel.configureBlocking(false);
                this.serverChannel.register(selector, 16);
                this.listeningThreadsStartedSignal.countDown();
lbl33:
                // 2 sources

                while (true) {
                    if ((n = selector.select(3000L)) == 0) {
                        if (!this.getKillAllThreads()) continue;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (IOException ex) {
                System.out.println("Main server IO error");
                ex.printStackTrace();
                try {
                    this.serverChannel.close();
                }
                catch (IOException var9_14) {
                    // empty catch block
                }
                try {
                    selector.close();
                }
                catch (IOException var9_15) {}
                break block35;
            }
            catch (Throwable var20_31) {
                try {
                    this.serverChannel.close();
                }
                catch (IOException var21_32) {
                    // empty catch block
                }
                try {
                    selector.close();
                    throw var20_31;
                }
                catch (IOException var21_33) {
                    // empty catch block
                }
                throw var20_31;
            }
            try {
                this.serverChannel.close();
            }
            catch (IOException var10_17) {
                // empty catch block
            }
            try {
                selector.close();
                return;
            }
            catch (IOException var10_18) {
                // empty catch block
            }
            return;
lbl-1000:
            // 1 sources

            {
                it = selector.selectedKeys().iterator();
                block26: while (true) {
                    if (it.hasNext()) ** break;
                    ** continue;
                    key = it.next();
                    if (key.isValid() && key.isAcceptable()) {
                        server = (ServerSocketChannel)key.channel();
                        channel = server.accept();
                        bytesRead = 0;
                        loops = 0;
                        buffer.clear();
                        buffer.limit(BYTES_TO_READ);
                        channel.configureBlocking(false);
                        try {
                            while (bytesRead < BYTES_TO_READ) {
                                bytes = channel.read(buffer);
                                if (bytes == -1) {
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                if ((bytesRead += bytes) >= BYTES_TO_READ) {
                                    buffer.flip();
                                    magic1 = buffer.getInt();
                                    magic2 = buffer.getInt();
                                    magic3 = buffer.getInt();
                                    if (magic1 == cMsgNetworkConstants.magicNumbers[0] && magic2 == cMsgNetworkConstants.magicNumbers[1] && magic3 == cMsgNetworkConstants.magicNumbers[2]) continue;
                                    buffer.clear();
                                    buffer.put(respond);
                                    buffer.flip();
                                    channel.write(buffer);
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                if (++loops > 50) {
                                    channel.close();
                                    it.remove();
                                    continue block26;
                                }
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException magic1) {}
                            }
                        }
                        catch (IOException e) {
                            channel.close();
                            it.remove();
                            continue;
                        }
                        channel.configureBlocking(true);
                        socket = channel.socket();
                        socket.setTcpNoDelay(true);
                        socket.setReceiveBufferSize(4096);
                        this.handlerThreads.add(new ClientHandler(channel));
                        if (this.debug >= 4) {
                            System.out.println(">> NS: new connection");
                        }
                    }
                    it.remove();
                }
            }
        }
        if (this.debug < 4) return;
        System.out.println("\n>> NS: Quitting Name Server");
    }

    private class ClientHandler
    extends Thread {
        private String domain = "cMsg";
        SocketChannel channel;
        DataInputStream in;
        DataOutputStream out;
        cMsgClientData info;
        int regime;
        byte connectingCloudStatus;
        boolean isReciprocalConnection;
        int nsTcpPort;
        int nsMulticastPort;
        String name;
        String myCloudPassword;
        String myClientPassword;
        String clientHost;

        ClientHandler(SocketChannel channel) {
            this.channel = channel;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                this.in = new DataInputStream(new BufferedInputStream(this.channel.socket().getInputStream(), 4096));
                this.out = new DataOutputStream(new BufferedOutputStream(this.channel.socket().getOutputStream(), 2048));
                int msgId = this.in.readInt();
                int version = this.in.readInt();
                int minorVersion = this.in.readInt();
                if (version != 6) {
                    this.out.writeInt(22);
                    String s = "version mismatch, client(" + version + ") != server(" + 6 + ")";
                    this.out.writeInt(s.length());
                    try {
                        this.out.write(s.getBytes("US-ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.out.flush();
                    return;
                }
                switch (msgId) {
                    case 0: {
                        this.handleRegularClient();
                        return;
                    }
                    case 34: {
                        this.handleServerClient();
                        return;
                    }
                    default: {
                        if (cMsgNameServer.this.debug < 2) return;
                        System.out.println("cMsg name server: can't understand your message -> " + msgId);
                        return;
                    }
                }
            }
            catch (IOException ex) {
                if (cMsgNameServer.this.debug < 2) return;
                System.out.println("cMsgNameServer's Client thread: IO error in talking to client");
                return;
            }
            finally {
                cMsgNameServer.this.handlerThreads.remove(this);
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                try {
                    this.channel.close();
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleServerClient() {
            try {
                this.readServerClientInfo();
                cMsgNameServer.this.cloudLock.lock();
                try {
                    if (!this.allowServerClientConnection()) {
                        return;
                    }
                    int uniqueKey = cMsgNameServer.this.connectionHandler.getUniqueKey();
                    this.info = new cMsgClientData(this.name, this.nsTcpPort, this.nsMulticastPort, this.clientHost, this.myClientPassword, uniqueKey);
                    if (cMsgNameServer.this.debug >= 4) {
                        System.out.println(">> NS: try to register " + this.name);
                    }
                    try {
                        this.registerServer();
                    }
                    catch (cMsgException ex) {
                        this.out.writeInt(ex.getReturnCode());
                        this.out.writeInt(ex.getMessage().length());
                        try {
                            this.out.write(ex.getMessage().getBytes("US-ASCII"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        this.out.flush();
                    }
                }
                finally {
                    cMsgNameServer.this.cloudLock.unlock();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void readServerClientInfo() throws IOException {
            this.regime = this.in.readInt();
            if (cMsgNameServer.this.debug >= 4) {
                if (this.regime == 2) {
                    System.out.println(">> NS: regime = High");
                } else if (this.regime == 0) {
                    System.out.println(">> NS: regime = Medium");
                } else if (this.regime == 1) {
                    System.out.println(">> NS: regime = Low");
                }
            }
            this.connectingCloudStatus = this.in.readByte();
            if (cMsgNameServer.this.debug >= 4) {
                if (this.connectingCloudStatus == 0) {
                    System.out.println(">> NS: connection cloud status = in cloud");
                } else if (this.connectingCloudStatus == 1) {
                    System.out.println(">> NS: connection cloud status = non cloud");
                } else if (this.connectingCloudStatus == 2) {
                    System.out.println(">> NS: connection cloud status = becoming cloud");
                }
            }
            boolean bl = this.isReciprocalConnection = this.in.readByte() == 0;
            if (cMsgNameServer.this.debug >= 4) {
                if (this.isReciprocalConnection) {
                    System.out.println(">> NS: reciprocal connection = true");
                } else {
                    System.out.println(">> NS: reciprocal connection = false");
                }
            }
            this.nsTcpPort = this.in.readInt();
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println(">> NS: Tcp listening port connecting server = " + this.nsTcpPort);
            }
            this.nsMulticastPort = this.in.readInt();
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println(">> NS: mcast listening port connecting server = " + this.nsMulticastPort);
            }
            int lengthHost = this.in.readInt();
            int lengthCloudPassword = this.in.readInt();
            int lengthClientPassword = this.in.readInt();
            int bytesToRead = lengthHost + lengthCloudPassword + lengthClientPassword;
            int offset = 0;
            byte[] bytes = new byte[bytesToRead];
            this.in.readFully(bytes, 0, bytesToRead);
            this.clientHost = new String(bytes, offset, lengthHost, "US-ASCII");
            offset += lengthHost;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println(">> NS: host = " + this.clientHost);
            }
            this.myCloudPassword = new String(bytes, offset, lengthCloudPassword, "US-ASCII");
            offset += lengthCloudPassword;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println(">> NS: given cloud password = " + this.myCloudPassword);
            }
            this.myClientPassword = new String(bytes, offset, lengthClientPassword, "US-ASCII");
            offset += lengthClientPassword;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println(">> NS: given client password = " + this.myClientPassword);
            }
            this.name = this.clientHost + ":" + this.nsTcpPort;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println(">> NS: host name = " + this.clientHost + ", client hame = " + this.name);
            }
        }

        private boolean allowServerClientConnection() throws IOException {
            boolean allowConnection = false;
            try {
                if (cMsgNameServer.this.cloudPassword != null && !cMsgNameServer.this.cloudPassword.equals(this.myCloudPassword)) {
                    System.out.println(">> NS: PASSWORDS DO NOT MATCH");
                    cMsgException ex = new cMsgException("wrong password - connection refused");
                    ex.setReturnCode(23);
                    throw ex;
                }
                if (cMsgNameServer.this.standAlone) {
                    System.out.println(">> NS: This is a standalone server, refuse server connection");
                    cMsgException ex = new cMsgException("stand alone server - no server connections allowed");
                    ex.setReturnCode(1);
                    throw ex;
                }
                if (cMsgNameServer.this.nameServers.contains(this.name)) {
                    System.out.println(">> NS: ALREADY CONNECTED TO " + this.name);
                    cMsgException ex = new cMsgException("already connected");
                    ex.setReturnCode(7);
                    throw ex;
                }
                if (cMsgNameServer.this.cloudStatus == 0) {
                    allowConnection = true;
                    this.isReciprocalConnection = false;
                } else if (this.connectingCloudStatus == 0) {
                    allowConnection = true;
                    this.isReciprocalConnection = true;
                } else if (cMsgNameServer.this.cloudStatus == 2 && this.connectingCloudStatus == 2) {
                    allowConnection = true;
                }
                if (!allowConnection) {
                    try {
                        System.out.println(">> NS: Connection NOT allowed so wait up to 5 sec for connection");
                        if (!cMsgNameServer.this.allowConnectionsCloudSignal.await(5L, TimeUnit.SECONDS)) {
                            cMsgException ex = new cMsgException("nameserver not in server cloud - timeout error");
                            ex.setReturnCode(2);
                            throw ex;
                        }
                    }
                    catch (InterruptedException e) {
                        cMsgException ex = new cMsgException("interrupted while waiting for name server to join server cloud");
                        ex.setReturnCode(1);
                        throw ex;
                    }
                }
                allowConnection = true;
            }
            catch (cMsgException ex) {
                this.out.writeInt(ex.getReturnCode());
                this.out.writeInt(ex.getMessage().length());
                try {
                    this.out.write(ex.getMessage().getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.out.flush();
            }
            return allowConnection;
        }

        private void replyToServerClient() throws IOException {
            this.out.writeInt(0);
            this.out.writeInt(this.info.clientKey);
            this.out.writeInt(domainServerPort);
            this.out.writeInt(this.info.getDomainHost().length());
            try {
                this.out.write(this.info.getDomainHost().getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            try {
                cMsgServerBridge b;
                if (!this.isReciprocalConnection) {
                    b = new cMsgServerBridge(cMsgNameServer.this, this.name, cMsgNameServer.this.port, cMsgNameServer.this.multicastPort);
                    b.connect(false, cMsgNameServer.this.cloudPassword, cMsgNameServer.this.clientPassword, false);
                    cMsgNameServer.this.bridges.put(this.name, b);
                    b.setCloudStatus(2);
                } else {
                    b = cMsgNameServer.this.bridgeBeingCreated;
                    if (b != null) {
                        b.setCloudStatus(this.connectingCloudStatus);
                    }
                }
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
            if (cMsgNameServer.this.cloudStatus == 0 && cMsgNameServer.this.nameServers.size() > 0 && !this.isReciprocalConnection) {
                this.out.writeInt(cMsgNameServer.this.nameServers.size());
                for (String serverName : cMsgNameServer.this.nameServers.keySet()) {
                    System.out.println(">>    - " + serverName);
                    this.out.writeInt(serverName.length());
                    this.out.write(serverName.getBytes("US-ASCII"));
                }
            } else {
                this.out.writeInt(0);
            }
            this.out.flush();
            if (this.connectingCloudStatus == 1) {
                this.connectingCloudStatus = (byte)2;
            }
            cMsgNameServer.this.nameServers.put(this.name, this.info);
        }

        private synchronized void registerServer() throws cMsgException, IOException {
            cMsgMessageDeliverer deliverer;
            cMsg subdomainHandler = (cMsg)cMsgNameServer.createClientHandler("cMsg");
            subdomainHandler.setUDLRemainder(null);
            this.info.subdomainHandler = subdomainHandler;
            this.info.cMsgSubdomainHandler = subdomainHandler;
            this.info.setDomainHost(cMsgNameServer.this.host);
            try {
                deliverer = new cMsgMessageDeliverer();
            }
            catch (IOException e) {
                cMsgException ex = new cMsgException("socket communication error");
                ex.setReturnCode(11);
                throw ex;
            }
            this.info.setDeliverer(deliverer);
            subdomainHandler.registerServer(this.info);
            cMsgDomainServerSelect dsServer = new cMsgDomainServerSelect(cMsgNameServer.this, 1, cMsgNameServer.this.debug, true);
            cMsgNameServer.this.connectionHandler.allowConnections(this.info);
            this.replyToServerClient();
            if (!cMsgNameServer.this.connectionHandler.gotConnections(this.info, 120)) {
                throw new cMsgException("server client did not make connections to domain server");
            }
            dsServer.setDaemon(true);
            dsServer.startThreads();
            dsServer.addClient(this.info);
            cMsgNameServer.this.domainServersSelect.put(dsServer, "");
            cMsgNameServer.this.monitorHandler.addClient(this.info, dsServer);
        }

        private void handleRegularClient() throws IOException {
            InetSocketAddress add = (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
            this.regime = this.in.readInt();
            int lengthPassword = this.in.readInt();
            int lengthDomainType = this.in.readInt();
            int lengthSubdomainType = this.in.readInt();
            int lengthUDLRemainder = this.in.readInt();
            int lengthHost = this.in.readInt();
            int lengthName = this.in.readInt();
            int lengthUDL = this.in.readInt();
            int lengthDescription = this.in.readInt();
            int bytesToRead = lengthPassword + lengthDomainType + lengthSubdomainType + lengthUDLRemainder + lengthHost + lengthName + lengthUDL + lengthDescription;
            int offset = 0;
            byte[] bytes = new byte[bytesToRead];
            this.in.readFully(bytes, 0, bytesToRead);
            String password = new String(bytes, offset, lengthPassword, "US-ASCII");
            offset += lengthPassword;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println("  password = " + password);
            }
            String domainType = new String(bytes, offset, lengthDomainType, "US-ASCII");
            offset += lengthDomainType;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println("  domain = " + domainType);
            }
            String subdomainType = new String(bytes, offset, lengthSubdomainType, "US-ASCII");
            offset += lengthSubdomainType;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println("  subdomain = " + subdomainType);
            }
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println("  server port = " + cMsgNameServer.this.port);
            }
            String UDLRemainder = new String(bytes, offset, lengthUDLRemainder, "US-ASCII");
            offset += lengthUDLRemainder;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println("  remainder = " + UDLRemainder);
            }
            String host = new String(bytes, offset, lengthHost, "US-ASCII");
            offset += lengthHost;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println("  host = " + host);
            }
            String name = new String(bytes, offset, lengthName, "US-ASCII");
            offset += lengthName;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println("  name = " + name);
            }
            String UDL = new String(bytes, offset, lengthUDL, "US-ASCII");
            offset += lengthUDL;
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println("  UDL = " + UDL);
            }
            String description = new String(bytes, offset, lengthDescription, "US-ASCII");
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println("  description = " + description);
            }
            if (!domainType.equalsIgnoreCase(this.domain)) {
                this.out.writeInt(20);
                String s = "this server implements " + this.domain + " domain";
                this.out.writeInt(s.length());
                try {
                    this.out.write(s.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.out.flush();
                return;
            }
            if (cMsgNameServer.this.clientPassword != null) {
                if (cMsgNameServer.this.debug >= 4) {
                    System.out.println("  local password = " + cMsgNameServer.this.clientPassword);
                    System.out.println("  given password = " + password);
                }
                if (password.length() < 1 || !cMsgNameServer.this.clientPassword.equals(password)) {
                    if (cMsgNameServer.this.debug >= 2) {
                        System.out.println("  wrong password sent");
                    }
                    this.out.writeInt(23);
                    String s = "wrong password given";
                    this.out.writeInt(s.length());
                    try {
                        this.out.write(s.getBytes("US-ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.out.flush();
                    return;
                }
            } else {
                if (cMsgNameServer.this.debug >= 4) {
                    System.out.println("  local password = <null>");
                    System.out.println("  given password = " + password);
                }
                if (password.length() > 0) {
                    if (cMsgNameServer.this.debug >= 2) {
                        System.out.println("  no password can be used with this server");
                    }
                    this.out.writeInt(23);
                    String s = "no password can be used with this server";
                    this.out.writeInt(s.length());
                    try {
                        this.out.write(s.getBytes("US-ASCII"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.out.flush();
                    return;
                }
            }
            int uniqueKey = cMsgNameServer.this.connectionHandler.getUniqueKey();
            this.info = new cMsgClientData(name, cMsgNameServer.this.port, domainServerPort, host, add.getAddress().getHostAddress(), subdomainType, UDLRemainder, UDL, description, uniqueKey);
            if (cMsgNameServer.this.debug >= 4) {
                System.out.println(">> NS: name server try to register " + name);
            }
            try {
                this.registerClient();
            }
            catch (cMsgException ex) {
                ex.printStackTrace();
                this.out.writeInt(ex.getReturnCode());
                this.out.writeInt(ex.getMessage().length());
                try {
                    this.out.write(ex.getMessage().getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerClient() throws cMsgException, IOException {
            cMsgDomainServerSelect ds;
            cMsgMessageDeliverer deliverer;
            cMsgSubdomainInterface subdomainHandler = cMsgNameServer.createClientHandler(this.info.getSubdomain());
            subdomainHandler.setUDLRemainder(this.info.getUDLremainder());
            this.info.subdomainHandler = subdomainHandler;
            this.info.setDomainHost(cMsgNameServer.this.host);
            try {
                deliverer = new cMsgMessageDeliverer();
            }
            catch (IOException e) {
                cMsgException ex = new cMsgException("socket communication error");
                ex.setReturnCode(11);
                throw ex;
            }
            this.info.setDeliverer(deliverer);
            if (subdomainHandler instanceof cMsg) {
                try {
                    if (!cMsgNameServer.this.allowConnectionsCloudSignal.await(5L, TimeUnit.SECONDS)) {
                        cMsgException ex = new cMsgException("nameserver not in server cloud - timeout error");
                        ex.setReturnCode(2);
                        throw ex;
                    }
                }
                catch (InterruptedException e) {
                    cMsgException ex = new cMsgException("interrupted while waiting for name server to join server cloud");
                    ex.setReturnCode(1);
                    throw ex;
                }
                this.info.cMsgSubdomainHandler = (cMsg)subdomainHandler;
                this.cMsgSubdomainRegistration(this.info.cMsgSubdomainHandler);
            } else {
                subdomainHandler.registerClient(this.info);
            }
            int dsLimit = 20;
            List<cMsgDomainServerSelect> list = cMsgNameServer.this.availableDomainServers;
            synchronized (list) {
                if (cMsgNameServer.this.availableDomainServers.size() > 0) {
                    ListIterator<cMsgDomainServerSelect> it = cMsgNameServer.this.availableDomainServers.listIterator();
                    while (it.hasNext()) {
                        ds = it.next();
                        if (!ds.isAlive()) {
                            it.remove();
                            ds.shutdown();
                            continue;
                        }
                        if (ds.numberOfClients() >= 1 || dsLimit-- > 0) continue;
                        it.remove();
                        ds.shutdown();
                    }
                }
            }
            cMsgDomainServer dServer = null;
            cMsgDomainServerSelect dsServer = null;
            if (this.regime == 1) {
                List<cMsgDomainServerSelect> list2 = cMsgNameServer.this.availableDomainServers;
                synchronized (list2) {
                    if (cMsgNameServer.this.availableDomainServers.size() > 0) {
                        ListIterator<cMsgDomainServerSelect> it = cMsgNameServer.this.availableDomainServers.listIterator();
                        while (it.hasNext()) {
                            ds = it.next();
                            if (ds.numberOfClients() >= cMsgNameServer.this.clientsMax || !ds.isAlive()) continue;
                            dsServer = ds;
                            ds.setClientsMax(cMsgNameServer.this.clientsMax);
                            it.remove();
                            break;
                        }
                    }
                }
                if (dsServer == null) {
                    dsServer = new cMsgDomainServerSelect(cMsgNameServer.this, cMsgNameServer.this.clientsMax, cMsgNameServer.this.debug, false);
                }
                this.info.setDomainUdpPort(dsServer.getUdpPort());
            } else if (this.regime == 0) {
                List<cMsgDomainServerSelect> list3 = cMsgNameServer.this.availableDomainServers;
                synchronized (list3) {
                    if (cMsgNameServer.this.availableDomainServers.size() > 0) {
                        ListIterator<cMsgDomainServerSelect> it = cMsgNameServer.this.availableDomainServers.listIterator();
                        while (it.hasNext()) {
                            ds = it.next();
                            if (ds.numberOfClients() >= 1 || !ds.isAlive()) continue;
                            dsServer = ds;
                            ds.setClientsMax(1);
                            it.remove();
                            break;
                        }
                    }
                }
                if (dsServer == null) {
                    dsServer = new cMsgDomainServerSelect(cMsgNameServer.this, 1, cMsgNameServer.this.debug, false);
                }
                this.info.setDomainUdpPort(dsServer.getUdpPort());
            } else {
                dServer = new cMsgDomainServer(cMsgNameServer.this, this.info, false, cMsgNameServer.this.debug);
            }
            cMsgNameServer.this.connectionHandler.allowConnections(this.info);
            this.sendClientConnectionInfo(this.info, subdomainHandler);
            if (!cMsgNameServer.this.connectionHandler.gotConnections(this.info, 120)) {
                subdomainHandler.handleClientShutdown();
                deliverer.close();
                throw new cMsgException("client did not make connections to domain server");
            }
            if (this.regime != 2) {
                if (!dsServer.isAlive()) {
                    dsServer.setDaemon(true);
                    dsServer.addClient(this.info);
                    dsServer.startThreads();
                    cMsgNameServer.this.domainServersSelect.put(dsServer, "");
                } else {
                    dsServer.addClient(this.info);
                }
                cMsgNameServer.this.monitorHandler.addClient(this.info, dsServer);
            } else {
                dServer.setDaemon(true);
                dServer.startThreads();
                cMsgNameServer.this.domainServers.put(dServer, "");
                cMsgNameServer.this.monitorHandler.addClient(this.info, dServer);
            }
        }

        private void sendClientConnectionInfo(cMsgClientData cd, cMsgSubdomainInterface handler) throws IOException {
            this.out.writeInt(0);
            byte[] atts = new byte[]{handler.hasSend() ? (byte)1 : 0, handler.hasSyncSend() ? (byte)1 : 0, handler.hasSubscribeAndGet() ? (byte)1 : 0, handler.hasSendAndGet() ? (byte)1 : 0, handler.hasSubscribe() ? (byte)1 : 0, handler.hasUnsubscribe() ? (byte)1 : 0, handler.hasShutdown() ? (byte)1 : 0};
            this.out.write(atts);
            this.out.writeInt(cd.clientKey);
            this.out.writeInt(this.info.getDomainPort());
            this.out.writeInt(this.info.getDomainUdpPort());
            this.out.writeInt(this.info.getDomainHost().length());
            try {
                this.out.write(this.info.getDomainHost().getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cMsgSubdomainRegistration(cMsg subdomainHandler) throws cMsgException, IOException {
            if (cMsgNameServer.this.bridges.size() < 1) {
                subdomainHandler.registerClient(this.info);
                return;
            }
            boolean gotCloudLock = false;
            boolean gotRegistrationLock = false;
            boolean registrationSuccessful = false;
            ArrayList<cMsgServerBridge> lockedServers = new ArrayList<cMsgServerBridge>();
            int maxNumberOfTrys = 6;
            int numberOfTrys = 0;
            Random random = new Random(System.currentTimeMillis());
            int startingDelay = 150;
            block20: while (numberOfTrys++ < maxNumberOfTrys) {
                block42: {
                    int delay;
                    lockedServers.clear();
                    startingDelay = numberOfTrys * startingDelay;
                    int grabLockTries = 0;
                    do {
                        if (!gotCloudLock && cMsgNameServer.this.cloudLock(10)) {
                            gotCloudLock = true;
                        }
                        if (!gotRegistrationLock) {
                            if (cMsg.registrationLock(10)) {
                                gotRegistrationLock = true;
                            }
                        }
                        if (gotCloudLock && gotRegistrationLock) continue;
                        if (++grabLockTries > 5) {
                            if (cMsgNameServer.this.debug >= 3) {
                                System.out.println("    << JR: Failed to grab inital cloud or registration lock");
                            }
                            if (gotCloudLock) {
                                cMsgNameServer.this.cloudUnlock();
                                gotCloudLock = false;
                            }
                            if (gotRegistrationLock) {
                                subdomainHandler.registrationUnlock();
                                gotRegistrationLock = false;
                            }
                            delay = startingDelay + (int)(150.0 * random.nextDouble());
                            try {
                                Thread.sleep(delay);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue block20;
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!gotCloudLock || !gotRegistrationLock);
                    int totalCloudMembers = 1;
                    for (cMsgServerBridge b : cMsgNameServer.this.bridges.values()) {
                        if (b.getCloudStatus() != 0) continue;
                        ++totalCloudMembers;
                    }
                    int majority = totalCloudMembers / 2 + 1;
                    int numberOfLockedCloudMembers = 1;
                    while (true) {
                        for (cMsgServerBridge cMsgServerBridge2 : cMsgNameServer.this.bridges.values()) {
                            if (lockedServers.contains(cMsgServerBridge2) || cMsgServerBridge2.getCloudStatus() != 0) continue;
                            try {
                                if (!cMsgServerBridge2.registrationLock(10)) continue;
                                lockedServers.add(cMsgServerBridge2);
                                ++numberOfLockedCloudMembers;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (numberOfLockedCloudMembers >= totalCloudMembers) break block42;
                        if (numberOfLockedCloudMembers < majority) break;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    for (cMsgServerBridge cMsgServerBridge3 : lockedServers) {
                        try {
                            cMsgServerBridge3.registrationUnlock();
                        }
                        catch (IOException e) {}
                    }
                    subdomainHandler.registrationUnlock();
                    cMsgNameServer.this.cloudUnlock();
                    gotCloudLock = false;
                    gotRegistrationLock = false;
                    delay = startingDelay + (int)(150.0 * random.nextDouble());
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    for (cMsgServerBridge bridge : cMsgNameServer.this.bridges.values()) {
                        String[] nameList = bridge.getClientNamesAndNamespaces();
                        for (int i = 0; i < nameList.length; i += 2) {
                            String name = nameList[i];
                            String ns = nameList[i + 1];
                            if (!name.equals(this.info.getName()) || !ns.equals(subdomainHandler.getNamespace())) continue;
                            cMsgException e = new cMsgException("client already exists");
                            e.setReturnCode(7);
                            throw e;
                        }
                    }
                    subdomainHandler.registerClient(this.info);
                }
                catch (Throwable throwable) {
                    for (cMsgServerBridge b : lockedServers) {
                        try {
                            b.registrationUnlock();
                        }
                        catch (IOException iOException) {}
                    }
                    subdomainHandler.registrationUnlock();
                    cMsgNameServer.this.cloudUnlock();
                    throw throwable;
                }
                for (cMsgServerBridge cMsgServerBridge4 : lockedServers) {
                    try {
                        cMsgServerBridge4.registrationUnlock();
                    }
                    catch (IOException iOException) {}
                }
                subdomainHandler.registrationUnlock();
                cMsgNameServer.this.cloudUnlock();
                registrationSuccessful = true;
                break;
            }
            if (!registrationSuccessful) {
                for (cMsgServerBridge b : lockedServers) {
                    try {
                        b.registrationUnlock();
                    }
                    catch (IOException iOException) {}
                }
                if (gotRegistrationLock) {
                    subdomainHandler.registrationUnlock();
                }
                if (gotCloudLock) {
                    cMsgNameServer.this.cloudUnlock();
                }
                System.out.println(">> NS: **********************************************************************");
                System.out.println(">> NS: Cannot register the specified client, since cannot grab required locks");
                System.out.println(">> NS: **********************************************************************");
                cMsgException e = new cMsgException("cannot grab required locks");
                e.setReturnCode(1);
                throw e;
            }
        }
    }
}

