/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class cMsgStartEt {
    String file;
    String cmd = "et_start -f /tmp/test -n 6 -s 32 -g 2";
    boolean debug;

    cMsgStartEt(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgStartEt.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                this.cmd = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.debug = true;
                continue;
            }
            cMsgStartEt.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgStartEt\n        [-c <et cmd>]       command to start et system\n        [-d]                turn on debug printout\n        [-h]                print this help\n");
    }

    public static void main(String[] args) {
        cMsgStartEt prog = new cMsgStartEt(args);
        prog.run();
    }

    private String getProcessOutput(InputStream inputStream) {
        StringBuilder sb = new StringBuilder(300);
        BufferedReader brErr = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = brErr.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    private String[] gatherAllOutput(Process process, boolean monitor) {
        String output;
        String[] strs = new String[2];
        if (monitor && (output = this.getProcessOutput(process.getInputStream())) != null) {
            strs[0] = output;
        }
        if ((output = this.getProcessOutput(process.getErrorStream())) != null) {
            strs[1] = output;
        }
        return strs;
    }

    public void run() {
        try {
            System.out.println("    DataTransport Et: create ET system with cmd:\n" + this.cmd);
            Process processET = Runtime.getRuntime().exec(this.cmd);
            Thread.yield();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean terminated = true;
            try {
                processET.exitValue();
            }
            catch (IllegalThreadStateException e) {
                terminated = false;
            }
            if (terminated) {
                String errorOut = null;
                String[] retStrings = this.gatherAllOutput(processET, true);
                if (retStrings[0] != null) {
                    errorOut = errorOut + retStrings[0];
                }
                if (retStrings[1] != null) {
                    errorOut = errorOut + "\n" + retStrings[0];
                }
                System.out.println("    Et system terminated so exit: " + errorOut);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

