/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.RCDomain;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.jlab.coda.cMsg.RCDomain.RunControl;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubscription;

class rcListeningThread
extends Thread {
    private String domainType = "rc";
    private RunControl client;
    private ServerSocketChannel serverChannel;
    private int debug;
    private ArrayList<ClientHandler> handlerThreads;
    private volatile boolean connected;
    private volatile boolean killThread;

    public void killThread() {
        this.killThread = true;
    }

    public rcListeningThread(RunControl myClient, ServerSocketChannel channel) {
        this.client = myClient;
        this.serverChannel = channel;
        this.debug = this.client.getDebug();
        this.handlerThreads = new ArrayList(2);
        this.setDaemon(true);
        this.setName("rc client listener");
    }

    void killClientHandlerThreads() {
        for (ClientHandler h : this.handlerThreads) {
            h.interrupt();
            try {
                h.channel.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block43: {
            if (this.debug >= 4) {
                System.out.println("Running RC Client Listening Thread");
            }
            selector = null;
            try {
                selector = Selector.open();
                this.serverChannel.configureBlocking(false);
                this.serverChannel.register(selector, 16);
                BYTES_TO_READ = 12;
                buffer = ByteBuffer.allocateDirect(BYTES_TO_READ);
                var4_7 = this;
                synchronized (var4_7) {
                    this.notifyAll();
                }
lbl15:
                // 2 sources

                while (true) {
                    if ((n = selector.select(2000L)) == 0) {
                        if (!this.killThread) continue;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (IOException ex) {
                if (this.debug >= 2) {
                    ex.printStackTrace();
                }
                try {
                    this.serverChannel.close();
                }
                catch (IOException var2_4) {
                    // empty catch block
                }
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (IOException var2_5) {
                    // empty catch block
                }
                this.killClientHandlerThreads();
                break block43;
            }
            catch (Throwable var15_25) {
                try {
                    this.serverChannel.close();
                }
                catch (IOException var16_26) {
                    // empty catch block
                }
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (IOException var16_27) {
                    // empty catch block
                }
                this.killClientHandlerThreads();
                throw var15_25;
            }
            try {
                this.serverChannel.close();
            }
            catch (IOException var5_10) {
                // empty catch block
            }
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (IOException var5_11) {
                // empty catch block
            }
            this.killClientHandlerThreads();
            return;
lbl-1000:
            // 1 sources

            {
                if (!this.killThread) ** GOTO lbl-1000
            }
            try {
                this.serverChannel.close();
            }
            catch (IOException var5_12) {
                // empty catch block
            }
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (IOException var5_13) {
                // empty catch block
            }
            this.killClientHandlerThreads();
            return;
lbl-1000:
            // 1 sources

            {
                it = selector.selectedKeys().iterator();
                block27: while (true) {
                    if (it.hasNext()) ** break;
                    ** continue;
                    key = it.next();
                    if (key.isValid() && key.isAcceptable()) {
                        if (this.connected) {
                            System.out.println("rcListening thd: connection to rc client already established, ignoring attempt");
                            server = (ServerSocketChannel)key.channel();
                            channel = server.accept();
                            channel.close();
                            it.remove();
                            continue;
                        }
                        server = (ServerSocketChannel)key.channel();
                        channel = server.accept();
                        bytesRead = 0;
                        loops = 0;
                        buffer.clear();
                        buffer.limit(BYTES_TO_READ);
                        channel.configureBlocking(false);
                        while (bytesRead < BYTES_TO_READ) {
                            bytes = channel.read(buffer);
                            if (bytes == -1) {
                                it.remove();
                                continue block27;
                            }
                            if ((bytesRead += bytes) >= BYTES_TO_READ) {
                                buffer.flip();
                                magic1 = buffer.getInt();
                                magic2 = buffer.getInt();
                                magic3 = buffer.getInt();
                                if (magic1 == cMsgNetworkConstants.magicNumbers[0] && magic2 == cMsgNetworkConstants.magicNumbers[1] && magic3 == cMsgNetworkConstants.magicNumbers[2]) continue;
                                it.remove();
                                continue block27;
                            }
                            if (++loops > 20) {
                                it.remove();
                                continue block27;
                            }
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException magic1) {}
                        }
                        channel.configureBlocking(true);
                        socket = channel.socket();
                        socket.setTcpNoDelay(true);
                        socket.setReceiveBufferSize(65535);
                        socket.setSendBufferSize(65535);
                        this.handlerThreads.add(new ClientHandler(channel));
                        this.connected = true;
                        if (this.debug >= 4) {
                            System.out.println("rcClientListeningThread: new connection");
                        }
                    }
                    it.remove();
                }
            }
        }
        if (this.debug >= 4) {
            System.out.println("Quitting RC Client Listening Thread");
        }
    }

    private class ClientHandler
    extends Thread {
        SocketChannel channel;
        private DataInputStream in;
        private DataOutputStream out;
        private byte[] bytes = new byte[65536];
        private boolean acknowledge;

        ClientHandler(SocketChannel channel) {
            this.channel = channel;
            this.setDaemon(true);
            this.setName("rc client handler");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.in = new DataInputStream(new BufferedInputStream(this.channel.socket().getInputStream(), 65536));
                this.out = new DataOutputStream(new BufferedOutputStream(this.channel.socket().getOutputStream(), 2048));
                block32: while (true) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    int size = this.in.readInt();
                    int msgId = this.in.readInt();
                    switch (msgId) {
                        case 21: {
                            cMsgMessageFull msg = this.readIncomingMessage();
                            if (this.acknowledge) {
                                this.out.writeInt(0);
                                this.out.flush();
                            }
                            this.runCallbacks(msg);
                            continue block32;
                        }
                        case 6: {
                            this.out.writeInt(1);
                            this.out.flush();
                            continue block32;
                        }
                        case 24: {
                            ((rcListeningThread)rcListeningThread.this).client.abandonConnection = true;
                            ((rcListeningThread)rcListeningThread.this).client.connectCompletion.countDown();
                            continue block32;
                        }
                        case 23: {
                            cMsgMessageFull msg = this.readIncomingMessage();
                            ((rcListeningThread)rcListeningThread.this).client.rcServerAddress = InetAddress.getByName(msg.getSenderHost());
                            cMsgPayloadItem pItem = msg.getPayloadItem("serverIp");
                            if (pItem != null) {
                                try {
                                    String serverIp = pItem.getString();
                                    ((rcListeningThread)rcListeningThread.this).client.rcServerAddress = InetAddress.getByName(serverIp);
                                }
                                catch (cMsgException cMsgException2) {
                                    // empty catch block
                                }
                            }
                            ((rcListeningThread)rcListeningThread.this).client.rcUdpServerPort = Integer.parseInt(msg.getText());
                            ((rcListeningThread)rcListeningThread.this).client.rcTcpServerPort = msg.getUserInt();
                            if (rcListeningThread.this.client.isConnected()) {
                                ((rcListeningThread)rcListeningThread.this).client.tcpSocket = new Socket(((rcListeningThread)rcListeningThread.this).client.rcServerAddress, ((rcListeningThread)rcListeningThread.this).client.rcTcpServerPort);
                                ((rcListeningThread)rcListeningThread.this).client.tcpSocket.setTcpNoDelay(true);
                                ((rcListeningThread)rcListeningThread.this).client.tcpSocket.setSendBufferSize(65535);
                                ((rcListeningThread)rcListeningThread.this).client.domainOut = new DataOutputStream(new BufferedOutputStream(((rcListeningThread)rcListeningThread.this).client.tcpSocket.getOutputStream(), 65536));
                                System.out.println("rcClient listen thd: made tcp reconnect to host " + ((rcListeningThread)rcListeningThread.this).client.rcServerAddress + ", port " + ((rcListeningThread)rcListeningThread.this).client.rcTcpServerPort);
                                continue block32;
                            }
                            ((rcListeningThread)rcListeningThread.this).client.connectCompletion.countDown();
                            continue block32;
                        }
                    }
                    if (rcListeningThread.this.debug < 3) continue;
                    System.out.println("handleClient: can't understand server message = " + msgId);
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                if (rcListeningThread.this.debug < 2) return;
                System.out.println("handleClient: I/O ERROR in RC client");
                return;
            }
            finally {
                rcListeningThread.this.handlerThreads.remove(this);
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
                try {
                    this.channel.close();
                }
                catch (IOException iOException) {}
                rcListeningThread.this.connected = false;
            }
        }

        private cMsgMessageFull readIncomingMessage() throws IOException {
            cMsgMessageFull msg = new cMsgMessageFull();
            msg.setVersion(this.in.readInt());
            this.in.skipBytes(4);
            msg.setUserInt(this.in.readInt());
            msg.setInfo(this.in.readInt());
            msg.setInfo(msg.getInfo() | 0x10 | 0x40);
            long time = (long)this.in.readInt() << 32 | (long)this.in.readInt() & 0xFFFFFFFFL;
            msg.setSenderTime(new Date(time));
            time = (long)this.in.readInt() << 32 | (long)this.in.readInt() & 0xFFFFFFFFL;
            msg.setUserTime(new Date(time));
            msg.setSysMsgId(this.in.readInt());
            msg.setSenderToken(this.in.readInt());
            int lengthSender = this.in.readInt();
            int lengthSenderHost = this.in.readInt();
            int lengthSubject = this.in.readInt();
            int lengthType = this.in.readInt();
            int lengthPayloadText = this.in.readInt();
            int lengthText = this.in.readInt();
            int lengthBinary = this.in.readInt();
            int stringBytesToRead = lengthSender + lengthSenderHost + lengthSubject + lengthType + lengthPayloadText + lengthText;
            int offset = 0;
            if (stringBytesToRead > this.bytes.length) {
                if (stringBytesToRead > 20000000 || stringBytesToRead < 1) {
                    System.out.println("readIncomingMessage: WARNING: attempt reading strings+payload of msg = " + stringBytesToRead + " bytes");
                    System.out.println("     bytes: sender " + lengthSender + ", sender host " + lengthSenderHost + ", sub " + lengthSubject + ", type " + lengthType + ", text " + lengthText + ", payload " + lengthPayloadText);
                }
                this.bytes = new byte[stringBytesToRead];
            }
            this.in.readFully(this.bytes, 0, stringBytesToRead);
            msg.setSender(new String(this.bytes, offset, lengthSender, "US-ASCII"));
            msg.setSenderHost(new String(this.bytes, offset += lengthSender, lengthSenderHost, "US-ASCII"));
            msg.setSubject(new String(this.bytes, offset += lengthSenderHost, lengthSubject, "US-ASCII"));
            msg.setType(new String(this.bytes, offset += lengthSubject, lengthType, "US-ASCII"));
            offset += lengthType;
            if (lengthPayloadText > 0) {
                String s = new String(this.bytes, offset, lengthPayloadText, "US-ASCII");
                offset += lengthPayloadText;
                try {
                    msg.setFieldsFromText(s, 2);
                }
                catch (cMsgException e) {
                    System.out.println("msg payload is in the wrong format: " + e.getMessage());
                }
            }
            if (lengthText > 0) {
                msg.setText(new String(this.bytes, offset, lengthText, "US-ASCII"));
                offset += lengthText;
            }
            if (lengthBinary > 0) {
                byte[] b = new byte[lengthBinary];
                this.in.readFully(b, 0, lengthBinary);
                try {
                    msg.setByteArrayNoCopy(b, 0, lengthBinary);
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
            msg.setDomain(rcListeningThread.this.domainType);
            msg.setReceiver(rcListeningThread.this.client.getName());
            msg.setReceiverHost(rcListeningThread.this.client.getHost());
            msg.setReceiverTime(new Date());
            return msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runCallbacks(cMsgMessageFull msg) {
            Set<cMsgSubscription> set = ((rcListeningThread)rcListeningThread.this).client.subscriptions;
            if (set.size() > 0) {
                if (!rcListeningThread.this.client.isReceiving()) {
                    if (rcListeningThread.this.debug >= 4) {
                        System.out.println("runCallbacks: all subscription callbacks have been stopped");
                    }
                    return;
                }
                Set<cMsgSubscription> set2 = set;
                synchronized (set2) {
                    for (cMsgSubscription sub : set) {
                        if (!sub.matches(msg.getSubject(), msg.getType())) continue;
                        for (cMsgCallbackThread cbThread : sub.getCallbacks()) {
                            cbThread.sendMessage(msg);
                        }
                    }
                }
            }
        }
    }
}

