/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;

public class regexpUDL {
    private String[] allowedSubdomains = new String[]{"LogFile", "CA", "Database", "Queue", "FileQueue", "SmartSockets", "TcpServer", "cMsg"};

    regexpUDL(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                regexpUDL.usage();
                System.exit(-1);
                continue;
            }
            regexpUDL.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java etTest\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            regexpUDL tp = new regexpUDL(args);
            tp.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        try {
            String udl = "cmsg:cmsg://host:23456/";
            String udlLowerCase = udl.toLowerCase();
            int index = udlLowerCase.indexOf("cmsg://");
            if (index < 0) {
                throw new cMsgException("invalid UDL");
            }
            String udlRemainder = udl.substring(index + 7);
            Pattern pattern = Pattern.compile("([^:/]+):?(\\d+)?/?(\\w+)?/?(.*)");
            Matcher matcher = pattern.matcher(udlRemainder);
            if (!matcher.find()) {
                throw new cMsgException("invalid UDL");
            }
            String udlHost = matcher.group(1);
            String udlPort = matcher.group(2);
            String udlSubdomain = matcher.group(3);
            String udlSubRemainder = matcher.group(4);
            System.out.println("\nparseUDL: \n  host      = " + udlHost + "\n  port      = " + udlPort + "\n  subdomain = " + udlSubdomain + "\n  remainder = " + udlSubRemainder);
            if (udlSubdomain == null) {
                udlSubdomain = "cMsg";
            } else {
                boolean foundSubD = false;
                for (String subDom : this.allowedSubdomains) {
                    if (!subDom.equalsIgnoreCase(udlSubdomain)) continue;
                    foundSubD = true;
                    System.out.println("Match");
                    break;
                }
                if (!foundSubD) {
                    if (udlSubRemainder == null || udlSubRemainder.length() < 1) {
                        udlSubRemainder = udlSubdomain;
                        System.out.println("NO Match 1, use cMsg & remainder = " + udlSubRemainder);
                    } else {
                        udlSubRemainder = udlSubdomain + "/" + udlSubRemainder;
                        System.out.println("NO Match 2, use cMsg & remainder = " + udlSubRemainder);
                    }
                    udlSubdomain = "cMsg";
                }
            }
            System.out.println("sub domain = " + udlSubdomain);
            Pattern pattern2 = Pattern.compile("^([\\w/]*)\\?*.*");
            Matcher matcher2 = pattern2.matcher(udlSubRemainder);
            if (!matcher2.lookingAt()) {
                throw new cMsgException("invalid namespace");
            }
            String s = matcher2.group(1);
            if (s == null) {
                throw new cMsgException("invalid namespace");
            }
            while (s.startsWith("/")) {
                s = s.substring(1);
            }
            while (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            String namespace = s.equals("") ? "/default" : "/" + s;
            System.out.println("namespace = " + namespace);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

