/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;

public class rcServerNetworkTest {
    private static void printNI(NetworkInterface ni) {
        System.out.println("\n\nInterface name = " + ni.getName());
        System.out.println("Interface display name = " + ni.getDisplayName());
        int counter = 1;
        List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
        for (InterfaceAddress ifAddr : inAddrs) {
            System.out.println("\n  interface address #" + counter++ + ":");
            InetAddress addr = ifAddr.getAddress();
            System.out.println("    host address = " + addr.getHostAddress());
            System.out.println("    canonical host name = " + addr.getCanonicalHostName());
            System.out.println("    host name = " + addr.getHostName());
            System.out.println("    toString() = " + addr.toString());
            InetAddress baddr = ifAddr.getBroadcast();
            if (baddr == null) continue;
            System.out.println("    broadcast addr = " + baddr.getHostAddress());
        }
    }

    public static void main(String[] args) {
        try {
            NetworkInterface ni;
            Enumeration<NetworkInterface> enumer;
            int udpPort = 45200;
            System.out.println("Rc multicast server listens on port " + udpPort + " and address " + "239.210.0.0");
            String host = null;
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                try {
                    host = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            System.out.println("\nPacket sent from rc multicast server to rc client has server host = " + host);
            System.out.println("  (but that is NOT used by the rc client).");
            System.out.println("\nPacket sent from rc server to rc client has server host (canonical) = " + InetAddress.getLocalHost().getCanonicalHostName());
            System.out.println("  send list of IP addresses:");
            try {
                enumer = NetworkInterface.getNetworkInterfaces();
                while (enumer.hasMoreElements()) {
                    ni = enumer.nextElement();
                    if (!ni.isUp() || ni.isLoopback()) continue;
                    List<InterfaceAddress> inAddrs = ni.getInterfaceAddresses();
                    for (InterfaceAddress ifAddr : inAddrs) {
                        InetAddress addr = ifAddr.getAddress();
                        byte[] b = addr.getAddress();
                        if (b.length != 4) continue;
                        System.out.println("    " + addr.getHostAddress());
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            System.out.println("Rc client uses IP addresses, in the given order, to connect to rc server");
            enumer = NetworkInterface.getNetworkInterfaces();
            while (enumer.hasMoreElements()) {
                ni = enumer.nextElement();
                if (!ni.isUp() || !ni.supportsMulticast() || ni.isLoopback()) continue;
                System.out.println("\nJoin multicast addr group of net interface w/ addrs: ");
                rcServerNetworkTest.printNI(ni);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

