/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;

public class UnsubTest {
    private String subject = "subject1";
    private String type = "type1";
    private String name = "unsubscribe tester";
    private String description = "java unsubscribe tester";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private int delay = 2000;
    private boolean debug;
    cMsg coda;

    UnsubTest(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                UnsubTest.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            UnsubTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java DoubleTest\n        [-n <name>]          set client name\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-d <time>]          set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            UnsubTest dtr = new UnsubTest(args);
            dtr.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running unsubscribe tester");
        }
        cMsgMessage msg = new cMsgMessage();
        msg.setSubject("subject1");
        msg.setType("type1");
        this.coda = new cMsg(this.UDL, this.name, this.description);
        this.coda.connect();
        this.coda.start();
        ReceivingCallback cb3 = new ReceivingCallback();
        cMsgSubscriptionHandle[] unsubHandles = new cMsgSubscriptionHandle[10];
        for (int i = 0; i < 10; ++i) {
            System.out.println("Subscribe " + (i + 1));
            unsubHandles[i] = this.coda.subscribe(this.subject, this.type, cb3, null);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println("Send msg");
        this.coda.send(msg);
        System.out.println("Wait 2 sec");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        for (int i = 0; i < 10; ++i) {
            System.out.println("Un subscribe " + (i + 1));
            this.coda.unsubscribe(unsubHandles[i]);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    class ReceivingCallback
    extends cMsgCallbackAdapter {
        ReceivingCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            System.out.println("Callback entering");
            try {
                Thread.sleep(8000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("Callback exiting");
        }
    }
}

