/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.remoteExec;

import java.util.LinkedList;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.remoteExec.ArgType;

public class ConstructorInfo {
    int numPrimitiveArgs;
    int numReferenceArgs;
    LinkedList<ConstructorArg> argList = new LinkedList();

    public synchronized void clearArgs() {
        this.argList.clear();
    }

    private boolean isPrimitive(String name) {
        if (name == null) {
            return false;
        }
        return name.equals("int") || name.equals("boolean") || name.equals("char") || name.equals("byte") || name.equals("short") || name.equals("long") || name.equals("float") || name.equals("double");
    }

    private ConstructorArg createPrimitiveArg(String name, String value) {
        ConstructorArg arg = new ConstructorArg();
        arg.isPrimitive = true;
        arg.className = name;
        arg.type = ArgType.PRIMITIVE;
        arg.strValue = value;
        ++this.numPrimitiveArgs;
        return arg;
    }

    public synchronized void addPrimitiveArg(String name, String value) throws cMsgException {
        if (!this.isPrimitive(name) || name.equals("char")) {
            throw new cMsgException("name must correspond to primitive type (not char)");
        }
        this.argList.add(this.createPrimitiveArg(name, value));
    }

    public synchronized void addPrimitiveArg(String name, String value, int index) throws cMsgException {
        if (!this.isPrimitive(name) || name.equals("char")) {
            throw new cMsgException("class must correspond to primitive type (not char)");
        }
        if (index > this.argList.size()) {
            this.argList.addLast(this.createPrimitiveArg(name, value));
        } else {
            this.argList.add(index, this.createPrimitiveArg(name, value));
        }
    }

    private ConstructorArg createPrimitiveCharArg(char value) {
        ConstructorArg arg = new ConstructorArg();
        arg.isPrimitive = true;
        arg.className = "char";
        arg.type = ArgType.PRIMITIVE;
        arg.charValue = value;
        ++this.numPrimitiveArgs;
        return arg;
    }

    public synchronized void addPrimitiveArg(char value) {
        this.argList.add(this.createPrimitiveCharArg(value));
    }

    public synchronized void addPrimitiveArg(char value, int index) {
        if (index > this.argList.size()) {
            this.argList.addLast(this.createPrimitiveCharArg(value));
        } else {
            this.argList.add(index, this.createPrimitiveCharArg(value));
        }
    }

    private ConstructorArg createRefArg(String className, ConstructorInfo info) {
        ConstructorArg arg = new ConstructorArg();
        arg.isPrimitive = false;
        arg.className = className;
        arg.info = info;
        if (info == null) {
            arg.type = ArgType.NULL;
            arg.info = null;
        } else {
            arg.type = ArgType.REFERENCE;
            ++this.numReferenceArgs;
        }
        return arg;
    }

    public synchronized void addReferenceArg(String className, ConstructorInfo info) throws cMsgException {
        if (className == null) {
            throw new cMsgException("className must NOT be null");
        }
        if (this.isPrimitive(className)) {
            throw new cMsgException("className must NOT correspond to primitive type");
        }
        this.argList.add(this.createRefArg(className, info));
    }

    public synchronized void addReferenceArg(String className, ConstructorInfo info, int index) throws cMsgException {
        if (className == null) {
            throw new cMsgException("className must NOT be null");
        }
        if (this.isPrimitive(className)) {
            throw new cMsgException("class must NOT correspond to primitive type");
        }
        if (index > this.argList.size()) {
            this.argList.addLast(this.createRefArg(className, info));
        } else {
            this.argList.add(index, this.createRefArg(className, info));
        }
    }

    public synchronized cMsgMessage createMessageFromArgs() {
        if (this.argList.size() < 1) {
            return null;
        }
        int numArgs = this.argList.size();
        for (ConstructorArg arg : this.argList) {
            if (arg.type != ArgType.REFERENCE || arg.info.argList.size() >= 1) continue;
            arg.type = ArgType.REFERENCE_NOARG;
            --this.numReferenceArgs;
        }
        cMsgMessage msg = new cMsgMessage();
        msg.setUserInt(numArgs);
        int[] argTypes = new int[numArgs];
        String[] classes = new String[numArgs];
        String[] stringArgs = new String[this.numPrimitiveArgs];
        cMsgMessage[] msgArgs = new cMsgMessage[this.numReferenceArgs];
        int cIndex = 0;
        int sIndex = 0;
        int mIndex = 0;
        for (ConstructorArg arg : this.argList) {
            classes[cIndex] = arg.className;
            argTypes[cIndex] = arg.type.getValue();
            ++cIndex;
            if (arg.isPrimitive) {
                if (arg.strValue != null) {
                    stringArgs[sIndex++] = arg.strValue;
                    continue;
                }
                stringArgs[sIndex++] = "" + arg.charValue;
                continue;
            }
            if (arg.type != ArgType.REFERENCE) continue;
            msgArgs[mIndex++] = arg.info.createMessageFromArgs();
        }
        try {
            cMsgPayloadItem item = new cMsgPayloadItem("classes", classes);
            msg.addPayloadItem(item);
            item = new cMsgPayloadItem("argTypes", argTypes);
            msg.addPayloadItem(item);
            if (this.numPrimitiveArgs > 0) {
                item = new cMsgPayloadItem("stringArgs", stringArgs);
                msg.addPayloadItem(item);
            }
            if (this.numReferenceArgs > 0) {
                item = new cMsgPayloadItem("messageArgs", msgArgs);
                msg.addPayloadItem(item);
            }
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        return msg;
    }

    private class ConstructorArg {
        boolean isPrimitive;
        String className;
        ArgType type;
        String strValue;
        char charValue;
        ConstructorInfo info;

        private ConstructorArg() {
        }
    }
}

