/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.common;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgUtilities;

public class cMsgServerFinder {
    private HashSet<Integer> cmsgPorts;
    private HashSet<Integer> rcPorts;
    private final int[] defaultCmsgPorts;
    private final int[] defaultRcPorts;
    private String password = "";
    private HashSet<ResponderInfo> cMsgResponders;
    private HashSet<ResponderInfo> rcResponders;
    private int sleepTime = 3000;
    private volatile boolean needToUpdateRc = true;
    private volatile boolean needToUpdateCmsg = true;
    private int debug;

    public cMsgServerFinder() {
        this(0);
    }

    public cMsgServerFinder(int debug) {
        this.debug = debug;
        this.rcResponders = new HashSet();
        this.cMsgResponders = new HashSet();
        this.rcPorts = new HashSet();
        this.cmsgPorts = new HashSet();
        this.defaultRcPorts = new int[20];
        this.defaultCmsgPorts = new int[20];
        for (int i = 0; i < 20; ++i) {
            this.defaultRcPorts[i] = 45200 + i;
            this.defaultCmsgPorts[i] = 45000 + i;
        }
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime < 0 ? 3000 : sleepTime;
    }

    void setDebug(int debug) {
        if (debug != 2 && debug != 4 && debug != 0 && debug != 1 && debug != 3) {
            return;
        }
        this.debug = debug;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String password) {
        if (password == null ? this.password == null : this.password != null && this.password.equals(password)) {
            return;
        }
        this.password = password;
        this.needToUpdateCmsg = true;
    }

    public synchronized void addRcPort(int port) {
        if (port < 1024 || port > 65535) {
            return;
        }
        if (this.rcPorts.contains(port)) {
            return;
        }
        this.rcPorts.add(port);
        this.needToUpdateRc = true;
    }

    public synchronized void addRcPorts(Collection<Integer> col) {
        for (Integer port : col) {
            this.addRcPort(port);
        }
    }

    public synchronized void removeRcPort(int port) {
        this.rcPorts.remove(port);
    }

    public synchronized void removeRcPorts() {
        this.rcPorts.clear();
    }

    public synchronized void addCmsgPort(int port) {
        if (port < 1024 || port > 65535) {
            return;
        }
        if (this.cmsgPorts.contains(port)) {
            return;
        }
        this.cmsgPorts.add(port);
        this.needToUpdateCmsg = true;
    }

    public synchronized void addCmsgPorts(Collection<Integer> col) {
        for (Integer port : col) {
            this.addCmsgPort(port);
        }
    }

    public synchronized void removeCmsgPort(int port) {
        this.cmsgPorts.remove(port);
    }

    public synchronized void removeCmsgPorts() {
        this.cmsgPorts.clear();
    }

    public synchronized boolean needsUpdate() {
        return this.needToUpdateCmsg || this.needToUpdateRc;
    }

    public synchronized void findCmsgServers() {
        this.cMsgResponders.clear();
        cMsgFinder cFinder = new cMsgFinder();
        cFinder.start();
        try {
            Thread.sleep(this.sleepTime + 200);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.needToUpdateCmsg = false;
    }

    public synchronized void findRcServers() {
        this.rcResponders.clear();
        rcFinder rFinder = new rcFinder();
        rFinder.start();
        try {
            Thread.sleep(this.sleepTime + 200);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.needToUpdateRc = false;
    }

    public synchronized void find() {
        this.cMsgResponders.clear();
        cMsgFinder cFinder = new cMsgFinder();
        cFinder.start();
        this.rcResponders.clear();
        rcFinder rFinder = new rcFinder();
        rFinder.start();
        try {
            Thread.sleep(this.sleepTime + 200);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.needToUpdateRc = false;
        this.needToUpdateCmsg = false;
    }

    public synchronized void print() {
        if (this.cMsgResponders.size() > 0) {
            System.out.println("\ncMsg name servers:");
        }
        for (ResponderInfo info : this.cMsgResponders) {
            if (info.host == null) {
                info.host = "<unknown>";
            }
            System.out.println("host = " + info.host + ",  UDP port = " + info.udpPort + ",  TCP port = " + info.tcpPort + "\n  IP addresses:");
            for (String s : info.ipAddrs) {
                System.out.println("    " + s);
            }
        }
        if (this.rcResponders.size() > 0) {
            System.out.println("\nrc multicast servers:");
        }
        for (ResponderInfo info : this.rcResponders) {
            if (info.host == null) {
                info.host = "<unknown>";
            }
            System.out.println("host = " + info.host + ",  UDP port = " + info.udpPort + ",  expid = " + info.expid + "\n  IP addresses:");
            for (String s : info.ipAddrs) {
                System.out.println("    " + s);
            }
        }
        System.out.println();
    }

    public String toString() {
        return this.toXML(true, true);
    }

    public String getCmsgServersXML() {
        return this.toXML(false, true);
    }

    public String getRcServersXML() {
        return this.toXML(true, false);
    }

    private synchronized String toXML(boolean rc, boolean cmsg) {
        int i;
        String[] bcasts;
        String[] ips;
        StringBuilder buffer = new StringBuilder(1024);
        if (cmsg) {
            for (ResponderInfo info : this.cMsgResponders) {
                if (info.host == null) {
                    info.host = "unknown";
                }
                buffer.append("<cMsgNameServer");
                buffer.append("  host=\"");
                buffer.append(info.host);
                buffer.append("\"  udpPort=\"");
                buffer.append(info.udpPort);
                buffer.append("\"  tcpPort=\"");
                buffer.append(info.tcpPort);
                buffer.append("\" >\n");
                ips = info.ipAddrs;
                bcasts = info.broadcastAddrs;
                for (i = 0; i < ips.length; ++i) {
                    buffer.append("  <interface ip=\"");
                    buffer.append(ips[i]);
                    buffer.append("\" bcast=\"");
                    buffer.append(bcasts[i]);
                    buffer.append("\" />\n");
                }
                buffer.append("</cMsgNameServer>\n");
            }
        }
        if (rc) {
            for (ResponderInfo info : this.rcResponders) {
                if (info.host == null) {
                    info.host = "unknown";
                }
                buffer.append("<rcMulticastServer");
                buffer.append("  host=\"");
                buffer.append(info.host);
                buffer.append("\"  udpPort=\"");
                buffer.append(info.udpPort);
                buffer.append("\"  expid=\"");
                buffer.append(info.expid);
                buffer.append("\" >\n");
                ips = info.ipAddrs;
                bcasts = info.broadcastAddrs;
                for (i = 0; i < ips.length; ++i) {
                    buffer.append("  <interface ip=\"");
                    buffer.append(ips[i]);
                    buffer.append("\" bcast=\"");
                    buffer.append(bcasts[i]);
                    buffer.append("\" />\n");
                }
                buffer.append("</rcMulticastServer>\n");
            }
        }
        return buffer.toString();
    }

    public synchronized cMsgMessage[] getCmsgServers() {
        if (this.cMsgResponders.size() < 1) {
            return null;
        }
        int i = 0;
        cMsgMessage[] msgs = new cMsgMessage[this.cMsgResponders.size()];
        for (ResponderInfo info : this.cMsgResponders) {
            if (info.host == null) {
                info.host = "unknown";
            }
            cMsgMessage msg = new cMsgMessage();
            try {
                cMsgPayloadItem item1 = new cMsgPayloadItem("host", info.host);
                cMsgPayloadItem item2 = new cMsgPayloadItem("udpPort", info.udpPort);
                cMsgPayloadItem item3 = new cMsgPayloadItem("tcpPort", info.tcpPort);
                cMsgPayloadItem item4 = new cMsgPayloadItem("addresses", info.ipAddrs);
                cMsgPayloadItem item5 = new cMsgPayloadItem("bcastAddresses", info.broadcastAddrs);
                msg.addPayloadItem(item1);
                msg.addPayloadItem(item2);
                msg.addPayloadItem(item3);
                msg.addPayloadItem(item4);
                msg.addPayloadItem(item5);
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
            msgs[i++] = msg;
        }
        return msgs;
    }

    public synchronized cMsgMessage[] getRcServers() {
        if (this.rcResponders.size() < 1) {
            return null;
        }
        int i = 0;
        cMsgMessage[] msgs = new cMsgMessage[this.rcResponders.size()];
        for (ResponderInfo info : this.rcResponders) {
            if (info.host == null) {
                info.host = "unknown";
            }
            cMsgMessage msg = new cMsgMessage();
            try {
                cMsgPayloadItem item1 = new cMsgPayloadItem("host", info.host);
                cMsgPayloadItem item2 = new cMsgPayloadItem("udpPort", info.udpPort);
                cMsgPayloadItem item3 = new cMsgPayloadItem("expid", info.expid);
                cMsgPayloadItem item4 = new cMsgPayloadItem("addresses", info.ipAddrs);
                cMsgPayloadItem item5 = new cMsgPayloadItem("bcastAddresses", info.broadcastAddrs);
                msg.addPayloadItem(item1);
                msg.addPayloadItem(item2);
                msg.addPayloadItem(item3);
                msg.addPayloadItem(item4);
                msg.addPayloadItem(item5);
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
            msgs[i++] = msg;
        }
        return msgs;
    }

    class rcMulticaster
    extends Thread {
        byte[] buffer;
        MulticastSocket socket;

        rcMulticaster(byte[] buffer, MulticastSocket socket) {
            this.socket = socket;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName("239.210.0.0");
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            try {
                Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                while (enumer.hasMoreElements()) {
                    DatagramPacket packet;
                    NetworkInterface ni = enumer.nextElement();
                    if (!ni.isUp()) continue;
                    Iterator iterator = cMsgServerFinder.this.rcPorts.iterator();
                    while (iterator.hasNext()) {
                        int port = (Integer)iterator.next();
                        packet = new DatagramPacket(this.buffer, this.buffer.length, addr, port);
                        this.socket.setNetworkInterface(ni);
                        this.socket.send(packet);
                    }
                    for (Object port : (Iterator)cMsgServerFinder.this.defaultRcPorts) {
                        packet = new DatagramPacket(this.buffer, this.buffer.length, addr, (int)port);
                        this.socket.send(packet);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class rcMulticastReceiver
    extends Thread {
        DatagramSocket socket;

        rcMulticastReceiver(DatagramSocket socket) {
            this.socket = socket;
        }

        public void printBuffer(ByteBuffer buf, int position, int words, String label) {
            IntBuffer ibuf;
            if (buf == null) {
                System.out.println("printBuffer: buf arg is null");
                return;
            }
            int origPos = buf.position();
            buf.position(position);
            if (label != null) {
                System.out.println(label + ":");
            }
            words = words > (ibuf = buf.asIntBuffer()).capacity() ? ibuf.capacity() : words;
            for (int i = 0; i < words; ++i) {
                System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
            }
            System.out.println();
            buf.position(origPos);
        }

        @Override
        public void run() {
            byte[] buf = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buf, 1024);
            block11: while (true) {
                packet.setLength(1024);
                try {
                    this.socket.receive(packet);
                    if (packet.getLength() < 24) {
                        if (cMsgServerFinder.this.debug < 3) continue;
                        System.out.println("rcMulticastReceiver: got packet that's too small");
                        continue;
                    }
                    int magic1 = cMsgUtilities.bytesToInt(buf, 0);
                    int magic2 = cMsgUtilities.bytesToInt(buf, 4);
                    int magic3 = cMsgUtilities.bytesToInt(buf, 8);
                    if (magic1 != cMsgNetworkConstants.magicNumbers[0] || magic2 != cMsgNetworkConstants.magicNumbers[1] || magic3 != cMsgNetworkConstants.magicNumbers[2]) {
                        if (cMsgServerFinder.this.debug < 3) continue;
                        System.out.println("rcMulticastReceiver: got bad magic # response to multicast");
                        continue;
                    }
                    int version = cMsgUtilities.bytesToInt(buf, 12);
                    int port = cMsgUtilities.bytesToInt(buf, 16);
                    int hostLen = cMsgUtilities.bytesToInt(buf, 20);
                    int expidLen = cMsgUtilities.bytesToInt(buf, 24);
                    if (version != 6) continue;
                    ResponderInfo info = new ResponderInfo();
                    info.version = version;
                    info.udpPort = port;
                    int index = 28;
                    if (hostLen > 0) {
                        index += hostLen;
                    }
                    if (expidLen > 0) {
                        info.expid = new String(buf, index, expidLen, "US-ASCII");
                        index += expidLen;
                    } else {
                        info.expid = "expid";
                    }
                    int addrCount = cMsgUtilities.bytesToInt(buf, index);
                    index += 4;
                    info.ipAddrs = new String[addrCount];
                    info.broadcastAddrs = new String[addrCount];
                    for (int i = 0; i < addrCount; ++i) {
                        try {
                            String ss;
                            int stringLen = cMsgUtilities.bytesToInt(buf, index);
                            index += 4;
                            try {
                                ss = new String(buf, index, stringLen, "US-ASCII");
                            }
                            catch (Exception e) {
                                return;
                            }
                            info.ipAddrs[i] = ss;
                            index += stringLen;
                            if (info.host == null) {
                                try {
                                    info.host = InetAddress.getByName(ss).getCanonicalHostName();
                                }
                                catch (UnknownHostException e) {
                                    // empty catch block
                                }
                            }
                            stringLen = cMsgUtilities.bytesToInt(buf, index);
                            info.broadcastAddrs[i] = ss = new String(buf, index += 4, stringLen, "US-ASCII");
                            index += stringLen;
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                    }
                    if (info.host == null) {
                        info.host = "unknown";
                    }
                    for (ResponderInfo rInfo : cMsgServerFinder.this.rcResponders) {
                        if (!info.host.equals(rInfo.host) || info.udpPort != rInfo.udpPort) continue;
                        continue block11;
                    }
                    cMsgServerFinder.this.rcResponders.add(info);
                    continue;
                }
                catch (InterruptedIOException e) {
                    return;
                }
                catch (SocketException e) {
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    class rcFinder
    extends Thread {
        rcFinder() {
        }

        @Override
        public void run() {
            byte[] buffer;
            String name = "serverFinder";
            String myExpid = "expid";
            DatagramSocket socket = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(6);
                out.writeInt(16);
                out.writeInt(1);
                out.writeInt(0);
                out.writeInt(name.length());
                out.writeInt(myExpid.length());
                try {
                    out.write(name.getBytes("US-ASCII"));
                    out.write(myExpid.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                out.flush();
                out.close();
                socket = new MulticastSocket();
                int tries = 20;
                while (socket.getLocalPort() > 44999 && socket.getLocalPort() < 46200) {
                    socket = new MulticastSocket();
                    if (--tries >= 0) continue;
                }
                socket.setReceiveBufferSize(1024);
                socket.setSoTimeout(cMsgServerFinder.this.sleepTime);
                baos.close();
                buffer = baos.toByteArray();
            }
            catch (IOException e) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    baos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (socket != null) {
                    socket.close();
                }
                System.out.println("Cannot create rc multicast packet");
                return;
            }
            rcMulticastReceiver receiver = new rcMulticastReceiver(socket);
            receiver.start();
            rcMulticaster sender = new rcMulticaster(buffer, (MulticastSocket)socket);
            sender.start();
            try {
                Thread.sleep(cMsgServerFinder.this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            receiver.interrupt();
            socket.close();
        }
    }

    class cMsgMulticaster
    extends Thread {
        byte[] buffer;
        DatagramSocket socket;

        cMsgMulticaster(byte[] buffer, DatagramSocket socket) {
            this.socket = socket;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName("239.220.0.0");
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            try {
                DatagramPacket packet;
                Iterator e = cMsgServerFinder.this.cmsgPorts.iterator();
                while (e.hasNext()) {
                    int port = (Integer)e.next();
                    packet = new DatagramPacket(this.buffer, this.buffer.length, addr, port);
                    this.socket.send(packet);
                }
                for (Object port : (Iterator)cMsgServerFinder.this.defaultCmsgPorts) {
                    packet = new DatagramPacket(this.buffer, this.buffer.length, addr, (int)port);
                    this.socket.send(packet);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class cMsgMulticastReceiver
    extends Thread {
        DatagramSocket socket;

        cMsgMulticastReceiver(DatagramSocket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            StringBuilder id = new StringBuilder(1024);
            byte[] buf = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buf, 1024);
            while (true) {
                try {
                    block10: while (true) {
                        packet.setLength(1024);
                        this.socket.receive(packet);
                        if (packet.getLength() < 24) continue;
                        int magicInt1 = cMsgUtilities.bytesToInt(buf, 0);
                        int magicInt2 = cMsgUtilities.bytesToInt(buf, 4);
                        int magicInt3 = cMsgUtilities.bytesToInt(buf, 8);
                        if (magicInt1 != cMsgNetworkConstants.magicNumbers[0] || magicInt2 != cMsgNetworkConstants.magicNumbers[1] || magicInt3 != cMsgNetworkConstants.magicNumbers[2]) continue;
                        int nameServerTcpPort = cMsgUtilities.bytesToInt(buf, 12);
                        int nameServerUdpPort = cMsgUtilities.bytesToInt(buf, 16);
                        int addrCount = cMsgUtilities.bytesToInt(buf, 20);
                        if (nameServerTcpPort < 1024 || nameServerTcpPort > 65535 || addrCount < 0 || addrCount > 50) continue;
                        int pos = 24;
                        ResponderInfo info = new ResponderInfo();
                        info.ipAddrs = new String[addrCount];
                        info.broadcastAddrs = new String[addrCount];
                        for (int i = 0; i < addrCount; ++i) {
                            try {
                                String ss;
                                int stringLen = cMsgUtilities.bytesToInt(buf, pos);
                                info.ipAddrs[i] = ss = new String(buf, pos += 4, stringLen, "US-ASCII");
                                pos += stringLen;
                                if (info.host == null) {
                                    try {
                                        info.host = InetAddress.getByName(ss).getCanonicalHostName();
                                    }
                                    catch (UnknownHostException unknownHostException) {
                                        // empty catch block
                                    }
                                }
                                stringLen = cMsgUtilities.bytesToInt(buf, pos);
                                info.broadcastAddrs[i] = ss = new String(buf, pos += 4, stringLen, "US-ASCII");
                                pos += stringLen;
                                continue;
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                        if (info.host == null) {
                            info.host = "unknown";
                        }
                        info.udpPort = nameServerUdpPort;
                        info.tcpPort = nameServerTcpPort;
                        for (ResponderInfo rInfo : cMsgServerFinder.this.cMsgResponders) {
                            if (!info.host.equals(rInfo.host) || info.udpPort != rInfo.udpPort) continue;
                            continue block10;
                        }
                        cMsgServerFinder.this.cMsgResponders.add(info);
                    }
                }
                catch (InterruptedIOException e) {
                    return;
                }
                catch (SocketException e) {
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    class cMsgFinder
    extends Thread {
        cMsgFinder() {
        }

        @Override
        public void run() {
            byte[] buffer;
            DatagramSocket socket = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(6);
                out.writeInt(1);
                out.writeInt(cMsgServerFinder.this.password.length());
                try {
                    out.write(cMsgServerFinder.this.password.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                out.flush();
                out.close();
                socket = new DatagramSocket();
                int tries = 20;
                while (socket.getLocalPort() > 44999 && socket.getLocalPort() < 46200) {
                    socket = new DatagramSocket();
                    if (--tries >= 0) continue;
                }
                socket.setReceiveBufferSize(1024);
                socket.setSoTimeout(cMsgServerFinder.this.sleepTime);
                buffer = baos.toByteArray();
                baos.close();
            }
            catch (IOException e) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    baos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (socket != null) {
                    socket.close();
                }
                System.out.println("Cannot create cmsg multicast packet");
                return;
            }
            cMsgMulticastReceiver receiver = new cMsgMulticastReceiver(socket);
            receiver.start();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cMsgMulticaster sender = new cMsgMulticaster(buffer, socket);
            sender.start();
            try {
                Thread.sleep(cMsgServerFinder.this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            receiver.interrupt();
            socket.close();
        }
    }

    class ResponderInfo {
        int version;
        int tcpPort;
        int udpPort;
        String expid;
        String host;
        String[] ipAddrs;
        String[] broadcastAddrs;

        ResponderInfo() {
        }
    }
}

