/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgDeliverMessageInterface;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubdomainAdapter;

public class FileQueue
extends cMsgSubdomainAdapter {
    private static HashMap<String, Object> queueHashMap = new HashMap(100);
    private cMsgClientInfo myClientInfo;
    private String myUDLRemainder;
    private cMsgDeliverMessageInterface myDeliverer;
    private Object mySyncObject;
    private String myQueueNameFull = null;
    private String myDirectory = ".";
    private String myFileNameBase = null;
    private String myLoSeqFile = null;
    private String myHiSeqFile = null;

    @Override
    public boolean hasSend() {
        return true;
    }

    @Override
    public boolean hasSendAndGet() {
        return true;
    }

    @Override
    public boolean hasSyncSend() {
        return true;
    }

    @Override
    public void setUDLRemainder(String UDLRemainder) throws cMsgException {
        this.myUDLRemainder = UDLRemainder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void registerClient(cMsgClientInfo info) throws cMsgException {
        String myCanonicalDir;
        String myQueueName;
        Matcher m;
        Pattern p;
        String remainder = null;
        this.myClientInfo = info;
        this.myDeliverer = info.getDeliverer();
        if (this.myUDLRemainder.indexOf("?") > 0) {
            p = Pattern.compile("^(.+?)(\\?.*)$");
            m = p.matcher(this.myUDLRemainder);
            if (!m.find()) {
                cMsgException ce = new cMsgException("?illegal UDL");
                ce.setReturnCode(1);
                throw ce;
            }
            myQueueName = m.group(1);
            remainder = m.group(2) + "&";
        } else {
            myQueueName = this.myUDLRemainder;
        }
        if (remainder != null && (m = (p = Pattern.compile("[&\\?]dir=(.*?)&", 2)).matcher(remainder)).find()) {
            this.myDirectory = m.group(1);
        }
        try {
            myCanonicalDir = new File(this.myDirectory).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException("Unable to get directory canonical name for " + this.myDirectory);
            ce.setReturnCode(1);
            throw ce;
        }
        if (myCanonicalDir == null) {
            cMsgException ce = new cMsgException("?null canonical dir name for " + this.myDirectory);
            ce.setReturnCode(1);
            throw ce;
        }
        this.myQueueNameFull = myCanonicalDir + "/cMsgFileQueue_" + myQueueName;
        this.myFileNameBase = this.myQueueNameFull + "_";
        this.myHiSeqFile = this.myFileNameBase + "Hi";
        this.myLoSeqFile = this.myFileNameBase + "Lo";
        Object object = queueHashMap;
        synchronized (object) {
            if (!queueHashMap.containsKey(this.myQueueNameFull)) {
                queueHashMap.put(this.myQueueNameFull, new Object());
            }
        }
        object = this.mySyncObject = queueHashMap.get(this.myQueueNameFull);
        synchronized (object) {
            File hi = new File(this.myHiSeqFile);
            File lo = new File(this.myLoSeqFile);
            if (hi.exists()) {
                if (lo.exists()) return;
            }
            try {
                FileWriter h = new FileWriter(hi);
                h.write("0\n");
                h.close();
                FileWriter l = new FileWriter(lo);
                l.write("0\n");
                l.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                cMsgException ce = new cMsgException(e.toString());
                ce.setReturnCode(1);
                throw ce;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSendRequest(cMsgMessageFull msg) throws cMsgException {
        String creator = null;
        try {
            cMsgPayloadItem creatorItem = msg.getPayloadItem("cMsgCreator");
            if (creatorItem != null) {
                creator = creatorItem.getString();
            }
        }
        catch (cMsgException e) {
            System.err.println("?cMsgQueue...message has no creator!");
        }
        msg.compressPayload();
        Object object = this.mySyncObject;
        synchronized (object) {
            try {
                RandomAccessFile r = new RandomAccessFile(this.myHiSeqFile, "rw");
                FileChannel c = r.getChannel();
                FileLock l = c.lock();
                long hi = Long.parseLong(r.readLine());
                r.seek(0L);
                r.writeBytes(++hi + "\n");
                FileOutputStream fos = null;
                ObjectOutputStream oos = null;
                fos = new FileOutputStream(String.format("%s%08d", this.myFileNameBase, hi));
                oos = new ObjectOutputStream(fos);
                oos.writeObject(msg);
                oos.close();
                l.release();
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                cMsgException ce = new cMsgException(e.toString());
                ce.setReturnCode(1);
                throw ce;
            }
        }
    }

    @Override
    public int handleSyncSendRequest(cMsgMessageFull msg) throws cMsgException {
        try {
            this.handleSendRequest(msg);
            return 0;
        }
        catch (cMsgException e) {
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSendAndGetRequest(cMsgMessageFull message) throws cMsgException {
        cMsgMessageFull response = null;
        Object object = this.mySyncObject;
        synchronized (object) {
            try {
                RandomAccessFile rHi = new RandomAccessFile(this.myHiSeqFile, "rw");
                FileChannel cHi = rHi.getChannel();
                FileLock lHi = cHi.lock();
                RandomAccessFile rLo = new RandomAccessFile(this.myLoSeqFile, "rw");
                FileChannel cLo = rLo.getChannel();
                FileLock lLo = cLo.lock();
                long hi = Long.parseLong(rHi.readLine());
                long lo = Long.parseLong(rLo.readLine());
                if (hi > lo) {
                    rLo.seek(0L);
                    rLo.writeBytes(++lo + "\n");
                    FileInputStream fis = null;
                    ObjectInputStream oin = null;
                    try {
                        fis = new FileInputStream(String.format("%s%08d", this.myFileNameBase, lo));
                        oin = new ObjectInputStream(fis);
                        response = (cMsgMessageFull)oin.readObject();
                        oin.close();
                        fis.close();
                        new File(String.format("%s%08d", this.myFileNameBase, lo)).delete();
                        response.expandPayload();
                        response.makeResponse(message);
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("?missing message file " + lo + " in queue " + this.myQueueNameFull);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
                lLo.release();
                lHi.release();
                rHi.close();
                rLo.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                cMsgException ce = new cMsgException(e.toString());
                ce.setReturnCode(1);
                throw ce;
            }
        }
        if (response == null) {
            response = cMsgMessageFull.createDeliverableMessage();
            response.makeNullResponse(message);
        }
        try {
            this.myDeliverer.deliverMessage(response, 20);
        }
        catch (IOException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }
}

