/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubdomainAdapter;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtEventImpl;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.enums.Mode;
import org.jlab.coda.et.exception.EtBusyException;
import org.jlab.coda.et.exception.EtClosedException;
import org.jlab.coda.et.exception.EtDeadException;
import org.jlab.coda.et.exception.EtEmptyException;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtTooManyException;
import org.jlab.coda.et.exception.EtWakeUpException;

public class Et
extends cMsgSubdomainAdapter {
    private String myUDLRemainder;
    private String etFile;
    private int openMethod;
    private int udpPort;
    private int serverPort;
    private ArrayList<String> multicastAddrs = new ArrayList();
    private String host;
    private int chunkSize = 1;
    private EtEvent[] events;
    private EtEvent[] putEvent = new EtEvent[1];
    private int eventsLeft = 0;
    private EtSystem etSystem;
    private EtAttachment gcAttachment;
    private boolean shutDown;

    @Override
    public boolean hasSend() {
        return true;
    }

    @Override
    public boolean hasSyncSend() {
        return true;
    }

    @Override
    public void setUDLRemainder(String udlRemainder) throws cMsgException {
        String remainder;
        Matcher matcher;
        Pattern pattern;
        block25: {
            int chunk;
            this.myUDLRemainder = udlRemainder;
            boolean debug = false;
            if (udlRemainder == null) {
                throw new cMsgException("invalid UDL");
            }
            pattern = Pattern.compile("([\\w\\.\\-/]+)(.*)");
            matcher = pattern.matcher(udlRemainder);
            this.openMethod = 1;
            if (matcher.find()) {
                this.etFile = matcher.group(1);
                remainder = matcher.group(2);
                if (debug) {
                    System.out.println("\nparseUDL: \n  ET file   = " + this.etFile + "\n  remainder = " + remainder);
                }
            } else {
                throw new cMsgException("invalid UDL");
            }
            if (this.etFile == null) {
                throw new cMsgException("parseUDL: no ET system file specified");
            }
            if (remainder == null) {
                return;
            }
            pattern = Pattern.compile("[\\?&]chunk=([0-9]+)");
            matcher = pattern.matcher(remainder);
            if (matcher.find() && (chunk = Integer.parseInt(matcher.group(1))) > 0 && chunk < 1001) {
                this.chunkSize = chunk;
            }
            this.openMethod = 1;
            pattern = Pattern.compile("[\\?&]open=([\\w]+)");
            matcher = pattern.matcher(remainder);
            if (matcher.find()) {
                String s = matcher.group(1);
                if (s.equalsIgnoreCase("direct")) {
                    this.openMethod = 2;
                } else if (s.equalsIgnoreCase("broadcast")) {
                    this.openMethod = 1;
                } else if (s.equalsIgnoreCase("multicast")) {
                    this.openMethod = 0;
                } else if (s.equalsIgnoreCase("broadAndMulticast")) {
                    this.openMethod = 3;
                }
            }
            this.serverPort = 11111;
            this.udpPort = 11111;
            pattern = Pattern.compile("[\\?&]port=([0-9]+)");
            matcher = pattern.matcher(remainder);
            if (matcher.find()) {
                try {
                    int port = Integer.parseInt(matcher.group(1));
                    if (port > 1024 && port < 65536) {
                        if (this.openMethod == 2) {
                            this.serverPort = port;
                        } else {
                            this.udpPort = port;
                        }
                        break block25;
                    }
                    cMsgException ex = new cMsgException("port number out of range");
                    ex.setReturnCode(16);
                    throw ex;
                }
                catch (NumberFormatException e) {
                    cMsgException ex = new cMsgException("bad port number");
                    ex.setReturnCode(5);
                    throw ex;
                }
            }
        }
        this.host = ".anywhere";
        if (this.openMethod == 2) {
            pattern = Pattern.compile("[\\?&]host=((?:[a-zA-Z]+[\\w\\.\\-]*)|(?:(?:[\\d]{1,3}\\.){3}[\\d]{1,3}))");
            matcher = pattern.matcher(remainder);
            this.host = matcher.find() ? matcher.group(1) : ".local";
        } else if (this.openMethod == 0 || this.openMethod == 3) {
            pattern = Pattern.compile("[\\?&]multi=((?:[\\d]{1,3}\\.){3}[\\d]{1,3})");
            matcher = pattern.matcher(remainder);
            while (matcher.find()) {
                String mAddr = matcher.group(1);
                this.multicastAddrs.add(mAddr);
            }
        }
    }

    @Override
    public void registerClient(cMsgClientInfo info) throws cMsgException {
        EtSystemOpenConfig config = null;
        try {
            if (this.openMethod == 2) {
                config = new EtSystemOpenConfig(this.etFile, this.host, this.serverPort);
            } else if (this.openMethod == 1) {
                config = new EtSystemOpenConfig(this.etFile, this.udpPort, this.host);
            } else if (this.openMethod == 0) {
                config = new EtSystemOpenConfig(this.etFile, this.host, this.multicastAddrs, this.udpPort, 32);
            } else if (this.openMethod == 3) {
                config = new EtSystemOpenConfig(this.etFile, this.host, null, this.multicastAddrs, false, this.openMethod, 0, this.udpPort, 32, 0);
            }
            this.etSystem = new EtSystem(config, 4);
            EtStation gc = this.etSystem.stationNameToObject("GRAND_CENTRAL");
            this.gcAttachment = this.etSystem.attach(gc);
        }
        catch (IOException e) {
            e.printStackTrace();
            cMsgException ex = new cMsgException("IO error");
            ex.setReturnCode(11);
            throw ex;
        }
        catch (EtException e) {
            e.printStackTrace();
            cMsgException ex = new cMsgException("bad argument value");
            ex.setReturnCode(4);
            throw ex;
        }
        catch (EtTooManyException e) {
            e.printStackTrace();
            cMsgException ex = new cMsgException("too many valid responses");
            ex.setReturnCode(17);
            throw ex;
        }
        catch (EtDeadException e) {
            e.printStackTrace();
            cMsgException ex = new cMsgException("ET system dead");
            ex.setReturnCode(10);
            throw ex;
        }
        catch (EtClosedException e) {
            e.printStackTrace();
            cMsgException ex = new cMsgException("etSystem object closed");
            ex.setReturnCode(10);
            throw ex;
        }
    }

    @Override
    public synchronized void handleSendRequest(cMsgMessageFull msg) throws cMsgException {
        if (this.shutDown) {
            return;
        }
        try {
            if (this.eventsLeft < 1) {
                int size = (int)this.etSystem.getEventSize();
                if (msg.getByteArrayLength() > size) {
                    size = msg.getByteArrayLength();
                }
                this.events = this.etSystem.newEvents(this.gcAttachment, Mode.SLEEP, 0, this.chunkSize, size);
                this.eventsLeft = this.events.length;
            }
            int index = this.events.length - this.eventsLeft;
            ((EtEventImpl)this.events[index]).setData(msg.getByteArray());
            this.putEvent[0] = this.events[index];
            --this.eventsLeft;
            this.etSystem.putEvents(this.gcAttachment, this.putEvent);
        }
        catch (IOException iOException) {
        }
        catch (EtException etException) {
        }
        catch (EtEmptyException etEmptyException) {
        }
        catch (EtBusyException etBusyException) {
        }
        catch (EtTimeoutException etTimeoutException) {
        }
        catch (EtWakeUpException etWakeUpException) {
        }
        catch (EtDeadException etDeadException) {
        }
        catch (EtClosedException etClosedException) {
            // empty catch block
        }
    }

    @Override
    public int handleSyncSendRequest(cMsgMessageFull msg) throws cMsgException {
        this.handleSendRequest(msg);
        return 0;
    }

    @Override
    public synchronized void handleClientShutdown() throws cMsgException {
        if (this.eventsLeft > 0) {
            EtEvent[] evs = new EtEvent[this.eventsLeft];
            int index = this.events.length - this.eventsLeft;
            try {
                this.etSystem.dumpEvents(this.gcAttachment, evs, index, this.eventsLeft);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.etSystem.close();
        this.shutDown = true;
    }
}

