/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import java.math.BigInteger;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;

public class cMsgPayloadProducer {
    private String subject = "SUBJECT";
    private String type = "TYPE";
    private String name = "producer";
    private String description = "java producer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private int delay;
    private int count = 50000;
    private boolean debug;

    cMsgPayloadProducer(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgPayloadProducer.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                this.count = Integer.parseInt(args[i + 1]);
                if (this.count < 1) {
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            cMsgPayloadProducer.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgPayloadProducer\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-delay <time>]      set time in millisec between sending of each message\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            cMsgPayloadProducer producer = new cMsgPayloadProducer(args);
            producer.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg producer sending to:\n    subject = " + this.subject + "\n    type    = " + this.type);
        }
        cMsg coda = new cMsg(this.UDL, this.name, this.description);
        coda.connect();
        cMsgMessage msg = new cMsgMessage();
        msg.setSubject(this.subject);
        msg.setType(this.type);
        String[] ses = new String[]{"one", "two", "three"};
        cMsgPayloadItem item1 = new cMsgPayloadItem("STR_ARRAY", ses);
        msg.addPayloadItem(item1);
        cMsgPayloadItem item2 = new cMsgPayloadItem("STR", "hey you");
        msg.addPayloadItem(item2);
        int ii = 123456789;
        cMsgPayloadItem item3 = new cMsgPayloadItem("INT", ii);
        msg.addPayloadItem(item3);
        int[] ia = new int[]{1, 2, 3};
        cMsgPayloadItem item4 = new cMsgPayloadItem("INT_ARRAY", ia);
        msg.addPayloadItem(item4);
        byte bt = 123;
        cMsgPayloadItem item5 = new cMsgPayloadItem("BYTE", bt);
        msg.addPayloadItem(item5);
        byte[] ba = new byte[]{1, 2, 3};
        cMsgPayloadItem item6 = new cMsgPayloadItem("BYTE_ARRAY", ba);
        msg.addPayloadItem(item6);
        short st = 12345;
        cMsgPayloadItem item7 = new cMsgPayloadItem("SHORT", st);
        msg.addPayloadItem(item7);
        short[] sa = new short[]{1, 2, 3};
        cMsgPayloadItem item8 = new cMsgPayloadItem("SHORT_ARRAY", sa);
        msg.addPayloadItem(item8);
        long lt = 123456789123456789L;
        cMsgPayloadItem item9 = new cMsgPayloadItem("LONG", lt);
        msg.addPayloadItem(item9);
        long[] la = new long[]{1L, 2L, 3L};
        cMsgPayloadItem item10 = new cMsgPayloadItem("LONG_ARRAY", la);
        msg.addPayloadItem(item10);
        cMsgPayloadItem item11 = new cMsgPayloadItem("BIN", ba, 2);
        msg.addPayloadItem(item11);
        long[] lb = new long[30];
        lb[0] = 1L;
        lb[15] = 2L;
        lb[29] = 3L;
        cMsgPayloadItem item20 = new cMsgPayloadItem("LONG_ARRAY_ZERO", lb);
        msg.addPayloadItem(item20);
        int[] ib = new int[30];
        ib[0] = 1;
        ib[15] = 2;
        ib[29] = 3;
        cMsgPayloadItem item21 = new cMsgPayloadItem("INT_ARRAY_ZERO", ib);
        msg.addPayloadItem(item21);
        short[] sb = new short[30];
        sb[0] = 1;
        sb[15] = 2;
        sb[29] = 3;
        cMsgPayloadItem item22 = new cMsgPayloadItem("SHORT_ARRAY_ZERO", sb);
        msg.addPayloadItem(item22);
        byte[] bb = new byte[30];
        bb[0] = 1;
        bb[15] = 2;
        bb[29] = 3;
        cMsgPayloadItem item23 = new cMsgPayloadItem("BYTE_ARRAY_ZERO", bb);
        msg.addPayloadItem(item23);
        BigInteger bi = new BigInteger("18446744073709551614");
        cMsgPayloadItem item30 = new cMsgPayloadItem("BIGINT", bi);
        msg.addPayloadItem(item30);
        BigInteger[] big = new BigInteger[10];
        big[0] = BigInteger.ONE;
        big[3] = big[4] = BigInteger.ZERO;
        big[2] = big[4];
        big[1] = big[4];
        big[5] = BigInteger.TEN;
        big[7] = big[8] = BigInteger.ZERO;
        big[6] = big[8];
        big[9] = BigInteger.ONE;
        cMsgPayloadItem item31 = new cMsgPayloadItem("BIGINT_ARRAY", big);
        msg.addPayloadItem(item31);
        float f = 12345.123f;
        cMsgPayloadItem item40 = new cMsgPayloadItem("FLT", f);
        msg.addPayloadItem(item40);
        float[] ff = new float[]{1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 3.0f};
        cMsgPayloadItem item41 = new cMsgPayloadItem("FLT_ARRAY", ff);
        msg.addPayloadItem(item41);
        double d = 1.2345678912345679E8;
        cMsgPayloadItem item42 = new cMsgPayloadItem("DBL", d);
        msg.addPayloadItem(item42);
        double[] dd = new double[]{1.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 3.0};
        cMsgPayloadItem item43 = new cMsgPayloadItem("DBL_ARRAY", dd);
        msg.addPayloadItem(item43);
        cMsgMessage[] ma = new cMsgMessage[2];
        ma[0] = new cMsgMessage();
        ma[0].setSubject("sub1");
        ma[0].setType("type1");
        cMsgPayloadItem item50 = new cMsgPayloadItem("DBL", d);
        ma[0].addPayloadItem(item50);
        ma[1] = new cMsgMessage();
        ma[1].setSubject("sub2");
        ma[1].setType("type2");
        cMsgPayloadItem item51 = new cMsgPayloadItem("INT", ii);
        ma[1].addPayloadItem(item51);
        cMsgPayloadItem item52 = new cMsgPayloadItem("MSG_ARRAY", ma);
        msg.addPayloadItem(item52);
        long totalT = 0L;
        long totalC = 0L;
        long ignore = 0L;
        while (true) {
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < this.count; ++i) {
                coda.send(msg);
                coda.flush(0);
                if (this.delay == 0) continue;
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            long t2 = System.currentTimeMillis();
            if (ignore == 0L) {
                long deltaT = t2 - t1;
                double freq = (double)this.count / (double)deltaT * 1000.0;
                double freqAvg = (double)(totalC += (long)this.count) / (double)(totalT += deltaT) * 1000.0;
                if (!this.debug) continue;
                System.out.println(cMsgPayloadProducer.doubleToString(freq, 1) + " Hz, Avg = " + cMsgPayloadProducer.doubleToString(freqAvg, 1) + " Hz");
                continue;
            }
            --ignore;
        }
    }
}

