/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.RCServerDomain;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.RCServerDomain.rcListeningThread;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgDomainAdapter;
import org.jlab.coda.cMsg.common.cMsgDomainInterface;
import org.jlab.coda.cMsg.common.cMsgGetHelper;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgShutdownHandlerInterface;
import org.jlab.coda.cMsg.common.cMsgSubscription;

public class RCServer
extends cMsgDomainAdapter {
    private int rcClientPort;
    private String rcClientHost;
    int localUdpPort;
    private int localTcpPort;
    private ArrayList<String> clientIpOrderedSet;
    private ArrayList<String> serverIpOrderedSet;
    private rcListeningThread listenerThread;
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private final ReentrantReadWriteLock methodLock = new ReentrantReadWriteLock();
    private Lock connectLock = this.methodLock.writeLock();
    private Lock notConnectLock = this.methodLock.readLock();
    private Lock subscribeLock = new ReentrantLock();
    private AtomicInteger uniqueId;
    Set<cMsgSubscription> subscriptions;
    private Map<Object, cMsgSubscription> unsubscriptions;
    ConcurrentHashMap<Integer, cMsgSubscription> subscribeAndGets;
    ConcurrentHashMap<Integer, cMsgGetHelper> sendAndGets;

    public String getString() {
        return this.rcClientHost + ":" + this.rcClientPort;
    }

    public RCServer() throws cMsgException {
        this.domain = "rcs";
        this.subscriptions = Collections.synchronizedSet(new HashSet(20));
        this.subscribeAndGets = new ConcurrentHashMap(20);
        this.sendAndGets = new ConcurrentHashMap(20);
        this.unsubscriptions = Collections.synchronizedMap(new HashMap(20));
        this.uniqueId = new AtomicInteger();
        try {
            this.host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new cMsgException("cMsg: cannot find host name");
        }
        class MyShutdownHandler
        implements cMsgShutdownHandlerInterface {
            cMsgDomainInterface cMsgObject;

            MyShutdownHandler(cMsgDomainInterface cMsgObject) {
                this.cMsgObject = cMsgObject;
            }

            @Override
            public void handleShutdown() {
                try {
                    this.cMsgObject.disconnect();
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
        }
        this.setShutdownHandler(new MyShutdownHandler(this));
    }

    @Override
    public void setUDL(String UDL) throws cMsgException {
        if (UDL == null) {
            throw new cMsgException("UDL argument is null");
        }
        this.UDL = UDL;
        String[] UDLstrings = UDL.split(";");
        if (this.debug >= 4) {
            for (int i = 0; i < UDLstrings.length; ++i) {
                System.out.println("UDL #" + i + " = " + UDLstrings[i]);
            }
        }
        ArrayList<String> clientIpList = new ArrayList<String>(UDLstrings.length);
        ArrayList<String> clientBroadcastList = new ArrayList<String>(UDLstrings.length);
        for (String udl : UDLstrings) {
            String udlRemainder;
            Pattern pattern = Pattern.compile("(cMsg)?:?([\\w\\-]+)://(.*)", 2);
            Matcher matcher = pattern.matcher(udl);
            if (!matcher.matches() || (udlRemainder = matcher.group(3)) == null) continue;
            try {
                Object[] retObjs = this.parseUDL(udlRemainder);
                int tcpPort = (Integer)retObjs[1];
                if (this.rcClientPort == 0 && tcpPort > 1023 && tcpPort < 65536) {
                    this.rcClientPort = tcpPort;
                }
                clientIpList.add((String)retObjs[0]);
                clientBroadcastList.add((String)retObjs[2]);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (clientIpList.size() < 1) {
            throw new cMsgException("no valid UDL given");
        }
        this.orderIpAddresses(clientIpList, clientBroadcastList);
    }

    private void orderIpAddresses(ArrayList<String> clientIps, ArrayList<String> clientBroadcasts) {
        List<InterfaceAddress> ipInfoList = cMsgUtilities.getAllIpInfo();
        this.clientIpOrderedSet = new ArrayList();
        this.serverIpOrderedSet = new ArrayList();
        for (int i = 0; i < clientIps.size(); ++i) {
            boolean onDifferentSubnet = true;
            for (InterfaceAddress iAddr : ipInfoList) {
                String localBroad = iAddr.getBroadcast().getHostAddress();
                if (!localBroad.equals(clientBroadcasts.get(i))) continue;
                this.clientIpOrderedSet.add(0, clientIps.get(i));
                onDifferentSubnet = false;
                break;
            }
            if (!onDifferentSubnet) continue;
            this.clientIpOrderedSet.add(clientIps.get(i));
        }
        for (InterfaceAddress iAddr : ipInfoList) {
            String localBroad = iAddr.getBroadcast().getHostAddress();
            boolean onDifferentSubnet = true;
            for (int i = 0; i < clientIps.size(); ++i) {
                if (!localBroad.equals(clientBroadcasts.get(i))) continue;
                this.serverIpOrderedSet.add(0, iAddr.getAddress().getHostAddress());
                onDifferentSubnet = false;
                break;
            }
            if (!onDifferentSubnet) continue;
            this.serverIpOrderedSet.add(iAddr.getAddress().getHostAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws cMsgException {
        this.connectLock.lock();
        try {
            if (this.connected) {
                return;
            }
            try {
                boolean failed = true;
                System.out.println("RC server: ordered RC client IP address list:");
                for (String clientHost : this.clientIpOrderedSet) {
                    System.out.println("     ip = " + clientHost + ", port = " + this.rcClientPort);
                }
                for (String clientHost : this.clientIpOrderedSet) {
                    try {
                        this.createTCPClientConnection(clientHost, this.rcClientPort);
                        this.rcClientHost = clientHost;
                        failed = false;
                        break;
                    }
                    catch (IOException e) {
                        System.out.println("RC server: failed to connect to RC client (host = " + clientHost + ", port = " + this.rcClientPort);
                    }
                }
                if (failed) {
                    throw new cMsgException("Failed to create socket to RC client");
                }
                if (this.listenerThread == null) {
                    this.listenerThread = new rcListeningThread(this);
                    this.listenerThread.start();
                    rcListeningThread rcListeningThread2 = this.listenerThread;
                    synchronized (rcListeningThread2) {
                        if (!this.listenerThread.isAlive()) {
                            try {
                                this.listenerThread.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                this.localTcpPort = this.listenerThread.getTcpPort();
                this.localUdpPort = this.listenerThread.getUdpPort();
                System.out.println("RC server: listening on TCP port = " + this.localTcpPort + " and UDP port = " + this.localUdpPort);
                cMsgMessageFull msg = new cMsgMessageFull();
                msg.setSenderHost(InetAddress.getByName(InetAddress.getLocalHost().getCanonicalHostName()).getHostAddress());
                cMsgPayloadItem pItem = new cMsgPayloadItem("serverIp", this.socket.getLocalAddress().getHostAddress());
                msg.addPayloadItem(pItem);
                System.out.println("RC server: tell RC client to connect back using IP = " + this.socket.getLocalAddress().getHostAddress());
                pItem = new cMsgPayloadItem("clientIp", this.rcClientHost);
                msg.addPayloadItem(pItem);
                msg.setText("" + this.localUdpPort);
                msg.setUserInt(this.localTcpPort);
                this.deliverMessage(msg, 23);
                try {
                    System.out.println("RC server connect: wait up to 15 sec for RC client TCP return connection");
                    boolean connectionMade = this.listenerThread.startLatch.await(15L, TimeUnit.SECONDS);
                    if (!connectionMade) {
                        throw new cMsgException("15 sec timeout waiting for RC client to connect back");
                    }
                }
                catch (InterruptedException e) {
                    throw new cMsgException("connect() interrupted", e);
                }
                System.out.println("RC server connect: complete");
                this.connected = true;
            }
            catch (IOException e) {
                if (this.listenerThread != null) {
                    this.listenerThread.killThread();
                }
                throw new cMsgException("cannot connect, IO error", e);
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnect() {
        try {
            this.listenerThread = new rcListeningThread(this);
            this.listenerThread.start();
            rcListeningThread rcListeningThread2 = this.listenerThread;
            synchronized (rcListeningThread2) {
                if (!this.listenerThread.isAlive()) {
                    try {
                        this.listenerThread.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.localTcpPort = this.listenerThread.getTcpPort();
            this.localUdpPort = this.listenerThread.getUdpPort();
            System.out.println("RC test server: listening on TCP port = " + this.localTcpPort + " and UDP port = " + this.localUdpPort);
            System.out.println("Rc test server IP addresses:");
            Collection<String> c = cMsgUtilities.getAllIpAddresses();
            for (String ip : c) {
                System.out.println("    " + ip);
            }
            class RcCallback
            extends cMsgCallbackAdapter {
                RcCallback() {
                }

                @Override
                public void callback(cMsgMessage msg, Object userObject) {
                    System.out.print(".");
                }
            }
            RcCallback cb3 = new RcCallback();
            cMsgSubscriptionHandle handle = this.testSubscribe("*", "*", cb3, null);
            this.start();
            Thread.sleep(200000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            RCServer server = new RCServer();
            server.testConnect();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public cMsgSubscriptionHandle testSubscribe(String subject, String type, cMsgCallbackInterface cb3, Object userObj) {
        int id = this.uniqueId.getAndIncrement();
        cMsgCallbackThread cbThread = new cMsgCallbackThread(cb3, userObj, this.domain, subject, type);
        cMsgSubscription newSub = new cMsgSubscription(subject, type, id, cbThread);
        this.unsubscriptions.put(cbThread, newSub);
        this.subscriptions.add(newSub);
        return cbThread;
    }

    public void close() {
        System.out.println("RC Server: CLOSE() called");
        this.disconnect();
        if (this.listenerThread != null) {
            this.listenerThread.killThread();
            this.listenerThread = null;
        }
    }

    @Override
    public void disconnect() {
        System.out.println("RC Server: DISCONNECT() called");
        this.connectLock.lock();
        try {
            if (!this.connected) {
                return;
            }
            this.connected = false;
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.connectLock.unlock();
        }
    }

    private void createTCPClientConnection(String clientHost, int clientPort) throws IOException {
        try {
            this.socket = new Socket(clientHost, clientPort);
            this.socket.setTcpNoDelay(true);
            this.socket.setSendBufferSize(65535);
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 65536));
            this.out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
            this.out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
            this.out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
            this.out.flush();
        }
        catch (IOException e) {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
        System.out.println("RC Server: made tcp socket to rc client " + clientHost + " on port " + clientPort);
    }

    private Object[] parseUDL(String udlRemainder) throws cMsgException, UnknownHostException {
        String bcastAddr;
        String udlPort;
        String udlHost;
        if (udlRemainder == null) {
            throw new cMsgException("invalid UDL");
        }
        Pattern pattern = Pattern.compile("([^:/]+):?(\\d+)?/([^/?&]+)(.*)");
        Matcher matcher = pattern.matcher(udlRemainder);
        int clientPort = 0;
        if (matcher.find()) {
            udlHost = matcher.group(1);
            udlPort = matcher.group(2);
            bcastAddr = matcher.group(3);
            String remainder = matcher.group(4);
            if (this.debug >= 4) {
                System.out.println("\nparseUDL: \n  host = " + udlHost + "\n  port = " + udlPort + "\n  broadcast = " + bcastAddr + "\n  remainder = " + remainder);
            }
        } else {
            throw new cMsgException("invalid UDL");
        }
        byte[] b = cMsgUtilities.isDottedDecimal(udlHost);
        if (b == null) {
            throw new cMsgException("host not in dot-decimal form");
        }
        if (udlPort != null && udlPort.length() > 0) {
            try {
                clientPort = Integer.parseInt(udlPort);
            }
            catch (NumberFormatException e) {
                clientPort = 45700;
                if (this.debug >= 3) {
                    System.out.println("parseUDL: non-integer port, guessing codaComponent port is " + this.rcClientPort);
                }
            }
        } else {
            clientPort = 45700;
            if (this.debug >= 3) {
                System.out.println("parseUDL: guessing codaComponent port is " + this.rcClientPort);
            }
        }
        if (clientPort < 1024 || clientPort > 65535) {
            throw new cMsgException("parseUDL: illegal port number");
        }
        return new Object[]{udlHost, clientPort, bcastAddr};
    }

    @Override
    public void send(cMsgMessage message) throws cMsgException {
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to server");
            }
            this.deliverMessage(message, 21);
        }
        catch (IOException e) {
            throw new cMsgException(e.getMessage(), e);
        }
        finally {
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int syncSend(cMsgMessage message, int timeout) throws cMsgException {
        int origTimeout = 0;
        int val = 0;
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                int n = val;
                return n;
            }
            origTimeout = this.socket.getSoTimeout();
            this.socket.setSoTimeout(timeout);
            this.out.writeInt(4);
            this.out.writeInt(6);
            this.out.flush();
            val = this.in.readInt();
        }
        catch (SocketTimeoutException e) {
            throw new cMsgException("timeout", e);
        }
        catch (IOException e) {
            int n = 0;
            return n;
        }
        finally {
            try {
                this.socket.setSoTimeout(origTimeout);
            }
            catch (SocketException socketException) {}
            this.notConnectLock.unlock();
        }
        return val;
    }

    private synchronized void deliverMessage(cMsgMessage msg, int msgType) throws IOException {
        int[] len = new int[6];
        int binLength = 0;
        if (msg.getSender() != null) {
            len[0] = msg.getSender().length();
        }
        if (msg.getSenderHost() != null) {
            len[1] = msg.getSenderHost().length();
        }
        if (msg.getSubject() != null) {
            len[2] = msg.getSubject().length();
        }
        if (msg.getType() != null) {
            len[3] = msg.getType().length();
        }
        if (msg.getPayloadText() != null) {
            len[4] = msg.getPayloadText().length();
        }
        if (msg.getText() != null) {
            len[5] = msg.getText().length();
        }
        if (msg.getByteArray() != null) {
            binLength = msg.getByteArrayLength();
        }
        int size = len[0] + len[1] + len[2] + len[3] + len[4] + len[5] + binLength + 72;
        this.out.writeInt(size);
        this.out.writeInt(msgType);
        this.out.writeInt(msg.getVersion());
        this.out.writeInt(0);
        this.out.writeInt(msg.getUserInt());
        this.out.writeInt(msg.getInfo());
        long now = new Date().getTime();
        this.out.writeInt((int)(now >>> 32));
        this.out.writeInt((int)(now & 0xFFFFFFFFL));
        this.out.writeInt((int)(msg.getUserTime().getTime() >>> 32));
        this.out.writeInt((int)(msg.getUserTime().getTime() & 0xFFFFFFFFL));
        this.out.writeInt(msg.getSysMsgId());
        this.out.writeInt(msg.getSenderToken());
        this.out.writeInt(len[0]);
        this.out.writeInt(len[1]);
        this.out.writeInt(len[2]);
        this.out.writeInt(len[3]);
        this.out.writeInt(len[4]);
        this.out.writeInt(len[5]);
        this.out.writeInt(binLength);
        try {
            if (msg.getSender() != null) {
                this.out.write(msg.getSender().getBytes("US-ASCII"));
            }
            if (msg.getSenderHost() != null) {
                this.out.write(msg.getSenderHost().getBytes("US-ASCII"));
            }
            if (msg.getSubject() != null) {
                this.out.write(msg.getSubject().getBytes("US-ASCII"));
            }
            if (msg.getType() != null) {
                this.out.write(msg.getType().getBytes("US-ASCII"));
            }
            if (msg.getPayloadText() != null) {
                this.out.write(msg.getPayloadText().getBytes("US-ASCII"));
            }
            if (msg.getText() != null) {
                this.out.write(msg.getText().getBytes("US-ASCII"));
            }
            if (binLength > 0) {
                this.out.write(msg.getByteArray(), msg.getByteArrayOffset(), binLength);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public cMsgSubscriptionHandle subscribe(String subject, String type, cMsgCallbackInterface cb3, Object userObj) throws cMsgException {
        if (subject == null) throw new cMsgException("subject, type or callback argument is null");
        if (type == null) throw new cMsgException("subject, type or callback argument is null");
        if (cb3 == null) {
            throw new cMsgException("subject, type or callback argument is null");
        }
        if (subject.length() < 1) throw new cMsgException("subject or type is blank string");
        if (type.length() < 1) {
            throw new cMsgException("subject or type is blank string");
        }
        cMsgCallbackThread cbThread = null;
        try {
            this.notConnectLock.lock();
            this.subscribeLock.lock();
            if (!this.connected) {
                throw new cMsgException("not connected to rc client");
            }
            Set<cMsgSubscription> set = this.subscriptions;
            synchronized (set) {
                for (cMsgSubscription sub : this.subscriptions) {
                    if (!sub.getSubject().equals(subject) || !sub.getType().equals(type)) continue;
                    cbThread = new cMsgCallbackThread(cb3, userObj, this.domain, subject, type);
                    sub.addCallback(cbThread);
                    this.unsubscriptions.put(cbThread, sub);
                    cMsgCallbackThread cMsgCallbackThread2 = cbThread;
                    return cMsgCallbackThread2;
                }
                int id = this.uniqueId.getAndIncrement();
                cbThread = new cMsgCallbackThread(cb3, userObj, this.domain, subject, type);
                cMsgSubscription newSub = new cMsgSubscription(subject, type, id, cbThread);
                this.unsubscriptions.put(cbThread, newSub);
                this.subscriptions.add(newSub);
                return cbThread;
            }
        }
        finally {
            this.subscribeLock.unlock();
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(cMsgSubscriptionHandle obj) throws cMsgException {
        if (obj == null) {
            throw new cMsgException("argument is null");
        }
        cMsgSubscription sub = this.unsubscriptions.remove(obj);
        if (sub == null) {
            return;
        }
        cMsgCallbackThread cbThread = (cMsgCallbackThread)obj;
        this.notConnectLock.lock();
        this.subscribeLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to rc client");
            }
            Set<cMsgSubscription> set = this.subscriptions;
            synchronized (set) {
                cbThread.dieNow(false);
                sub.getCallbacks().remove(cbThread);
                if (sub.numberOfCallbacks() < 1) {
                    this.subscriptions.remove(sub);
                }
            }
        }
        finally {
            this.subscribeLock.unlock();
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public cMsgMessage subscribeAndGet(String subject, String type, int timeout) throws cMsgException, TimeoutException {
        if (subject == null || type == null) {
            throw new cMsgException("message subject or type is null");
        }
        if (subject.length() < 1 || type.length() < 1) {
            throw new cMsgException("message subject or type is blank string");
        }
        int id = 0;
        cMsgSubscription helper = null;
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to rc client");
            }
            id = this.uniqueId.getAndIncrement();
            helper = new cMsgSubscription(subject, type);
            this.subscribeAndGets.put(id, helper);
        }
        finally {
            this.notConnectLock.unlock();
        }
        try {
            cMsgSubscription cMsgSubscription2 = helper;
            synchronized (cMsgSubscription2) {
                if (timeout > 0) {
                    helper.wait(timeout);
                } else {
                    helper.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (helper.isTimedOut()) {
            this.subscribeAndGets.remove(id);
            throw new TimeoutException();
        }
        return helper.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public cMsgMessage sendAndGet(cMsgMessage message, int timeout) throws cMsgException, TimeoutException {
        String subject = message.getSubject();
        String type = message.getType();
        if (subject == null || type == null) {
            throw new cMsgException("message subject and/or type is null");
        }
        if (subject.length() < 1 || type.length() < 1) {
            throw new cMsgException("message subject or type is blank string");
        }
        int id = 0;
        cMsgGetHelper helper = null;
        this.notConnectLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to rc client");
            }
            id = this.uniqueId.getAndIncrement();
            helper = new cMsgGetHelper();
            this.sendAndGets.put(id, helper);
            cMsgMessageFull fullMsg = new cMsgMessageFull(message);
            fullMsg.setSenderToken(id);
            fullMsg.setGetRequest(true);
            this.deliverMessage(fullMsg, 21);
        }
        catch (IOException e) {
            System.out.println("IOException in send&Get, msg = " + e.getMessage());
            throw new cMsgException(e.getMessage(), e);
        }
        finally {
            this.notConnectLock.unlock();
        }
        try {
            cMsgGetHelper cMsgGetHelper2 = helper;
            synchronized (cMsgGetHelper2) {
                if (timeout > 0) {
                    helper.wait(timeout);
                } else {
                    helper.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (helper.isTimedOut()) {
            this.sendAndGets.remove(id);
            throw new TimeoutException();
        }
        return helper.getMessage();
    }
}

