/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.FileDomain;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.common.cMsgDomainAdapter;
import org.jlab.coda.cMsg.common.cMsgMessageFull;

public class File
extends cMsgDomainAdapter {
    private String myFileName;
    private PrintWriter myPrintHandle;
    private boolean textOnly = false;

    public File() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            System.err.println(e);
            this.host = "unknown";
        }
    }

    @Override
    public synchronized void connect() throws cMsgException {
        if (this.connected) {
            return;
        }
        this.parseUDL();
        try {
            this.myPrintHandle = new PrintWriter(new BufferedWriter(new FileWriter(this.myFileName, true)));
            this.myPrintHandle.println("<cMsgFile  name=\"" + this.myFileName + "\"  date=\"" + new Date() + "\">\n\n");
            this.connected = true;
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace();
            cMsgException ce = new cMsgException("connect: unable to open file");
            ce.setReturnCode(1);
            throw ce;
        }
    }

    @Override
    public synchronized void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.myPrintHandle.println("\n\n</cMsgFile>\n");
        this.myPrintHandle.println("\n\n<!--===========================================================================================-->\n\n\n");
        this.myPrintHandle.close();
    }

    @Override
    public synchronized void send(cMsgMessage msg) throws cMsgException {
        if (!this.connected) {
            throw new cMsgException("File is closed, Call \"connect\" first");
        }
        Date now = new Date();
        if (this.textOnly) {
            this.myPrintHandle.println(now + ":    " + msg.getText());
        } else if (msg.getDomain() == null || msg.getDomain().length() <= 0) {
            cMsgMessageFull msgFull = new cMsgMessageFull(msg);
            msgFull.setDomain(this.domain);
            msgFull.setSender(this.name);
            msgFull.setSenderHost(this.host);
            msgFull.setSenderTime(now);
            msgFull.setReceiver(this.domain);
            msgFull.setReceiverTime(now);
            msgFull.setReceiverHost(this.host);
            this.myPrintHandle.println(msgFull);
        } else {
            this.myPrintHandle.println(msg);
        }
    }

    @Override
    public int syncSend(cMsgMessage message, int timeout) throws cMsgException {
        this.send(message);
        return 0;
    }

    @Override
    public synchronized void flush(int timeout) throws cMsgException {
        if (!this.connected) {
            throw new cMsgException("File is closed, Call \"connect\" first");
        }
        this.myPrintHandle.flush();
    }

    private void parseUDL() throws cMsgException {
        this.domain = "file";
        if (this.UDLremainder == null) {
            throw new cMsgException("invalid UDL");
        }
        String remainder = null;
        int ind = this.UDLremainder.indexOf(63);
        if (ind > 0) {
            this.myFileName = this.UDLremainder.substring(0, ind);
            remainder = this.UDLremainder.substring(ind + 1);
        } else {
            this.myFileName = this.UDLremainder;
        }
        if (remainder != null) {
            Pattern p = Pattern.compile("textOnly=(\\w+)", 2);
            Matcher m = p.matcher(remainder);
            m.find();
            this.textOnly = m.group(1).equals("true");
        }
    }
}

