/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.EmuDomain;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgDomainAdapter;

public final class EmuClient
extends cMsgDomainAdapter {
    private int multicastTimeout = 30000;
    private final ArrayList<String> ipAddresses = new ArrayList(10);
    private final ArrayList<String> broadcastAddresses = new ArrayList(10);
    private String serverIp;
    private volatile int tcpServerPort;
    private int multicastServerPort;
    private MulticastSocket multicastUdpSocket;
    private boolean multicasting;
    private String serverIpAddress;
    private int socketCount = 1;
    private Socket[] tcpSocket;
    private DataOutputStream[] domainOut;
    private CountDownLatch multicastResponse;
    private int maxSize = 4010000;
    private int tcpSendBufferSize = this.maxSize + 1024;
    private boolean tcpNoDelay = false;
    private int codaID;
    private String destComponentName;
    private String expid;
    private String preferredSubnet;

    public EmuClient() throws cMsgException {
        this.domain = "emu";
    }

    @Override
    public String getServerHost() {
        return this.serverIp;
    }

    @Override
    public int getServerPort() {
        return this.tcpServerPort;
    }

    @Override
    public void connect() throws cMsgException {
        int i;
        DatagramPacket udpPacket;
        this.parseUDL(this.UDLremainder);
        if (this.connected) {
            return;
        }
        if (!this.multicasting) {
            this.directConnect();
            return;
        }
        this.multicastResponse = new CountDownLatch(1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        DataOutputStream out = new DataOutputStream(baos);
        try {
            out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
            out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
            out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
            out.writeInt(2);
            out.writeInt(6);
            out.writeInt(this.destComponentName.length());
            out.writeInt(this.expid.length());
            try {
                out.write(this.destComponentName.getBytes("US-ASCII"));
                out.write(this.expid.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            out.flush();
            out.close();
            this.multicastUdpSocket = new MulticastSocket();
            this.multicastUdpSocket.setTimeToLive(3);
            InetAddress multicastServerAddress = null;
            try {
                multicastServerAddress = InetAddress.getByName("239.230.0.0");
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            byte[] buf = baos.toByteArray();
            udpPacket = new DatagramPacket(buf, buf.length, multicastServerAddress, this.multicastServerPort);
        }
        catch (IOException e) {
            try {
                out.close();
            }
            catch (IOException buf) {
                // empty catch block
            }
            try {
                baos.close();
            }
            catch (IOException buf) {
                // empty catch block
            }
            if (this.multicastUdpSocket != null) {
                this.multicastUdpSocket.close();
            }
            if (this.debug >= 2) {
                System.out.println("I/O Error: " + e);
            }
            throw new cMsgException(e.getMessage(), e);
        }
        this.debug = 3;
        MulticastReceiver receiver = new MulticastReceiver();
        receiver.start();
        Multicaster sender = new Multicaster(udpPacket);
        sender.start();
        boolean response = false;
        if (this.multicastTimeout > 0) {
            try {
                if (this.multicastResponse.await(this.multicastTimeout, TimeUnit.MILLISECONDS)) {
                    response = true;
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            try {
                this.multicastResponse.await();
                response = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.multicastUdpSocket.close();
        sender.interrupt();
        if (!response) {
            throw new cMsgException("No response to UDP multicast received");
        }
        List<String> orderedIps = cMsgUtilities.orderIPAddresses(this.ipAddresses, this.broadcastAddresses, this.preferredSubnet);
        ArrayList<String> orderedLocalIps = new ArrayList<String>();
        for (String brAddr : this.broadcastAddresses) {
            String outgoingIp = cMsgUtilities.getMatchingLocalIpAddress(brAddr);
            orderedLocalIps.add(outgoingIp);
        }
        IOException ioex = null;
        this.tcpSocket = new Socket[this.socketCount];
        this.domainOut = new DataOutputStream[this.socketCount];
        boolean gotAllConnections = true;
        boolean[] gotTcpConnection = new boolean[this.socketCount];
        System.out.println("      Emu connect: tcp noDelay = " + this.tcpNoDelay);
        if (orderedIps != null && orderedIps.size() > 0) {
            block26: for (int j = 0; j < orderedIps.size(); ++j) {
                String ip = orderedIps.get(j);
                for (int i2 = 0; i2 < this.socketCount; ++i2) {
                    try {
                        this.tcpSocket[i2] = new Socket();
                        this.tcpSocket[i2].setTcpNoDelay(this.tcpNoDelay);
                        this.tcpSocket[i2].setSendBufferSize(this.tcpSendBufferSize);
                        if (orderedLocalIps.get(j) != null) {
                            try {
                                this.tcpSocket[i2].bind(new InetSocketAddress((String)orderedLocalIps.get(j), 0));
                                System.out.println("      Emu connect: socket " + i2 + " bound outgoing data to " + (String)orderedLocalIps.get(j));
                            }
                            catch (IOException e) {
                                System.out.println("      Emu connect: socket " + i2 + " tried but FAILED to bind outgoing data to " + (String)orderedLocalIps.get(j));
                            }
                        }
                        System.out.println("      Emu connect: socket " + i2 + " try making TCP connection to host = " + ip + "; port = " + this.tcpServerPort);
                        this.tcpSocket[i2].connect(new InetSocketAddress(ip, this.tcpServerPort), 5000);
                        this.domainOut[i2] = new DataOutputStream(new BufferedOutputStream(this.tcpSocket[i2].getOutputStream()));
                        System.out.println("      Emu connect: socket " + i2 + " MADE TCP connection to host = " + ip + "; port = " + this.tcpServerPort);
                        this.serverIp = ip;
                        gotTcpConnection[i2] = true;
                        if (i2 != this.socketCount - 1) continue;
                        break block26;
                    }
                    catch (SocketTimeoutException e) {
                        System.out.println("      Emu connect: socket " + i2 + " TIMEOUT (5 sec) connecting to " + ip);
                        ioex = e;
                        if (i2 <= 0) continue block26;
                        throw new cMsgException("Connect error with Emu server", e);
                    }
                    catch (IOException e) {
                        System.out.println("      Emu connect: socket " + i2 + " failure connecting to " + ip);
                        ioex = e;
                        if (i2 <= 0) continue block26;
                        throw new cMsgException("Connect error with Emu server", e);
                    }
                }
            }
        }
        for (i = 0; i < this.socketCount; ++i) {
            gotAllConnections = gotAllConnections && gotTcpConnection[i];
        }
        if (!gotAllConnections) {
            if (this.domainOut != null) {
                for (i = 0; i < this.socketCount; ++i) {
                    try {
                        this.domainOut[i].close();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (this.tcpSocket != null) {
                for (i = 0; i < this.socketCount; ++i) {
                    try {
                        this.tcpSocket[i].close();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            throw new cMsgException("Cannot make all TCP connections to Emu server", ioex);
        }
        try {
            this.talkToServer();
        }
        catch (IOException e) {
            throw new cMsgException("Communication error with Emu server", e);
        }
        this.connected = true;
    }

    private void directConnect() throws cMsgException {
        int i;
        String outgoingIp = null;
        if (this.preferredSubnet != null) {
            outgoingIp = cMsgUtilities.getMatchingLocalIpAddress(this.preferredSubnet);
        }
        Throwable ioex = null;
        this.tcpSocket = new Socket[this.socketCount];
        this.domainOut = new DataOutputStream[this.socketCount];
        boolean gotAllConnections = true;
        boolean[] gotTcpConnection = new boolean[this.socketCount];
        System.out.println("      Emu connect: tcp noDelay = " + this.tcpNoDelay);
        for (i = 0; i < this.socketCount; ++i) {
            try {
                this.tcpSocket[i] = new Socket();
                this.tcpSocket[i].setReuseAddress(true);
                this.tcpSocket[i].setTcpNoDelay(this.tcpNoDelay);
                this.tcpSocket[i].setSendBufferSize(this.tcpSendBufferSize);
                if (outgoingIp != null) {
                    try {
                        this.tcpSocket[i].bind(new InetSocketAddress(outgoingIp, 0));
                        System.out.println("      Emu connect direct: socket " + i + " bound outgoing data to " + outgoingIp);
                    }
                    catch (IOException e) {
                        System.out.println("      Emu connect direct: socket " + i + " tried but FAILED to bind outgoing data to " + outgoingIp);
                    }
                }
                System.out.println("      Emu connect direct: socket " + i + " try making TCP connection to host = " + this.serverIpAddress + "; port = " + this.tcpServerPort);
                this.tcpSocket[i].connect(new InetSocketAddress(this.serverIpAddress, this.tcpServerPort), 20000);
                this.domainOut[i] = new DataOutputStream(new BufferedOutputStream(this.tcpSocket[i].getOutputStream()));
                System.out.println("      Emu connect direct: socket " + i + " MADE TCP connection to host = " + this.serverIpAddress + "; port = " + this.tcpServerPort);
                this.serverIp = this.serverIpAddress;
                gotTcpConnection[i] = true;
                if (i != this.socketCount - 1) continue;
                break;
            }
            catch (SocketTimeoutException e) {
                System.out.println("      Emu connect direct: socket " + i + " TIMEOUT (20 sec) connecting to " + this.serverIpAddress);
                for (int j = 0; j < i; ++j) {
                    try {
                        this.domainOut[j].close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.tcpSocket[j].close();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new cMsgException("Connect error with Emu server", e);
            }
            catch (IOException e) {
                System.out.println("      Emu connect direct: socket " + i + " failure connecting to " + this.serverIpAddress);
                throw new cMsgException("Connect error with Emu server", e);
            }
        }
        for (i = 0; i < this.socketCount; ++i) {
            gotAllConnections = gotAllConnections && gotTcpConnection[i];
        }
        if (!gotAllConnections) {
            if (this.domainOut != null) {
                for (i = 0; i < this.socketCount; ++i) {
                    try {
                        this.domainOut[i].close();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (this.tcpSocket != null) {
                for (i = 0; i < this.socketCount; ++i) {
                    try {
                        this.tcpSocket[i].close();
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            throw new cMsgException("Cannot make all TCP connections to Emu server", ioex);
        }
        try {
            this.talkToServer();
        }
        catch (IOException e) {
            throw new cMsgException("Communication error with Emu server", e);
        }
        this.connected = true;
    }

    private void talkToServer() throws IOException {
        try {
            for (int i = 0; i < this.socketCount; ++i) {
                this.domainOut[i].writeInt(cMsgNetworkConstants.magicNumbers[0]);
                this.domainOut[i].writeInt(cMsgNetworkConstants.magicNumbers[1]);
                this.domainOut[i].writeInt(cMsgNetworkConstants.magicNumbers[2]);
                this.domainOut[i].writeInt(6);
                this.domainOut[i].writeInt(this.codaID);
                this.domainOut[i].writeInt(this.maxSize);
                this.domainOut[i].writeInt(this.socketCount);
                this.domainOut[i].writeInt(i + 1);
                this.domainOut[i].flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void parseUDLOld(String udlRemainder) throws cMsgException {
        String remainder;
        String udlDestName;
        String udlExpid;
        String udlPort;
        if (udlRemainder == null) {
            throw new cMsgException("invalid UDL");
        }
        Pattern pattern = Pattern.compile("(\\d+)/([^/]+)/([^?&]+)(.*)");
        Matcher matcher = pattern.matcher(udlRemainder);
        if (matcher.find()) {
            udlPort = matcher.group(1);
            udlExpid = matcher.group(2);
            udlDestName = matcher.group(3);
            remainder = matcher.group(4);
            if (this.debug >= 4) {
                System.out.println("\nparseUDL: \n  port      = " + udlPort + "\n  expid     = " + udlExpid + "\n  component = " + udlDestName + "\n  remainder = " + remainder);
            }
        } else {
            throw new cMsgException("invalid UDL");
        }
        try {
            this.multicastServerPort = Integer.parseInt(udlPort);
        }
        catch (NumberFormatException e) {
            throw new cMsgException("parseUDL: bad port number");
        }
        if (this.multicastServerPort < 1024 || this.multicastServerPort > 65535) {
            throw new cMsgException("parseUDL: illegal port number");
        }
        if (udlExpid == null) {
            throw new cMsgException("parseUDL: must specify the EXPID");
        }
        this.expid = udlExpid;
        if (udlDestName == null) {
            throw new cMsgException("parseUDL: must specify the destination CODA component name");
        }
        this.destComponentName = udlDestName;
        if (remainder == null) {
            throw new cMsgException("parseUDL: must specify the CODA id");
        }
        pattern = Pattern.compile("[\\?]codaId=([0-9]+)", 2);
        matcher = pattern.matcher(remainder);
        if (matcher.find()) {
            try {
                this.codaID = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new cMsgException("parseUDL: improper CODA id", e);
            }
        } else {
            throw new cMsgException("parseUDL: must specify the CODA id");
        }
        pattern = Pattern.compile("[\\?&]timeout=([0-9]+)", 2);
        matcher = pattern.matcher(remainder);
        if (matcher.find()) {
            try {
                this.multicastTimeout = 1000 * Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]bufSize=([0-9]+)", 2)).matcher(remainder)).find()) {
            try {
                int mSize = Integer.parseInt(matcher.group(1));
                if (mSize > 0) {
                    this.maxSize = mSize;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]tcpSend=([0-9]+)", 2)).matcher(remainder)).find()) {
            try {
                this.tcpSendBufferSize = Integer.parseInt(matcher.group(1));
                if (this.tcpSendBufferSize == 0) {
                    this.tcpSendBufferSize = this.maxSize + 1024;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]subnet=((?:[0-9]{1,3}\\.){3}[0-9]{1,3})", 2)).matcher(remainder)).find()) {
            try {
                this.preferredSubnet = matcher.group(1);
                if (cMsgUtilities.isDottedDecimal(this.preferredSubnet) == null) {
                    this.preferredSubnet = null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]sockets=([0-9]+)", 2)).matcher(remainder)).find()) {
            try {
                this.socketCount = Integer.parseInt(matcher.group(1));
                if (this.socketCount < 1) {
                    this.socketCount = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]noDelay", 2)).matcher(remainder)).find()) {
            try {
                this.tcpNoDelay = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void parseUDL(String udlRemainder) throws cMsgException {
        int port;
        if (udlRemainder == null) {
            throw new cMsgException("invalid UDL");
        }
        Pattern pattern = Pattern.compile("([^:/?]+)?:?(\\d+)/([^/]+)/([^?&]+)(.*)");
        Matcher matcher = pattern.matcher(udlRemainder);
        if (!matcher.find()) {
            throw new cMsgException("invalid UDL");
        }
        String udlHost = matcher.group(1);
        String udlPort = matcher.group(2);
        String udlExpid = matcher.group(3);
        String udlDestName = matcher.group(4);
        String remainder = matcher.group(5);
        System.out.println("\nparseUDL: \n  host      = " + udlHost + "\n  port      = " + udlPort + "\n  expid     = " + udlExpid + "\n  component = " + udlDestName + "\n  remainder = " + remainder);
        if (udlHost == null) {
            this.serverIpAddress = "multicast";
        }
        if (udlHost.equalsIgnoreCase("multicast")) {
            this.serverIpAddress = "239.210.0.0";
            this.multicasting = true;
            System.out.println("Will multicast to 239.210.0.0");
        } else {
            this.serverIpAddress = udlHost;
            try {
                if (InetAddress.getByName(udlHost).isMulticastAddress()) {
                    System.out.println("Will multicast to " + udlHost);
                    this.multicasting = true;
                } else {
                    byte[] addr = cMsgUtilities.isDottedDecimal(udlHost);
                    if (addr == null) {
                        throw new cMsgException("parseUDL: host is not \"multicast\" or in dotted decimal form");
                    }
                    System.out.println("Will direct connect to " + udlHost);
                }
            }
            catch (UnknownHostException e) {
                this.serverIpAddress = "239.210.0.0";
                this.multicasting = true;
                System.out.println("Will multicast to 239.210.0.0");
            }
        }
        try {
            port = Integer.parseInt(udlPort);
        }
        catch (NumberFormatException e) {
            throw new cMsgException("parseUDL: bad port number");
        }
        if (port < 1024 || port > 65535) {
            throw new cMsgException("parseUDL: illegal port number");
        }
        if (this.multicasting) {
            this.multicastServerPort = port;
            System.out.println("multicast port = " + this.multicastServerPort);
        } else {
            this.tcpServerPort = port;
            System.out.println("tcp server port = " + this.tcpServerPort);
        }
        if (udlExpid == null) {
            throw new cMsgException("parseUDL: must specify the EXPID");
        }
        this.expid = udlExpid;
        System.out.println("expid = " + udlExpid);
        if (udlDestName == null) {
            throw new cMsgException("parseUDL: must specify the destination CODA component name");
        }
        this.destComponentName = udlDestName;
        System.out.println("dest component = " + udlDestName);
        if (remainder == null) {
            throw new cMsgException("parseUDL: must specify the CODA id");
        }
        pattern = Pattern.compile("[\\?]codaId=([0-9]+)", 2);
        matcher = pattern.matcher(remainder);
        if (matcher.find()) {
            try {
                this.codaID = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new cMsgException("parseUDL: improper CODA id", e);
            }
        } else {
            throw new cMsgException("parseUDL: must specify the CODA id");
        }
        System.out.println("CODA id = " + this.codaID);
        pattern = Pattern.compile("[\\?&]timeout=([0-9]+)", 2);
        matcher = pattern.matcher(remainder);
        if (matcher.find()) {
            try {
                this.multicastTimeout = 1000 * Integer.parseInt(matcher.group(1));
                System.out.println("timeout = " + this.multicastTimeout / 1000 + " seconds");
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]bufSize=([0-9]+)", 2)).matcher(remainder)).find()) {
            try {
                int mSize = Integer.parseInt(matcher.group(1));
                if (mSize > 0) {
                    this.maxSize = mSize;
                }
                System.out.println("max data buffer size = " + this.maxSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]tcpSend=([0-9]+)", 2)).matcher(remainder)).find()) {
            try {
                this.tcpSendBufferSize = Integer.parseInt(matcher.group(1));
                if (this.tcpSendBufferSize == 0) {
                    this.tcpSendBufferSize = this.maxSize + 1024;
                }
                System.out.println("tcp send buffer size = " + this.tcpSendBufferSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]subnet=((?:[0-9]{1,3}\\.){3}[0-9]{1,3})", 2)).matcher(remainder)).find()) {
            try {
                this.preferredSubnet = matcher.group(1);
                if (cMsgUtilities.isDottedDecimal(this.preferredSubnet) == null) {
                    this.preferredSubnet = null;
                }
                System.out.println("Emu client: preferred subnet = " + this.preferredSubnet);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]sockets=([0-9]+)", 2)).matcher(remainder)).find()) {
            try {
                this.socketCount = Integer.parseInt(matcher.group(1));
                if (this.socketCount < 1) {
                    this.socketCount = 1;
                }
                System.out.println("socket count = " + this.socketCount);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("[\\?&]noDelay", 2)).matcher(remainder)).find()) {
            try {
                this.tcpNoDelay = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush(int timeout) throws cMsgException {
        try {
            for (int i = 0; i < this.socketCount; ++i) {
                this.domainOut[i].flush();
            }
        }
        catch (IOException e) {
            throw new cMsgException(e);
        }
    }

    @Override
    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        for (int i = 0; i < this.socketCount; ++i) {
            try {
                this.domainOut[i].flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.tcpSocket[i].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.domainOut[i].close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.multicastUdpSocket != null) {
            this.multicastUdpSocket.close();
        }
    }

    @Override
    public void send(cMsgMessage message) throws cMsgException {
        int sendIndex = message.getSysMsgId();
        int binaryLength = message.getByteArrayLength();
        if (!this.connected) {
            throw new cMsgException("not connected to server");
        }
        try {
            this.domainOut[sendIndex].writeLong((long)message.getUserInt() << 32 | (long)binaryLength & 0xFFFFFFFFL);
            if (binaryLength > 0) {
                this.domainOut[sendIndex].write(message.getByteArray(), message.getByteArrayOffset(), binaryLength);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException e) {
            e.printStackTrace();
            if (this.debug >= 2) {
                System.out.println("send: " + e.getMessage());
            }
            throw new cMsgException(e);
        }
    }

    class Multicaster
    extends Thread {
        DatagramPacket packet;

        Multicaster(DatagramPacket udpPacket) {
            this.packet = udpPacket;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
                while (true) {
                    int sleepCount = 0;
                    try {
                        Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                        while (enumer.hasMoreElements()) {
                            NetworkInterface ni = enumer.nextElement();
                            if (!ni.isUp()) continue;
                            System.out.println("Emu client: sending mcast packet over " + ni.getName());
                            EmuClient.this.multicastUdpSocket.setNetworkInterface(ni);
                            EmuClient.this.multicastUdpSocket.send(this.packet);
                            Thread.sleep(200L);
                            ++sleepCount;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (sleepCount >= true) continue;
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    class MulticastReceiver
    extends Thread {
        MulticastReceiver() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            byte[] buf = new byte[1024];
            DatagramPacket packet = new DatagramPacket(buf, 1024);
            int lengthOfInts = 20;
            block6: while (true) {
                packet.setLength(1024);
                int index = 0;
                try {
                    EmuClient.this.multicastUdpSocket.receive(packet);
                    if (packet.getLength() < lengthOfInts) {
                        if (EmuClient.this.debug < 3) continue;
                        System.out.println("Multicast receiver: got packet that's too small");
                        continue;
                    }
                    int magic1 = cMsgUtilities.bytesToInt(buf, index);
                    int magic2 = cMsgUtilities.bytesToInt(buf, index += 4);
                    int magic3 = cMsgUtilities.bytesToInt(buf, index += 4);
                    index += 4;
                    if (magic1 != cMsgNetworkConstants.magicNumbers[0] || magic2 != cMsgNetworkConstants.magicNumbers[1] || magic3 != cMsgNetworkConstants.magicNumbers[2]) {
                        if (EmuClient.this.debug < 3) continue;
                        System.out.println("Multicast receiver: got bad magic # response to multicast");
                        continue;
                    }
                    EmuClient.this.tcpServerPort = cMsgUtilities.bytesToInt(buf, index);
                    index += 4;
                    if (EmuClient.this.tcpServerPort < 1024 || EmuClient.this.tcpServerPort > 65535) {
                        if (EmuClient.this.debug < 3) continue;
                        System.out.println("Multicast receiver: got bad tcp port value (" + EmuClient.this.tcpServerPort + ")");
                        continue;
                    }
                    int addressCount = cMsgUtilities.bytesToInt(buf, index);
                    index += 4;
                    if (addressCount < 1) {
                        if (EmuClient.this.debug < 3) continue;
                        System.out.println("Multicast receiver: got bad # of addresses (" + addressCount + ")");
                        continue;
                    }
                    int totalLen = lengthOfInts;
                    for (int i = 0; i < addressCount; ++i) {
                        if (packet.getLength() < (totalLen += 4)) {
                            if (EmuClient.this.debug < 3) continue;
                            System.out.println("Multicast receiver: got packet that's too small");
                            continue;
                        }
                        int len = cMsgUtilities.bytesToInt(buf, index);
                        index += 4;
                        if (len < 7) {
                            if (EmuClient.this.debug < 3) continue block6;
                            System.out.println("Multicast receiver: got length that's too small");
                            continue block6;
                        }
                        if (packet.getLength() < (totalLen += len)) {
                            if (EmuClient.this.debug < 3) continue block6;
                            System.out.println("Multicast receiver: got packet that's too small");
                            continue block6;
                        }
                        String ip = new String(buf, index, len, "US-ASCII");
                        index += len;
                        EmuClient.this.ipAddresses.add(ip);
                        if (packet.getLength() < (totalLen += 4)) {
                            if (EmuClient.this.debug < 3) continue;
                            System.out.println("Multicast receiver: got packet that's too small");
                            continue;
                        }
                        len = cMsgUtilities.bytesToInt(buf, index);
                        index += 4;
                        if (len < 7) {
                            if (EmuClient.this.debug < 3) continue block6;
                            System.out.println("Multicast receiver: got length that's too small");
                            continue block6;
                        }
                        if (packet.getLength() < (totalLen += len)) {
                            if (EmuClient.this.debug < 3) continue block6;
                            System.out.println("Multicast receiver: got packet that's too small");
                            continue block6;
                        }
                        ip = new String(buf, index, len, "US-ASCII");
                        index += len;
                        EmuClient.this.broadcastAddresses.add(ip);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Got IOException in multicast receive, exiting");
                    return;
                }
                catch (Exception e) {
                    continue;
                }
                break;
            }
            EmuClient.this.multicastResponse.countDown();
        }
    }
}

