/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class etTest2 {
    int size;
    int port;
    String host;
    DataInputStream in;
    DataOutputStream out;
    byte[] buffer;

    etTest2(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                etTest2.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-size")) {
                this.size = Integer.parseInt(args[i + 1]);
                if (this.size < 1) {
                    System.out.println("size must be in valid range");
                    etTest2.usage();
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-port")) {
                this.port = Integer.parseInt(args[i + 1]);
                if (this.port < 1024 || this.port > 65535) {
                    System.out.println("port must be in valid range");
                    etTest2.usage();
                    System.exit(-1);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-host")) {
                this.host = args[i + 1];
                ++i;
                continue;
            }
            etTest2.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java etTest\n        [-size <size>]      size (bytes) of amount of data to send server\n        [-port <port>]      server port to connect to\n        [-host <host>]      server host to connect to\n        [-h]                print this help\n");
    }

    public static void main(String[] args) {
        etTest2 tp = new etTest2(args);
        tp.run();
    }

    private static String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    private void readData() throws IOException {
        this.out.writeInt(1);
        this.out.writeInt(this.size);
        this.out.flush();
        this.in.readFully(this.buffer);
    }

    private void writeData() throws IOException {
        this.out.writeInt(2);
        this.out.writeInt(this.size);
        this.out.write(this.buffer);
        this.out.flush();
    }

    public void run() {
        double freq = 0.0;
        double freqAvg = 0.0;
        long totalT = 0L;
        long totalC = 0L;
        long ignore = 0L;
        try {
            this.buffer = new byte[this.size];
            if (this.host == null) {
                this.host = InetAddress.getLocalHost().getCanonicalHostName();
            }
            System.out.println("Try to connect to server on " + this.host + " at port " + this.port + " with size " + this.size);
            Socket socket = new Socket(this.host, this.port);
            socket.setTcpNoDelay(true);
            socket.setSendBufferSize(131072);
            this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream(), 131072));
            this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 131072));
            while (true) {
                long count = 0L;
                long t1 = System.currentTimeMillis();
                do {
                    this.readData();
                    this.writeData();
                } while ((count += (long)this.size) <= 1000000000L);
                long t2 = System.currentTimeMillis();
                if (ignore == 0L) {
                    long deltaT = t2 - t1;
                    freq = (double)count / (double)deltaT * 1000.0;
                    freqAvg = (double)(totalC += count) / (double)(totalT += deltaT) * 1000.0;
                    System.out.println(etTest2.doubleToString(freq, 1) + " Hz, Avg = " + etTest2.doubleToString(freqAvg, 1) + " Hz");
                    continue;
                }
                --ignore;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

