/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;

public class VardanProducer {
    private String subject = "SUBJECT\"";
    private String type = "TYPE";
    private String name = "VardanProducer";
    private String description = "java consumer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private boolean debug;
    private long count;
    private int delay;
    private int loops = 300;
    private long time1;
    private long time2;

    VardanProducer(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                VardanProducer.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                this.delay = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            VardanProducer.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java VardanProducer\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-debug]             turn on printout\n        [-delay]             time in millisec to wait between sends\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            VardanProducer consumer = new VardanProducer(args);
            consumer.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private String doubleToString(double d, int places) {
        if (places < 0) {
            places = 0;
        }
        double factor = Math.pow(10.0, places);
        String s = "" + (double)Math.round(d * factor) / factor;
        if (places == 0) {
            return s.substring(0, s.length() - 2);
        }
        while (s.length() - s.indexOf(".") < places + 1) {
            s = s + "0";
        }
        return s;
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg consumer subscribed to:\n    subject = " + this.subject + "\n    type    = " + this.type);
        }
        cMsg coda = new cMsg(this.UDL, this.name, this.description);
        coda.setDebug(2);
        cMsgMessage msg = new cMsgMessage();
        msg.setSubject(this.subject);
        msg.setType(this.type);
        double freq = 0.0;
        double freqAvg = 0.0;
        long totalT = 0L;
        long totalC = 0L;
        long ignore = 0L;
        while (true) {
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < this.loops; ++i) {
                System.out.println("Will connect");
                coda.connect();
                System.out.println("Will send");
                coda.send(msg);
                System.out.println("Will disconnect");
                coda.disconnect();
                System.out.println("Will wait");
                if (this.delay == 0) continue;
                try {
                    Thread.sleep(this.delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            long t2 = System.currentTimeMillis();
            if (ignore == 0L) {
                long deltaT = t2 - t1;
                freq = (double)this.loops / (double)deltaT * 1000.0;
                freqAvg = (double)(totalC += (long)this.loops) / (double)(totalT += deltaT) * 1000.0;
                if (!this.debug) continue;
                System.out.println("Sending at " + this.doubleToString(freq, 1) + " Hz, Avg = " + this.doubleToString(freqAvg, 1) + " Hz");
                continue;
            }
            --ignore;
        }
    }
}

