/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.remoteExec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.remoteExec.ArgType;
import org.jlab.coda.cMsg.remoteExec.CommandType;
import org.jlab.coda.cMsg.remoteExec.ExecutorSecurity;
import org.jlab.coda.cMsg.remoteExec.IExecutorThread;
import org.jlab.coda.cMsg.remoteExec.InfoType;

public class Executor {
    private String password;
    private AtomicInteger uniqueId = new AtomicInteger(1);
    private String udl;
    private String name;
    private cMsg cmsgConnection;
    private Hashtable<Integer, CommandInfo> processMap = new Hashtable(100);
    private Hashtable<Integer, CommandInfo> threadMap = new Hashtable(100);
    private cMsgMessage statusMsg;

    public Executor(String password, String udl, String name) throws cMsgException {
        String host;
        if (udl == null) {
            throw new cMsgException("Need to specify a udl");
        }
        if (password != null && password.length() > 16) {
            throw new cMsgException("Password must be <= 16 characters");
        }
        this.udl = udl;
        this.password = password;
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new cMsgException("Cannot find our own hostname", e);
        }
        this.name = name != null ? name : host;
        try {
            Process pr = Runtime.getRuntime().exec("uname -s");
            BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String os = br.readLine();
            pr = Runtime.getRuntime().exec("uname -m");
            br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String machine = br.readLine();
            pr = Runtime.getRuntime().exec("uname -p");
            br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String processor = br.readLine();
            pr = Runtime.getRuntime().exec("uname -r");
            br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String release = br.readLine();
            try {
                this.statusMsg = new cMsgMessage();
                this.statusMsg.setHistoryLengthMax(0);
                this.statusMsg.setSubject(".all");
                this.statusMsg.setType("cMsgRemoteExec");
                cMsgPayloadItem item0 = new cMsgPayloadItem("returnType", InfoType.REPORTING.getValue());
                this.statusMsg.addPayloadItem(item0);
                cMsgPayloadItem item1 = new cMsgPayloadItem("name", this.name);
                this.statusMsg.addPayloadItem(item1);
                cMsgPayloadItem item2 = new cMsgPayloadItem("os", os);
                this.statusMsg.addPayloadItem(item2);
                cMsgPayloadItem item3 = new cMsgPayloadItem("machine", machine);
                this.statusMsg.addPayloadItem(item3);
                cMsgPayloadItem item4 = new cMsgPayloadItem("processor", processor);
                this.statusMsg.addPayloadItem(item4);
                cMsgPayloadItem item5 = new cMsgPayloadItem("release", release);
                this.statusMsg.addPayloadItem(item5);
                cMsgPayloadItem item6 = new cMsgPayloadItem("host", host);
                this.statusMsg.addPayloadItem(item6);
            }
            catch (cMsgException cMsgException2) {}
        }
        catch (IOException e) {
            throw new cMsgException(e);
        }
        new CmsgConnectionHandler();
    }

    private void sendStatusTo(String commander) throws cMsgException {
        this.statusMsg.setSubject(commander);
        this.cmsgConnection.send(this.statusMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAll(boolean kill) {
        Hashtable<Integer, CommandInfo> hashtable = this.processMap;
        synchronized (hashtable) {
            for (CommandInfo info : this.processMap.values()) {
                if (kill) {
                    info.killed.set(true);
                } else {
                    info.stopped.set(true);
                }
                info.process.destroy();
            }
        }
        hashtable = this.threadMap;
        synchronized (hashtable) {
            for (CommandInfo info : this.threadMap.values()) {
                if (kill) {
                    info.killed.set(true);
                } else {
                    info.stopped.set(true);
                }
                info.execThread.shutItDown();
            }
        }
    }

    private void stop(int id) {
        CommandInfo info = this.processMap.get(id);
        if (info == null) {
            info = this.threadMap.get(id);
        }
        if (info == null) {
            return;
        }
        info.stopped.set(true);
        if (info.isProcess) {
            info.process.destroy();
        } else {
            info.execThread.shutItDown();
        }
    }

    private String getProcessOutput(InputStream inputStream) {
        StringBuilder sb = new StringBuilder(300);
        BufferedReader brErr = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = brErr.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            System.out.println("startProcess: io error gathering (error) output");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    private String[] gatherAllOutput(Process process, cMsgMessage msg, boolean monitor) {
        cMsgPayloadItem item2;
        String output;
        String[] strs = new String[2];
        if (monitor && (output = this.getProcessOutput(process.getInputStream())) != null) {
            strs[0] = output;
            try {
                item2 = new cMsgPayloadItem("output", output);
                msg.addPayloadItem(item2);
            }
            catch (cMsgException item2) {
                // empty catch block
            }
        }
        if ((output = this.getProcessOutput(process.getErrorStream())) != null) {
            strs[1] = output;
            try {
                item2 = new cMsgPayloadItem("error", output);
                msg.addPayloadItem(item2);
                cMsgPayloadItem item1 = new cMsgPayloadItem("immediateError", 0);
                msg.addPayloadItem(item1);
            }
            catch (cMsgException cMsgException2) {
                // empty catch block
            }
        }
        return strs;
    }

    private static String[] decodeCommandLine(String[] args) {
        String[] stuff = new String[3];
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-n")) {
                stuff[2] = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                stuff[1] = args[i + 1];
                ++i;
                continue;
            }
            if (!args[i].equalsIgnoreCase("-p")) continue;
            stuff[0] = args[i + 1];
            ++i;
        }
        return stuff;
    }

    public static void main(String[] args) {
        try {
            String[] arggs = Executor.decodeCommandLine(args);
            System.out.println("Starting Executor with:\n  password = " + arggs[0] + "\n  name = " + arggs[2] + "\n  udl = " + arggs[1]);
            new Executor(arggs[0], arggs[1], arggs[2]);
            try {
                while (true) {
                    Thread.sleep(2000L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
            return;
        }
    }

    private class ThreadRun
    extends Thread {
        private int id;
        private CommandInfo info;
        private cMsgMessage responseMsg;

        ThreadRun(CommandInfo info, cMsgMessage responseMsg) {
            this.info = info;
            this.responseMsg = responseMsg;
        }

        @Override
        public void run() {
            this.startThread();
        }

        private Object createObjectFromMessage(cMsgMessage msg, String className) throws cMsgException {
            Object returnObject;
            try {
                Class<?> c = Class.forName(className);
                Constructor<?> conn = c.getConstructor(new Class[0]);
                if (msg == null) {
                    returnObject = conn.newInstance(new Object[0]);
                } else {
                    int numArgs = msg.getUserInt();
                    Class[] parameterTypes = new Class[numArgs];
                    Class[] argClasses = new Class[numArgs];
                    Object[] args = new Object[numArgs];
                    cMsgPayloadItem classesItem = msg.getPayloadItem("classes");
                    cMsgPayloadItem argsTypesItem = msg.getPayloadItem("argTypes");
                    if (classesItem == null || argsTypesItem == null) {
                        throw new cMsgException("Protocol violation: classes and/or types arrays null");
                    }
                    String[] classNames = classesItem.getStringArray();
                    int[] argTypeValues = argsTypesItem.getIntArray();
                    if (classNames.length < numArgs || argTypeValues.length < numArgs) {
                        throw new cMsgException("Protocol violation: too few classes and/or types");
                    }
                    ArgType[] argTypes = new ArgType[numArgs];
                    int numStringArgs = 0;
                    int numMessageArgs = 0;
                    for (int i = 0; i < numArgs; ++i) {
                        ArgType aType = ArgType.getArgType(argTypeValues[i]);
                        if (aType == null) {
                            throw new cMsgException("Protocol violation: bad arg type value");
                        }
                        if (aType == ArgType.PRIMITIVE) {
                            ++numStringArgs;
                        } else if (aType == ArgType.REFERENCE) {
                            ++numMessageArgs;
                        }
                        argTypes[i] = aType;
                        if (classNames[i].equals("int")) {
                            parameterTypes[i] = Integer.TYPE;
                            argClasses[i] = Integer.class;
                            continue;
                        }
                        if (classNames[i].equals("boolean")) {
                            parameterTypes[i] = Boolean.TYPE;
                            argClasses[i] = Boolean.class;
                            continue;
                        }
                        if (classNames[i].equals("byte")) {
                            parameterTypes[i] = Byte.TYPE;
                            argClasses[i] = Byte.class;
                            continue;
                        }
                        if (classNames[i].equals("short")) {
                            parameterTypes[i] = Short.TYPE;
                            argClasses[i] = Short.class;
                            continue;
                        }
                        if (classNames[i].equals("long")) {
                            parameterTypes[i] = Long.TYPE;
                            argClasses[i] = Long.class;
                            continue;
                        }
                        if (classNames[i].equals("float")) {
                            parameterTypes[i] = Float.TYPE;
                            argClasses[i] = Float.class;
                            continue;
                        }
                        if (classNames[i].equals("double")) {
                            parameterTypes[i] = Double.TYPE;
                            argClasses[i] = Double.class;
                            continue;
                        }
                        if (classNames[i].equals("char")) {
                            parameterTypes[i] = Character.TYPE;
                            argClasses[i] = Character.class;
                            continue;
                        }
                        parameterTypes[i] = Class.forName(classNames[i]);
                        argClasses[i] = parameterTypes[i];
                    }
                    cMsgPayloadItem stringValuesItem = msg.getPayloadItem("stringArgs");
                    cMsgPayloadItem messageValuesItem = msg.getPayloadItem("messageArgs");
                    if (numStringArgs > 0 && (stringValuesItem == null || stringValuesItem.getCount() < numStringArgs)) {
                        throw new cMsgException("Protocol violation: string and/or message value arrays null");
                    }
                    if (numMessageArgs > 0 && (messageValuesItem == null || messageValuesItem.getCount() < numMessageArgs)) {
                        throw new cMsgException("Protocol violation: too few string and/or message values");
                    }
                    String[] stringArgs = null;
                    cMsgMessage[] msgArgs = null;
                    if (numStringArgs > 0) {
                        stringArgs = stringValuesItem.getStringArray();
                    }
                    if (numMessageArgs > 0) {
                        msgArgs = messageValuesItem.getMessageArray();
                    }
                    int stringArgIndex = 0;
                    int messageArgIndex = 0;
                    Class[] stringParam = new Class[]{String.class};
                    Class[] charParam = new Class[]{Character.class};
                    Object[] singleArg = new Object[1];
                    block10: for (int i = 0; i < numArgs; ++i) {
                        switch (argTypes[i]) {
                            case PRIMITIVE: {
                                Constructor con = argClasses[i].getConstructor(stringParam);
                                singleArg[0] = stringArgs[stringArgIndex++];
                                args[i] = con.newInstance(singleArg);
                                continue block10;
                            }
                            case PRIMITIVE_CHAR: {
                                Constructor con = argClasses[i].getConstructor(charParam);
                                singleArg[0] = Character.valueOf((char)Integer.parseInt(stringArgs[stringArgIndex++]));
                                args[i] = con.newInstance(singleArg);
                                continue block10;
                            }
                            case REFERENCE: {
                                Object argObject;
                                cMsgMessage argMsg = msgArgs[messageArgIndex++];
                                args[i] = argObject = this.createObjectFromMessage(argMsg, classNames[i]);
                                continue block10;
                            }
                            case REFERENCE_NOARG: {
                                args[i] = argClasses[i].getConstructor(new Class[0]).newInstance(new Object[0]);
                                continue block10;
                            }
                            case NULL: {
                                args[i] = null;
                                continue block10;
                            }
                        }
                    }
                    Constructor<?> co = c.getConstructor(parameterTypes);
                    returnObject = co.newInstance(args);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new cMsgException(e);
            }
            return returnObject;
        }

        private void startThread() {
            cMsgPayloadItem item2;
            IExecutorThread eThread;
            try {
                eThread = (IExecutorThread)this.createObjectFromMessage(this.info.argsMessage, this.info.className);
            }
            catch (cMsgException e) {
                e.printStackTrace();
                try {
                    cMsgPayloadItem item1 = new cMsgPayloadItem("terminated", 1);
                    this.responseMsg.addPayloadItem(item1);
                    cMsgPayloadItem item2 = new cMsgPayloadItem("error", e.getMessage());
                    this.responseMsg.addPayloadItem(item2);
                    cMsgPayloadItem item3 = new cMsgPayloadItem("immediateError", 1);
                    this.responseMsg.addPayloadItem(item3);
                    Executor.this.cmsgConnection.send(this.responseMsg);
                }
                catch (cMsgException item1) {
                    // empty catch block
                }
                return;
            }
            eThread.startItUp();
            int id = Executor.this.uniqueId.incrementAndGet();
            try {
                item2 = new cMsgPayloadItem("id", id);
                this.responseMsg.addPayloadItem(item2);
            }
            catch (cMsgException item2) {
                // empty catch block
            }
            this.info.execThread = eThread;
            Executor.this.threadMap.put(id, this.info);
            if (!this.info.wait) {
                try {
                    Executor.this.cmsgConnection.send(this.responseMsg);
                }
                catch (cMsgException item2) {
                    // empty catch block
                }
            }
            try {
                eThread.waitUntilDone();
            }
            catch (InterruptedException item2) {
                // empty catch block
            }
            try {
                item2 = new cMsgPayloadItem("terminated", 1);
                this.responseMsg.addPayloadItem(item2);
            }
            catch (cMsgException item3) {
                // empty catch block
            }
            if (this.info.killed.get()) {
                try {
                    item2 = new cMsgPayloadItem("killed", 1);
                    this.responseMsg.addPayloadItem(item2);
                }
                catch (cMsgException item4) {}
            } else if (this.info.stopped.get()) {
                try {
                    item2 = new cMsgPayloadItem("stopped", 1);
                    this.responseMsg.addPayloadItem(item2);
                }
                catch (cMsgException item5) {
                    // empty catch block
                }
            }
            try {
                if (this.info.wait) {
                    Executor.this.cmsgConnection.send(this.responseMsg);
                    return;
                }
                Executor.this.threadMap.remove(id);
                cMsgMessage imDoneMsg = new cMsgMessage();
                imDoneMsg.setSubject(this.info.commander);
                imDoneMsg.setType("cMsgRemoteExec");
                cMsgPayloadItem item1 = new cMsgPayloadItem("returnType", InfoType.THREAD_END.getValue());
                imDoneMsg.addPayloadItem(item1);
                cMsgPayloadItem item2 = new cMsgPayloadItem("id", this.info.commandId);
                imDoneMsg.addPayloadItem(item2);
                if (this.info.killed.get()) {
                    try {
                        cMsgPayloadItem item6 = new cMsgPayloadItem("killed", 1);
                        imDoneMsg.addPayloadItem(item6);
                    }
                    catch (cMsgException item6) {}
                } else if (this.info.stopped.get()) {
                    try {
                        cMsgPayloadItem item7 = new cMsgPayloadItem("stopped", 1);
                        imDoneMsg.addPayloadItem(item7);
                    }
                    catch (cMsgException cMsgException2) {
                        // empty catch block
                    }
                }
                Executor.this.cmsgConnection.send(imDoneMsg);
            }
            catch (cMsgException cMsgException3) {
                // empty catch block
            }
        }
    }

    private class ProcessRun
    extends Thread {
        private CommandInfo info;
        private cMsgMessage responseMsg;

        ProcessRun(CommandInfo info, cMsgMessage responseMsg) {
            this.info = info;
            this.responseMsg = responseMsg;
        }

        @Override
        public void run() {
            this.startProcess();
        }

        private void startProcess() {
            cMsgPayloadItem item4;
            cMsgPayloadItem item23;
            Process process;
            try {
                process = Runtime.getRuntime().exec(this.info.command);
                Thread.yield();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception e) {
                try {
                    cMsgPayloadItem item1 = new cMsgPayloadItem("terminated", 1);
                    this.responseMsg.addPayloadItem(item1);
                    cMsgPayloadItem item22 = new cMsgPayloadItem("error", e.getMessage());
                    this.responseMsg.addPayloadItem(item22);
                    cMsgPayloadItem item3 = new cMsgPayloadItem("immediateError", 1);
                    this.responseMsg.addPayloadItem(item3);
                    Executor.this.cmsgConnection.send(this.responseMsg);
                }
                catch (cMsgException item1) {
                    // empty catch block
                }
                return;
            }
            boolean terminated = true;
            try {
                process.exitValue();
            }
            catch (Exception e) {
                terminated = false;
            }
            int id = 0;
            if (!terminated) {
                id = Executor.this.uniqueId.incrementAndGet();
                try {
                    item23 = new cMsgPayloadItem("id", id);
                    this.responseMsg.addPayloadItem(item23);
                }
                catch (cMsgException item3) {
                    // empty catch block
                }
                this.info.process = process;
                Executor.this.processMap.put(id, this.info);
            }
            if (!this.info.wait) {
                try {
                    if (terminated) {
                        cMsgPayloadItem item1 = new cMsgPayloadItem("terminated", 1);
                        this.responseMsg.addPayloadItem(item1);
                        Executor.this.gatherAllOutput(process, this.responseMsg, this.info.monitor);
                    }
                    Executor.this.cmsgConnection.send(this.responseMsg);
                }
                catch (cMsgException item1) {
                    // empty catch block
                }
            }
            try {
                item23 = new cMsgPayloadItem("terminated", 1);
                this.responseMsg.addPayloadItem(item23);
            }
            catch (cMsgException item23) {
                // empty catch block
            }
            String[] stringsOut = Executor.this.gatherAllOutput(process, this.responseMsg, this.info.monitor);
            if (this.info.killed.get()) {
                try {
                    item4 = new cMsgPayloadItem("killed", 1);
                    this.responseMsg.addPayloadItem(item4);
                }
                catch (cMsgException item4) {}
            } else if (this.info.stopped.get()) {
                try {
                    item4 = new cMsgPayloadItem("stopped", 1);
                    this.responseMsg.addPayloadItem(item4);
                }
                catch (cMsgException item5) {
                    // empty catch block
                }
            }
            Executor.this.processMap.remove(id);
            try {
                cMsgPayloadItem item6;
                if (this.info.wait) {
                    Executor.this.cmsgConnection.send(this.responseMsg);
                    return;
                }
                cMsgMessage imDoneMsg = new cMsgMessage();
                imDoneMsg.setSubject(this.info.commander);
                imDoneMsg.setType("cMsgRemoteExec");
                cMsgPayloadItem item1 = new cMsgPayloadItem("returnType", InfoType.PROCESS_END.getValue());
                imDoneMsg.addPayloadItem(item1);
                cMsgPayloadItem item24 = new cMsgPayloadItem("id", this.info.commandId);
                imDoneMsg.addPayloadItem(item24);
                if (stringsOut[0] != null && this.info.monitor) {
                    item6 = new cMsgPayloadItem("output", stringsOut[0]);
                    imDoneMsg.addPayloadItem(item6);
                }
                if (stringsOut[1] != null) {
                    item6 = new cMsgPayloadItem("error", stringsOut[1]);
                    imDoneMsg.addPayloadItem(item6);
                }
                if (this.info.killed.get()) {
                    try {
                        item6 = new cMsgPayloadItem("killed", 1);
                        imDoneMsg.addPayloadItem(item6);
                    }
                    catch (cMsgException item7) {}
                } else if (this.info.stopped.get()) {
                    try {
                        item6 = new cMsgPayloadItem("stopped", 1);
                        imDoneMsg.addPayloadItem(item6);
                    }
                    catch (cMsgException cMsgException2) {
                        // empty catch block
                    }
                }
                Executor.this.cmsgConnection.send(imDoneMsg);
            }
            catch (cMsgException cMsgException3) {
                // empty catch block
            }
        }
    }

    private class CommandCallback
    extends cMsgCallbackAdapter {
        private CommandCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            if (msg.hasPayload()) {
                String passwd = null;
                try {
                    cMsgPayloadItem item = msg.getPayloadItem("p");
                    if (item != null) {
                        passwd = ExecutorSecurity.decrypt(item.getString());
                    }
                    if (Executor.this.password != null && !Executor.this.password.equals(passwd)) {
                        System.out.println("Reject message, wrong password");
                        return;
                    }
                    item = msg.getPayloadItem("commandType");
                    if (item == null) {
                        System.out.println("Reject message, no command type");
                        return;
                    }
                    String commandType = item.getString();
                    CommandType type = CommandType.getCommandType(commandType);
                    if (type == null) {
                        System.out.println("Reject message, command type not recognized");
                        return;
                    }
                    switch (type) {
                        case START_PROCESS: {
                            if (!msg.isGetRequest()) {
                                System.out.println("Reject message, start_process cmd must be sendAndGet msg");
                                return;
                            }
                            CommandInfo commandInfo = new CommandInfo();
                            commandInfo.isProcess = true;
                            item = msg.getPayloadItem("command");
                            if (item == null) {
                                System.out.println("Reject message, no command");
                                return;
                            }
                            commandInfo.command = ExecutorSecurity.decrypt(item.getString());
                            item = msg.getPayloadItem("monitor");
                            boolean monitor = false;
                            if (item != null) {
                                monitor = item.getInt() != 0;
                            }
                            commandInfo.monitor = monitor;
                            item = msg.getPayloadItem("wait");
                            boolean wait = false;
                            if (item != null) {
                                wait = item.getInt() != 0;
                            }
                            commandInfo.wait = wait;
                            item = msg.getPayloadItem("commander");
                            if (item == null) {
                                System.out.println("Reject message, no commander");
                                return;
                            }
                            commandInfo.commander = item.getString();
                            item = msg.getPayloadItem("id");
                            if (item == null) {
                                System.out.println("Reject message, no commander id");
                                return;
                            }
                            commandInfo.commandId = item.getInt();
                            ProcessRun pr = new ProcessRun(commandInfo, msg.response());
                            pr.start();
                            break;
                        }
                        case START_THREAD: {
                            if (!msg.isGetRequest()) {
                                System.out.println("Reject message, start_thread cmd must be sendAndGet msg");
                                return;
                            }
                            CommandInfo commandInfo = new CommandInfo();
                            commandInfo.monitor = false;
                            commandInfo.isProcess = false;
                            item = msg.getPayloadItem("className");
                            if (item == null || item.getString() == null) {
                                System.out.println("Reject message, no class name");
                                return;
                            }
                            commandInfo.className = ExecutorSecurity.decrypt(item.getString());
                            item = msg.getPayloadItem("wait");
                            boolean wait = false;
                            if (item != null) {
                                wait = item.getInt() != 0;
                            }
                            commandInfo.wait = wait;
                            item = msg.getPayloadItem("commander");
                            if (item == null) {
                                System.out.println("Reject message, no commander");
                                return;
                            }
                            commandInfo.commander = item.getString();
                            item = msg.getPayloadItem("id");
                            if (item == null) {
                                System.out.println("Reject message, no commander id");
                                return;
                            }
                            commandInfo.commandId = item.getInt();
                            item = msg.getPayloadItem("args");
                            if (item != null) {
                                commandInfo.argsMessage = item.getMessage();
                            }
                            ThreadRun tr = new ThreadRun(commandInfo, msg.response());
                            tr.start();
                            break;
                        }
                        case STOP_ALL: {
                            Executor.this.stopAll(false);
                            break;
                        }
                        case STOP: {
                            item = msg.getPayloadItem("id");
                            if (item == null) {
                                System.out.println("Reject message, no id");
                                return;
                            }
                            Executor.this.stop(item.getInt());
                            break;
                        }
                        case DIE: {
                            item = msg.getPayloadItem("killProcesses");
                            boolean killProcesses = false;
                            if (item != null) {
                                boolean bl = killProcesses = item.getInt() != 0;
                            }
                            if (killProcesses) {
                                Executor.this.stopAll(true);
                            }
                            System.exit(0);
                            break;
                        }
                        case IDENTIFY: {
                            item = msg.getPayloadItem("commander");
                            if (item == null) {
                                System.out.println("Reject message, no commander");
                                return;
                            }
                            String commander = item.getString();
                            Executor.this.sendStatusTo(commander);
                            break;
                        }
                    }
                }
                catch (cMsgException e) {
                    System.out.println("Reject message, bad format");
                }
            } else {
                System.out.println("Reject message, no payload");
            }
        }
    }

    private class CmsgConnectionHandler
    extends Thread {
        CmsgConnectionHandler() {
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (Executor.this.cmsgConnection != null && Executor.this.cmsgConnection.isConnected()) continue;
                try {
                    Executor.this.cmsgConnection = new cMsg(Executor.this.udl, Executor.this.name, "cmsg java executor");
                    Executor.this.cmsgConnection.connect();
                    CommandCallback cb3 = new CommandCallback();
                    Executor.this.cmsgConnection.subscribe("cMsgRemoteExec", Executor.this.name, cb3, null);
                    Executor.this.cmsgConnection.subscribe("cMsgRemoteExec", ".all", cb3, null);
                    Executor.this.cmsgConnection.start();
                    Executor.this.sendStatusTo(".all");
                }
                catch (cMsgException cMsgException2) {
                }
            }
        }
    }

    private class CommandInfo {
        IExecutorThread execThread;
        Process process;
        String className;
        String command;
        String commander;
        int commandId;
        boolean monitor;
        boolean wait;
        boolean isProcess;
        AtomicBoolean killed = new AtomicBoolean();
        AtomicBoolean stopped = new AtomicBoolean();
        cMsgMessage argsMessage;

        private CommandInfo() {
        }
    }
}

