/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.remoteExec;

import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.remoteExec.CallbackState;
import org.jlab.coda.cMsg.remoteExec.CommandCallback;
import org.jlab.coda.cMsg.remoteExec.Commander;
import org.jlab.coda.cMsg.remoteExec.ExecutorInfo;

public class CommandReturn {
    private int id;
    private int executorId;
    private String errorOutput;
    private String regularOutput;
    private boolean error;
    private boolean terminated;
    private CommandCallback processCallback;
    private Object userObject;
    private CallbackState callbackState;
    private boolean locked;
    private Commander commander;
    private ExecutorInfo executor;

    CommandReturn(Commander commander, ExecutorInfo executor, CallbackState callbackState) {
        this.executor = executor;
        this.commander = commander;
        this.callbackState = callbackState;
    }

    CommandReturn(Commander commander, ExecutorInfo executor, int id, int processId, boolean error, boolean terminated, String regularOutput, String errorOutput) {
        this.executor = executor;
        this.commander = commander;
        this.setValues(id, processId, error, terminated, regularOutput, errorOutput);
    }

    public synchronized void setValues(int id, int processId, boolean error, boolean terminated, String regularOutput, String errorOutput) {
        if (this.locked) {
            return;
        }
        if (errorOutput != null) {
            error = true;
        }
        this.id = id;
        this.executorId = processId;
        this.error = error;
        this.terminated = terminated;
        this.regularOutput = regularOutput;
        this.errorOutput = errorOutput;
    }

    public void stop() {
        try {
            this.commander.stop(this.executor, this.id);
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
    }

    public synchronized boolean isLocked() {
        return this.locked;
    }

    synchronized void lock() {
        this.locked = true;
    }

    public synchronized void registerCallback(CommandCallback processCallback, Object userObject) {
        this.userObject = userObject;
        this.processCallback = processCallback;
    }

    public synchronized void unregisterCallback() {
        this.userObject = null;
        this.processCallback = null;
        if (this.callbackState == CallbackState.PENDING) {
            this.callbackState = CallbackState.CANCELLED;
        }
    }

    public synchronized void executeCallback() {
        if (this.processCallback == null) {
            return;
        }
        this.processCallback.callback(this.userObject, this);
        this.callbackState = CallbackState.RUN;
    }

    public synchronized boolean callbackCancelled() {
        return this.callbackState != CallbackState.RUN && this.callbackState != CallbackState.NONE && this.callbackState != CallbackState.PENDING;
    }

    public synchronized CallbackState getCallbackState() {
        return this.callbackState;
    }

    synchronized void setCallbackState(CallbackState callbackState) {
        if (this.locked) {
            return;
        }
        this.callbackState = callbackState;
    }

    synchronized void setCallbackStateIfLocked(CallbackState callbackState) {
        this.callbackState = callbackState;
    }

    synchronized int getExecutorId() {
        return this.executorId;
    }

    public synchronized int getId() {
        return this.id;
    }

    synchronized void hasTerminated(boolean b) {
        this.terminated = b;
    }

    public synchronized boolean hasTerminated() {
        return this.terminated;
    }

    public synchronized boolean hasError() {
        return this.error;
    }

    public synchronized boolean hasOutput() {
        return this.regularOutput != null;
    }

    public synchronized String getOutput() {
        return this.regularOutput;
    }

    public synchronized String getError() {
        return this.errorOutput;
    }

    synchronized void setError(String error) {
        this.errorOutput = error;
        if (error != null) {
            this.error = true;
        }
    }

    synchronized void setOutput(String output) {
        this.regularOutput = output;
    }

    public String toString() {
        return "Id = " + this.id + ", execId = " + this.executorId + ", error = " + this.error + ", term = " + this.terminated + ", output = " + (this.regularOutput != null) + ", error output = " + (this.errorOutput != null);
    }
}

