/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgGetHelper;
import org.jlab.coda.cMsg.common.cMsgNotifier;

public class cMsgSubscription
extends cMsgGetHelper {
    private String subject;
    private String subjectRegexp;
    private Pattern subjectPattern;
    private boolean wildCardsInSub;
    private Set<String> subjectMatches = Collections.synchronizedSet(new HashSet(65));
    private String type;
    private String typeRegexp;
    private Pattern typePattern;
    private boolean wildCardsInType;
    private Set<String> typeMatches = Collections.synchronizedSet(new HashSet(65));
    private int id;
    private String namespace;
    private HashSet<cMsgNotifier> notifiers;
    private ConcurrentHashMap<cMsgCallbackThread, String> callbacks;
    private HashSet<cMsgClientInfo> allSubscribers;
    private HashMap<cMsgClientInfo, Integer> clientSubAndGetters;
    private HashSet<cMsgClientInfo> clientSubscribers;
    private static final String escapeChars = "\\(){}[]+.|^$";
    private static final String[] lookFor = new String[]{"\\", "(", ")", "{", "}", "[", "]", "+", ".", "|", "^", "$"};
    private static final String[] lookForBar = new String[]{"|"};
    private static final String[] lookForNoBar = new String[]{"\\", "(", ")", "{", "}", "[", "]", "+", ".", "^", "$"};
    private static final int lookForLen = 1;
    private static final String[] replaceWith = new String[]{"\\\\", "\\(", "\\)", "\\{", "\\}", "\\[", "\\]", "\\+", "\\.", "\\|", "\\^", "\\$"};
    private static final String[] replaceWithBar = new String[]{"\\|"};
    private static final String[] replaceWithNoBar = new String[]{"\\\\", "\\(", "\\)", "\\{", "\\}", "\\[", "\\]", "\\+", "\\.", "\\^", "\\$"};
    private static final int replaceWithLen = 2;
    private static final int LT = 0;
    private static final int GT = 1;
    private static final int EQ = 2;
    private static final int OR = 3;
    private static final int AND = 4;
    private static final String exprRange = "\\\\\\{([\\x20i<>=&|[0-9]+]*)\\\\\\}";
    private static final String exprFull = "(?:i|[0-9]+)[<>=](?:i|[0-9]+)(?:[|&](?:i|[0-9]+)[<>=](?:i|[0-9]+))*";
    private static final String exprSec = "(i|[0-9]+)([<>=])(i|[0-9]+)([|&])*";
    private static final Pattern patRange = Pattern.compile("\\\\\\{([\\x20i<>=&|[0-9]+]*)\\\\\\}");
    private static final Pattern patFull = Pattern.compile("(?:i|[0-9]+)[<>=](?:i|[0-9]+)(?:[|&](?:i|[0-9]+)[<>=](?:i|[0-9]+))*");
    private static final Pattern patSec = Pattern.compile("(i|[0-9]+)([<>=])(i|[0-9]+)([|&])*");
    private List<ArrayList<Integer>> subNumbersList = new LinkedList<ArrayList<Integer>>();
    private List<ArrayList<Integer>> typeNumbersList = new LinkedList<ArrayList<Integer>>();

    public cMsgSubscription(String subject, String type) {
        this.setSubject(subject);
        this.setType(type);
    }

    public cMsgSubscription(String subject, String type, String namespace) {
        this.namespace = namespace;
        this.setSubject(subject);
        this.setType(type);
        this.notifiers = new HashSet(30);
        this.allSubscribers = new HashSet(30);
        this.clientSubAndGetters = new HashMap(30);
        this.clientSubscribers = new HashSet(30);
    }

    public cMsgSubscription(String subject, String type, int id, cMsgCallbackThread cbThread) {
        this.id = id;
        this.setSubject(subject);
        this.setType(type);
        this.notifiers = new HashSet(30);
        this.clientSubAndGetters = new HashMap(30);
        this.allSubscribers = new HashSet(30);
        this.clientSubscribers = new HashSet(30);
        this.callbacks = new ConcurrentHashMap(30);
        this.callbacks.put(cbThread, "");
    }

    private void setSubject(String subject) {
        this.subject = subject;
        if (subject == null) {
            return;
        }
        if (subject.contains("{") && subject.contains("}")) {
            this.createRegexp(subject, true);
        }
        boolean doPound = false;
        boolean doQuestion = false;
        boolean doStar = false;
        if (subject.contains("*")) {
            doStar = true;
        }
        if (subject.contains("?")) {
            doQuestion = true;
        }
        if (subject.contains("#")) {
            doPound = true;
        }
        if (doStar || doQuestion || doPound) {
            if (!this.wildCardsInSub) {
                this.subjectRegexp = cMsgSubscription.replaceWildcards(subject, doStar, doQuestion, doPound);
                this.wildCardsInSub = true;
            } else {
                this.subjectRegexp = cMsgSubscription.replaceWildcards(this.subjectRegexp, doStar, doQuestion, doPound);
            }
        }
        if (this.wildCardsInSub) {
            this.subjectPattern = Pattern.compile(this.subjectRegexp);
        }
    }

    private void setType(String type) {
        this.type = type;
        if (type == null) {
            return;
        }
        if (type.contains("{") && type.contains("}")) {
            this.createRegexp(type, false);
        }
        boolean doPound = false;
        boolean doQuestion = false;
        boolean doStar = false;
        if (type.contains("*")) {
            doStar = true;
        }
        if (type.contains("?")) {
            doQuestion = true;
        }
        if (type.contains("#")) {
            doPound = true;
        }
        if (doStar || doQuestion || doPound) {
            if (!this.wildCardsInType) {
                this.typeRegexp = cMsgSubscription.replaceWildcards(type, doStar, doQuestion, doPound);
                this.wildCardsInType = true;
            } else {
                this.typeRegexp = cMsgSubscription.replaceWildcards(this.typeRegexp, doStar, doQuestion, doPound);
            }
        }
        if (this.wildCardsInType) {
            this.typePattern = Pattern.compile(this.typeRegexp);
        }
    }

    private void createRegexp(String subtyp, boolean isSubject) {
        String subtypEscaped = cMsgSubscription.escapeNoBar(subtyp);
        StringBuffer sb = new StringBuffer(subtyp.length() * 2);
        Matcher matchExprs = patRange.matcher(subtypEscaped);
        boolean foundRangeMatch = false;
        block0: while (matchExprs.find()) {
            ArrayList<Integer> numbers = new ArrayList<Integer>(20);
            String s = matchExprs.group(1).replaceAll("\\x20", "");
            Matcher m = patFull.matcher(s);
            if (!m.matches()) {
                if (!s.equals("") && !s.equals("i")) continue;
                numbers.add(1);
                numbers.add(2);
                numbers.add(1);
                if (isSubject) {
                    this.subNumbersList.add(numbers);
                } else {
                    this.typeNumbersList.add(numbers);
                }
                matchExprs.appendReplacement(sb, "([0-9]+)");
                foundRangeMatch = true;
                continue;
            }
            m = patSec.matcher(s);
            while (m.find()) {
                String s4 = null;
                String s1 = m.group(1);
                String s2 = m.group(2);
                String s3 = m.group(3);
                if (m.groupCount() > 3) {
                    s4 = m.group(4);
                }
                boolean b1 = s1.equals("i");
                boolean b3 = s3.equals("i");
                if (b1 && b3 || !b1 && !b3) continue block0;
                if (b1) {
                    numbers.add(-1);
                } else {
                    numbers.add(Integer.valueOf(s1));
                }
                if (s2.equals("<")) {
                    numbers.add(0);
                } else if (s2.equals(">")) {
                    numbers.add(1);
                } else {
                    numbers.add(2);
                }
                if (b3) {
                    numbers.add(-1);
                } else {
                    numbers.add(Integer.valueOf(s3));
                }
                if (s4 == null) break;
                if (s4.equals("|")) {
                    numbers.add(3);
                    continue;
                }
                numbers.add(4);
            }
            if (isSubject) {
                this.subNumbersList.add(numbers);
            } else {
                this.typeNumbersList.add(numbers);
            }
            matchExprs.appendReplacement(sb, "([0-9]+)");
            foundRangeMatch = true;
        }
        if (!foundRangeMatch) {
            return;
        }
        matchExprs.appendTail(sb);
        if (isSubject) {
            this.wildCardsInSub = true;
            this.subjectRegexp = cMsgSubscription.escapeBar(sb.toString());
        } else {
            this.wildCardsInType = true;
            this.typeRegexp = cMsgSubscription.escapeBar(sb.toString());
        }
    }

    public static String escape(String s) {
        return cMsgSubscription.escapeString(s, lookFor, replaceWith);
    }

    public static String escapeNoBar(String s) {
        return cMsgSubscription.escapeString(s, lookForNoBar, replaceWithNoBar);
    }

    public static String escapeBar(String s) {
        return cMsgSubscription.escapeString(s, lookForBar, replaceWithBar);
    }

    private static String escapeString(String s, String[] lookFor, String[] replaceWith) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(s.length() * 2);
        buf.append(s);
        for (int i = 0; i < lookFor.length; ++i) {
            int lastIndex = 0;
            for (int j = 0; j < buf.length() && (lastIndex = buf.indexOf(lookFor[i], lastIndex)) >= 0; ++j) {
                buf.replace(lastIndex, lastIndex + 1, replaceWith[i]);
                lastIndex += 2;
            }
        }
        return buf.toString();
    }

    private static String replaceWildcards(String s, boolean doStar, boolean doQuestion, boolean doPound) {
        int j;
        int lastIndex;
        StringBuilder buf = new StringBuilder(s.length() * 2);
        buf.append(s);
        if (doStar) {
            lastIndex = 0;
            for (j = 0; j < buf.length() && (lastIndex = buf.indexOf("*", lastIndex)) >= 0; ++j) {
                buf.replace(lastIndex, lastIndex + 1, ".*");
                lastIndex += 2;
            }
        }
        if (doQuestion) {
            lastIndex = 0;
            for (j = 0; j < buf.length() && (lastIndex = buf.indexOf("?", lastIndex)) >= 0; ++j) {
                buf.replace(lastIndex, lastIndex + 1, ".{1}");
                lastIndex += 4;
            }
        }
        if (doPound) {
            lastIndex = 0;
            for (j = 0; j < buf.length() && (lastIndex = buf.indexOf("#", lastIndex)) >= 0; ++j) {
                buf.replace(lastIndex, lastIndex + 1, "[0-9]*");
                lastIndex += 6;
            }
        }
        return buf.toString();
    }

    private boolean matchesRegexp(String subtyp, boolean isSubject) {
        int numRanges;
        Matcher matcher = null;
        if (isSubject) {
            matcher = this.subjectPattern.matcher(subtyp);
            numRanges = this.subNumbersList.size();
        } else {
            matcher = this.typePattern.matcher(subtyp);
            numRanges = this.typeNumbersList.size();
        }
        if (!matcher.matches()) {
            return false;
        }
        if (matcher.groupCount() != numRanges) {
            System.out.println("Internal error: mismatch between # of integers grabbed and # of integer ranges");
            return false;
        }
        if (matcher.groupCount() > 0) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                boolean lastBool;
                String s = matcher.group(i);
                try {
                    int myNum = Integer.parseInt(s);
                    Integer conj = null;
                    lastBool = true;
                    int numIndex = 0;
                    ArrayList<Integer> numbers = isSubject ? this.subNumbersList.get(i - 1) : this.typeNumbersList.get(i - 1);
                    while (numIndex < numbers.size()) {
                        boolean myBool;
                        int num2;
                        int num1;
                        if ((num1 = numbers.get(numIndex++).intValue()) == -1) {
                            num1 = myNum;
                        }
                        int oper = numbers.get(numIndex++);
                        if ((num2 = numbers.get(numIndex++).intValue()) == -1) {
                            num2 = myNum;
                        }
                        if (oper == 1) {
                            myBool = num1 > num2;
                        } else if (oper == 0) {
                            myBool = num1 < num2;
                        } else {
                            boolean bl = myBool = num1 == num2;
                        }
                        if (conj != null) {
                            myBool = conj == 4 ? myBool && lastBool : myBool || lastBool;
                        }
                        lastBool = myBool;
                        if (numIndex >= numbers.size()) continue;
                        conj = numbers.get(numIndex++);
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (lastBool) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matches(String msgSubject, String msgType) {
        if (this.subject == null || this.type == null) {
            return false;
        }
        if (!this.subjectMatches.contains(msgSubject)) {
            if (!this.wildCardsInSub ? !msgSubject.equals(this.subject) : !this.matchesRegexp(msgSubject, true)) {
                return false;
            }
            if (this.subjectMatches.size() > 50) {
                this.subjectMatches.clear();
            }
            this.subjectMatches.add(msgSubject);
        }
        if (!this.typeMatches.contains(msgType)) {
            if (!this.wildCardsInType ? !msgType.equals(this.type) : !this.matchesRegexp(msgType, false)) {
                return false;
            }
            if (this.typeMatches.size() > 50) {
                this.typeMatches.clear();
            }
            this.typeMatches.add(msgType);
        }
        return true;
    }

    public static boolean matches(String regexp, String s, boolean escapeRegexp) {
        if (regexp == null) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (escapeRegexp) {
            regexp = cMsgSubscription.escape(regexp);
            regexp = cMsgSubscription.replaceWildcards(regexp, true, true, true);
        }
        return s.matches(regexp);
    }

    public boolean matchesOrig(String msgSubject, String msgType) {
        Matcher m;
        if (this.subject == null || this.type == null) {
            return false;
        }
        if (!this.wildCardsInSub ? !msgSubject.equals(this.subject) : !(m = this.subjectPattern.matcher(msgSubject)).matches()) {
            return false;
        }
        return !(!this.wildCardsInType ? !msgType.equals(this.type) : !(m = this.typePattern.matcher(msgType)).matches());
    }

    public void printSizes() {
        System.out.println("        notifiers           = " + this.notifiers.size());
        if (this.callbacks != null) {
            System.out.println("        callbacks           = " + this.callbacks.size());
        }
        System.out.println("        allSubscribers      = " + this.allSubscribers.size());
        System.out.println("        clientSubscribers   = " + this.clientSubscribers.size());
        System.out.println("        clientSubAndGetters = " + this.clientSubAndGetters.size());
    }

    public boolean areWildCardsInSub() {
        return this.wildCardsInSub;
    }

    public boolean areWildCardsInType() {
        return this.wildCardsInType;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getSubjectRegexp() {
        return this.subjectRegexp;
    }

    public Pattern getSubjectPattern() {
        return this.subjectPattern;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeRegexp() {
        return this.typeRegexp;
    }

    public Pattern getTypePattern() {
        return this.typePattern;
    }

    @Override
    public int getIntVal() {
        return this.id;
    }

    @Override
    public void setIntVal(int id) {
        this.id = id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Set<cMsgCallbackThread> getCallbacks() {
        return this.callbacks.keySet();
    }

    public void addCallback(cMsgCallbackThread cbThread) {
        this.callbacks.put(cbThread, "");
    }

    public void removeCallback(cMsgCallbackThread cbThread) {
        this.callbacks.remove(cbThread);
    }

    public int numberOfCallbacks() {
        return this.callbacks.size();
    }

    public HashSet<cMsgClientInfo> getClientSubscribers() {
        return this.clientSubscribers;
    }

    public boolean addClientSubscriber(cMsgClientInfo client) {
        return this.clientSubscribers.add(client);
    }

    public boolean removeClientSubscriber(cMsgClientInfo client) {
        return this.clientSubscribers.remove(client);
    }

    public HashSet<cMsgClientInfo> getAllSubscribers() {
        return this.allSubscribers;
    }

    public boolean containsSubscriber(cMsgClientInfo client) {
        return this.allSubscribers.contains(client);
    }

    public boolean addSubscriber(cMsgClientInfo client) {
        return this.allSubscribers.add(client);
    }

    public boolean removeSubscriber(cMsgClientInfo client) {
        return this.allSubscribers.remove(client);
    }

    public HashMap<cMsgClientInfo, Integer> getSubAndGetters() {
        return this.clientSubAndGetters;
    }

    public void addSubAndGetter(cMsgClientInfo client) {
        Integer count = this.clientSubAndGetters.get(client);
        if (count == null) {
            this.clientSubAndGetters.put(client, 1);
        } else {
            this.clientSubAndGetters.put(client, count + 1);
        }
    }

    public void clearSubAndGetters() {
        this.clientSubAndGetters.clear();
    }

    public void removeSubAndGetter(cMsgClientInfo client) {
        Integer count = this.clientSubAndGetters.get(client);
        if (count == null || count < 2) {
            this.clientSubAndGetters.remove(client);
        } else {
            this.clientSubAndGetters.put(client, count - 1);
        }
    }

    public int numberOfSubscribers() {
        return this.allSubscribers.size() + this.clientSubAndGetters.size();
    }

    public Set<cMsgNotifier> getNotifiers() {
        return this.notifiers;
    }

    public void addNotifier(cMsgNotifier notifier) {
        this.notifiers.add(notifier);
    }

    public void removeNotifier(cMsgNotifier notifier) {
        this.notifiers.remove(notifier);
    }

    public void clearNotifiers() {
        this.notifiers.clear();
    }
}

