/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubdomainAdapter;

public class LogFile
extends cMsgSubdomainAdapter {
    private static HashMap<String, LogFileObject> openFiles = new HashMap(100);
    private String myCanonicalName;
    private PrintWriter myPrintHandle = null;
    private String myUDLRemainder;

    @Override
    public boolean hasSend() {
        return true;
    }

    @Override
    public boolean hasSyncSend() {
        return true;
    }

    @Override
    public void setUDLRemainder(String UDLRemainder) throws cMsgException {
        this.myUDLRemainder = UDLRemainder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerClient(cMsgClientInfo info) throws cMsgException {
        String myFileName;
        String remainder = null;
        if (this.myUDLRemainder.indexOf("?") > 0) {
            Pattern p = Pattern.compile("^(.+?)(\\?)(.*)$");
            Matcher m = p.matcher(this.myUDLRemainder);
            m.find();
            myFileName = m.group(1);
            remainder = m.group(2);
        } else {
            myFileName = this.myUDLRemainder;
        }
        try {
            File f = new File(myFileName);
            if (f.exists()) {
                this.myCanonicalName = f.getCanonicalPath();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException("Unable to get canonical name");
            ce.setReturnCode(1);
            throw ce;
        }
        HashMap<String, LogFileObject> hashMap = openFiles;
        synchronized (hashMap) {
            if (openFiles.containsKey(this.myCanonicalName)) {
                LogFileObject l = openFiles.get(this.myCanonicalName);
                this.myPrintHandle = l.printHandle;
                l.count.incrementAndGet();
            } else {
                try {
                    this.myPrintHandle = new PrintWriter(new BufferedWriter(new FileWriter(myFileName, true)));
                    openFiles.put(this.myCanonicalName, new LogFileObject(this.myPrintHandle));
                    this.myPrintHandle.println("<cMsgLogFile  name=\"" + myFileName + "\"  date=\"" + new Date() + "\">\n\n");
                }
                catch (IOException e) {
                    System.out.println(e);
                    e.printStackTrace();
                    cMsgException ce = new cMsgException("registerClient: unable to open file");
                    ce.setReturnCode(1);
                    throw ce;
                }
            }
        }
    }

    @Override
    public void handleSendRequest(cMsgMessageFull msg) throws cMsgException {
        msg.setReceiver("cMsg:LogFile");
        this.myPrintHandle.println(msg);
    }

    @Override
    public int handleSyncSendRequest(cMsgMessageFull msg) throws cMsgException {
        this.handleSendRequest(msg);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleClientShutdown() throws cMsgException {
        HashMap<String, LogFileObject> hashMap = openFiles;
        synchronized (hashMap) {
            LogFileObject l = openFiles.get(this.myCanonicalName);
            if (l.count.decrementAndGet() <= 0) {
                this.myPrintHandle.println("</cMsgLogFile>\n");
                this.myPrintHandle.println("\n\n\n<!--===========================================================================================-->\n\n\n");
                this.myPrintHandle.close();
                openFiles.remove(this.myCanonicalName);
            }
        }
    }

    private static class LogFileObject {
        PrintWriter printHandle;
        AtomicInteger count;

        LogFileObject(PrintWriter handle) {
            this.printHandle = handle;
            this.count = new AtomicInteger(1);
        }
    }
}

