/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.subdomains;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.common.cMsgClientInfo;
import org.jlab.coda.cMsg.common.cMsgDeliverMessageInterface;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgSubdomainAdapter;

public class Database
extends cMsgSubdomainAdapter {
    private cMsgDeliverMessageInterface myDeliverer;
    private String myUDLRemainder;
    Connection myCon = null;
    Statement myStmt = null;

    @Override
    public boolean hasSyncSend() {
        return true;
    }

    @Override
    public boolean hasSendAndGet() {
        return true;
    }

    @Override
    public void setUDLRemainder(String UDLRemainder) throws cMsgException {
        this.myUDLRemainder = UDLRemainder;
    }

    @Override
    public void registerClient(cMsgClientInfo info) throws cMsgException {
        cMsgException ce;
        String driver = null;
        String URL2 = null;
        String account = null;
        String password = null;
        this.myDeliverer = info.getDeliverer();
        int ind = this.myUDLRemainder.indexOf("?");
        if (ind != 0) {
            cMsgException ce2 = new cMsgException("illegal UDL");
            ce2.setReturnCode(1);
            throw ce2;
        }
        String remainder = this.myUDLRemainder + "&";
        Pattern p = Pattern.compile("[&\\?]driver=(.*?)&", 2);
        Matcher m = p.matcher(remainder);
        m.find();
        driver = m.group(1);
        p = Pattern.compile("[&\\?]url=(.*?)&", 2);
        m = p.matcher(remainder);
        m.find();
        URL2 = m.group(1);
        p = Pattern.compile("[&\\?]account=(.*?)&", 2);
        m = p.matcher(remainder);
        if (m.find()) {
            account = m.group(1);
        }
        if ((m = (p = Pattern.compile("[&\\?]password=(.*?)&", 2)).matcher(remainder)).find()) {
            password = m.group(1);
        }
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
            e.printStackTrace();
            ce = new cMsgException("registerClient: unable to load driver");
            ce.setReturnCode(1);
            throw ce;
        }
        try {
            this.myCon = DriverManager.getConnection(URL2, account, password);
        }
        catch (SQLException e) {
            System.out.println(e);
            e.printStackTrace();
            ce = new cMsgException("registerClient: unable to connect to database");
            ce.setReturnCode(1);
            throw ce;
        }
        try {
            this.myStmt = this.myCon.createStatement();
        }
        catch (SQLException e) {
            System.out.println(e);
            e.printStackTrace();
            ce = new cMsgException("registerClient: unable to create statement");
            ce.setReturnCode(1);
            throw ce;
        }
    }

    @Override
    public synchronized int handleSyncSendRequest(cMsgMessageFull msg) throws cMsgException {
        String sql = msg.getText();
        try {
            this.myStmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            System.out.println("?Database::handleSyncSendRequest: error executing: " + sql);
            System.out.println(e);
            return 1;
        }
        return 0;
    }

    @Override
    public synchronized void handleSendAndGetRequest(cMsgMessageFull msg) throws cMsgException {
        cMsgMessageFull response = null;
        int maxRow = msg.getUserInt();
        String sql = msg.getText();
        try {
            ResultSet rs = this.myStmt.executeQuery(sql);
            if (rs != null) {
                int i;
                int ncol = 0;
                int nrow = 0;
                String[] colNames = null;
                int[] colTypes = null;
                ArrayList[] colData = null;
                while (rs.next()) {
                    if (ncol == 0) {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        ncol = rsmd.getColumnCount();
                        colNames = new String[ncol];
                        colTypes = new int[ncol];
                        colData = new ArrayList[ncol];
                        for (i = 0; i < ncol; ++i) {
                            colNames[i] = rsmd.getColumnName(i + 1);
                            colTypes[i] = rsmd.getColumnType(i + 1);
                            colData[i] = new ArrayList();
                        }
                    }
                    if (maxRow > 0 && nrow >= maxRow) break;
                    ++nrow;
                    for (i = 0; i < ncol; ++i) {
                        this.addDataToArrayList(rs, i + 1, colTypes[i], colData[i]);
                    }
                }
                rs.close();
                if (nrow > 0) {
                    response = cMsgMessageFull.createDeliverableMessage();
                    response.setUserInt(nrow);
                    response.makeResponse(msg);
                    for (i = 0; i < ncol; ++i) {
                        this.addArrayListToPayload(colNames[i], colTypes[i], colData[i], response);
                    }
                }
            }
        }
        catch (SQLException e) {
            System.out.println("?Database::handleSendAndGetRequest: illegal sql: " + sql);
            System.out.println(e);
        }
        if (response == null) {
            response = cMsgMessageFull.createDeliverableMessage();
            response.setUserInt(0);
            response.makeNullResponse(msg);
        }
        try {
            this.myDeliverer.deliverMessage(response, 20);
        }
        catch (IOException e) {
            e.printStackTrace();
            cMsgException ce = new cMsgException(e.toString());
            ce.setReturnCode(1);
            throw ce;
        }
    }

    public void addDataToArrayList(ResultSet rs, int col, int type, ArrayList al) {
        if (rs == null) {
            return;
        }
        try {
            switch (type) {
                case -6: {
                    al.add(rs.getByte(col));
                    break;
                }
                case 5: {
                    al.add(rs.getShort(col));
                    break;
                }
                case 4: {
                    al.add(rs.getInt(col));
                    break;
                }
                case -5: {
                    al.add(rs.getLong(col));
                    break;
                }
                case 6: 
                case 7: {
                    al.add(Float.valueOf(rs.getFloat(col)));
                    break;
                }
                case 8: {
                    al.add(rs.getDouble(col));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String s = rs.getString(col);
                    al.add(rs.wasNull() ? "null" : s);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    al.add(rs.getBytes(col));
                    break;
                }
                case 91: {
                    Date d = rs.getDate(col);
                    al.add(rs.wasNull() ? "null" : d);
                    break;
                }
                case 92: {
                    Time t = rs.getTime(col);
                    al.add(rs.wasNull() ? "null" : t);
                    break;
                }
                case 93: {
                    Timestamp ts = rs.getTimestamp(col);
                    al.add(rs.wasNull() ? "null" : ts);
                    break;
                }
                default: {
                    System.out.println("?Database::addDataToArrayList...illegal type: " + type);
                    return;
                }
            }
        }
        catch (SQLException e) {
            System.out.println(e);
        }
    }

    public void addArrayListToPayload(String name, int type, ArrayList al, cMsgMessageFull msg) {
        int nrow = al.size();
        Object[] ala = al.toArray();
        try {
            switch (type) {
                case -6: {
                    byte[] a = new byte[nrow];
                    for (int i = 0; i < nrow; ++i) {
                        a[i] = (Byte)ala[i];
                    }
                    msg.addPayloadItem(new cMsgPayloadItem(name, a));
                    break;
                }
                case 5: {
                    short[] a = new short[nrow];
                    for (int i = 0; i < nrow; ++i) {
                        a[i] = (Short)ala[i];
                    }
                    msg.addPayloadItem(new cMsgPayloadItem(name, a));
                    break;
                }
                case 4: {
                    int[] a = new int[nrow];
                    for (int i = 0; i < nrow; ++i) {
                        a[i] = (Integer)ala[i];
                    }
                    msg.addPayloadItem(new cMsgPayloadItem(name, a));
                    break;
                }
                case -5: {
                    long[] a = new long[nrow];
                    for (int i = 0; i < nrow; ++i) {
                        a[i] = (Long)ala[i];
                    }
                    msg.addPayloadItem(new cMsgPayloadItem(name, a));
                    break;
                }
                case 6: 
                case 7: {
                    float[] a = new float[nrow];
                    for (int i = 0; i < nrow; ++i) {
                        a[i] = ((Float)ala[i]).floatValue();
                    }
                    msg.addPayloadItem(new cMsgPayloadItem(name, a));
                    break;
                }
                case 8: {
                    double[] a = new double[nrow];
                    for (int i = 0; i < nrow; ++i) {
                        a[i] = (Double)ala[i];
                    }
                    msg.addPayloadItem(new cMsgPayloadItem(name, a));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String[] a = new String[nrow];
                    for (int i = 0; i < nrow; ++i) {
                        a[i] = (String)ala[i];
                    }
                    msg.addPayloadItem(new cMsgPayloadItem(name, a));
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    String[] a = new String[nrow];
                    for (int i = 0; i < nrow; ++i) {
                        a[i] = ala[i].toString();
                    }
                    msg.addPayloadItem(new cMsgPayloadItem(name, a));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[][] a = new byte[nrow][];
                    for (int i = 0; i < nrow; ++i) {
                        a[i] = (byte[])ala[i];
                    }
                    msg.addPayloadItem(new cMsgPayloadItem(name, a));
                    break;
                }
                default: {
                    System.out.println("?Database::addArrayListToPayload...illegal type: " + type);
                    return;
                }
            }
        }
        catch (cMsgException e) {
            System.out.println(e);
        }
    }

    @Override
    public synchronized void handleClientShutdown() throws cMsgException {
        try {
            this.myStmt.close();
            this.myCon.close();
        }
        catch (SQLException e) {
            throw new cMsgException("database sub-domain handler shutdown error");
        }
    }
}

