/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgNameServer;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerBridge;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgUtilities;

class cMsgServerCloudJoiner
extends Thread {
    private int port;
    private int multicastPort;
    private cMsgNameServer nameServer;
    private HashSet<String> serversToConnectTo = new HashSet(20);
    private HashSet<String> cloudServers = new HashSet(20);
    private int debug;

    public cMsgServerCloudJoiner(cMsgNameServer nameServer, int nsTcpPort, int nsUdpPort, Set<String> servers, int debug) {
        this.port = nsTcpPort;
        this.multicastPort = nsUdpPort;
        this.debug = debug;
        this.nameServer = nameServer;
        this.cloudServers.addAll(servers);
        this.start();
    }

    @Override
    public void run() {
        boolean methodDebug = false;
        HashSet<String> unknownServers = new HashSet<String>(10);
        try {
            this.nameServer.listeningThreadsStartedSignal.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean madeFirstConnection = false;
        for (String startServer : this.cloudServers) {
            if (methodDebug) {
                System.out.println("    << JR: Try joining cloud of server = " + startServer);
            }
            this.serversToConnectTo.clear();
            this.serversToConnectTo.add(startServer);
            do {
                unknownServers.clear();
                for (String server : this.serversToConnectTo) {
                    Set<String> serverCandidates;
                    block85: {
                        serverCandidates = null;
                        try {
                            cMsgServerBridge bridge;
                            if (methodDebug) {
                                System.out.println("    << JR: Creating bridge to: " + server);
                            }
                            boolean multicasting = server.startsWith("multicast:");
                            this.nameServer.bridgeBeingCreated = bridge = new cMsgServerBridge(this.nameServer, server, this.port, this.multicastPort);
                            serverCandidates = bridge.connect(true, this.nameServer.cloudPassword, this.nameServer.clientPassword, multicasting);
                            if (multicasting) {
                                server = bridge.client.getName();
                                bridge.setServerName(server);
                                if (methodDebug) {
                                    System.out.println("    << JR: Set client name and bridge server name to " + server);
                                }
                            }
                            madeFirstConnection = true;
                            if (this.nameServer.getCloudStatus() == 1) {
                                if (methodDebug) {
                                    System.out.println("    << JR: Now in BECOMINGCLOUD status");
                                }
                                this.nameServer.setCloudStatus(2);
                            }
                            if (methodDebug) {
                                System.out.println("    << JR: Adding bridge to map for server = " + server);
                            }
                            this.nameServer.bridges.put(server, bridge);
                        }
                        catch (cMsgException e) {
                            if (this.nameServer.getCloudStatus() != 1) break block85;
                            if (methodDebug) {
                                System.out.println("    << JR: Cannot connect to given server: " + server + ", so continue");
                            }
                            System.out.println(e.getMessage());
                            continue;
                        }
                    }
                    if (serverCandidates == null) continue;
                    block31: for (String s : serverCandidates) {
                        String servHostName;
                        String servPort;
                        Object alternateName;
                        int indexColon = s.lastIndexOf(":");
                        String sPort = s.substring(indexColon + 1);
                        int sport = 45000;
                        try {
                            sport = Integer.parseInt(sPort);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        String hostName = s.substring(0, indexColon);
                        int indexDot = s.indexOf(".");
                        if (indexDot > -1) {
                            alternateName = hostName.substring(0, indexDot) + ":" + sPort;
                            if (methodDebug) {
                                System.out.println("    << JR: alternateName (unqualified) = " + (String)alternateName);
                            }
                        } else {
                            try {
                                alternateName = InetAddress.getByName(hostName).getCanonicalHostName();
                                alternateName = alternateName + ":" + sPort;
                                if (methodDebug) {
                                    System.out.println("    << JR: alternateName (qualified) = " + (String)alternateName);
                                }
                            }
                            catch (UnknownHostException e) {
                                alternateName = s;
                            }
                        }
                        if (((ConcurrentHashMap.KeySetView)this.nameServer.bridges.keySet()).contains(s) || ((ConcurrentHashMap.KeySetView)this.nameServer.bridges.keySet()).contains(alternateName) || this.serversToConnectTo.contains(s) || this.serversToConnectTo.contains(alternateName)) {
                            if (!methodDebug) continue;
                            System.out.println("    << JR: Skip -> server " + s);
                            continue;
                        }
                        if (cMsgUtilities.isHostLocal(hostName) && sport == this.nameServer.getPort()) {
                            if (!methodDebug) continue;
                            System.out.println("    << JR: Skip myself -> server " + s);
                            continue;
                        }
                        for (String serv : this.nameServer.bridges.keySet()) {
                            indexColon = serv.lastIndexOf(":");
                            servPort = serv.substring(indexColon + 1);
                            servHostName = serv.substring(0, indexColon);
                            if (!servPort.equals(sPort) || !cMsgUtilities.isHostSame(hostName, servHostName)) continue;
                            if (!methodDebug) continue block31;
                            System.out.println("    << JR: Do NOT add server " + s + " since " + hostName + " = " + servHostName + " (found in this bridges list)");
                            continue block31;
                        }
                        for (String serv : this.serversToConnectTo) {
                            indexColon = serv.lastIndexOf(":");
                            servPort = serv.substring(indexColon + 1);
                            servHostName = serv.substring(0, indexColon);
                            if (!servPort.equals(sPort) || !cMsgUtilities.isHostSame(hostName, servHostName)) continue;
                            if (!methodDebug) continue block31;
                            System.out.println("    << JR: Do NOT add server " + s + " since " + hostName + " = " + servHostName + " (found in this serversToConnectTo list)");
                            continue block31;
                        }
                        for (String serv : this.nameServer.nameServers.keySet()) {
                            indexColon = serv.lastIndexOf(":");
                            servPort = serv.substring(indexColon + 1);
                            servHostName = serv.substring(0, indexColon);
                            if (!servPort.equals(sPort) || !cMsgUtilities.isHostSame(hostName, servHostName)) continue;
                            if (!methodDebug) continue block31;
                            System.out.println("    << JR: Do NOT add server " + s + " since " + hostName + " = " + servHostName + " (found in this server's list of server clients)");
                            continue block31;
                        }
                        if (methodDebug) {
                            System.out.println("    << JR: Added unknown server " + s + " to list (size = " + unknownServers.size() + ")");
                        }
                        unknownServers.add(s);
                    }
                }
                this.serversToConnectTo.clear();
                this.serversToConnectTo.addAll(unknownServers);
                if (!methodDebug) continue;
                System.out.println("    << JR: Size of serversToConnectTo map: " + this.serversToConnectTo.size());
            } while (this.serversToConnectTo.size() > 0);
            if (!madeFirstConnection) continue;
            break;
        }
        if (!madeFirstConnection) {
            if (methodDebug) {
                System.out.println("    << JR: Could not connect to any given server");
            }
            this.nameServer.setCloudStatus(0);
            this.nameServer.allowConnectionsCloudSignal.countDown();
            return;
        }
        boolean gotSelfLock = false;
        boolean gotCloudLock = false;
        boolean amInCloud = false;
        cMsgServerBridge firstLockBridge = null;
        int maxNumberOfTrys = 3;
        int numberOfTrys = 0;
        ArrayList<cMsgServerBridge> lockedBridges = new ArrayList<cMsgServerBridge>();
        if (methodDebug) {
            System.out.println("    << JR: About to grab all cloudlocks");
        }
        block35: while (numberOfTrys++ < maxNumberOfTrys) {
            block86: {
                if (methodDebug) {
                    System.out.println("    << JR: startOver");
                }
                if (!gotSelfLock) {
                    this.nameServer.cloudLock();
                    gotSelfLock = true;
                }
                lockedBridges.clear();
                int grabLockTries = 0;
                gotCloudLock = false;
                do {
                    for (cMsgServerBridge bridge : this.nameServer.bridges.values()) {
                        if (methodDebug) {
                            System.out.println("    << JR: grabLockTries = " + grabLockTries);
                        }
                        if (methodDebug) {
                            System.out.println("    << JR: status = " + bridge.getCloudStatus() + ", bridge = " + bridge);
                        }
                        if (bridge.getCloudStatus() != 0) continue;
                        try {
                            if (methodDebug) {
                                System.out.println("    << JR: try in-cloud lock");
                            }
                            if (bridge.cloudLock(200)) {
                                if (methodDebug) {
                                    System.out.println("    << JR: first grabbed 1 cloud lock (for " + bridge.serverName + ")");
                                }
                                lockedBridges.add(bridge);
                                firstLockBridge = bridge;
                                gotCloudLock = true;
                                break;
                            }
                            if (!methodDebug) continue;
                            System.out.println("    << JR: failed to grab cloud lock (for " + bridge.serverName + ")");
                        }
                        catch (IOException hostName) {}
                    }
                    if (gotCloudLock) continue;
                    if (++grabLockTries > 3) {
                        if (this.debug >= 3) {
                            System.out.println("    << JR: Failed to grab inital cloud lock");
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException sPort) {
                            // empty catch block
                        }
                        if (!methodDebug) continue block35;
                        System.out.println("    << JR: continue to startOver");
                        continue block35;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException sPort) {
                        // empty catch block
                    }
                } while (!gotCloudLock);
                int totalCloudMembers = 0;
                for (cMsgServerBridge bridge : this.nameServer.bridges.values()) {
                    if (bridge.getCloudStatus() != 0) continue;
                    ++totalCloudMembers;
                }
                int majority = totalCloudMembers / 2 + 1;
                int numberOfLockedCloudMembers = 1;
                while (true) {
                    for (cMsgServerBridge bridge : this.nameServer.bridges.values()) {
                        if (lockedBridges.contains(bridge)) {
                            if (!methodDebug) continue;
                            System.out.println("    << JR: Already grabbed (so skip grabbing) cloud lock for " + bridge.serverName);
                            continue;
                        }
                        try {
                            if (methodDebug) {
                                System.out.println("    << JR: Try to cloud lock bridge to " + bridge.serverName);
                            }
                            if (!bridge.cloudLock(200)) continue;
                            if (methodDebug) {
                                System.out.println("    << JR: LOCKED IT!!");
                            }
                            lockedBridges.add(bridge);
                            if (bridge.getCloudStatus() != 0) continue;
                            ++numberOfLockedCloudMembers;
                        }
                        catch (IOException e) {}
                    }
                    if (numberOfLockedCloudMembers >= totalCloudMembers) {
                        if (methodDebug) {
                            System.out.println("    << JR: Have all locks, move on");
                        }
                        break block86;
                    }
                    if (numberOfLockedCloudMembers < majority) break;
                    if (methodDebug) {
                        System.out.println("    << JR: Get More Locks");
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException alternateName) {}
                }
                for (cMsgServerBridge b : lockedBridges) {
                    try {
                        b.cloudUnlock();
                    }
                    catch (IOException e) {}
                }
                this.nameServer.cloudUnlock();
                gotSelfLock = false;
                gotCloudLock = false;
                Random rand = new Random();
                int milliSec = (int)((double)(10 + rand.nextInt(291)) * Math.pow(2.0, (double)numberOfTrys - 1.0));
                try {
                    Thread.sleep(milliSec);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!methodDebug) continue;
                System.out.println("    << JR: Drop locks and start over");
                continue;
            }
            this.nameServer.setCloudStatus(0);
            for (cMsgServerBridge bridge : this.nameServer.bridges.values()) {
                if (methodDebug) {
                    System.out.println("    << JR: Tell server we are in the cloud");
                }
                try {
                    bridge.thisServerCloudStatus(0);
                }
                catch (IOException e) {
                    System.out.println("    << JR: Bombed while Telling server we are in the cloud");
                }
            }
            for (cMsgServerBridge bridge : lockedBridges) {
                try {
                    if (methodDebug) {
                        System.out.println("    << JR: Try unlocking cloud lock for " + bridge.serverName);
                    }
                    bridge.cloudUnlock();
                    if (!methodDebug) continue;
                    System.out.println("    << JR: UNLOCKED cloud lock for " + bridge.serverName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (methodDebug) {
                System.out.println("    << JR: Try unlocking cloud lock for this server");
            }
            this.nameServer.cloudUnlock();
            if (methodDebug) {
                System.out.println("    << JR: Unlocked cloud lock for this server");
            }
            if (methodDebug) {
                System.out.println("    << JR: I'm in the cloud\n\n");
            }
            amInCloud = true;
            break;
        }
        if (!amInCloud) {
            if (gotSelfLock) {
                this.nameServer.cloudUnlock();
            }
            if (gotCloudLock) {
                try {
                    firstLockBridge.cloudUnlock();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.out.println("    << JR: *******************************************************************");
            System.out.println("    << JR: Cannot join the specified cloud, becoming the center of a new cloud");
            System.out.println("    << JR: *******************************************************************");
        }
        this.nameServer.setCloudStatus(0);
        this.nameServer.allowConnectionsCloudSignal.countDown();
    }
}

