/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.server;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgClientData;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgHolder;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgNameServer;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerBridge;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerSendAndGetter;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerSubscribeAndGetter;
import org.jlab.coda.cMsg.cMsgDomain.server.cMsgServerSubscribeInfo;
import org.jlab.coda.cMsg.cMsgDomain.subdomains.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgUtilities;
import org.jlab.coda.cMsg.common.cMsgMessageFull;
import org.jlab.coda.cMsg.common.cMsgNotifier;
import org.jlab.coda.cMsg.common.cMsgSubscription;

class cMsgDomainServerSelect
extends Thread {
    static String domainType = "cMsg";
    private int clientsMax;
    private int udpPort;
    private cMsgNameServer nameServer;
    private int debug;
    cMsgClientData myClientInfo;
    private boolean noUdp;
    ConcurrentHashMap<cMsgClientData, String> clients;
    ConcurrentHashMap<cMsgClientData, String> clients2register;
    Selector selector;
    private DatagramChannel udpChannel;
    private DatagramSocket udpSocket;
    private LinkedBlockingQueue<cMsgHolder> bufferQ;
    private RequestHandler requestHandlerThread;
    private ThreadPoolExecutor subAndGetThreadPool;
    private ThreadPoolExecutor sendAndGetThreadPool;
    AtomicBoolean calledShutdown = new AtomicBoolean();
    private ConcurrentHashMap<Integer, cMsgServerSendAndGetter> sendAndGetters;
    private volatile boolean killMainThread;

    int getClientsMax() {
        return this.clientsMax;
    }

    void setClientsMax(int clientsMax) {
        this.clientsMax = clientsMax;
    }

    public int getUdpPort() {
        return this.udpPort;
    }

    boolean clientIsServer() {
        if (this.myClientInfo == null || this.clients.size() != 1) {
            return false;
        }
        return this.myClientInfo.isServer();
    }

    private cMsgClientData getClient(InetSocketAddress sockAddr, int tcpPort) {
        if (this.clients.size() < 1) {
            return null;
        }
        for (cMsgClientData cd : this.clients.keySet()) {
            InetSocketAddress clientAddr = cd.getMessageChannelRemoteSocketAddress();
            if (clientAddr.getPort() != tcpPort) continue;
            String host = clientAddr.getAddress().getCanonicalHostName();
            try {
                for (InetAddress addr : InetAddress.getAllByName(host)) {
                    if (!addr.equals(sockAddr.getAddress())) continue;
                    return cd;
                }
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return null;
    }

    private void printSizes() {
        System.out.println("\n\nSIZES:");
        System.out.println("     request   cue    = " + this.bufferQ.size());
        System.out.println("     sendAndGetters   = " + this.sendAndGetters.size());
        System.out.println("     clients          = " + this.clients.size());
        System.out.println("     clients2register = " + this.clients2register.size());
    }

    public cMsgDomainServerSelect(cMsgNameServer nameServer, int clientsMax, int debug, boolean noUdp) throws cMsgException, IOException {
        this.debug = debug;
        this.noUdp = noUdp;
        this.nameServer = nameServer;
        this.clientsMax = clientsMax;
        this.clients2register = new ConcurrentHashMap(clientsMax);
        this.clients = new ConcurrentHashMap(clientsMax);
        this.bufferQ = new LinkedBlockingQueue(1000);
        this.sendAndGetters = new ConcurrentHashMap(10);
        class RejectHandler
        implements RejectedExecutionHandler {
            RejectHandler() {
            }

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.start();
            }
        }
        this.subAndGetThreadPool = new ThreadPoolExecutor(1, 5, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new RejectHandler());
        this.sendAndGetThreadPool = new ThreadPoolExecutor(1, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new RejectHandler());
        if (!noUdp) {
            try {
                this.udpChannel = DatagramChannel.open();
                this.udpSocket = this.udpChannel.socket();
                this.udpSocket.setReceiveBufferSize(65536);
                this.udpSocket.bind(new InetSocketAddress(0));
                this.udpPort = this.udpSocket.getLocalPort();
            }
            catch (IOException ex) {
                if (this.udpChannel != null) {
                    this.udpChannel.close();
                }
                ex.printStackTrace();
                cMsgException e = new cMsgException("Exiting Server: cannot create socket to listen on");
                e.setReturnCode(12);
                throw e;
            }
        }
        this.selector = Selector.open();
    }

    void startThreads() throws IOException {
        this.requestHandlerThread = new RequestHandler();
        this.start();
    }

    synchronized int numberOfClients() {
        return this.clients.size();
    }

    private synchronized void removeClient(cMsgClientData info) {
        String s = this.clients.remove(info);
        if (s != null) {
            this.makeDomainServerAvailable();
        }
    }

    private synchronized void makeDomainServerAvailable() {
        if (this.clients.size() < this.clientsMax && !this.nameServer.availableDomainServers.contains(this)) {
            this.nameServer.availableDomainServers.add(this);
        }
    }

    synchronized boolean addClient(cMsgClientData info) throws IOException {
        if (this.clients.size() >= this.clientsMax) {
            return false;
        }
        this.clients.put(info, "");
        this.myClientInfo = info;
        if (!this.noUdp) {
            info.setDomainUdpPort(this.udpSocket.getLocalPort());
        }
        info.getDeliverer().createClientConnection(info.getMessageChannel(), false);
        this.clients2register.put(info, "");
        this.selector.wakeup();
        this.makeDomainServerAvailable();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void shutdown() {
        for (cMsgClientData cd : this.clients.keySet()) {
            if (!cd.calledSubdomainShutdown.compareAndSet(false, true)) continue;
            try {
                cd.subdomainHandler.handleClientShutdown();
            }
            catch (cMsgException cMsgException2) {}
        }
        this.nameServer.domainServersSelect.remove(this);
        this.nameServer.availableDomainServers.remove(this);
        this.bufferQ.clear();
        this.requestHandlerThread.interrupt();
        if (!this.noUdp) {
            this.udpSocket.close();
        }
        for (cMsgClientData cd : this.clients.keySet()) {
            try {
                cd.keepAliveChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                cd.getMessageChannel().close();
            }
            catch (IOException iOException) {}
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.killMainThread = true;
        for (cMsgClientData cd : this.clients.keySet()) {
            if (!cd.isServer()) {
                this.nameServer.subscribeLock.lock();
                try {
                    ConcurrentHashMap<String, cMsgServerBridge> concurrentHashMap = this.nameServer.bridges;
                    synchronized (concurrentHashMap) {
                        for (cMsgServerBridge b : this.nameServer.bridges.values()) {
                            if (b.getCloudStatus() != 0) continue;
                            for (cMsgServerSubscribeInfo sub : this.nameServer.subscriptions) {
                                if (sub.info != cd) continue;
                                try {
                                    if (sub.isSubscribed()) {
                                        b.unsubscribe(sub.subject, sub.type, sub.namespace);
                                    }
                                    for (Map.Entry<Integer, cMsgCallbackAdapter> entry : sub.getSubAndGetters().entrySet()) {
                                        b.unsubscribeAndGet(sub.subject, sub.type, sub.namespace, entry.getValue());
                                    }
                                }
                                catch (IOException iOException) {
                                }
                            }
                        }
                    }
                    Iterator<cMsgServerSubscribeInfo> it = this.nameServer.subscriptions.iterator();
                    while (it.hasNext()) {
                        cMsgServerSubscribeInfo sub = it.next();
                        if (sub.info != cd) continue;
                        it.remove();
                    }
                    continue;
                }
                finally {
                    this.nameServer.subscribeLock.unlock();
                    continue;
                }
            }
            cMsgServerBridge b = this.nameServer.bridges.remove(cd.getName());
            if (b != null) {
                b.client.cleanup();
            }
            cMsgClientData cDat = this.nameServer.nameServers.remove(cd.getName());
            if (this.debug < 4) continue;
            if (b != null && cDat != null) {
                System.out.println(">>    DS: DELETED server client FROM BRIDGES AND NAMESERVERS");
                continue;
            }
            System.out.println(">>    DS: COULD NOT DELETE Client FROM BRIDGES AND/OR NAMESERVERS");
        }
        this.subAndGetThreadPool.shutdownNow();
        this.sendAndGetThreadPool.shutdownNow();
        this.clients.clear();
        this.clients2register.clear();
        this.sendAndGetters.clear();
        this.myClientInfo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteClient(cMsgClientData cd) {
        if (!this.clients.containsKey(cd)) {
            return;
        }
        this.removeClient(cd);
        Object it = this.bufferQ.iterator();
        while (it.hasNext()) {
            int msgId;
            cMsgHolder hldr = it.next();
            if (hldr == null || hldr.data != cd || (msgId = cMsgUtilities.bytesToInt(hldr.array, 0)) == 5) continue;
            it.remove();
        }
        if (!cd.isServer()) {
            this.nameServer.subscribeLock.lock();
            try {
                it = this.nameServer.bridges;
                synchronized (it) {
                    for (cMsgServerBridge b : this.nameServer.bridges.values()) {
                        if (b.getCloudStatus() != 0) continue;
                        for (cMsgServerSubscribeInfo sub : this.nameServer.subscriptions) {
                            if (sub.info != cd) continue;
                            try {
                                if (sub.isSubscribed()) {
                                    b.unsubscribe(sub.subject, sub.type, sub.namespace);
                                }
                                for (Map.Entry<Integer, cMsgCallbackAdapter> entry : sub.getSubAndGetters().entrySet()) {
                                    b.unsubscribeAndGet(sub.subject, sub.type, sub.namespace, entry.getValue());
                                }
                            }
                            catch (IOException iOException) {
                            }
                        }
                    }
                }
                Iterator<cMsgServerSubscribeInfo> it2 = this.nameServer.subscriptions.iterator();
                while (it2.hasNext()) {
                    cMsgServerSubscribeInfo sub = it2.next();
                    if (sub.info != cd) continue;
                    it2.remove();
                }
            }
            finally {
                this.nameServer.subscribeLock.unlock();
            }
        }
        cMsgServerBridge b = this.nameServer.bridges.remove(cd.getName());
        if (b != null) {
            b.client.cleanup();
        }
        cMsgClientData cDat = this.nameServer.nameServers.remove(cd.getName());
        if (this.debug >= 4) {
            if (b != null && cDat != null) {
                System.out.println("    **** DELETED server client FROM BRIDGES AND NAMESERVERS");
            } else {
                System.out.println("    **** COULD NOT DELETE Client FROM BRIDGES AND/OR NAMESERVERS");
            }
        }
        int iterations = 100;
        block21: while (iterations-- > 0) {
            for (cMsgHolder holder : this.bufferQ) {
                if (cd != holder.data) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
                continue block21;
            }
        }
        if (cd.calledSubdomainShutdown.compareAndSet(false, true)) {
            try {
                cd.subdomainHandler.handleClientShutdown();
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }
        try {
            cd.keepAliveChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            cd.getMessageChannel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (cd.getDeliverer() != null) {
            cd.getDeliverer().close();
        }
        if (this.clients.size() < 1) {
            this.myClientInfo = null;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 36[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class RequestHandler
    extends Thread {
        RequestHandler() {
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            cMsgClientData info = null;
            block33: while (true) {
                try {
                    block34: while (true) {
                        cMsgHolder holder;
                        try {
                            holder = (cMsgHolder)cMsgDomainServerSelect.this.bufferQ.take();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        byte[] array = holder.array;
                        info = holder.data;
                        int msgId = cMsgUtilities.bytesToInt(array, 0);
                        switch (msgId) {
                            case 5: {
                                if (holder.isUdpChannel) {
                                    ++info.monData.udpSends;
                                } else {
                                    ++info.monData.tcpSends;
                                }
                                holder = this.readSendInfo(array, info);
                                info.subdomainHandler.handleSendRequest(holder.message);
                                break;
                            }
                            case 6: {
                                ++info.monData.syncSends;
                                holder = this.readSendInfo(array, info);
                                int i = info.subdomainHandler.handleSyncSendRequest(holder.message);
                                info.getDeliverer().deliverMessage(i, holder.ssid, 25);
                                break;
                            }
                            case 9: {
                                holder = this.readSubscribeInfo(array);
                                ++info.monData.subAndGets;
                                if (info.cMsgSubdomainHandler == null) {
                                    info.subdomainHandler.handleSubscribeAndGetRequest(holder.subject, holder.type, holder.id);
                                    break;
                                }
                                this.handleCmsgSubdomainSubscribeAndGet(holder, info);
                                break;
                            }
                            case 10: {
                                holder = this.readSubscribeInfo(array);
                                info.subdomainHandler.handleUnsubscribeAndGetRequest(holder.subject, holder.type, holder.id);
                                if (info.cMsgSubdomainHandler == null) continue block33;
                                this.handleCmsgSubdomainUnsubscribeAndGet(holder, info);
                                break;
                            }
                            case 11: {
                                holder = this.readGetInfo(array, info);
                                ++info.monData.sendAndGets;
                                if (info.cMsgSubdomainHandler == null) {
                                    info.subdomainHandler.handleSendAndGetRequest(holder.message);
                                    break;
                                }
                                this.handleCmsgSubdomainSendAndGet(holder, info);
                                break;
                            }
                            case 12: {
                                holder = this.readUngetInfo(array);
                                info.subdomainHandler.handleUnSendAndGetRequest(holder.id);
                                break;
                            }
                            case 44: {
                                holder = this.readGetInfo(array, info);
                                info.cMsgSubdomainHandler.handleServerSendAndGetRequest(holder.message, holder.namespace);
                                break;
                            }
                            case 45: {
                                holder = this.readUngetInfo(array);
                                info.cMsgSubdomainHandler.handleUnSendAndGetRequest(holder.id);
                                break;
                            }
                            case 7: {
                                holder = this.readSubscribeInfo(array);
                                ++info.monData.subscribes;
                                info.subdomainHandler.handleSubscribeRequest(holder.subject, holder.type, holder.id);
                                if (info.cMsgSubdomainHandler == null) continue block33;
                                this.handleCmsgSubdomainSubscribe(holder, info);
                                break;
                            }
                            case 8: {
                                holder = this.readSubscribeInfo(array);
                                ++info.monData.unsubscribes;
                                info.subdomainHandler.handleUnsubscribeRequest(holder.subject, holder.type, holder.id);
                                if (info.cMsgSubdomainHandler == null) continue block33;
                                this.handleCmsgSubdomainUnsubscribe(holder, info);
                                break;
                            }
                            case 30: {
                                holder = this.readSubscribeInfo(array);
                                info.cMsgSubdomainHandler.handleServerSubscribeRequest(holder.subject, holder.type, holder.namespace);
                                break;
                            }
                            case 31: {
                                holder = this.readSubscribeInfo(array);
                                info.cMsgSubdomainHandler.handleServerUnsubscribeRequest(holder.subject, holder.type, holder.namespace);
                                break;
                            }
                            case 13: {
                                break;
                            }
                            case 1: {
                                if (cMsgDomainServerSelect.this.debug >= 1) {
                                    System.out.println("Client " + info.getName() + " called disconnect");
                                }
                                cMsgDomainServerSelect.this.deleteClient(info);
                                break;
                            }
                            case 47: {
                                cMsgDomainServerSelect.this.nameServer.shutdown();
                                break;
                            }
                            case 46: {
                                holder = this.readShutdownInfo(array);
                                info.subdomainHandler.handleShutdownClientsRequest(holder.client, holder.include);
                                break;
                            }
                            case 3: {
                                holder = this.readShutdownInfo(array);
                                info.subdomainHandler.handleShutdownClientsRequest(holder.client, holder.include);
                                if (((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.size() <= 0) continue block33;
                                Iterator<cMsgServerBridge> iterator = ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.values().iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block33;
                                    cMsgServerBridge b = iterator.next();
                                    if (b.getCloudStatus() != 0) continue;
                                    b.shutdownClients(holder.client, holder.include);
                                }
                            }
                            case 4: {
                                holder = this.readShutdownInfo(array);
                                if (((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.size() > 0) {
                                    for (cMsgServerBridge b : ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.values()) {
                                        if (b.getCloudStatus() != 0 || !cMsgSubscription.matches(holder.client, b.serverName, true)) continue;
                                        b.shutdownServer();
                                    }
                                }
                                if (!holder.include || !cMsgSubscription.matches(holder.client, cMsgDomainServerSelect.this.nameServer.getServerName(), true)) continue block33;
                                cMsgDomainServerSelect.this.nameServer.shutdown();
                                break;
                            }
                            case 40: {
                                cMsgClientData cMsgClientData2 = info;
                                cMsgClientData2.cMsgSubdomainHandler.registrationUnlock();
                                break;
                            }
                            case 39: {
                                int delay = cMsgUtilities.bytesToInt(array, 4);
                                cMsg cfr_ignored_0 = info.cMsgSubdomainHandler;
                                boolean gotLock = cMsg.registrationLock(delay);
                                int answer = gotLock ? 1 : 0;
                                info.getDeliverer().deliverMessage(answer, 0, 28);
                                break;
                            }
                            case 42: {
                                try {
                                    cMsgDomainServerSelect.this.nameServer.cloudUnlock();
                                }
                                catch (Exception e) {
                                    System.out.println("CANNOT UNLOCK CLOUD");
                                    e.printStackTrace();
                                }
                                continue block34;
                            }
                            case 41: {
                                int delay = cMsgUtilities.bytesToInt(array, 4);
                                boolean gotLock = cMsgDomainServerSelect.this.nameServer.cloudLock(delay);
                                int answer = gotLock ? 1 : 0;
                                info.getDeliverer().deliverMessage(answer, 0, 27);
                                break;
                            }
                            case 43: {
                                int status = cMsgUtilities.bytesToInt(array, 4);
                                this.setCloudStatus(status, info);
                                break;
                            }
                            case 38: {
                                cMsgClientData cMsgClientData3 = info;
                                info.getDeliverer().deliverMessage(cMsgClientData3.cMsgSubdomainHandler.getClientNamesAndNamespaces(), 26);
                                break;
                            }
                            default: {
                                if (cMsgDomainServerSelect.this.debug >= 3) {
                                    System.out.println("dServer handleClient: can't understand your message " + info.getName());
                                }
                                cMsgDomainServerSelect.this.deleteClient(info);
                            }
                        }
                    }
                }
                catch (cMsgException ex) {
                    ex.printStackTrace();
                    cMsgDomainServerSelect.this.deleteClient(info);
                    continue;
                }
                catch (IOException ex) {
                    cMsgDomainServerSelect.this.deleteClient(info);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setCloudStatus(int status, cMsgClientData info) {
            if (status != 0) {
                return;
            }
            cMsgServerBridge bridge = ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.get(info.getName());
            ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.lock();
            try {
                if (bridge != null) {
                    bridge.setCloudStatus(status);
                    if (cMsgDomainServerSelect.this.debug >= 4) {
                        System.out.println("    DS: " + bridge.serverName + " has joined the cloud");
                    }
                } else {
                    String alternateName;
                    String name = info.getName();
                    String sPort = name.substring(name.lastIndexOf(":") + 1);
                    int n = name.indexOf(".");
                    if (n > -1) {
                        alternateName = name.substring(0, n) + ":" + (String)sPort;
                    } else {
                        try {
                            alternateName = name.substring(0, name.lastIndexOf(":"));
                            alternateName = InetAddress.getByName(alternateName).getCanonicalHostName();
                            alternateName = alternateName + ":" + (String)sPort;
                        }
                        catch (UnknownHostException e) {
                            if (cMsgDomainServerSelect.this.debug >= 2) {
                                System.out.println("    DS: cannot find bridge to server " + bridge.serverName);
                            }
                            ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.unlock();
                            return;
                        }
                    }
                    bridge = ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.get(alternateName);
                    if (bridge != null) {
                        bridge.setCloudStatus(status);
                        if (cMsgDomainServerSelect.this.debug >= 4) {
                            System.out.println("    DS: " + bridge.serverName + " has joined the cloud");
                        }
                    } else {
                        if (cMsgDomainServerSelect.this.debug >= 2) {
                            System.out.println("    DS: cannot find bridge to server " + bridge.serverName);
                        }
                        return;
                    }
                }
                for (cMsgServerSubscribeInfo sub : ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions) {
                    try {
                        if (sub.isSubscribed()) {
                            bridge.subscribe(sub.subject, sub.type, sub.namespace);
                        }
                        for (Map.Entry entry : sub.getSubAndGetters().entrySet()) {
                            bridge.subscribeAndGet(sub.subject, sub.type, sub.namespace, (cMsgCallbackInterface)entry.getValue());
                        }
                    }
                    catch (IOException e) {
                        if (cMsgDomainServerSelect.this.debug < 3) continue;
                        System.out.println("dServer requestThread: cannot subscribe with server " + bridge.serverName);
                        e.printStackTrace();
                    }
                }
            }
            finally {
                ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.unlock();
            }
        }

        private cMsgHolder readSendInfo(byte[] array, cMsgClientData info) throws IOException {
            cMsgMessageFull msg = new cMsgMessageFull();
            int index = 4;
            int ssid = cMsgUtilities.bytesToInt(array, index);
            msg.setUserInt(cMsgUtilities.bytesToInt(array, index += 4));
            msg.setSysMsgId(cMsgUtilities.bytesToInt(array, index += 4));
            msg.setSenderToken(cMsgUtilities.bytesToInt(array, index += 4));
            msg.setInfo(cMsgUtilities.bytesToInt(array, index += 4) | 0x10);
            msg.setExpandedPayload(false);
            long time = (long)cMsgUtilities.bytesToInt(array, index += 4) << 32 | (long)cMsgUtilities.bytesToInt(array, index + 4) & 0xFFFFFFFFL;
            msg.setSenderTime(new Date(time));
            time = (long)cMsgUtilities.bytesToInt(array, index += 8) << 32 | (long)cMsgUtilities.bytesToInt(array, index + 4) & 0xFFFFFFFFL;
            msg.setUserTime(new Date(time));
            int lengthSubject = cMsgUtilities.bytesToInt(array, index += 8);
            int lengthType = cMsgUtilities.bytesToInt(array, index += 4);
            int lengthPayloadTxt = cMsgUtilities.bytesToInt(array, index += 4);
            int lengthText = cMsgUtilities.bytesToInt(array, index += 4);
            int lengthBinary = cMsgUtilities.bytesToInt(array, index += 4);
            msg.setSubject(new String(array, index += 4, lengthSubject, "US-ASCII"));
            msg.setType(new String(array, index += lengthSubject, lengthType, "US-ASCII"));
            index += lengthType;
            if (lengthPayloadTxt > 0) {
                String s = new String(array, index, lengthPayloadTxt, "US-ASCII");
                index += lengthPayloadTxt;
                msg.setPayloadText(s);
            }
            if (lengthText > 0) {
                msg.setText(new String(array, index, lengthText, "US-ASCII"));
                index += lengthText;
            } else {
                msg.setText("");
            }
            if (lengthBinary > 0) {
                try {
                    msg.setByteArrayNoCopy(array, index, lengthBinary);
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
            msg.setVersion(6);
            msg.setDomain(domainType);
            msg.setReceiver("cMsg domain server");
            msg.setReceiverHost(info.getDomainHost());
            msg.setReceiverTime(new Date());
            msg.setSender(info.getName());
            msg.setSenderHost(info.getClientHost());
            return new cMsgHolder(msg, ssid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCmsgSubdomainSubscribeAndGet(cMsgHolder holder, cMsgClientData info) throws cMsgException {
            boolean localOnly = true;
            cMsgCallbackAdapter cb3 = null;
            cMsgNotifier notifier = null;
            cMsgServerSubscribeInfo sub = null;
            holder.namespace = info.getNamespace();
            ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.lock();
            try {
                if (((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.standAlone || ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.size() < 1) {
                    info.subdomainHandler.handleSubscribeAndGetRequest(holder.subject, holder.type, holder.id);
                } else {
                    localOnly = false;
                    notifier = new cMsgNotifier();
                    notifier.id = holder.id;
                    notifier.latch = new CountDownLatch(1);
                    notifier.client = info;
                    cb3 = cMsgServerBridge.getSubAndGetCallback();
                    for (cMsgServerBridge b : ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.values()) {
                        if (b.getCloudStatus() != 0) continue;
                        try {
                            if (notifier.latch.getCount() < 1L) break;
                            b.subscribeAndGet(holder.subject, holder.type, holder.namespace, cb3);
                        }
                        catch (IOException e) {
                            if (cMsgDomainServerSelect.this.debug < 3) continue;
                            System.out.println("dServer requestThread: cannot subscribe with server " + b.serverName);
                            e.printStackTrace();
                        }
                    }
                    info.cMsgSubdomainHandler.handleServerSubscribeAndGetRequest(holder.subject, holder.type, notifier);
                }
                boolean subscriptionExists = false;
                Iterator<cMsgServerSubscribeInfo> iterator = ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions.iterator();
                while (iterator.hasNext()) {
                    cMsgServerSubscribeInfo subscription;
                    sub = subscription = iterator.next();
                    if (sub.info != info || !sub.namespace.equals(info.getNamespace()) || !sub.subject.equals(holder.subject) || !sub.type.equals(holder.type)) continue;
                    subscriptionExists = true;
                    break;
                }
                if (subscriptionExists) {
                    sub.addSubAndGetter(holder.id, cb3);
                } else {
                    sub = new cMsgServerSubscribeInfo(holder.subject, holder.type, holder.namespace, info, holder.id, cb3);
                    ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions.add(sub);
                }
            }
            finally {
                ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.unlock();
            }
            if (!localOnly) {
                cMsgServerSubscribeAndGetter getter = new cMsgServerSubscribeAndGetter(cMsgDomainServerSelect.this.nameServer, notifier, cb3, ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions, sub);
                cMsgDomainServerSelect.this.subAndGetThreadPool.execute(getter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCmsgSubdomainUnsubscribeAndGet(cMsgHolder holder, cMsgClientData info) {
            ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.lock();
            try {
                cMsgServerSubscribeInfo sub = null;
                Iterator<cMsgServerSubscribeInfo> iterator = ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions.iterator();
                while (iterator.hasNext()) {
                    cMsgServerSubscribeInfo subscription;
                    sub = subscription = iterator.next();
                    if (sub.info != info || !sub.namespace.equals(info.getNamespace()) || !sub.subject.equals(holder.subject) || !sub.type.equals(holder.type)) continue;
                    sub.removeSubAndGetter(holder.id);
                    break;
                }
                if (sub != null && sub.numberOfSubscribers() < 1) {
                    ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions.remove(sub);
                }
            }
            finally {
                ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.unlock();
            }
        }

        private void handleCmsgSubdomainSendAndGet(cMsgHolder holder, cMsgClientData info) throws cMsgException {
            if (((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.standAlone || ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.size() < 1) {
                info.subdomainHandler.handleSendAndGetRequest(holder.message);
                return;
            }
            holder.namespace = info.getNamespace();
            cMsgNotifier notifier = new cMsgNotifier();
            notifier.id = holder.message.getSenderToken();
            notifier.latch = new CountDownLatch(1);
            notifier.client = info;
            int smId = info.cMsgSubdomainHandler.handleServerSendAndGetRequest(holder.message, holder.namespace, notifier);
            cMsgCallbackAdapter cb3 = cMsgServerBridge.getSendAndGetCallback(holder.message.getSenderToken(), smId);
            for (cMsgServerBridge b : ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.values()) {
                if (b.getCloudStatus() != 0) continue;
                try {
                    if (notifier.latch.getCount() < 1L) break;
                    b.sendAndGet(holder.message, holder.namespace, cb3);
                }
                catch (IOException e) {
                    System.out.println("DS requestThread: error on sendAndGet with server " + b.serverName);
                    e.printStackTrace();
                }
            }
            cMsgServerSendAndGetter getter = new cMsgServerSendAndGetter(cMsgDomainServerSelect.this.nameServer, notifier, cMsgDomainServerSelect.this.sendAndGetters);
            cMsgDomainServerSelect.this.sendAndGetters.put(notifier.id, getter);
            cMsgDomainServerSelect.this.sendAndGetThreadPool.execute(getter);
        }

        private cMsgHolder readGetInfo(byte[] array, cMsgClientData info) throws IOException {
            cMsgMessageFull msg = new cMsgMessageFull();
            int index = 8;
            msg.setUserInt(cMsgUtilities.bytesToInt(array, index));
            msg.setSenderToken(cMsgUtilities.bytesToInt(array, index += 4));
            msg.setInfo(cMsgUtilities.bytesToInt(array, index += 4) | 0x10);
            msg.setExpandedPayload(false);
            long time = (long)cMsgUtilities.bytesToInt(array, index += 4) << 32 | (long)cMsgUtilities.bytesToInt(array, index + 4) & 0xFFFFFFFFL;
            msg.setSenderTime(new Date(time));
            time = (long)cMsgUtilities.bytesToInt(array, index += 8) << 32 | (long)cMsgUtilities.bytesToInt(array, index + 4) & 0xFFFFFFFFL;
            msg.setUserTime(new Date(time));
            int lengthSubject = cMsgUtilities.bytesToInt(array, index += 8);
            int lengthType = cMsgUtilities.bytesToInt(array, index += 4);
            int lengthNamespace = cMsgUtilities.bytesToInt(array, index += 4);
            int lengthPayloadTxt = cMsgUtilities.bytesToInt(array, index += 4);
            int lengthText = cMsgUtilities.bytesToInt(array, index += 4);
            int lengthBinary = cMsgUtilities.bytesToInt(array, index += 4);
            msg.setSubject(new String(array, index += 4, lengthSubject, "US-ASCII"));
            msg.setType(new String(array, index += lengthSubject, lengthType, "US-ASCII"));
            index += lengthType;
            String ns = null;
            if (lengthNamespace > 0) {
                ns = new String(array, index, lengthNamespace, "US-ASCII");
                index += lengthNamespace;
            }
            if (lengthPayloadTxt > 0) {
                String s = new String(array, index, lengthPayloadTxt, "US-ASCII");
                msg.setPayloadText(s);
                index += lengthPayloadTxt;
            }
            if (lengthText > 0) {
                msg.setText(new String(array, index, lengthText, "US-ASCII"));
                index += lengthText;
            } else {
                msg.setText("");
            }
            if (lengthBinary > 0) {
                try {
                    msg.setByteArrayNoCopy(array, index, lengthBinary);
                }
                catch (cMsgException s) {
                    // empty catch block
                }
            }
            msg.setVersion(6);
            msg.setGetRequest(true);
            msg.setDomain(domainType);
            msg.setReceiver("cMsg domain server");
            msg.setReceiverHost(info.getDomainHost());
            msg.setReceiverTime(new Date());
            msg.setSender(info.getName());
            msg.setSenderHost(info.getClientHost());
            cMsgHolder h = new cMsgHolder(msg);
            h.namespace = ns;
            return h;
        }

        private cMsgHolder readUngetInfo(byte[] array) throws IOException {
            cMsgHolder holder = new cMsgHolder();
            holder.id = cMsgUtilities.bytesToInt(array, 4);
            return holder;
        }

        private cMsgHolder readSubscribeInfo(byte[] array) throws IOException {
            cMsgHolder holder = new cMsgHolder();
            int index = 4;
            holder.id = cMsgUtilities.bytesToInt(array, index);
            int lengthSubject = cMsgUtilities.bytesToInt(array, index += 4);
            int lengthType = cMsgUtilities.bytesToInt(array, index += 4);
            int lengthNamespace = cMsgUtilities.bytesToInt(array, index += 4);
            holder.subject = new String(array, index += 4, lengthSubject, "US-ASCII");
            holder.type = new String(array, index += lengthSubject, lengthType, "US-ASCII");
            index += lengthType;
            if (lengthNamespace > 0) {
                holder.namespace = new String(array, index, lengthNamespace, "US-ASCII");
            }
            return holder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCmsgSubdomainSubscribe(cMsgHolder holder, cMsgClientData info) throws cMsgException {
            holder.namespace = info.getNamespace();
            ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.lock();
            try {
                cMsgServerSubscribeInfo sub = null;
                if (((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.size() > 0) {
                    for (cMsgServerBridge b : ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.values()) {
                        if (b.getCloudStatus() != 0) continue;
                        try {
                            b.subscribe(holder.subject, holder.type, holder.namespace);
                        }
                        catch (IOException e) {
                            if (cMsgDomainServerSelect.this.debug < 3) continue;
                            System.out.println("dServer requestThread: cannot subscribe with server " + b.serverName);
                            e.printStackTrace();
                        }
                    }
                }
                boolean subExists = false;
                Iterator<cMsgServerSubscribeInfo> iterator = ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions.iterator();
                while (iterator.hasNext()) {
                    cMsgServerSubscribeInfo subscription;
                    sub = subscription = iterator.next();
                    if (sub.info != info || !sub.namespace.equals(holder.namespace) || !sub.subject.equals(holder.subject) || !sub.type.equals(holder.type)) continue;
                    subExists = true;
                    break;
                }
                if (subExists) {
                    sub.addSubscription();
                } else {
                    sub = new cMsgServerSubscribeInfo(holder.subject, holder.type, holder.namespace, info);
                    ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions.add(sub);
                }
            }
            finally {
                ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCmsgSubdomainUnsubscribe(cMsgHolder holder, cMsgClientData info) {
            ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.lock();
            try {
                cMsgServerSubscribeInfo sub = null;
                if (((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.size() > 0) {
                    for (cMsgServerBridge b : ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.bridges.values()) {
                        if (b.getCloudStatus() != 0) continue;
                        try {
                            b.unsubscribe(holder.subject, holder.type, info.getNamespace());
                        }
                        catch (IOException e) {
                            if (cMsgDomainServerSelect.this.debug < 3) continue;
                            System.out.println("dServer requestThread: cannot unsubscribe with server " + b.serverName);
                            e.printStackTrace();
                        }
                    }
                }
                Iterator<Object> iterator = ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions.iterator();
                while (iterator.hasNext()) {
                    cMsgServerSubscribeInfo subscription;
                    sub = subscription = (cMsgServerSubscribeInfo)iterator.next();
                    if (sub.info != info || !sub.namespace.equals(info.getNamespace()) || !sub.subject.equals(holder.subject) || !sub.type.equals(holder.type)) continue;
                    sub.removeSubscription();
                    break;
                }
                if (sub != null && sub.numberOfSubscribers() < 1) {
                    ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscriptions.remove(sub);
                }
            }
            finally {
                ((cMsgDomainServerSelect)cMsgDomainServerSelect.this).nameServer.subscribeLock.unlock();
            }
        }

        private cMsgHolder readShutdownInfo(byte[] array) throws IOException {
            int index = 4;
            int flag = cMsgUtilities.bytesToInt(array, index);
            int lengthClient = cMsgUtilities.bytesToInt(array, index += 4);
            String client = new String(array, index += 4, lengthClient, "US-ASCII");
            return new cMsgHolder(client, flag == 1);
        }
    }
}

