/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.cMsgDomain.cMsgMonitor;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgDomain.cMsgMonitor.Monitor;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MonitorPanel
extends JPanel {
    private String udl;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode topNode;
    private HashMap<String, DefaultMutableTreeNode> serverMap = new HashMap(10);
    private HashMap<String, DefaultMutableTreeNode> clientMap = new HashMap(20);
    private HashMap<String, DefaultMutableTreeNode> subMap = new HashMap(50);
    private cMsg connection;
    private Document document;
    private boolean updated;
    private Monitor monitor;
    private JButton pauseButton;
    private JSpinner period;
    private boolean paused;
    private int updatePeriod = 2;
    private MessageProcessor processor;
    private boolean killThread;
    Runnable updateDisplay = new Runnable(){

        @Override
        public void run() {
            MonitorPanel.this.displayDomTree();
        }
    };

    public MonitorPanel(String udl, Monitor tabbedPane) throws cMsgException {
        this.udl = udl;
        this.monitor = tabbedPane;
        String uniqueName = "monitor_" + System.currentTimeMillis();
        this.connection = new cMsg(udl, uniqueName, "monitor");
        this.connection.connect();
        this.topNode = new DefaultMutableTreeNode("Monitor Data");
        this.createDisplay();
        this.processor = new MessageProcessor();
        this.processor.start();
    }

    private void close() {
        try {
            this.connection.disconnect();
        }
        catch (cMsgException cMsgException2) {
            // empty catch block
        }
        this.monitor.tabbedPane.remove(this);
        this.monitor.monitors.remove(this.udl);
        this.killThread = true;
        this.processor.interrupt();
    }

    private void createDisplay() {
        this.treeModel = new DefaultTreeModel(this.topNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setDoubleBuffered(true);
        this.tree.setLargeModel(true);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        this.tree.setCellRenderer(renderer);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.setLayout(new BorderLayout());
        this.add("Center", treeView);
        this.add("South", this.createLowerPanel());
    }

    private JPanel createLowerPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentX(0.0f);
        EmptyBorder eb = new EmptyBorder(10, 10, 10, 10);
        BevelBorder bb = new BevelBorder(1);
        CompoundBorder cb3 = new CompoundBorder(eb, bb);
        panel.setBorder(cb3);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorPanel.this.close();
            }
        });
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MonitorPanel.this.paused) {
                    MonitorPanel.this.paused = false;
                    MonitorPanel.this.pauseButton.setText("Pause");
                } else {
                    MonitorPanel.this.paused = true;
                    MonitorPanel.this.pauseButton.setText("Resume");
                }
            }
        });
        JPanel panel1 = new JPanel();
        JLabel label1 = new JLabel("Update period (sec) : ");
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(2, 1, 100, 1);
        spinnerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MonitorPanel.this.updatePeriod = (Integer)MonitorPanel.this.period.getValue();
                MonitorPanel.this.processor.interrupt();
            }
        });
        this.period = new JSpinner(spinnerModel);
        panel1.add(label1);
        panel1.add(this.period);
        panel.add(this.pauseButton);
        panel.add(panel1);
        panel.add(closeButton);
        return panel;
    }

    private void displayDomTree() {
        int serverIndex = 0;
        int end = 499;
        int last = 99;
        StringBuilder str = new StringBuilder(500);
        StringBuilder nameBuilder = new StringBuilder(100);
        NodeList serverList = this.document.getChildNodes().item(0).getChildNodes();
        HashSet<String> removeServerNames = new HashSet<String>(this.serverMap.keySet());
        HashSet<String> currentServerNames = new HashSet<String>(10);
        HashSet<String> removeClientNames = new HashSet<String>(this.clientMap.keySet());
        HashSet<String> currentClientNames = new HashSet<String>(20);
        HashSet<String> removeSubNames = new HashSet<String>(this.subMap.keySet());
        HashSet<String> currentSubNames = new HashSet<String>(50);
        for (int i = 0; i < serverList.getLength(); ++i) {
            DefaultMutableTreeNode jtreeServerNode;
            Node serverNode = serverList.item(i);
            if (serverNode.getNodeType() != 1) continue;
            Element el = (Element)serverNode;
            String serverName = el.getAttribute("name");
            str.append("server = ");
            str.append(serverName);
            if (this.serverMap.containsKey(serverName)) {
                jtreeServerNode = this.serverMap.get(serverName);
                jtreeServerNode.setUserObject(str.toString());
                this.treeModel.nodeChanged(jtreeServerNode);
            } else {
                jtreeServerNode = new DefaultMutableTreeNode(str.toString());
                this.treeModel.insertNodeInto(jtreeServerNode, this.topNode, serverIndex);
                this.serverMap.put(serverName, jtreeServerNode);
            }
            currentServerNames.add(serverName);
            str.delete(0, end);
            ++serverIndex;
            int clientIndex = 0;
            if (!serverNode.hasChildNodes()) continue;
            NodeList clientList = serverNode.getChildNodes();
            for (int j = 0; j < clientList.getLength(); ++j) {
                DefaultMutableTreeNode jtreeNode;
                boolean clientJustCreated;
                DefaultMutableTreeNode jtreeClientNode;
                Node clientNode = clientList.item(j);
                if (clientNode.getNodeType() != 1) continue;
                el = (Element)clientNode;
                String clientName = el.getAttribute("name");
                String subdomain = el.getAttribute("subdomain");
                str.append("client = ");
                str.append(clientName);
                String fullClientName = clientName + ":" + serverName;
                if (this.clientMap.containsKey(fullClientName)) {
                    jtreeClientNode = this.clientMap.get(fullClientName);
                    jtreeClientNode.setUserObject(str.toString());
                    this.treeModel.nodeChanged(jtreeClientNode);
                    clientJustCreated = false;
                } else {
                    jtreeClientNode = new DefaultMutableTreeNode(str.toString());
                    this.treeModel.insertNodeInto(jtreeClientNode, jtreeServerNode, clientIndex);
                    this.clientMap.put(fullClientName, jtreeClientNode);
                    clientJustCreated = true;
                }
                currentClientNames.add(fullClientName);
                str.delete(0, end);
                ++clientIndex;
                if (!clientNode.hasChildNodes()) continue;
                int index = 0;
                NodeList domList = el.getElementsByTagName("namespace");
                Node domNode = domList.item(0);
                str.append("subdomain = ");
                str.append(subdomain);
                str.append(",  namespace = ");
                str.append(domNode.getTextContent());
                if (clientJustCreated) {
                    jtreeNode = new DefaultMutableTreeNode(str.toString());
                    this.treeModel.insertNodeInto(jtreeNode, jtreeClientNode, index);
                } else {
                    jtreeNode = (DefaultMutableTreeNode)jtreeClientNode.getChildAt(index);
                    jtreeNode.setUserObject(str.toString());
                }
                str.delete(0, end);
                ++index;
                domList = el.getElementsByTagName("timeConnected");
                domNode = domList.item(0);
                str.append("time connected = ");
                str.append(domNode.getTextContent());
                if (clientJustCreated) {
                    jtreeNode = new DefaultMutableTreeNode(str.toString());
                    this.treeModel.insertNodeInto(jtreeNode, jtreeClientNode, index);
                } else {
                    jtreeNode = (DefaultMutableTreeNode)jtreeClientNode.getChildAt(index);
                    jtreeNode.setUserObject(str.toString());
                }
                str.delete(0, end);
                ++index;
                domList = el.getElementsByTagName("sendStats");
                Element e2 = (Element)domList.item(0);
                str.append("send stats : tcpSends= ");
                str.append(e2.getAttribute("tcpSends"));
                str.append(",  udpSends= ");
                str.append(e2.getAttribute("udpSends"));
                str.append(",  syncSends= ");
                str.append(e2.getAttribute("syncSends"));
                str.append(",  send&Gets= ");
                str.append(e2.getAttribute("sendAndGets"));
                if (clientJustCreated) {
                    jtreeNode = new DefaultMutableTreeNode(str.toString());
                    this.treeModel.insertNodeInto(jtreeNode, jtreeClientNode, index);
                } else {
                    jtreeNode = (DefaultMutableTreeNode)jtreeClientNode.getChildAt(index);
                    jtreeNode.setUserObject(str.toString());
                }
                str.delete(0, end);
                ++index;
                domList = el.getElementsByTagName("subStats");
                e2 = (Element)domList.item(0);
                str.append("sub stats : subscribes= ");
                str.append(e2.getAttribute("subscribes"));
                str.append(",  unsubscribes= ");
                str.append(e2.getAttribute("unsubscribes"));
                str.append(",  sub&Gets= ");
                str.append(e2.getAttribute("subAndGets"));
                if (clientJustCreated) {
                    jtreeNode = new DefaultMutableTreeNode(str.toString());
                    this.treeModel.insertNodeInto(jtreeNode, jtreeClientNode, index);
                } else {
                    jtreeNode = (DefaultMutableTreeNode)jtreeClientNode.getChildAt(index);
                    jtreeNode.setUserObject(str.toString());
                }
                str.delete(0, end);
                ++index;
                domList = el.getElementsByTagName("subscription");
                if (domList.getLength() < 1) continue;
                for (int n = 0; n < domList.getLength(); ++n) {
                    domNode = domList.item(n);
                    e2 = (Element)domNode;
                    str.append("subscription :  subject= ");
                    str.append(e2.getAttribute("subject"));
                    str.append(",  type= ");
                    str.append(e2.getAttribute("type"));
                    nameBuilder.append(e2.getAttribute("subject"));
                    nameBuilder.append(":");
                    nameBuilder.append(fullClientName);
                    nameBuilder.append(":");
                    nameBuilder.append(e2.getAttribute("type"));
                    String subName = nameBuilder.toString();
                    if (this.subMap.containsKey(subName)) {
                        jtreeNode = this.subMap.get(subName);
                        jtreeNode.setUserObject(str.toString());
                        this.treeModel.nodeChanged(jtreeNode);
                    } else {
                        jtreeNode = new DefaultMutableTreeNode(str.toString());
                        this.treeModel.insertNodeInto(jtreeNode, jtreeClientNode, index);
                        this.subMap.put(nameBuilder.toString(), jtreeNode);
                    }
                    currentSubNames.add(subName);
                    nameBuilder.delete(0, last);
                    str.delete(0, end);
                    ++index;
                    if (!domNode.hasChildNodes()) continue;
                    NodeList cbList = domNode.getChildNodes();
                    int index2 = 0;
                    for (int m = 0; m < cbList.getLength(); ++m) {
                        DefaultMutableTreeNode jtreeCbNode;
                        Node cbNode = cbList.item(m);
                        if (cbNode.getNodeType() != 1) continue;
                        e2 = (Element)cbNode;
                        String id = e2.getAttribute("id");
                        String received = e2.getAttribute("received");
                        String cueSize = e2.getAttribute("cueSize");
                        str.append("callback : id= ");
                        str.append(id);
                        str.append(",  received= ");
                        str.append(received);
                        str.append(", cueSize= ");
                        str.append(cueSize);
                        if (this.updated) {
                            try {
                                jtreeCbNode = (DefaultMutableTreeNode)jtreeNode.getChildAt(index2);
                                jtreeCbNode.setUserObject(str.toString());
                                this.treeModel.nodeChanged(jtreeCbNode);
                            }
                            catch (Exception e) {
                                jtreeCbNode = new DefaultMutableTreeNode(str.toString());
                                this.treeModel.insertNodeInto(jtreeCbNode, jtreeNode, index2);
                            }
                        } else {
                            jtreeCbNode = new DefaultMutableTreeNode(str.toString());
                            this.treeModel.insertNodeInto(jtreeCbNode, jtreeNode, index2);
                        }
                        str.delete(0, end);
                        ++index2;
                    }
                }
            }
        }
        removeServerNames.removeAll(currentServerNames);
        for (String nam : removeServerNames) {
            this.treeModel.removeNodeFromParent(this.serverMap.get(nam));
            this.serverMap.remove(nam);
        }
        removeClientNames.removeAll(currentClientNames);
        for (String nam : removeClientNames) {
            this.treeModel.removeNodeFromParent(this.clientMap.get(nam));
            this.clientMap.remove(nam);
        }
        removeSubNames.removeAll(currentSubNames);
        for (String nam : removeSubNames) {
            this.treeModel.removeNodeFromParent(this.subMap.get(nam));
            this.subMap.remove(nam);
        }
        if (!this.updated) {
            this.tree.expandPath(new TreePath(this.topNode));
        }
        this.treeModel.nodeChanged(this.topNode);
        this.updated = true;
    }

    class MessageProcessor
    extends Thread {
        private cMsgMessage msg;

        MessageProcessor() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setCoalescing(true);
            factory.setValidating(false);
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            long lastUpdate = 0L;
            while (true) {
                try {
                    if (this.isInterrupted() && MonitorPanel.this.killThread) {
                        return;
                    }
                    long now = new Date().getTime();
                    long diff = now - lastUpdate;
                    if (!MonitorPanel.this.paused && diff > 1000L) {
                        this.msg = MonitorPanel.this.connection.monitor(null);
                        lastUpdate = new Date().getTime();
                    }
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                    MonitorPanel.this.close();
                    return;
                }
                try {
                    String xml = this.msg.getText();
                    if (xml != null && xml.length() > 0) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xml.getBytes("US-ASCII"));
                        MonitorPanel.this.document = builder.parse(byteArrayInputStream);
                        SwingUtilities.invokeLater(MonitorPanel.this.updateDisplay);
                    }
                }
                catch (SAXException sxe) {
                    void var10_16;
                    SAXException sAXException = sxe;
                    if (sxe.getException() != null) {
                        Exception exception = sxe.getException();
                    }
                    var10_16.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                try {
                    Thread.sleep(MonitorPanel.this.updatePeriod * 1000);
                    continue;
                }
                catch (InterruptedException e) {
                    if (MonitorPanel.this.killThread) return;
                    continue;
                }
                break;
            }
        }
    }
}

