/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;

public class rcClientKiller {
    private cMsg cmsg;
    private String expid;
    private int timeout;
    private int udpPort = 45200;

    rcClientKiller(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                rcClientKiller.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-e")) {
                this.expid = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-p")) {
                this.udpPort = Integer.parseInt(args[i + 1]);
                if (this.udpPort < 1024 || this.udpPort > 65535) {
                    System.out.println("port must be > 1023 and < 65536");
                    continue;
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.timeout = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            rcClientKiller.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java rcClientKiller\n        [-e <expid>]  set expid of this multicast server\n        [-p <port>]   set UDP port of this multicast server\n        [-t <time>]   set time in seconds to look for interfering multicast servers\n");
    }

    public static void main(String[] args) {
        try {
            rcClientKiller server = new rcClientKiller(args);
            server.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        System.out.println("Starting RC Client Killer");
        String UDL = "rcm://" + this.udpPort + "/" + this.expid;
        if (this.timeout > 0) {
            UDL = UDL + "?multicastTO=" + this.timeout;
        }
        this.cmsg = new cMsg(UDL, "multicast listener", "udp trial");
        try {
            this.cmsg.connect();
        }
        catch (cMsgException e) {
            System.out.println(e.getMessage());
            return;
        }
        MulticastCallback cb3 = new MulticastCallback();
        this.cmsg.subscribe("sub", "type", cb3, null);
        this.cmsg.start();
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class MulticastCallback
    extends cMsgCallbackAdapter {
        MulticastCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            try {
                rcClientKiller.this.cmsg.send(msg);
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
            System.out.println("Just sent abort to " + msg.getSender());
        }
    }
}

