/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.common.cMsgShutdownHandlerInterface;

public class cMsgShutdowner {
    private String name = "shutdowner";
    private String description = "java shutdowner";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private String client = "defaultClientNameHere";
    private boolean debug;
    private boolean shutMeDown;

    cMsgShutdowner(String[] args) {
        this.decodeCommandLine(args);
    }

    public void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgShutdowner.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                this.client = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-me")) {
                this.shutMeDown = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            cMsgShutdowner.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgShutdowner\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-c <client name>]   name of client(s) to shutdown (in cMsg domain, wildcards allowed where\n                             * matches everything, ? matches 1 char, # matches 1 or 0 pos int)\n        [-me]                allow this cmsg client to be shutdown\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            cMsgShutdowner shutdowner = new cMsgShutdowner(args);
            shutdowner.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg shutdowner");
        }
        cMsg coda = new cMsg(this.UDL, this.name, this.description);
        coda.connect();
        if (this.debug) {
            System.out.println("Shutting down " + this.client);
        }
        coda.setShutdownHandler(new myShutdownHandler());
        try {
            if (this.debug) {
                System.out.println("Wait 3 seconds, then shutdown " + this.client);
            }
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        coda.shutdownClients(this.client, this.shutMeDown);
        try {
            if (this.debug) {
                System.out.println("Wait 3 more seconds, then disconnect");
            }
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        coda.disconnect();
    }

    class myShutdownHandler
    implements cMsgShutdownHandlerInterface {
        myShutdownHandler() {
        }

        @Override
        public void handleShutdown() {
            System.out.println("RUNNING SHUTDOWN HANDLER");
            System.exit(-1);
        }
    }
}

