/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import java.util.Map;
import java.util.Set;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;

public class cMsgMonitor {
    private String name = "monitor";
    private String description = "java monitor";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private boolean debug;

    cMsgMonitor(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgMonitor.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            cMsgMonitor.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgMonitor\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            cMsgMonitor mon = new cMsgMonitor(args);
            mon.run();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        if (this.debug) {
            System.out.println("Running cMsg monitor");
        }
        cMsg coda = new cMsg(this.UDL, this.name, this.description);
        coda.connect();
        long period = 3000L;
        while (true) {
            cMsgMessage msg;
            if ((msg = coda.monitor(null)) == null) {
                continue;
            }
            Map<String, cMsgPayloadItem> map = msg.getPayloadItems();
            Set<Map.Entry<String, cMsgPayloadItem>> set = map.entrySet();
            for (Map.Entry<String, cMsgPayloadItem> entry : set) {
                System.out.println("Key = " + entry.getKey() + ", Val = " + entry.getValue());
            }
            cMsgPayloadItem item = msg.getPayloadItem("IpAddresses");
            if (item != null) {
                String[] ips;
                System.out.println("\nPlatform is on:");
                for (String ip : ips = item.getStringArray()) {
                    System.out.println("  " + ip);
                }
            }
            System.out.println("monitor message:\n" + msg.getText());
            System.out.println("********************************\n");
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

