/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.apps;

import java.util.HashSet;
import java.util.Set;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.common.cMsgServerFinder;

public class cMsgFindServers {
    private cMsgServerFinder finder;
    private HashSet<Integer> cmsgPorts;
    private HashSet<Integer> rcPorts = new HashSet(100);
    private int debug = 4;
    private int waitTime = -1;
    private boolean inXML;

    cMsgFindServers(String[] args) {
        this.cmsgPorts = new HashSet(100);
        this.finder = new cMsgServerFinder();
        this.decodeCommandLine(args);
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgServerFinder\n        [-cmsg <UDP ports list>]   list of cMsg domain UDP ports to probe\n        [-rc   <UDP ports list>]   list of rc domain UDP ports to probe\n        [-pswd <password>]         password for connecting to cMsg domain server\n        [-xml]                     output in XML\n        [-t]                       time to wait for server response in seconds\n        [-h]                       print this help\n");
        System.out.println("        A port list is a single string with ports separated by");
        System.out.println("        white space or punctuation with the exception of dashes.");
        System.out.println("        Two ports joined by a single dash are taken as a range of ports.");
        System.out.println("        No white space allowed in defining ranges.\n");
    }

    public static void main(String[] args) {
        cMsgFindServers sfinder = new cMsgFindServers(args);
        sfinder.run();
    }

    public void run() {
        int j;
        String[] bcast;
        String[] ip2;
        this.finder.find();
        System.out.println();
        if (this.inXML) {
            System.out.println(this.finder.toString());
            return;
        }
        cMsgMessage[] rcServers = this.finder.getRcServers();
        cMsgMessage[] cmsgServers = this.finder.getCmsgServers();
        int i = 0;
        if (rcServers != null) {
            System.out.println("rcServers:");
            for (cMsgMessage msg : rcServers) {
                System.out.println("    server #" + (i + 1));
                try {
                    System.out.println("        host    = " + msg.getPayloadItem("host").getString());
                    System.out.println("        udpPort = " + msg.getPayloadItem("udpPort").getInt());
                    System.out.println("        expid   = " + msg.getPayloadItem("expid").getString());
                    System.out.println("        addresses:");
                    ip2 = msg.getPayloadItem("addresses").getStringArray();
                    bcast = msg.getPayloadItem("bcastAddresses").getStringArray();
                    for (j = 0; j < ip2.length; ++j) {
                        System.out.println("           ip = " + ip2[j] + ", bcast = " + bcast[j]);
                    }
                    System.out.println();
                }
                catch (cMsgException ip2) {
                    // empty catch block
                }
                ++i;
            }
        }
        i = 0;
        if (cmsgServers != null) {
            System.out.println("cMsgServers:");
            for (cMsgMessage msg : cmsgServers) {
                System.out.println("    server #" + (i + 1));
                try {
                    System.out.println("        host      = " + msg.getPayloadItem("host").getString());
                    System.out.println("        udpPort   = " + msg.getPayloadItem("udpPort").getInt());
                    System.out.println("        tcpPort   = " + msg.getPayloadItem("tcpPort").getInt());
                    System.out.println("        addresses:");
                    ip2 = msg.getPayloadItem("addresses").getStringArray();
                    bcast = msg.getPayloadItem("bcastAddresses").getStringArray();
                    for (j = 0; j < ip2.length; ++j) {
                        System.out.println("           ip = " + ip2[j] + ", bcast = " + bcast[j]);
                    }
                    System.out.println();
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgFindServers.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-pswd")) {
                String password = args[i + 1];
                this.finder.setPassword(password);
                if (this.debug >= 4) {
                    System.out.println("Setting password to " + password);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-rc")) {
                this.parsePortList(args[i + 1], "rc", this.rcPorts);
                if (this.rcPorts.size() > 0) {
                    this.finder.addRcPorts(this.rcPorts);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                try {
                    this.waitTime = Integer.parseInt(args[i + 1]);
                    this.finder.setSleepTime(1000 * this.waitTime);
                }
                catch (NumberFormatException e) {
                    if (this.debug < 2) continue;
                    System.out.println("bad wait time, ignore");
                    continue;
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-cmsg")) {
                this.parsePortList(args[i + 1], "cmsg", this.cmsgPorts);
                if (this.cmsgPorts.size() > 0) {
                    this.finder.addCmsgPorts(this.cmsgPorts);
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-xml")) {
                this.inXML = true;
                continue;
            }
            cMsgFindServers.usage();
            System.exit(-1);
        }
    }

    private void parsePortList(String s, String type, Set<Integer> set) {
        String[] strs = s.split("[\\p{Punct}\\s&&[^-]]");
        if (strs.length < 1) {
            if (this.debug >= 2) {
                System.out.println("no valid " + type + " ports specified");
            }
            return;
        }
        for (String str : strs) {
            int port;
            if (str.contains("-")) {
                int port2;
                int port1;
                block15: {
                    String[] ports = str.split("-");
                    if (ports.length != 2) {
                        if (this.debug < 2) continue;
                        System.out.println("wrong # of " + type + " ports defining range");
                        continue;
                    }
                    try {
                        port1 = Integer.parseInt(ports[0]);
                        port2 = Integer.parseInt(ports[1]);
                        if (port1 < 1024 || port1 > 65535 || port2 < 1024 || port2 > 65535) {
                            if (this.debug < 2) continue;
                            System.out.println(type + " ports must be > 1023 and < 65536");
                        }
                        break block15;
                    }
                    catch (NumberFormatException e) {
                        if (this.debug < 2) continue;
                        System.out.println("bad " + type + " port format in range");
                    }
                    continue;
                }
                if (port1 > port2) {
                    port = port1;
                    port1 = port2;
                    port2 = port;
                }
                for (int k = port1; k <= port2; ++k) {
                    if (this.debug >= 4) {
                        System.out.println("adding " + type + " port " + k);
                    }
                    set.add(k);
                }
                continue;
            }
            try {
                port = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                if (this.debug < 2) continue;
                System.out.println("bad " + type + " port format");
                continue;
            }
            if (port < 1024 || port > 65535) {
                if (this.debug < 2) continue;
                System.out.println(type + " ports must be > 1023 and < 65536");
                continue;
            }
            if (this.debug >= 4) {
                System.out.println("adding " + type + " port " + port);
            }
            set.add(port);
        }
    }
}

