/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.RCMulticastDomain;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.cMsg.RCMulticastDomain.rcListeningThread;
import org.jlab.coda.cMsg.cMsgCallbackInterface;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgNetworkConstants;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;
import org.jlab.coda.cMsg.common.cMsgCallbackThread;
import org.jlab.coda.cMsg.common.cMsgDomainAdapter;
import org.jlab.coda.cMsg.common.cMsgDomainInterface;
import org.jlab.coda.cMsg.common.cMsgShutdownHandlerInterface;
import org.jlab.coda.cMsg.common.cMsgSubscription;

public class RCMulticast
extends cMsgDomainAdapter {
    int udpPort;
    int localTempPort;
    CountDownLatch multicastResponse = new CountDownLatch(1);
    String respondingHost;
    String expid;
    volatile boolean acceptingClients;
    volatile boolean hasSubscription;
    Set<cMsgSubscription> subscriptions;
    private MulticastSocket multicastSocket;
    private int multicastTimeout = 2000;
    private rcListeningThread listener;
    private final ReentrantReadWriteLock methodLock = new ReentrantReadWriteLock();
    private Lock connectLock = this.methodLock.writeLock();
    private Lock notConnectLock = this.methodLock.readLock();
    private Lock subscribeLock = new ReentrantLock();
    private Map<Object, cMsgSubscription> unsubscriptions;

    public RCMulticast() throws cMsgException {
        this.domain = "rcm";
        this.subscriptions = new HashSet<cMsgSubscription>(20);
        this.unsubscriptions = Collections.synchronizedMap(new HashMap(20));
        try {
            try {
                this.host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                this.host = InetAddress.getLocalHost().getCanonicalHostName();
            }
        }
        catch (UnknownHostException e) {
            throw new cMsgException("cMsg: cannot find host name", e);
        }
        class MyShutdownHandler
        implements cMsgShutdownHandlerInterface {
            cMsgDomainInterface cMsgObject;

            MyShutdownHandler(cMsgDomainInterface cMsgObject) {
                this.cMsgObject = cMsgObject;
            }

            @Override
            public void handleShutdown() {
                try {
                    this.cMsgObject.disconnect();
                }
                catch (cMsgException cMsgException2) {
                    // empty catch block
                }
            }
        }
        this.setShutdownHandler(new MyShutdownHandler(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws cMsgException {
        this.parseUDL(this.UDLremainder);
        this.connectLock.lock();
        try {
            DatagramPacket udpPacket;
            if (this.connected) {
                return;
            }
            this.listener = new rcListeningThread(this, this.udpPort);
            this.listener.start();
            rcListeningThread rcListeningThread2 = this.listener;
            synchronized (rcListeningThread2) {
                if (!this.listener.isAlive()) {
                    try {
                        this.listener.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                out.writeInt(cMsgNetworkConstants.magicNumbers[0]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[1]);
                out.writeInt(cMsgNetworkConstants.magicNumbers[2]);
                out.writeInt(6);
                out.writeInt(4);
                out.writeInt(this.udpPort);
                out.writeInt((int)System.currentTimeMillis());
                out.writeInt(this.name.length());
                out.writeInt(this.expid.length());
                try {
                    out.write(this.name.getBytes("US-ASCII"));
                    out.write(this.expid.getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                out.flush();
                out.close();
                this.multicastSocket = new MulticastSocket();
                this.multicastSocket.setTimeToLive(32);
                this.localTempPort = this.multicastSocket.getLocalPort();
                InetAddress rcServerMulticastAddress = null;
                try {
                    rcServerMulticastAddress = InetAddress.getByName("239.210.0.0");
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                baos.close();
                byte[] buf = baos.toByteArray();
                udpPacket = new DatagramPacket(buf, buf.length, rcServerMulticastAddress, this.udpPort);
            }
            catch (IOException e) {
                this.listener.killThread();
                try {
                    out.close();
                }
                catch (IOException buf) {
                    // empty catch block
                }
                try {
                    baos.close();
                }
                catch (IOException buf) {
                    // empty catch block
                }
                if (this.multicastSocket != null) {
                    this.multicastSocket.close();
                }
                if (this.debug >= 2) {
                    System.out.println("I/O Error: " + e);
                }
                throw new cMsgException(e.getMessage());
            }
            Multicaster sender = new Multicaster(udpPacket);
            sender.start();
            boolean response = false;
            try {
                if (this.multicastResponse.await(this.multicastTimeout, TimeUnit.MILLISECONDS)) {
                    response = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sender.interrupt();
            if (response) {
                this.listener.killThread();
                this.multicastSocket.close();
                throw new cMsgException("Another RC Multicast server is running at port " + this.udpPort + " host " + this.respondingHost + " with EXPID = " + this.expid);
            }
            this.acceptingClients = true;
            this.multicastSocket.close();
            this.connected = true;
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.connectLock.lock();
        try {
            if (!this.connected) {
                return;
            }
            this.connected = false;
            this.listener.killThread();
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public void send(cMsgMessage message) throws cMsgException {
        this.notConnectLock.lock();
        Socket socket = null;
        FilterOutputStream out = null;
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to server");
            }
            cMsgPayloadItem item = message.getPayloadItem("IpAddresses");
            String[] ipAddrs = item != null ? item.getStringArray() : new String[]{message.getSenderHost()};
            IOException ioex = null;
            boolean connectedSocket = false;
            for (String ip : ipAddrs) {
                try {
                    socket = new Socket(ip, message.getUserInt());
                    connectedSocket = true;
                    break;
                }
                catch (IOException e) {
                    ioex = e;
                }
            }
            if (!connectedSocket) {
                throw new cMsgException("cannot create socket to rc client", ioex);
            }
            socket.setTcpNoDelay(true);
            out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            ((DataOutputStream)out).writeInt(cMsgNetworkConstants.magicNumbers[0]);
            ((DataOutputStream)out).writeInt(cMsgNetworkConstants.magicNumbers[1]);
            ((DataOutputStream)out).writeInt(cMsgNetworkConstants.magicNumbers[2]);
            ((DataOutputStream)out).writeInt(4);
            ((DataOutputStream)out).writeInt(24);
            ((DataOutputStream)out).flush();
            out.close();
            socket.close();
        }
        catch (IOException e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new cMsgException(e.getMessage(), e);
        }
        finally {
            this.notConnectLock.unlock();
        }
    }

    private void parseUDL(String udlRemainder) throws cMsgException {
        String remainder;
        String udlExpid;
        Matcher matcher;
        Pattern pattern;
        block20: {
            String udlPort;
            if (udlRemainder == null) {
                throw new cMsgException("invalid UDL");
            }
            pattern = Pattern.compile("(\\d+)?/([^?&]+)(.*)");
            matcher = pattern.matcher(udlRemainder);
            if (matcher.find()) {
                udlPort = matcher.group(1);
                udlExpid = matcher.group(2);
                remainder = matcher.group(3);
                if (this.debug >= 4) {
                    System.out.println("\nparseUDL: \n  port  = " + udlPort + "\n  expid = " + udlExpid + "\n  junk  = " + remainder);
                }
            } else {
                throw new cMsgException("invalid UDL");
            }
            if (udlPort != null && udlPort.length() > 0) {
                try {
                    this.udpPort = Integer.parseInt(udlPort);
                }
                catch (NumberFormatException e) {
                    if (this.debug < 3) break block20;
                    System.out.println("parseUDL: non-integer port specified in UDL = " + udlPort);
                }
            }
        }
        if (this.udpPort < 1) {
            try {
                String env = System.getenv("RC_MULTICAST_PORT");
                if (env != null) {
                    this.udpPort = Integer.parseInt(env);
                }
            }
            catch (NumberFormatException ex) {
                System.out.println("parseUDL: bad port number specified in RC_MULTICAST_PORT env variable");
            }
        }
        if (this.udpPort < 1) {
            this.udpPort = 45200;
            if (this.debug >= 3) {
                System.out.println("parseUDL: using default multicast port = " + this.udpPort);
            }
        }
        if (this.udpPort < 1024 || this.udpPort > 65535) {
            throw new cMsgException("parseUDL: illegal port number");
        }
        if (udlExpid == null) {
            throw new cMsgException("parseUDL: must specify the EXPID");
        }
        this.expid = udlExpid;
        this.UDLremainder = remainder == null ? "" : remainder;
        if (remainder == null) {
            return;
        }
        pattern = Pattern.compile("[\\?&]multicastTO=([0-9]+)", 2);
        matcher = pattern.matcher(remainder);
        if (matcher.find()) {
            try {
                this.multicastTimeout = 1000 * Integer.parseInt(matcher.group(1));
                if (this.multicastTimeout < 1) {
                    this.multicastTimeout = 2000;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public cMsgSubscriptionHandle subscribe(String subject, String type, cMsgCallbackInterface cb3, Object userObj) throws cMsgException {
        subject = "s";
        type = "t";
        cMsgCallbackThread cbThread = null;
        try {
            this.notConnectLock.lock();
            this.subscribeLock.lock();
            if (!this.connected) {
                throw new cMsgException("not connected to rc client");
            }
            Set<cMsgSubscription> set = this.subscriptions;
            synchronized (set) {
                for (cMsgSubscription sub : this.subscriptions) {
                    if (!sub.getSubject().equals(subject) || !sub.getType().equals(type)) continue;
                    cbThread = new cMsgCallbackThread(cb3, userObj, this.domain, subject, type);
                    sub.addCallback(cbThread);
                    this.unsubscriptions.put(cbThread, sub);
                    cMsgCallbackThread cMsgCallbackThread2 = cbThread;
                    return cMsgCallbackThread2;
                }
                cbThread = new cMsgCallbackThread(cb3, userObj, this.domain, subject, type);
                cMsgSubscription newSub = new cMsgSubscription(subject, type, 0, cbThread);
                this.unsubscriptions.put(cbThread, newSub);
                this.subscriptions.add(newSub);
                this.hasSubscription = true;
                return cbThread;
            }
        }
        finally {
            this.subscribeLock.unlock();
            this.notConnectLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(cMsgSubscriptionHandle obj) throws cMsgException {
        if (obj == null) {
            throw new cMsgException("argument is null");
        }
        this.notConnectLock.lock();
        this.subscribeLock.lock();
        try {
            if (!this.connected) {
                throw new cMsgException("not connected to rc client");
            }
            Set<cMsgSubscription> set = this.subscriptions;
            synchronized (set) {
                cMsgSubscription sub = this.unsubscriptions.remove(obj);
                if (sub != null) {
                    cMsgCallbackThread cbThread = (cMsgCallbackThread)obj;
                    cbThread.dieNow(false);
                    sub.getCallbacks().remove(cbThread);
                    if (sub.numberOfCallbacks() < 1) {
                        this.subscriptions.remove(sub);
                    }
                }
                if (this.subscriptions.size() < 1) {
                    this.hasSubscription = false;
                }
            }
        }
        finally {
            this.subscribeLock.unlock();
            this.notConnectLock.unlock();
        }
    }

    class Multicaster
    extends Thread {
        DatagramPacket packet;

        Multicaster(DatagramPacket udpPacket) {
            this.packet = udpPacket;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
                while (true) {
                    try {
                        Enumeration<NetworkInterface> enumer = NetworkInterface.getNetworkInterfaces();
                        while (enumer.hasMoreElements()) {
                            NetworkInterface ni = enumer.nextElement();
                            if (!ni.isUp()) continue;
                            RCMulticast.this.multicastSocket.setNetworkInterface(ni);
                            RCMulticast.this.multicastSocket.send(this.packet);
                        }
                    }
                    catch (IOException e) {
                        return;
                    }
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

