/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.eventViewer.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileLastBytesChanger {
    private String inputFileName = null;
    private String outputFileName = "outputFile";
    private byte b1;
    private byte b2;
    private byte b3;
    private boolean b1Defined;
    private boolean b2Defined;
    private boolean b3Defined;

    FileLastBytesChanger(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                FileLastBytesChanger.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-i")) {
                this.inputFileName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-o")) {
                this.outputFileName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-b1")) {
                try {
                    this.b1 = Byte.decode(args[i + 1]);
                    this.b1Defined = true;
                }
                catch (NumberFormatException e) {
                    System.out.println("b1 arg must be a numerical byte");
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-b2")) {
                try {
                    this.b2 = Byte.decode(args[i + 1]);
                    this.b2Defined = true;
                }
                catch (NumberFormatException e) {
                    System.out.println("b2 arg must be a numerical byte");
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-b3")) {
                try {
                    this.b3 = Byte.decode(args[i + 1]);
                    this.b3Defined = true;
                }
                catch (NumberFormatException e) {
                    System.out.println("b3 arg must be a numerical byte");
                }
                ++i;
                continue;
            }
            FileLastBytesChanger.usage();
            System.exit(-1);
        }
        if (this.inputFileName == null) {
            FileLastBytesChanger.usage();
            System.out.println("-i arg must be defined\n");
            System.exit(-1);
        }
        if (!this.b1Defined) {
            FileLastBytesChanger.usage();
            System.out.println("-b1 arg must be defined\n");
            System.exit(-1);
        }
        if (this.b3Defined && !this.b2Defined) {
            FileLastBytesChanger.usage();
            System.out.println("-b2 arg must be defined if -b3 is\n");
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgProducer\n         -i  <input file name>   name of file to read\n        [-o  <output file name>] name of file to write\n         -b1 <1st byte>          first byte to change at file's end\n        [-b2 <2nd byte>]         second byte to change at file's end\n        [-b3 <3rd byte>]         third byte to change at file's end\n        [-h]                     print this help\n");
    }

    public static void main(String[] args) {
        try {
            FileLastBytesChanger producer = new FileLastBytesChanger(args);
            producer.run();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void run() throws IOException {
        File inFile = new File(this.inputFileName);
        File outFile = new File(this.outputFileName);
        try {
            long fileBytes = inFile.length();
            if (fileBytes > 2100000000L) {
                throw new IOException("File is too big");
            }
            int extraBytes = (int)(fileBytes % 4L);
            FileInputStream in = new FileInputStream(inFile);
            FileOutputStream out = new FileOutputStream(outFile);
            int i = 0;
            while ((long)i < fileBytes - (long)extraBytes) {
                out.write(in.read());
                ++i;
            }
            switch (extraBytes) {
                case 3: {
                    if (this.b3Defined) {
                        out.write(this.b1);
                        out.write(this.b2);
                        out.write(this.b3);
                        break;
                    }
                    if (this.b2Defined) {
                        out.write(in.read());
                        out.write(this.b1);
                        out.write(this.b2);
                        break;
                    }
                    out.write(in.read());
                    out.write(in.read());
                    out.write(this.b1);
                    break;
                }
                case 2: {
                    if (this.b3Defined || this.b2Defined) {
                        out.write(this.b1);
                        out.write(this.b2);
                        break;
                    }
                    out.write(in.read());
                    out.write(this.b1);
                    break;
                }
                case 1: {
                    out.write(this.b1);
                    break;
                }
            }
            out.close();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

