/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.eventViewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class SimpleMappedMemoryHandler {
    private long fileSize;
    private final long maxMapSize = 1000000000L;
    private ByteOrder order;
    private int mapCount;
    private ArrayList<ByteBuffer> maps = new ArrayList(20);
    private FileChannel fileChannel;
    private int extraByteCount;

    public SimpleMappedMemoryHandler(File file, ByteOrder order) throws IOException {
        this.order = order;
        FileInputStream fileInputStream = new FileInputStream(file);
        this.fileChannel = fileInputStream.getChannel();
        long remainingSize = this.fileSize = this.fileChannel.size();
        if (this.fileSize < 4L) {
            throw new IOException("file too small at " + this.fileSize + " bytes");
        }
        this.extraByteCount = (int)(this.fileSize % 4L);
        long offset = 0L;
        MappedByteBuffer memoryMapBuf = null;
        if (remainingSize < 1L) {
            return;
        }
        while (remainingSize > 0L) {
            long sz = Math.min(remainingSize, 1000000000L);
            memoryMapBuf = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, offset, sz);
            memoryMapBuf.order(order);
            this.maps.add(memoryMapBuf);
            offset += sz;
            remainingSize -= sz;
            ++this.mapCount;
        }
    }

    public SimpleMappedMemoryHandler(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        this.mapCount = 1;
        this.maps.add(buf);
    }

    public void close() {
        try {
            this.fileChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean haveExtraBytes() {
        return this.extraByteCount > 0;
    }

    public int getExtraByteCount() {
        return this.extraByteCount;
    }

    public long getMaxMapSize() {
        return 1000000000L;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public int getMapSize(int mapIndex) {
        if (mapIndex < 0 || mapIndex > this.mapCount - 1) {
            return 0;
        }
        return this.maps.get(mapIndex).limit();
    }

    public int getMapCount() {
        return this.mapCount;
    }

    public ByteBuffer getFirstMap() {
        return this.maps.get(0);
    }

    public void setByteOrder(ByteOrder order) {
        if (this.order == order) {
            return;
        }
        this.order = order;
        for (ByteBuffer map : this.maps) {
            map.order(order);
        }
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public ByteBuffer getMap(int mapIndex) {
        if (mapIndex < 0 || mapIndex > this.mapCount - 1) {
            return null;
        }
        return this.maps.get(mapIndex);
    }

    public int getInt(long wordPosition) {
        return this.getIntAtBytePos(4L * wordPosition);
    }

    public int getIntAtBytePos(long bytePosition) {
        int mapIndex = (int)(bytePosition / 1000000000L);
        int byteIndex = (int)(bytePosition - (long)mapIndex * 1000000000L);
        ByteBuffer buf = this.getMap(mapIndex);
        if (buf == null) {
            return 0;
        }
        long remainingBytes = this.fileSize - bytePosition;
        if (remainingBytes < 4L && remainingBytes > 0L) {
            int lastInt = 0;
            switch ((int)remainingBytes) {
                case 1: {
                    lastInt = buf.get(byteIndex) & 0xFF;
                    break;
                }
                case 2: {
                    if (buf.order() == ByteOrder.BIG_ENDIAN) {
                        lastInt = buf.get(byteIndex) << 8 & 0xFF00 | buf.get(byteIndex + 1) & 0xFF;
                        break;
                    }
                    lastInt = buf.get(byteIndex + 1) << 8 & 0xFF00 | buf.get(byteIndex) & 0xFF;
                    break;
                }
                case 3: {
                    if (buf.order() == ByteOrder.BIG_ENDIAN) {
                        lastInt = buf.get(byteIndex) << 16 & 0xFF0000 | buf.get(byteIndex + 1) << 8 & 0xFF00 | buf.get(byteIndex + 2) & 0xFF;
                        break;
                    }
                    lastInt = buf.get(byteIndex + 2) << 16 & 0xFF0000 | buf.get(byteIndex + 1) << 8 & 0xFF00 | buf.get(byteIndex) & 0xFF;
                    break;
                }
            }
            return lastInt;
        }
        return buf.getInt(byteIndex);
    }

    public short getShortAtBytePos(long bytePosition) {
        int mapIndex = (int)(bytePosition / 1000000000L);
        int byteIndex = (int)(bytePosition - (long)mapIndex * 1000000000L);
        ByteBuffer buf = this.getMap(mapIndex);
        if (buf == null) {
            return 0;
        }
        if (this.fileSize - bytePosition == 1L) {
            return (short)(buf.get(byteIndex) & 0xFF);
        }
        return buf.getShort(byteIndex);
    }

    public byte getByteAtBytePos(long bytePosition) {
        int mapIndex = (int)(bytePosition / 1000000000L);
        int byteIndex = (int)(bytePosition - (long)mapIndex * 1000000000L);
        ByteBuffer buf = this.getMap(mapIndex);
        if (buf == null) {
            return 0;
        }
        return buf.get(byteIndex);
    }

    public int getMapIndex(long wordIndex) {
        return (int)(wordIndex * 4L / 1000000000L);
    }
}

