/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.eventViewer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.jlab.coda.eventViewer.BlockHeader;
import org.jlab.coda.eventViewer.CodaBankTag;
import org.jlab.coda.eventViewer.EvioHeader;
import org.jlab.coda.eventViewer.FileFrameBig;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;

public class EvioScanner {
    private final ArrayList<BlockHeader> blockErrorNodes = new ArrayList(10);
    private final FileFrameBig.MyTableModel dataModel;
    private final FileFrameBig.MyRenderer dataRenderer;
    private FileFrameBig parentComponent;
    private FileFrameBig.ErrorScanTask errorScanTask;

    public static boolean dataTypeHasPadding(DataType type) {
        return type == DataType.CHAR8 || type == DataType.UCHAR8 || type == DataType.SHORT16 || type == DataType.USHORT16 || type == DataType.COMPOSITE;
    }

    public EvioScanner(FileFrameBig component, FileFrameBig.MyTableModel dataModel, FileFrameBig.MyRenderer dataRenderer, FileFrameBig.ErrorScanTask errorTask) throws EvioException {
        this.parentComponent = component;
        this.dataModel = dataModel;
        this.dataRenderer = dataRenderer;
        this.errorScanTask = errorTask;
        this.checkFirstHeader();
    }

    public ArrayList<BlockHeader> getBlockErrorNodes() {
        return this.blockErrorNodes;
    }

    public boolean hasError() {
        return this.blockErrorNodes.size() > 0;
    }

    private EvioHeader extractEventNode(FileFrameBig.MyTableModel model, long position, int place, long bytesLeft) {
        if (bytesLeft < 8L) {
            return null;
        }
        EvioHeader node = new EvioHeader(position, place, model);
        node.len = model.getInt(position);
        node.pos = position;
        node.type = DataType.BANK.getValue();
        node.dataPos = position + 8L;
        node.dataLen = node.len - 1L;
        int word = model.getInt(position += 4L);
        node.tag = word >>> 16;
        int dt = word >> 8 & 0xFF;
        node.dataType = dt & 0x3F;
        node.pad = dt >>> 6;
        if (dt == 64) {
            node.dataType = DataType.TAGSEGMENT.getValue();
            node.pad = 0;
        }
        node.num = word & 0xFF;
        if (bytesLeft < 4L * (node.len + 1L)) {
            node.error = "buffer underflow";
            return node;
        }
        DataType dataTypeObj = DataType.getDataType((int)node.dataType);
        if (dataTypeObj == null) {
            node.error = "Bad data type (" + node.dataType + ")";
        } else if (node.pad != 0) {
            if (node.pad == 2) {
                if (!EvioScanner.dataTypeHasPadding(dataTypeObj)) {
                    node.error = "Padding (" + node.pad + ") does not match data type (" + dataTypeObj + ")";
                }
            } else if (dataTypeObj != DataType.CHAR8 && dataTypeObj != DataType.UCHAR8 && dataTypeObj != DataType.COMPOSITE) {
                node.error = "Padding (" + node.pad + ") does not match data type (" + dataTypeObj + ")";
            }
        }
        return node;
    }

    private EvioHeader searchForErrorInEvent(FileFrameBig.MyTableModel model, long position, int place, long bytesLeft) {
        EvioHeader subNode;
        boolean debug = false;
        EvioHeader eventNode = new EvioHeader(position, place, model);
        eventNode.len = model.getInt(position);
        eventNode.pos = position;
        eventNode.type = DataType.BANK.getValue();
        eventNode.dataPos = position + 8L;
        eventNode.dataLen = eventNode.len - 1L;
        if (bytesLeft < 4L * (eventNode.len + 1L)) {
            eventNode.error = "buffer underflow";
            if (debug) {
                System.out.println("searchForErrorInEvent: place = " + place + ", buffer underflow");
            }
            return eventNode;
        }
        int word = model.getInt(position += 4L);
        eventNode.tag = word >>> 16;
        int dt = word >> 8 & 0xFF;
        eventNode.dataType = dt & 0x3F;
        eventNode.pad = dt >>> 6;
        if (dt == 64) {
            eventNode.dataType = DataType.TAGSEGMENT.getValue();
            eventNode.pad = 0;
        }
        eventNode.num = word & 0xFF;
        eventNode.bankType = CodaBankTag.getDescription(eventNode.tag);
        DataType dataTypeObj = DataType.getDataType((int)eventNode.dataType);
        if (dataTypeObj == null) {
            eventNode.error = "Bad data type (" + eventNode.dataType + ")";
            if (debug) {
                System.out.println("searchForErrorInEvent: place = " + place + ", " + eventNode.error);
            }
            return eventNode;
        }
        if (eventNode.pad != 0) {
            if (eventNode.pad == 2) {
                if (!EvioScanner.dataTypeHasPadding(dataTypeObj)) {
                    eventNode.error = "Padding (" + eventNode.pad + ") does not match data type (= " + dataTypeObj + ")";
                    if (debug) {
                        System.out.println("searchForErrorInEvent: place = " + place + ", " + eventNode.error);
                    }
                    return eventNode;
                }
            } else if (dataTypeObj != DataType.CHAR8 && dataTypeObj != DataType.UCHAR8 && dataTypeObj != DataType.COMPOSITE) {
                eventNode.error = "Padding (" + eventNode.pad + ") does not match data type (" + dataTypeObj + ")";
                if (debug) {
                    System.out.println("searchForErrorInEvent: place = " + place + ", " + eventNode.error);
                }
                return eventNode;
            }
        }
        if ((subNode = this.scanStructureForError(eventNode)) != null) {
            if (debug) {
                System.out.println("searchForErrorInEvent: sub node error = " + subNode.error);
            }
            if (eventNode.error == null) {
                eventNode.error = subNode.error;
            }
        }
        eventNode.errorHeader = subNode;
        return eventNode;
    }

    private EvioHeader scanStructureForError(EvioHeader node) {
        DataType type = node.getDataTypeObj();
        if (!type.isStructure()) {
            return null;
        }
        long position = node.dataPos;
        long endingPos = position + 4L * node.dataLen;
        FileFrameBig.MyTableModel model = node.model;
        long thisStructureDataWords = node.len;
        DataType nodeType = node.getTypeObj();
        if (nodeType == DataType.BANK || nodeType == DataType.ALSOBANK) {
            --thisStructureDataWords;
        }
        long totalKidWords = 0L;
        boolean debug = false;
        switch (type) {
            case BANK: 
            case ALSOBANK: {
                while (position <= endingPos - 8L) {
                    EvioHeader returnedNode;
                    EvioHeader kidNode = (EvioHeader)node.clone();
                    long len = (long)model.getInt(position) & 0xFFFFFFFFL;
                    kidNode.pos = position;
                    long dataLen = len - 1L;
                    int word = model.getInt(position += 4L);
                    position += 4L;
                    kidNode.tag = word >>> 16;
                    int dt = word >> 8 & 0xFF;
                    int dataType = dt & 0x3F;
                    kidNode.pad = dt >>> 6;
                    if (dt == 64) {
                        dataType = DataType.TAGSEGMENT.getValue();
                        kidNode.pad = 0;
                    }
                    kidNode.num = word & 0xFF;
                    kidNode.len = len;
                    kidNode.type = DataType.BANK.getValue();
                    kidNode.dataLen = dataLen;
                    kidNode.dataPos = position;
                    kidNode.dataType = dataType;
                    kidNode.isEvent = false;
                    kidNode.bankType = CodaBankTag.getDescription(kidNode.tag);
                    totalKidWords += len + 1L;
                    DataType dataTypeObj = DataType.getDataType((int)dataType);
                    if (dataTypeObj == null) {
                        kidNode.error = "Bad data type (" + dataType + ")";
                        if (debug) {
                            System.out.println("Error 1: " + kidNode.error);
                        }
                        return kidNode;
                    }
                    if (kidNode.pad != 0) {
                        if (kidNode.pad == 2) {
                            if (!EvioScanner.dataTypeHasPadding(dataTypeObj)) {
                                kidNode.error = "Padding (" + kidNode.pad + ") does not match data type (= " + dataTypeObj + ")";
                                if (debug) {
                                    System.out.println("Error 1: " + kidNode.error);
                                }
                                return kidNode;
                            }
                        } else if (dataTypeObj != DataType.CHAR8 && dataTypeObj != DataType.UCHAR8 && dataTypeObj != DataType.COMPOSITE) {
                            kidNode.error = "Padding (" + kidNode.pad + ") does not match data type (" + dataTypeObj + ")";
                            if (debug) {
                                System.out.println("Error 1: " + kidNode.error);
                            }
                            return kidNode;
                        }
                    }
                    if (DataType.isStructure((int)dataType) && (returnedNode = this.scanStructureForError(kidNode)) != null) {
                        return returnedNode;
                    }
                    position += 4L * dataLen;
                }
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                while (position <= endingPos - 4L) {
                    EvioHeader returnedNode;
                    EvioHeader kidNode = (EvioHeader)node.clone();
                    kidNode.pos = position;
                    int word = model.getInt(position);
                    position += 4L;
                    kidNode.tag = word >>> 24;
                    int dt = word >>> 16 & 0xFF;
                    int dataType = dt & 0x3F;
                    kidNode.pad = dt >>> 6;
                    if (dt == 64) {
                        dataType = DataType.TAGSEGMENT.getValue();
                        kidNode.pad = 0;
                    }
                    long len = word & 0xFFFF;
                    kidNode.num = 0;
                    kidNode.len = len;
                    kidNode.type = DataType.SEGMENT.getValue();
                    kidNode.dataLen = len;
                    kidNode.dataPos = position;
                    kidNode.dataType = dataType;
                    kidNode.isEvent = false;
                    kidNode.bankType = CodaBankTag.getDescription(kidNode.tag);
                    totalKidWords += len + 1L;
                    DataType dataTypeObj = DataType.getDataType((int)dataType);
                    if (dataTypeObj == null) {
                        kidNode.error = "Bad data type (" + dataType + ")";
                        if (debug) {
                            System.out.println("Error 2: " + kidNode.error);
                        }
                        return kidNode;
                    }
                    if (kidNode.pad != 0) {
                        if (kidNode.pad == 2) {
                            if (!EvioScanner.dataTypeHasPadding(dataTypeObj)) {
                                kidNode.error = "Padding (" + kidNode.pad + ") does not match data type (= " + dataTypeObj + ")";
                                if (debug) {
                                    System.out.println("Error 2: " + kidNode.error);
                                }
                                return kidNode;
                            }
                        } else if (dataTypeObj != DataType.CHAR8 && dataTypeObj != DataType.UCHAR8 && dataTypeObj != DataType.COMPOSITE) {
                            kidNode.error = "Padding (" + kidNode.pad + ") does not match data type (" + dataTypeObj + ")";
                            if (debug) {
                                System.out.println("Error 2: " + kidNode.error);
                            }
                            return kidNode;
                        }
                    }
                    if (DataType.isStructure((int)dataType) && (returnedNode = this.scanStructureForError(kidNode)) != null) {
                        return returnedNode;
                    }
                    position += 4L * len;
                }
                break;
            }
            case TAGSEGMENT: {
                while (position <= endingPos - 4L) {
                    EvioHeader returnedNode;
                    EvioHeader kidNode = (EvioHeader)node.clone();
                    kidNode.pos = position;
                    int word = model.getInt(position);
                    position += 4L;
                    kidNode.tag = word >>> 20;
                    int dataType = word >>> 16 & 0xF;
                    long len = word & 0xFFFF;
                    kidNode.pad = 0;
                    kidNode.num = 0;
                    kidNode.len = len;
                    kidNode.type = DataType.TAGSEGMENT.getValue();
                    kidNode.dataLen = len;
                    kidNode.dataPos = position;
                    kidNode.dataType = dataType;
                    kidNode.isEvent = false;
                    totalKidWords += len + 1L;
                    DataType dataTypeObj = DataType.getDataType((int)dataType);
                    if (dataTypeObj == null) {
                        kidNode.error = "Bad data type (" + dataType + ")";
                        if (debug) {
                            System.out.println("Error 3: " + kidNode.error);
                        }
                        return kidNode;
                    }
                    if (DataType.isStructure((int)dataType) && (returnedNode = this.scanStructureForError(kidNode)) != null) {
                        return returnedNode;
                    }
                    position += 4L * len;
                }
                break;
            }
            default: {
                totalKidWords = thisStructureDataWords;
            }
        }
        if (totalKidWords != thisStructureDataWords) {
            node.error = "Bad word length(s): node's data = " + thisStructureDataWords + ", kids' = " + totalKidWords;
            if (debug) {
                System.out.println("Error 4: " + node.error);
            }
            return node;
        }
        return null;
    }

    public boolean scanFileForErrors() throws EvioException {
        BlockHeader blockNode;
        long blockWordSize;
        long blockDataBytes;
        long fileByteSize;
        boolean firstBlock = true;
        boolean foundError = false;
        boolean debug = false;
        this.blockErrorNodes.clear();
        int eventCount = 0;
        long bufPos = 0L;
        long fileBytesLeft = fileByteSize = this.dataModel.getFileSize();
        if (fileBytesLeft < 32L) {
            throw new EvioException("File too small (" + fileBytesLeft + " bytes)");
        }
        do {
            long byteLen;
            if (this.errorScanTask != null) {
                int progressPercent = (int)(100L * (fileByteSize - fileBytesLeft) / fileByteSize);
                this.errorScanTask.setTaskProgress(progressPercent);
            }
            if (this.errorScanTask != null && this.errorScanTask.stopSearch()) {
                return foundError;
            }
            blockWordSize = (long)this.dataModel.getInt(bufPos) & 0xFFFFFFFFL;
            int blockNum = this.dataModel.getInt(bufPos + 4L);
            int byteInfo = this.dataModel.getInt(bufPos + 20L);
            int blockHdrWordSize = this.dataModel.getInt(bufPos + 8L);
            int blockEventCount = this.dataModel.getInt(bufPos + 12L);
            int magicNum = this.dataModel.getInt(bufPos + 28L);
            blockNode = new BlockHeader();
            blockNode.filePos = bufPos;
            blockNode.len = blockWordSize;
            blockNode.headerLen = blockHdrWordSize;
            blockNode.count = blockEventCount;
            blockNode.place = blockNum;
            blockNode.setInfoWord(byteInfo);
            boolean foundErrorInBlock = false;
            long blockEventLengthsSum = 0L;
            blockDataBytes = 4L * (blockWordSize - (long)blockHdrWordSize);
            if (blockWordSize < 8L || blockHdrWordSize < 8 || blockNum < 0 || blockEventCount < 0) {
                blockNode.error = "Block: len, header len, event cnt or block # is out of range";
                this.blockErrorNodes.add(blockNode);
                if (debug) {
                    System.out.println("scanFile: fatal error = " + blockNode.error);
                }
                this.dataModel.highLightBlockHeader(FileFrameBig.highlightBlkHdrErr, bufPos, true);
                return true;
            }
            if (magicNum != -1059454720) {
                if (Integer.reverseBytes(magicNum) == -1059454720) {
                    this.blockErrorNodes.clear();
                    JOptionPane.showMessageDialog(this.parentComponent, "Try switching data endian under \"File\" menu", "Return", 1);
                    throw new EvioException("Switch endianness & try again");
                }
                blockNode.error = "Block header, magic # incorrect";
                this.blockErrorNodes.add(blockNode);
                if (debug) {
                    System.out.println("scanFile: fatal error = " + blockNode.error);
                }
                this.dataModel.highLightBlockHeader(FileFrameBig.highlightBlkHdrErr, bufPos, true);
                return true;
            }
            if (blockHdrWordSize != 8 && debug) {
                System.out.println("Warning, suspicious block header size, " + blockHdrWordSize);
            }
            long bufPosInBlock = bufPos += (long)(4 * blockHdrWordSize);
            fileBytesLeft -= (long)(4 * blockHdrWordSize);
            if (firstBlock && BlockHeaderV4.hasDictionary((int)byteInfo)) {
                firstBlock = false;
                byteLen = 4L * (((long)this.dataModel.getInt(bufPosInBlock) & 0xFFFFFFFFL) + 1L);
                bufPosInBlock += byteLen;
                blockEventLengthsSum += byteLen;
            }
            for (int i = 0; i < blockEventCount; ++i) {
                EvioHeader node;
                if (fileBytesLeft - blockEventLengthsSum < 8L) {
                    blockNode.error = "Not enough data to read event (bad bank len?)";
                    this.blockErrorNodes.add(blockNode);
                    foundError = true;
                    foundErrorInBlock = true;
                    if (!debug) break;
                    System.out.println("scanFile: fatal error = " + blockNode.error);
                    break;
                }
                if (blockDataBytes - blockEventLengthsSum == 0L) {
                    blockNode.error = "Block event count = " + blockEventCount + ", but should = " + i;
                    this.blockErrorNodes.add(blockNode);
                    foundError = true;
                    foundErrorInBlock = true;
                    if (!debug) break;
                    System.out.println("scanFile: block event count is " + blockEventCount + " but should be " + i);
                    break;
                }
                long word = this.dataModel.getInt(bufPosInBlock + 28L);
                if (word == (long)BlockHeader.MAGIC_INT) {
                    blockNode.error = "block len too large and event count = " + blockEventCount + " but should = " + i;
                    this.blockErrorNodes.add(blockNode);
                    foundError = true;
                    foundErrorInBlock = true;
                    break;
                }
                try {
                    node = this.searchForErrorInEvent(this.dataModel, bufPosInBlock, eventCount + i, fileBytesLeft - blockEventLengthsSum);
                }
                catch (Exception e) {
                    node = this.extractEventNode(this.dataModel, bufPosInBlock, eventCount + i, fileBytesLeft - blockEventLengthsSum);
                    blockNode.error = e.getMessage() + " (bad bank len?)";
                    blockNode.events.add(node);
                    this.blockErrorNodes.add(blockNode);
                    foundError = true;
                    foundErrorInBlock = true;
                    this.dataModel.highLightEventHeader(FileFrameBig.highlightEvntHdrErr, bufPosInBlock, true);
                    break;
                }
                if (node.errorHeader != null || node.error != null) {
                    blockNode.error = "contained event #" + node.place + " has error";
                    blockNode.events.add(node);
                    this.blockErrorNodes.add(blockNode);
                    foundError = true;
                    foundErrorInBlock = true;
                    this.dataModel.highLightEventHeader(FileFrameBig.highlightEvntHdrErr, bufPosInBlock, true);
                    if (node.errorHeader == null || node == node.errorHeader) break;
                    blockNode.events.add(node.errorHeader);
                    this.dataModel.highLightEventHeader(FileFrameBig.highlightNodeErr, node.errorHeader.pos, true);
                    break;
                }
                blockNode.events.add(node);
                byteLen = 4L * (((long)this.dataModel.getInt(bufPosInBlock) & 0xFFFFFFFFL) + 1L);
                bufPosInBlock += byteLen;
                blockEventLengthsSum += byteLen;
            }
            if (foundErrorInBlock) {
                this.dataModel.highLightBlockHeader(FileFrameBig.highlightBlkHdrErr, blockNode.filePos, true);
            } else if (blockEventLengthsSum != blockDataBytes) {
                blockNode.error = "Byte len of events in block (" + blockEventLengthsSum + ") doesn't match block header (" + blockDataBytes + ")";
                this.blockErrorNodes.add(blockNode);
                this.dataModel.highLightBlockHeader(FileFrameBig.highlightBlkHdrErr, blockNode.filePos, true);
                if (debug) {
                    System.out.println("scanFile: try again error = " + blockNode.error);
                }
            } else {
                blockNode.events.clear();
            }
            eventCount += blockEventCount;
        } while ((fileBytesLeft -= blockDataBytes) != 0L && 4L * (blockWordSize = (long)this.dataModel.getInt(bufPos += blockDataBytes) & 0xFFFFFFFFL) <= fileBytesLeft);
        if (fileBytesLeft == 0L) {
            return false;
        }
        if (4L * blockWordSize > fileBytesLeft) {
            blockNode.error = "Block len too large (not enough data)";
            this.blockErrorNodes.add(blockNode);
            if (debug) {
                System.out.println("scanFile: not enough data for block len");
            }
            this.dataModel.highLightBlockHeader(FileFrameBig.highlightBlkHdrErr, blockNode.filePos, true);
            return true;
        }
        if (fileBytesLeft < 32L) {
            blockNode.error = "Extra " + fileBytesLeft + " bytes at file end";
            this.blockErrorNodes.add(blockNode);
            if (debug) {
                System.out.println("scanFile: data left at file end");
            }
            this.dataModel.highLightBlockHeader(FileFrameBig.highlightBlkHdrErr, blockNode.filePos, true);
            return true;
        }
        return false;
    }

    private void checkFirstHeader() throws EvioException {
        ByteBuffer byteBuffer = this.dataModel.getMemoryHandler().getFirstMap();
        if (byteBuffer.limit() < 32) {
            throw new EvioException("Too little data");
        }
        int magicNumber = byteBuffer.getInt(28);
        if (magicNumber != -1059454720) {
            throw new EvioException("Try switching data endian under \"File\" menu");
        }
        int bitInfo = byteBuffer.getInt(20);
        int evioVersion = bitInfo & 0xFF;
        if (evioVersion < 4) {
            throw new EvioException("unsupported evio version (" + evioVersion + ")");
        }
    }
}

