/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.eventViewer;

import org.jlab.coda.eventViewer.CodaBankTag;
import org.jlab.coda.eventViewer.EvioScanner;
import org.jlab.coda.eventViewer.FileFrameBig;
import org.jlab.coda.jevio.DataType;

public final class EvioHeader
implements Cloneable {
    long len;
    long pos;
    int type;
    int tag;
    int num;
    int pad;
    long dataLen;
    long dataPos;
    int dataType;
    String bankType;
    String error;
    boolean isEvent;
    FileFrameBig.MyTableModel model;
    Long wordIndex;
    int place;
    EvioHeader errorHeader;

    EvioHeader(int word1, int word2) {
        this.len = (long)word1 & 0xFFFFFFFFL;
        this.tag = word2 >> 16 & 0xFFFF;
        this.num = word2 & 0xFF;
        this.pad = word2 >> 14 & 3;
        this.dataType = word2 >> 8 & 0x3F;
        this.type = DataType.BANK.getValue();
        this.bankType = CodaBankTag.getDescription(this.tag);
    }

    EvioHeader(int word1, int word2, Long wordIndex) {
        this(word1, word2);
        this.wordIndex = wordIndex;
    }

    EvioHeader(long pos, int place, FileFrameBig.MyTableModel model) {
        this.pos = pos;
        this.place = place;
        this.model = model;
        this.isEvent = true;
        this.type = DataType.BANK.getValue();
    }

    public boolean probablyIsBank() {
        if (this.dataType == 0) {
            return false;
        }
        DataType dataTypeObj = DataType.getDataType((int)this.dataType);
        if (dataTypeObj == null) {
            return false;
        }
        return this.pad == 0 || !(this.pad == 2 ? !EvioScanner.dataTypeHasPadding(dataTypeObj) : dataTypeObj != DataType.CHAR8 && dataTypeObj != DataType.UCHAR8);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public void setAll(int word1, int word2, long pos, long dataPos, int dataLen, int dataType, boolean isEvent) {
        this.len = word1;
        this.tag = word2 >> 16 & 0xFFFF;
        this.num = word2 & 0xFF;
        this.pad = word2 >> 14 & 3;
        dataType = word2 >> 8 & 0x3F;
        this.type = DataType.BANK.getValue();
        this.bankType = CodaBankTag.getDescription(this.tag);
        this.pos = pos;
        this.dataPos = dataPos;
        this.dataLen = dataLen;
        this.dataType = dataType;
        this.isEvent = isEvent;
    }

    public long getFilePosition() {
        return this.pos;
    }

    public DataType getDataTypeObj() {
        return DataType.getDataType((int)this.dataType);
    }

    public DataType getTypeObj() {
        return DataType.getDataType((int)this.type);
    }
}

