/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.eventViewer;

import java.util.HashMap;

public enum CodaBankTag {
    TRIGGER_RAW_NOTS(65296, "Raw trigger bank"),
    TRIGGER_RAW_TS(65297, "Raw trigger bank"),
    TRIGGER_BUILT_NOTS_NORUN(65312, "Built trigger bank"),
    TRIGGER_BUILT_TS_NORUN(65313, "Built trigger bank"),
    TRIGGER_BUILT_NOTS_RUN(65314, "Built trigger bank"),
    TRIGGER_BUILT_TS_RUN(65315, "Built trigger bank"),
    TRIGGER_BUILT_NOTS_NORUN_NOSPEC(65316, "Built trigger bank"),
    TRIGGER_BUILT_TS_NORUN_NOSPEC(65317, "Built trigger bank"),
    TRIGGER_BUILT_NOTS_RUN_NOSPEC(65318, "Built trigger bank"),
    TRIGGER_BUILT_TS_RUN_NOSPEC(65319, "Built trigger bank"),
    PEB(65360, "PEB built"),
    PEB_SYNC(65368, "PEB built & sync"),
    SEB(65392, "SEB built"),
    SEB_SYNC(65400, "SEB built & sync"),
    SYNC(65488, "Sync event"),
    PRESTART(65489, "Prestart event"),
    GO(65490, "Go event"),
    PAUSE(65491, "Pause event"),
    END(65492, "End event");

    private int value;
    private String description;
    private static HashMap<Integer, CodaBankTag> tagToString;

    public static CodaBankTag getBankType(int val) {
        return tagToString.get(val);
    }

    public static String getName(int val) {
        CodaBankTag tag = CodaBankTag.getBankType(val);
        if (tag == null) {
            return "Unknown";
        }
        return tag.name();
    }

    public static String getDescription(int val) {
        CodaBankTag tag = CodaBankTag.getBankType(val);
        if (tag == null) {
            return "Unknown";
        }
        return tag.description;
    }

    private CodaBankTag(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        tagToString = new HashMap(32);
        for (CodaBankTag type : CodaBankTag.values()) {
            tagToString.put(type.value, type);
        }
    }
}

