/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.eventViewer;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jlab.coda.eventViewer.NamedLabel;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;

public class HeaderPanel
extends JPanel {
    private NamedLabel lengthLabel;
    private NamedLabel structureLabel;
    private NamedLabel dataTypeLabel;
    private NamedLabel tagLabel;
    private NamedLabel numberLabel;
    private NamedLabel descriptionLabel;

    public HeaderPanel() {
        this.setLayout(new GridLayout(2, 1, 0, 3));
        this.setBorder(new EmptyBorder(5, 5, 2, 0));
        this.structureLabel = new NamedLabel("structure", "description", 150);
        this.dataTypeLabel = new NamedLabel("data type", "description", 150);
        this.tagLabel = new NamedLabel("tag", "number", 150);
        this.numberLabel = new NamedLabel("number", "number", 150);
        this.lengthLabel = new NamedLabel("length", "description", 200);
        this.descriptionLabel = new NamedLabel("description", "description", 200);
        Dimension d1 = this.structureLabel.getPreferredSize();
        Dimension d2 = this.descriptionLabel.getPreferredSize();
        this.structureLabel.setMaximumSize(d1);
        this.dataTypeLabel.setMaximumSize(d1);
        this.tagLabel.setMaximumSize(d1);
        this.numberLabel.setMaximumSize(d1);
        this.lengthLabel.setMaximumSize(d2);
        this.descriptionLabel.setMaximumSize(d2);
        JPanel p0 = this.createLayoutPanel();
        JPanel p1 = this.createLayoutPanel();
        p0.add(this.structureLabel);
        p0.add(Box.createRigidArea(new Dimension(5, 0)));
        p0.add(this.tagLabel);
        p0.add(Box.createRigidArea(new Dimension(5, 0)));
        p0.add(this.lengthLabel);
        p1.add(this.dataTypeLabel);
        p1.add(Box.createRigidArea(new Dimension(5, 0)));
        p1.add(this.numberLabel);
        p1.add(Box.createRigidArea(new Dimension(5, 0)));
        p1.add(this.descriptionLabel);
        this.add(p0);
        this.add(p1);
    }

    private JPanel createLayoutPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        return p;
    }

    public void setHeader(BaseStructure structure) {
        if (structure == null || structure.getHeader() == null) {
            this.structureLabel.setText("   ");
            this.lengthLabel.setText("   ");
            this.tagLabel.setText("   ");
            this.dataTypeLabel.setText("   ");
            this.numberLabel.setText("   ");
            this.descriptionLabel.setText("   ");
        } else {
            BaseStructureHeader header = structure.getHeader();
            this.structureLabel.setText("" + structure.getStructureType());
            this.lengthLabel.setText(4 * header.getLength() + " bytes");
            this.tagLabel.setText("" + header.getTag());
            this.dataTypeLabel.setText("" + header.getDataType());
            this.numberLabel.setText("" + header.getNumber());
            this.descriptionLabel.setText(structure.getDescription());
        }
    }

    public void setDescription(BaseStructure structure) {
        if (structure == null) {
            this.descriptionLabel.setText("   ");
            return;
        }
        this.descriptionLabel.setText(structure.getDescription());
    }
}

