/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.eventViewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.jlab.coda.eventViewer.BlockHeader;
import org.jlab.coda.eventViewer.EvioHeader;
import org.jlab.coda.eventViewer.EvioScanner;
import org.jlab.coda.eventViewer.SimpleMappedMemoryHandler;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;

public class FileFrameBig
extends JFrame
implements PropertyChangeListener {
    private JTable dataTable;
    private MyTableModel dataTableModel;
    private MyRenderer dataTableRenderer;
    private JScrollPane tablePane;
    private HashMap<Integer, String> comments = new HashMap();
    private TreeMap<Long, EvioHeader> eventMap = new TreeMap();
    private ByteOrder order = ByteOrder.BIG_ENDIAN;
    private JMenuItem switchMenuItem;
    SimpleMappedMemoryHandler mappedMemoryHandler;
    private volatile BlockHeader currentBlockHeader;
    private volatile boolean isScanned;
    private JPanel controlPanel;
    private JPanel errorPanel;
    private static int controlPanelWidth = 220;
    private static Color darkGreen = new Color(0, 120, 0);
    private static Color highlightRed = new Color(255, 220, 220);
    private static Color highlightBlue = new Color(200, 230, 255);
    private static Color highlightYellow = new Color(240, 240, 170);
    private static Color highlightPurple = new Color(230, 210, 255);
    private static Color highlightCyan = new Color(190, 255, 255);
    private static Color highlightGreen = new Color(210, 250, 210);
    private static Color highlightOrange = new Color(255, 200, 130);
    static Color highlightBlkHdr = highlightGreen;
    static Color highlightEvntHdr = highlightCyan;
    static Color highlightValue = highlightYellow;
    static Color highlightBlkHdrErr = highlightRed;
    static Color highlightEvntHdrErr = highlightPurple;
    static Color highlightNodeErr = highlightOrange;
    private JLabel messageLabel;
    private JLabel fileNameLabel;
    private String fileName;
    private JSlider viewPosition;
    private JRadioButton wordValueButton;
    private JRadioButton wordIndexButton;
    private JRadioButton evioBlockButton;
    private JRadioButton evioEventButton;
    private JRadioButton evioFaultButton;
    private JRadioButton pageScrollButton;
    private ButtonGroup radioGroup;
    private JRadioButton[] faultButtons;
    private ButtonGroup faultRadioGroup;
    private EvioScanner evioFaultScanner;
    JPanel eventInfoPanel;
    JPanel blockInfoPanel;
    private JProgressBar progressBar;
    private JButton searchButtonStart;
    private JButton searchButtonStop;
    private JButton searchButtonNext;
    private JButton searchButtonPrev;
    private JComboBox<String> searchStringBox;
    private String searchString;
    private int lastSearchedRow = -1;
    private int lastSearchedCol = 0;
    private int lastFoundRow = -1;
    private int lastFoundCol = 0;
    private int lastFoundMap;
    private volatile boolean stopSearch;
    private volatile boolean searchDone = true;
    private SearchTask task;

    public FileFrameBig(File file) {
        super(file.getName() + " bytes");
        this.initializeLookAndFeel();
        WindowAdapter wa = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                FileFrameBig.this.dispose();
            }
        };
        this.addWindowListener(wa);
        this.setLayout(new BorderLayout());
        this.fileName = file.getPath();
        this.addMenus();
        this.addControlPanel();
        this.addKeyPanel();
        this.addFileViewPanel(file);
        this.sizeToScreen(this, 0.85);
        this.setVisible(true);
    }

    private void addMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu(" File ");
        ActionListener al_switch = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFrameBig.this.setMessage(" ", null, null);
                FileFrameBig.this.switchEndian();
                if (FileFrameBig.this.wordIndexButton.isSelected() || FileFrameBig.this.pageScrollButton.isSelected()) {
                    FileFrameBig.this.dataTable.setRowSelectionInterval(FileFrameBig.this.lastSearchedRow, FileFrameBig.this.lastSearchedRow);
                    FileFrameBig.this.dataTable.setColumnSelectionInterval(FileFrameBig.this.lastSearchedCol, FileFrameBig.this.lastSearchedCol);
                }
            }
        };
        this.switchMenuItem = new JMenuItem("To little endian");
        this.switchMenuItem.addActionListener(al_switch);
        menu.add(this.switchMenuItem);
        ActionListener al_clearError = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFrameBig.this.setMessage(" ", null, null);
            }
        };
        JMenuItem clearErrorMenuItem = new JMenuItem("Clear error");
        clearErrorMenuItem.addActionListener(al_clearError);
        menu.add(clearErrorMenuItem);
        ActionListener al_clearComments = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFrameBig.this.setMessage(" ", null, null);
                FileFrameBig.this.comments.clear();
                FileFrameBig.this.dataTableModel.fireTableDataChanged();
            }
        };
        JMenuItem clearCommentsMenuItem = new JMenuItem("Clear comments");
        clearCommentsMenuItem.addActionListener(al_clearComments);
        menu.add(clearCommentsMenuItem);
        ActionListener al_clearHighlights = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFrameBig.this.setMessage(" ", null, null);
                FileFrameBig.this.eventMap.clear();
                FileFrameBig.this.dataTableModel.clearHighLights();
                FileFrameBig.this.dataTableModel.fireTableDataChanged();
            }
        };
        JMenuItem clearHighlightsMenuItem = new JMenuItem("Clear highlights");
        clearHighlightsMenuItem.addActionListener(al_clearHighlights);
        menu.add(clearHighlightsMenuItem);
        ActionListener al_exit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFrameBig.this.dispose();
            }
        };
        JMenuItem exit_item = new JMenuItem("Quit");
        exit_item.addActionListener(al_exit);
        menu.add(exit_item);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    private void switchEndian() {
        if (this.order == ByteOrder.BIG_ENDIAN) {
            this.order = ByteOrder.LITTLE_ENDIAN;
            this.switchMenuItem.setText("To big endian");
        } else {
            this.order = ByteOrder.BIG_ENDIAN;
            this.switchMenuItem.setText("To little endian");
        }
        this.mappedMemoryHandler.setByteOrder(this.order);
        this.setTableData();
    }

    private void setMessage(String msg, Color foreColor, Color backColor) {
        this.messageLabel.setForeground(foreColor);
        this.messageLabel.setBackground(backColor);
        this.messageLabel.setText(msg);
    }

    private int findTopVisibleRow(JViewport viewport) {
        Point pt = viewport.getViewPosition();
        return (pt.y + this.dataTable.getRowHeight() / 2) / this.dataTable.getRowHeight();
    }

    private boolean atEnd(JViewport viewport) {
        Point pt = viewport.getViewPosition();
        Dimension dim = viewport.getExtentSize();
        return pt.y + dim.height >= this.dataTable.getHeight();
    }

    private void scrollToVisible(boolean down, int pagesPerClick) {
        Rectangle rec;
        JViewport viewport = this.tablePane.getViewport();
        Point pt = viewport.getViewPosition();
        Dimension dim = viewport.getExtentSize();
        int numRowsViewed = dim.height / this.dataTable.getRowHeight();
        int extraPixels = dim.height % this.dataTable.getRowHeight();
        int deltaY = pagesPerClick * numRowsViewed * this.dataTable.getRowHeight();
        if (down) {
            if (this.atEnd(viewport)) {
                if (!this.dataTableModel.nextMap()) {
                    return;
                }
                rec = new Rectangle(pt.x, 0, dim.width, dim.height);
            } else {
                rec = new Rectangle(pt.x, pt.y + deltaY, dim.width, dim.height);
            }
        } else {
            if (this.atEnd(viewport)) {
                deltaY -= extraPixels;
            }
            rec = new Rectangle(pt.x, pt.y - deltaY, dim.width, dim.height);
            if (pt.y < 1) {
                if (!this.dataTableModel.previousMap()) {
                    return;
                }
                rec = new Rectangle(pt.x, viewport.getViewSize().height - extraPixels, dim.width, dim.height);
            }
        }
        this.dataTable.scrollRectToVisible(rec);
        this.dataTableModel.dataChanged();
    }

    private void scrollToIndex(long position, Color color, boolean isEvent) {
        JViewport viewport = this.tablePane.getViewport();
        Point pt = viewport.getViewPosition();
        Dimension dim = viewport.getExtentSize();
        int[] mapRowCol = this.dataTableModel.getMapRowCol(position);
        if (mapRowCol == null) {
            JOptionPane.showMessageDialog(this, "Reached end of file", "Return", 1);
            return;
        }
        this.dataTableModel.setMapIndex(mapRowCol[0]);
        int finalY = (mapRowCol[1] - 5) * this.dataTable.getRowHeight();
        Rectangle rec = new Rectangle(pt.x, finalY, dim.width, dim.height);
        this.lastSearchedRow = mapRowCol[1];
        this.lastSearchedCol = mapRowCol[2];
        if (color != null) {
            if (isEvent) {
                this.dataTableModel.highLightEventHeader(color, this.lastSearchedRow, this.lastSearchedCol, false);
            } else {
                this.dataTableRenderer.setHighlightCell(color, this.lastSearchedRow, this.lastSearchedCol, false);
            }
        }
        this.dataTable.scrollRectToVisible(rec);
        this.dataTableModel.dataChanged();
        this.dataTable.setRowSelectionInterval(this.lastSearchedRow, this.lastSearchedRow);
        this.dataTable.setColumnSelectionInterval(this.lastSearchedCol, this.lastSearchedCol);
    }

    private int[] scrollToAndHighlight(boolean down, long findValue, boolean getBlock, String comments, SearchTask task) {
        JViewport viewport = this.tablePane.getViewport();
        Point viewPoint = viewport.getViewPosition();
        Dimension dim = viewport.getExtentSize();
        int viewHeight = dim.height;
        int viewWidth = dim.width;
        int dataTableRowHeight = this.dataTable.getRowHeight();
        int[] blockData = null;
        int maxMapIndex = this.dataTableModel.getMapCount() - 1;
        int startingMapIndex = this.dataTableModel.getMapIndex();
        Rectangle rec = null;
        int startingCol = 1;
        boolean foundValue = false;
        this.stopSearch = false;
        this.searchDone = false;
        block0: while (true) {
            long val;
            int col;
            int row;
            int rowCount = this.dataTableModel.getRowCount();
            if (down) {
                if (this.lastSearchedRow < 0) {
                    row = 0;
                    startingCol = 1;
                } else if (this.lastSearchedCol == 5) {
                    if (this.lastSearchedRow == rowCount - 1) {
                        row = rowCount;
                    } else {
                        row = this.lastSearchedRow + 1;
                        startingCol = 1;
                    }
                } else {
                    row = this.lastSearchedRow;
                    startingCol = this.lastSearchedCol + 1;
                }
                while (row < rowCount) {
                    for (col = startingCol; col < 6; ++col) {
                        int viewY;
                        int rowY;
                        if (this.stopSearch) {
                            foundValue = false;
                            break block0;
                        }
                        val = this.dataTableModel.getLongValueAt(row, col);
                        this.lastSearchedRow = row;
                        this.lastSearchedCol = col;
                        if (val != findValue) continue;
                        if (getBlock) {
                            blockData = this.dataTableModel.highLightBlockHeader(highlightBlkHdr, row, col, false);
                            if (blockData == null) {
                                foundValue = false;
                                continue;
                            }
                            if ((blockData[5] & 0xF) < 2 || (blockData[5] & 0xF) > 6) {
                                foundValue = false;
                                continue;
                            }
                        } else {
                            this.dataTableModel.highLightCell(highlightValue, row, col, false);
                        }
                        if (comments != null) {
                            this.dataTableModel.setValueAt(comments, row, 6);
                        }
                        if ((rowY = row * dataTableRowHeight) >= (viewY = viewPoint.y) && rowY <= viewY + viewHeight) {
                            this.dataTableModel.dataChanged();
                            this.dataTable.setRowSelectionInterval(row, row);
                            this.dataTable.setColumnSelectionInterval(col, col);
                        } else {
                            int finalY = (row - 5) * dataTableRowHeight;
                            rec = new Rectangle(viewPoint.x, finalY, viewWidth, viewHeight);
                        }
                        this.lastFoundRow = row;
                        this.lastFoundCol = col;
                        this.lastFoundMap = this.dataTableModel.getMapIndex();
                        foundValue = true;
                        break block0;
                    }
                    startingCol = 1;
                    if (++row % 0x400000 != 0) continue;
                    task.setTaskProgress(this.dataTableModel.getRowProgress(row));
                }
            } else {
                if (this.lastSearchedRow < 0) {
                    row = -1;
                } else if (this.lastSearchedCol == 1) {
                    if (this.lastSearchedRow == 0) {
                        row = -1;
                    } else {
                        row = this.lastSearchedRow - 1;
                        startingCol = 5;
                    }
                } else {
                    row = this.lastSearchedRow;
                    startingCol = this.lastSearchedCol - 1;
                }
                while (row >= 0) {
                    for (col = startingCol; col > 0; --col) {
                        int viewY;
                        int rowY;
                        if (this.stopSearch) {
                            foundValue = false;
                            break block0;
                        }
                        val = this.dataTableModel.getLongValueAt(row, col);
                        this.lastSearchedRow = row;
                        this.lastSearchedCol = col;
                        if (val != findValue) continue;
                        if (getBlock) {
                            blockData = this.dataTableModel.highLightBlockHeader(highlightBlkHdr, row, col, false);
                            if (blockData == null) {
                                foundValue = false;
                                continue;
                            }
                            if ((blockData[5] & 0xF) < 2 || (blockData[5] & 0xF) > 6) {
                                foundValue = false;
                                continue;
                            }
                        } else {
                            this.dataTableModel.highLightCell(highlightValue, row, col, false);
                        }
                        if (comments != null) {
                            this.dataTableModel.setValueAt(comments, row, 6);
                        }
                        if ((rowY = row * dataTableRowHeight) >= (viewY = viewPoint.y) && rowY <= viewY + viewHeight) {
                            this.dataTableModel.dataChanged();
                            this.dataTable.setRowSelectionInterval(row, row);
                            this.dataTable.setColumnSelectionInterval(col, col);
                        } else {
                            int numRowsViewed = viewHeight / dataTableRowHeight;
                            int finalY = (row - numRowsViewed + 6) * dataTableRowHeight;
                            rec = new Rectangle(viewPoint.x, finalY, viewWidth, viewHeight);
                        }
                        this.lastFoundRow = row;
                        this.lastFoundCol = col;
                        this.lastFoundMap = this.dataTableModel.getMapIndex();
                        foundValue = true;
                        break block0;
                    }
                    startingCol = 5;
                    if (--row % 0x400000 != 0) continue;
                    task.setTaskProgress(this.dataTableModel.getRowProgress(row));
                }
            }
            if (down) {
                if (!this.dataTableModel.nextMap()) {
                    this.dataTable.clearSelection();
                    break;
                }
                this.lastSearchedRow = -1;
                this.lastSearchedCol = 0;
                continue;
            }
            if (!this.dataTableModel.previousMap()) {
                this.dataTable.clearSelection();
                break;
            }
            this.lastSearchedRow = this.dataTableModel.getRowCount() - 1;
            this.lastSearchedCol = 6;
        }
        if (!foundValue) {
            if (this.stopSearch) {
                this.setMessage("Search Stopped", darkGreen, null);
            } else {
                this.setMessage("No value found", darkGreen, null);
            }
            this.lastSearchedCol = this.lastFoundCol;
            this.lastSearchedRow = this.lastFoundRow;
            if (this.dataTableModel.getMapIndex() != this.lastFoundMap) {
                this.dataTableModel.setMapIndex(this.lastFoundMap);
            }
            this.dataTable.setRowSelectionInterval(this.lastFoundRow, this.lastFoundRow);
            this.dataTable.setColumnSelectionInterval(this.lastFoundCol, this.lastFoundCol);
            this.searchDone = true;
            return blockData;
        }
        if (rec != null) {
            this.dataTable.scrollRectToVisible(rec);
            this.dataTableModel.dataChanged();
            this.dataTable.setRowSelectionInterval(this.lastSearchedRow, this.lastSearchedRow);
            this.dataTable.setColumnSelectionInterval(this.lastSearchedCol, this.lastSearchedCol);
        }
        this.searchDone = true;
        return blockData;
    }

    private void handleWordValueSearch(boolean down, boolean findBlock) {
        this.setMessage(" ", null, null);
        long l = 3235512576L;
        if (!findBlock) {
            String txt = (String)this.searchStringBox.getSelectedItem();
            try {
                if (txt.length() > 1 && txt.substring(0, 2).equalsIgnoreCase("0x")) {
                    txt = txt.substring(2);
                    l = Long.parseLong(txt, 16);
                } else {
                    l = Long.parseLong(txt, 10);
                }
            }
            catch (NumberFormatException e) {
                this.setMessage("Search input not a number: " + txt, Color.red, null);
                this.searchButtonStop.setEnabled(false);
                return;
            }
        }
        String label = null;
        long ll = l;
        if (l == 3235512576L) {
            label = "Block Header";
        }
        this.task = new SearchTask(down, findBlock, ll, label);
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    private void handleErrorSearch() {
        this.searchDone = false;
        ErrorScanTask errorTask = new ErrorScanTask();
        errorTask.addPropertyChangeListener(this);
        errorTask.execute();
    }

    private EvioHeader handleEventSearchForward() {
        int n;
        long val;
        int[] mapRowCol;
        long wordIndex;
        this.setMessage(" ", null, null);
        EvioHeader node = null;
        int row = this.dataTable.getSelectedRow();
        int col = this.dataTable.getSelectedColumn();
        if (!this.dataTableModel.isDataColumn(col)) {
            if (row > 0 || col >= this.dataTableModel.getColumnCount() - 1) {
                JOptionPane.showMessageDialog(this, "Start at 0 or beginning of known event", "Return", 1);
                return null;
            }
            row = 0;
            col = 1;
            wordIndex = this.dataTableModel.getWordIndexOf(row, col);
            mapRowCol = this.dataTableModel.getMapRowCol(wordIndex + 7L);
            this.dataTableModel.setMapIndex(mapRowCol[0]);
            val = this.dataTableModel.getLongValueAt(mapRowCol[1], mapRowCol[2]);
            if (val == 3235512576L) {
                this.searchDone = true;
                this.scrollToIndex(wordIndex += 8L, highlightEvntHdr, true);
                node = new EvioHeader((int)this.dataTableModel.getLongValueAt(wordIndex), (int)this.dataTableModel.getLongValueAt(wordIndex + 1L), wordIndex);
                return node;
            }
        }
        this.dataTableModel.highLightEventHeader(highlightEvntHdr, row, col, false);
        wordIndex = this.dataTableModel.getWordIndexOf(row, col);
        node = new EvioHeader((int)this.dataTableModel.getLongValueAt(wordIndex), (int)this.dataTableModel.getLongValueAt(wordIndex + 1L), wordIndex);
        if (!node.probablyIsBank() && (n = JOptionPane.showOptionDialog(this, "\"Probably not a bank, continue?", null, 2, 3, null, null, null)) != 0) {
            return null;
        }
        this.eventMap.put(wordIndex, node);
        long eventWordLen = this.dataTableModel.getLongValueAt(row, col) + 1L;
        mapRowCol = this.dataTableModel.getMapRowCol((wordIndex += eventWordLen) + 7L);
        if (mapRowCol == null) {
            this.searchDone = true;
            JOptionPane.showMessageDialog(this, "No more events", "Return", 1);
            return null;
        }
        this.dataTableModel.setMapIndex(mapRowCol[0]);
        val = this.dataTableModel.getLongValueAt(mapRowCol[1], mapRowCol[2]);
        if (val == 3235512576L) {
            wordIndex += 8L;
        }
        this.scrollToIndex(wordIndex, highlightEvntHdr, true);
        this.searchDone = true;
        node = new EvioHeader((int)this.dataTableModel.getLongValueAt(wordIndex), (int)this.dataTableModel.getLongValueAt(wordIndex + 1L), wordIndex);
        this.eventMap.put(wordIndex, node);
        return node;
    }

    private EvioHeader handleEventSearchBack() {
        long wordIndex;
        SortedMap<Long, EvioHeader> map;
        this.setMessage(" ", null, null);
        if (this.eventMap.size() == 0) {
            return null;
        }
        int row = this.dataTable.getSelectedRow();
        int col = this.dataTable.getSelectedColumn();
        if (!this.dataTableModel.isDataColumn(col)) {
            if (col == 0) {
                col = 1;
            } else if (col == 6) {
                col = 5;
            }
        }
        if ((map = this.eventMap.headMap(wordIndex = this.dataTableModel.getWordIndexOf(row, col))).size() < 1) {
            return null;
        }
        Long key = map.lastKey();
        if (key == null) {
            return null;
        }
        EvioHeader node = (EvioHeader)map.get(key);
        this.scrollToIndex(key, highlightEvntHdr, true);
        return node;
    }

    private void handleWordIndexSearch() {
        this.setMessage(" ", null, null);
        long l = 1L;
        String txt = (String)this.searchStringBox.getSelectedItem();
        try {
            if (txt.length() > 1 && txt.substring(0, 2).equalsIgnoreCase("0x")) {
                txt = txt.substring(2);
                l = Long.parseLong(txt, 16);
            } else {
                l = Long.parseLong(txt, 10);
            }
        }
        catch (NumberFormatException e) {
            this.setMessage("Search input not a number: " + txt, Color.red, null);
            return;
        }
        if (l < 1L) {
            l = 1L;
        }
        this.scrollToIndex(l - 1L, null, false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.searchDone) {
            return;
        }
        if ("progress".equalsIgnoreCase(evt.getPropertyName())) {
            this.progressBar.setValue((Integer)evt.getNewValue());
        }
    }

    private void setControlsForErrorScan() {
        this.searchButtonStart.setText("Start Scan");
        this.searchButtonStop.setText("Stop");
        this.enableControls();
        this.searchStringBox.setEnabled(false);
    }

    private void enableSearchControls() {
        this.searchButtonStop.setText("Stop");
        this.enableControls();
        this.searchButtonStart.setEnabled(false);
    }

    private void enableControlsDuringSearch() {
        this.searchButtonStart.setEnabled(false);
        this.searchButtonStop.setEnabled(true);
        this.searchStringBox.setEnabled(false);
        this.searchButtonNext.setEnabled(false);
        this.searchButtonPrev.setEnabled(false);
        this.wordValueButton.setEnabled(false);
        this.wordIndexButton.setEnabled(false);
        this.pageScrollButton.setEnabled(false);
        this.evioBlockButton.setEnabled(false);
        this.evioEventButton.setEnabled(false);
        this.evioFaultButton.setEnabled(false);
    }

    private void enableControlsForPositionJump() {
        this.enableControls();
        this.searchButtonStart.setEnabled(false);
        this.searchButtonStop.setEnabled(false);
        this.searchButtonPrev.setEnabled(false);
    }

    private void enableControlsForEventJump() {
        this.enableControls();
        this.searchButtonStart.setEnabled(false);
        this.searchButtonStop.setEnabled(false);
    }

    private void enableControlsForScrolling() {
        this.searchButtonStart.setText("<<");
        this.searchButtonStop.setText(">>");
        this.enableControls();
    }

    private void enableControlsForBlock() {
        this.searchButtonStop.setText("Stop");
        this.enableControls();
        this.searchButtonStart.setEnabled(false);
        this.searchStringBox.setSelectedIndex(0);
        this.searchStringBox.setEditable(false);
    }

    private void enableControls() {
        this.searchButtonStart.setEnabled(true);
        this.searchButtonStop.setEnabled(true);
        this.searchStringBox.setEnabled(true);
        this.searchButtonNext.setEnabled(true);
        this.searchButtonPrev.setEnabled(true);
        this.wordValueButton.setEnabled(true);
        this.wordIndexButton.setEnabled(true);
        this.pageScrollButton.setEnabled(true);
        this.evioBlockButton.setEnabled(true);
        this.evioEventButton.setEnabled(true);
        this.evioFaultButton.setEnabled(true);
    }

    private void setSliderPosition() {
        JViewport viewport = this.tablePane.getViewport();
        Point viewPoint = viewport.getViewPosition();
        int viewHeight = viewport.getExtentSize().height;
        long midRow = (2 * viewPoint.y + viewHeight) / (2 * this.dataTable.getRowHeight());
        int currentMapIndex = this.dataTableModel.getMapIndex();
        if (currentMapIndex > 0) {
            midRow += (long)(currentMapIndex * this.dataTableModel.getMaxRowsPerMap());
        }
        this.viewPosition.setValue((int)(1000L * midRow / this.dataTableModel.getTotalRows()));
    }

    private void updateEventInfoPanel(EvioHeader node) {
        if (node == null || this.eventInfoPanel == null) {
            return;
        }
        ((JLabel)this.eventInfoPanel.getComponent(1)).setText("" + (node.len & 0xFFFFFFFFL));
        ((JLabel)this.eventInfoPanel.getComponent(3)).setText("0x" + Integer.toHexString(node.tag));
        ((JLabel)this.eventInfoPanel.getComponent(5)).setText("" + node.num);
        ((JLabel)this.eventInfoPanel.getComponent(11)).setText("" + node.pad);
        ((JLabel)this.eventInfoPanel.getComponent(13)).setText("" + node.bankType);
        DataType nodeType = node.getTypeObj();
        String type = nodeType == null ? "bad (" + node.type + ")" : "" + nodeType;
        ((JLabel)this.eventInfoPanel.getComponent(7)).setText("" + type);
        DataType dataType = node.getDataTypeObj();
        String dtype = dataType == null ? "bad (" + node.dataType + ")" : "" + dataType;
        ((JLabel)this.eventInfoPanel.getComponent(9)).setText("" + dtype);
    }

    private void removeEventInfoPanel() {
        if (this.eventInfoPanel == null) {
            return;
        }
        Component[] comps = this.controlPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != this.eventInfoPanel) continue;
            this.controlPanel.remove(i);
            this.controlPanel.remove(i - 1);
        }
        this.controlPanel.revalidate();
        this.controlPanel.repaint();
        this.eventInfoPanel = null;
    }

    private void addEventInfoPanel() {
        if (this.eventInfoPanel != null) {
            return;
        }
        Border blkLineBorder = BorderFactory.createLineBorder(Color.black);
        Border lineBorder = BorderFactory.createLineBorder(Color.blue);
        AbstractBorder compound = BorderFactory.createCompoundBorder(lineBorder, null);
        compound = BorderFactory.createTitledBorder(compound, "Event Info", 2, 2, null, Color.blue);
        this.eventInfoPanel = new JPanel();
        this.eventInfoPanel.setLayout(new GridLayout(7, 2, 5, 2));
        this.eventInfoPanel.setBorder(compound);
        JLabel[] labels = new JLabel[14];
        labels[0] = new JLabel("Length  ");
        labels[2] = new JLabel("Tag  ");
        labels[4] = new JLabel("Num  ");
        labels[6] = new JLabel("Type  ");
        labels[8] = new JLabel("Data type  ");
        labels[10] = new JLabel("Padding  ");
        labels[12] = new JLabel("Bank Type  ");
        labels[1] = new JLabel("");
        labels[3] = new JLabel("");
        labels[5] = new JLabel("");
        labels[7] = new JLabel("");
        labels[9] = new JLabel("");
        labels[11] = new JLabel("");
        labels[13] = new JLabel("");
        for (int i = 0; i < 14; ++i) {
            labels[i].setOpaque(true);
            if (i % 2 == 1) {
                labels[i].setBackground(Color.white);
                labels[i].setForeground(darkGreen);
                labels[i].setBorder(blkLineBorder);
            } else {
                labels[i].setHorizontalAlignment(4);
            }
            this.eventInfoPanel.add(labels[i]);
        }
        this.controlPanel.add(Box.createVerticalStrut(10));
        this.controlPanel.add(this.eventInfoPanel);
        this.controlPanel.revalidate();
        this.controlPanel.repaint();
    }

    private void updateBlockInfoPanel(int[] blockData) {
        if (blockData == null || this.blockInfoPanel == null) {
            return;
        }
        ((JLabel)this.blockInfoPanel.getComponent(1)).setText("" + blockData[0]);
        ((JLabel)this.blockInfoPanel.getComponent(3)).setText("" + blockData[2]);
        ((JLabel)this.blockInfoPanel.getComponent(5)).setText("" + blockData[1]);
        ((JLabel)this.blockInfoPanel.getComponent(7)).setText("" + blockData[3]);
        ((JLabel)this.blockInfoPanel.getComponent(9)).setText("" + (blockData[5] & 0xFF));
        ((JLabel)this.blockInfoPanel.getComponent(11)).setText("" + BlockHeaderV4.hasDictionary((int)blockData[5]));
        ((JLabel)this.blockInfoPanel.getComponent(13)).setText("" + BlockHeaderV4.isLastBlock((int)blockData[5]));
    }

    private void updateBlockInfoPanel(BlockHeader header) {
        if (header == null || this.blockInfoPanel == null) {
            return;
        }
        ((JLabel)this.blockInfoPanel.getComponent(1)).setText("" + header.len);
        ((JLabel)this.blockInfoPanel.getComponent(3)).setText("" + header.headerLen);
        ((JLabel)this.blockInfoPanel.getComponent(5)).setText("" + header.place);
        ((JLabel)this.blockInfoPanel.getComponent(7)).setText("" + header.count);
        ((JLabel)this.blockInfoPanel.getComponent(9)).setText("" + header.version);
        ((JLabel)this.blockInfoPanel.getComponent(11)).setText("" + header.hasDictionary);
        ((JLabel)this.blockInfoPanel.getComponent(13)).setText("" + header.isLast);
    }

    private void removeBlockInfoPanel() {
        if (this.blockInfoPanel == null) {
            return;
        }
        Component[] comps = this.controlPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != this.blockInfoPanel) continue;
            this.controlPanel.remove(i);
            this.controlPanel.remove(i - 1);
        }
        this.controlPanel.revalidate();
        this.controlPanel.repaint();
        this.blockInfoPanel = null;
    }

    private void addBlockInfoPanel() {
        if (this.blockInfoPanel != null) {
            return;
        }
        Border blkLineBorder = BorderFactory.createLineBorder(Color.black);
        Border lineBorder = BorderFactory.createLineBorder(Color.blue);
        AbstractBorder compound = BorderFactory.createCompoundBorder(lineBorder, null);
        compound = BorderFactory.createTitledBorder(compound, "Block Info", 2, 2, null, Color.blue);
        this.blockInfoPanel = new JPanel();
        this.blockInfoPanel.setLayout(new GridLayout(7, 2, 5, 2));
        this.blockInfoPanel.setBorder(compound);
        JLabel[] labels = new JLabel[14];
        labels[0] = new JLabel("Total words  ");
        labels[2] = new JLabel("Header words  ");
        labels[4] = new JLabel("Id number  ");
        labels[6] = new JLabel("Event count  ");
        labels[8] = new JLabel("Version  ");
        labels[10] = new JLabel("Has dictionary  ");
        labels[12] = new JLabel("Is last  ");
        labels[1] = new JLabel("");
        labels[3] = new JLabel("");
        labels[5] = new JLabel("");
        labels[7] = new JLabel("");
        labels[9] = new JLabel("");
        labels[11] = new JLabel("");
        labels[13] = new JLabel("");
        for (int i = 0; i < 14; ++i) {
            labels[i].setOpaque(true);
            if (i % 2 == 1) {
                labels[i].setBackground(Color.white);
                labels[i].setForeground(darkGreen);
                labels[i].setBorder(blkLineBorder);
            } else {
                labels[i].setHorizontalAlignment(4);
            }
            this.blockInfoPanel.add(labels[i]);
        }
        this.controlPanel.add(Box.createVerticalStrut(10));
        this.controlPanel.add(this.blockInfoPanel);
        this.controlPanel.revalidate();
        this.controlPanel.repaint();
    }

    private void removeEvioFaultPanel() {
        if (this.errorPanel == null) {
            return;
        }
        Component[] comps = this.controlPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != this.errorPanel) continue;
            this.controlPanel.remove(i);
            this.controlPanel.remove(i - 1);
        }
        this.controlPanel.revalidate();
        this.controlPanel.repaint();
        this.errorPanel = null;
    }

    private void addEvioFaultPanel(ErrorScanTask errorTask) {
        if (this.evioFaultScanner == null) {
            try {
                this.evioFaultScanner = new EvioScanner(this, this.dataTableModel, this.dataTableRenderer, errorTask);
            }
            catch (EvioException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Return", 1);
                return;
            }
        }
        if (this.isScanned) {
            this.removeEvioFaultPanel();
        }
        this.isScanned = true;
        try {
            this.evioFaultScanner.scanFileForErrors();
        }
        catch (Exception e) {
            return;
        }
        if (!this.evioFaultScanner.hasError()) {
            this.setMessage("No errors found", darkGreen, null);
            return;
        }
        this.setMessage("Errors found", Color.red, null);
        this.faultRadioGroup = new ButtonGroup();
        Border lineBorder = BorderFactory.createLineBorder(Color.blue);
        AbstractBorder compound = BorderFactory.createCompoundBorder(lineBorder, null);
        compound = BorderFactory.createTitledBorder(compound, "Evio Errors", 2, 2, null, Color.blue);
        this.errorPanel = new JPanel();
        this.errorPanel.setBorder(compound);
        this.errorPanel.setLayout(new BorderLayout(0, 10));
        this.errorPanel.setMinimumSize(new Dimension(controlPanelWidth, 180));
        this.errorPanel.setPreferredSize(new Dimension(controlPanelWidth, 180));
        MouseListener ml = new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ButtonModel sel = FileFrameBig.this.faultRadioGroup.getSelection();
                if (sel == null) {
                    return;
                }
                String actionCmd = sel.getActionCommand();
                String[] strings = actionCmd.split(":");
                int index = Integer.parseInt(strings[1]);
                boolean isBlock = strings[0].equals("B");
                FileFrameBig.this.currentBlockHeader = FileFrameBig.this.evioFaultScanner.getBlockErrorNodes().get(index);
                ((FileFrameBig)FileFrameBig.this).currentBlockHeader.currentEventIndex = -1;
                FileFrameBig.this.setMessage(((FileFrameBig)FileFrameBig.this).currentBlockHeader.error, Color.red, null);
                FileFrameBig.this.scrollToIndex(((FileFrameBig)FileFrameBig.this).currentBlockHeader.filePos / 4L, null, false);
                FileFrameBig.this.setSliderPosition();
                FileFrameBig.this.removeEventInfoPanel();
                FileFrameBig.this.addBlockInfoPanel();
                FileFrameBig.this.updateBlockInfoPanel(FileFrameBig.this.currentBlockHeader);
            }
        };
        ArrayList<BlockHeader> blocks = this.evioFaultScanner.getBlockErrorNodes();
        int blockCount = blocks.size();
        this.faultButtons = new JRadioButton[blockCount];
        DefaultListModel<JRadioButton> model = new DefaultListModel<JRadioButton>();
        for (int i = 0; i < blockCount; ++i) {
            BlockHeader blockHeader = blocks.get(i);
            this.faultButtons[i] = new JRadioButton("Block " + blockHeader.place);
            this.faultButtons[i].setActionCommand("B:" + i);
            this.faultRadioGroup.add(this.faultButtons[i]);
            model.addElement(this.faultButtons[i]);
        }
        JList list = new JList(model);
        class PanelRenderer
        implements ListCellRenderer {
            PanelRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JRadioButton renderer = (JRadioButton)value;
                renderer.setSelected(isSelected);
                if (isSelected) {
                    renderer.doClick();
                }
                return renderer;
            }
        }
        list.setCellRenderer(new PanelRenderer());
        list.addMouseListener(ml);
        JScrollPane jsp = new JScrollPane(list);
        this.errorPanel.add(jsp);
        this.controlPanel.add(Box.createVerticalStrut(10), 6);
        this.controlPanel.add((Component)this.errorPanel, 7);
        this.controlPanel.revalidate();
        this.controlPanel.repaint();
    }

    private void scanBlockErrorEventsBack() {
        EvioHeader header;
        if (this.currentBlockHeader == null) {
            return;
        }
        if (--this.currentBlockHeader.currentEventIndex < 0) {
            this.currentBlockHeader.currentEventIndex = 0;
        }
        if ((header = this.currentBlockHeader.events.get(this.currentBlockHeader.currentEventIndex)) == null) {
            return;
        }
        if (header.error != null) {
            this.setMessage(header.error, Color.red, null);
            this.scrollToIndex(header.getFilePosition() / 4L, highlightEvntHdrErr, true);
        } else {
            this.setMessage("", null, null);
            this.scrollToIndex(header.getFilePosition() / 4L, highlightEvntHdr, true);
        }
        this.setSliderPosition();
        this.addEventInfoPanel();
        this.updateEventInfoPanel(header);
    }

    private void scanBlockErrorEventsForward() {
        EvioHeader header;
        if (this.currentBlockHeader == null) {
            return;
        }
        int maxIndex = this.currentBlockHeader.events.size() - 1;
        if (maxIndex < 0) {
            return;
        }
        if (++this.currentBlockHeader.currentEventIndex > maxIndex) {
            this.currentBlockHeader.currentEventIndex = maxIndex;
        }
        if ((header = this.currentBlockHeader.events.get(this.currentBlockHeader.currentEventIndex)) == null) {
            return;
        }
        if (header.error != null) {
            this.setMessage(header.error, Color.red, null);
            this.scrollToIndex(header.getFilePosition() / 4L, highlightEvntHdrErr, true);
        } else {
            this.setMessage("", null, null);
            this.scrollToIndex(header.getFilePosition() / 4L, highlightEvntHdr, true);
        }
        this.setSliderPosition();
        this.addEventInfoPanel();
        this.updateEventInfoPanel(header);
    }

    private void addKeyPanel() {
        JPanel keyPanel = new JPanel();
        keyPanel.setLayout(new BorderLayout());
        CompoundBorder border = new CompoundBorder(BorderFactory.createEtchedBorder(1), new EmptyBorder(5, 5, 5, 5));
        keyPanel.setBorder(border);
        Border blkLineBorder = BorderFactory.createLineBorder(Color.gray);
        Border lineBorder = BorderFactory.createLineBorder(Color.blue);
        AbstractBorder compound = BorderFactory.createCompoundBorder(lineBorder, null);
        compound = BorderFactory.createTitledBorder(compound, "Color Key", 2, 2, null, Color.blue);
        JPanel keyInfoPanel = new JPanel();
        keyInfoPanel.setLayout(new GridLayout(7, 1, 5, 2));
        keyInfoPanel.setBorder(compound);
        JLabel[] labels = new JLabel[]{new JLabel("Block normal"), new JLabel("Event normal"), new JLabel("Block with error"), new JLabel("Event with error"), new JLabel("Evio struct error"), new JLabel("Word value"), new JLabel("Current selection")};
        labels[0].setBackground(highlightBlkHdr);
        labels[1].setBackground(highlightEvntHdr);
        labels[2].setBackground(highlightBlkHdrErr);
        labels[3].setBackground(highlightEvntHdrErr);
        labels[4].setBackground(highlightNodeErr);
        labels[5].setBackground(highlightValue);
        labels[6].setBackground(Color.yellow);
        for (int i = 0; i < 7; ++i) {
            labels[i].setOpaque(true);
            labels[i].setBorder(blkLineBorder);
            keyInfoPanel.add(labels[i]);
        }
        keyPanel.add((Component)keyInfoPanel, "North");
        this.add((Component)keyPanel, "East");
    }

    private void addControlPanel() {
        JPanel containControlPanel = new JPanel(new BorderLayout());
        this.controlPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.controlPanel, 1);
        this.controlPanel.setLayout(boxLayout);
        CompoundBorder border = new CompoundBorder(BorderFactory.createEtchedBorder(1), new EmptyBorder(5, 5, 5, 5));
        this.controlPanel.setBorder(border);
        Border lineBorder = BorderFactory.createLineBorder(Color.blue);
        AbstractBorder compound = BorderFactory.createCompoundBorder(lineBorder, null);
        compound = BorderFactory.createTitledBorder(compound, "Search By", 2, 2, null, Color.blue);
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new GridLayout(6, 1, 0, 2));
        radioButtonPanel.setMinimumSize(new Dimension(controlPanelWidth, 170));
        radioButtonPanel.setPreferredSize(new Dimension(controlPanelWidth, 170));
        radioButtonPanel.setBorder(compound);
        this.wordValueButton = new JRadioButton("Word Value");
        this.wordValueButton.setMnemonic(86);
        this.wordValueButton.setActionCommand("1");
        this.wordValueButton.setSelected(true);
        this.wordIndexButton = new JRadioButton("Word Position");
        this.wordIndexButton.setMnemonic(73);
        this.wordIndexButton.setActionCommand("2");
        this.pageScrollButton = new JRadioButton("Page Scrolling");
        this.pageScrollButton.setMnemonic(70);
        this.pageScrollButton.setActionCommand("3");
        this.evioBlockButton = new JRadioButton("Evio Block");
        this.evioBlockButton.setMnemonic(66);
        this.evioBlockButton.setActionCommand("4");
        this.evioEventButton = new JRadioButton("Evio Event");
        this.evioEventButton.setMnemonic(69);
        this.evioEventButton.setActionCommand("5");
        this.evioFaultButton = new JRadioButton("Evio Fault");
        this.evioFaultButton.setMnemonic(70);
        this.evioFaultButton.setActionCommand("6");
        this.radioGroup = new ButtonGroup();
        this.radioGroup.add(this.wordValueButton);
        this.radioGroup.add(this.wordIndexButton);
        this.radioGroup.add(this.pageScrollButton);
        this.radioGroup.add(this.evioBlockButton);
        this.radioGroup.add(this.evioEventButton);
        this.radioGroup.add(this.evioFaultButton);
        radioButtonPanel.add(this.wordValueButton);
        radioButtonPanel.add(this.wordIndexButton);
        radioButtonPanel.add(this.pageScrollButton);
        radioButtonPanel.add(this.evioBlockButton);
        radioButtonPanel.add(this.evioEventButton);
        radioButtonPanel.add(this.evioFaultButton);
        this.controlPanel.add(Box.createVerticalStrut(5));
        this.controlPanel.add(radioButtonPanel);
        ActionListener al_radio = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int cmd = Integer.parseInt(FileFrameBig.this.radioGroup.getSelection().getActionCommand());
                switch (cmd) {
                    case 1: {
                        FileFrameBig.this.enableSearchControls();
                        FileFrameBig.this.searchButtonStart.setEnabled(false);
                        FileFrameBig.this.searchStringBox.setEditable(true);
                        FileFrameBig.this.removeEventInfoPanel();
                        FileFrameBig.this.removeBlockInfoPanel();
                        break;
                    }
                    case 2: {
                        FileFrameBig.this.enableControlsForPositionJump();
                        FileFrameBig.this.searchStringBox.setEditable(true);
                        FileFrameBig.this.removeEventInfoPanel();
                        FileFrameBig.this.removeBlockInfoPanel();
                        break;
                    }
                    case 3: {
                        FileFrameBig.this.enableControlsForScrolling();
                        FileFrameBig.this.searchStringBox.setEditable(false);
                        FileFrameBig.this.removeEventInfoPanel();
                        FileFrameBig.this.removeBlockInfoPanel();
                        break;
                    }
                    case 4: {
                        FileFrameBig.this.enableControlsForBlock();
                        FileFrameBig.this.removeEventInfoPanel();
                        break;
                    }
                    case 5: {
                        FileFrameBig.this.enableControlsForEventJump();
                        FileFrameBig.this.searchStringBox.setSelectedIndex(0);
                        FileFrameBig.this.searchStringBox.setEditable(false);
                        FileFrameBig.this.removeBlockInfoPanel();
                        break;
                    }
                    case 6: {
                        FileFrameBig.this.setControlsForErrorScan();
                        break;
                    }
                }
            }
        };
        this.wordValueButton.addActionListener(al_radio);
        this.wordIndexButton.addActionListener(al_radio);
        this.evioBlockButton.addActionListener(al_radio);
        this.evioEventButton.addActionListener(al_radio);
        this.evioFaultButton.addActionListener(al_radio);
        this.pageScrollButton.addActionListener(al_radio);
        ActionListener al_box = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                String selectedItem = (String)jcb.getSelectedItem();
                int numItems = jcb.getItemCount();
                boolean addNewItem = true;
                if (selectedItem == null || selectedItem.equals("") || selectedItem.equals(FileFrameBig.this.searchString)) {
                    return;
                }
                FileFrameBig.this.searchString = selectedItem;
                if (numItems == 0) {
                    addNewItem = true;
                } else {
                    for (int i = 0; i < numItems; ++i) {
                        String listItem = (String)jcb.getItemAt(i);
                        if (!listItem.equals(selectedItem)) continue;
                        addNewItem = false;
                        break;
                    }
                }
                if (addNewItem) {
                    jcb.addItem(selectedItem);
                }
            }
        };
        this.searchStringBox = new JComboBox<String>(new String[]{"0xc0da0100"});
        this.searchStringBox.setEditable(true);
        this.searchStringBox.addActionListener(al_box);
        AbstractBorder compound2 = BorderFactory.createCompoundBorder(lineBorder, null);
        compound2 = BorderFactory.createTitledBorder(compound2, "Search For", 2, 2, null, Color.blue);
        this.searchStringBox.setBorder(compound2);
        this.controlPanel.add(Box.createVerticalStrut(10));
        this.controlPanel.add(this.searchStringBox);
        AbstractBorder compound3 = BorderFactory.createCompoundBorder(lineBorder, null);
        compound3 = BorderFactory.createTitledBorder(compound3, "Search Controls", 2, 2, null, Color.blue);
        JPanel searchPanel = new JPanel();
        searchPanel.setBorder(compound3);
        BoxLayout boxLayout2 = new BoxLayout(searchPanel, 1);
        searchPanel.setLayout(boxLayout2);
        JPanel searchButtonPanel = new JPanel();
        searchButtonPanel.setLayout(new GridLayout(1, 2, 3, 0));
        this.searchButtonPrev = new JButton(" < ");
        ActionListener al_search = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFrameBig.this.stopSearch = false;
                FileFrameBig.this.progressBar.setValue(0);
                FileFrameBig.this.progressBar.setString(null);
                int cmd = Integer.parseInt(FileFrameBig.this.radioGroup.getSelection().getActionCommand());
                switch (cmd) {
                    case 1: {
                        FileFrameBig.this.handleWordValueSearch(false, false);
                        break;
                    }
                    case 2: {
                        FileFrameBig.this.handleWordIndexSearch();
                        FileFrameBig.this.setSliderPosition();
                        break;
                    }
                    case 3: {
                        FileFrameBig.this.setMessage(" ", null, null);
                        FileFrameBig.this.scrollToVisible(false, 1);
                        FileFrameBig.this.setSliderPosition();
                        break;
                    }
                    case 4: {
                        FileFrameBig.this.handleWordValueSearch(false, true);
                        break;
                    }
                    case 5: {
                        EvioHeader node = FileFrameBig.this.handleEventSearchBack();
                        if (node == null) break;
                        FileFrameBig.this.addEventInfoPanel();
                        FileFrameBig.this.updateEventInfoPanel(node);
                        FileFrameBig.this.setSliderPosition();
                        break;
                    }
                    case 6: {
                        FileFrameBig.this.scanBlockErrorEventsBack();
                        break;
                    }
                }
            }
        };
        this.searchButtonPrev.addActionListener(al_search);
        searchButtonPanel.add(this.searchButtonPrev);
        this.searchButtonNext = new JButton(" > ");
        ActionListener al_searchNext = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFrameBig.this.stopSearch = false;
                FileFrameBig.this.progressBar.setValue(0);
                FileFrameBig.this.progressBar.setString(null);
                int cmd = Integer.parseInt(FileFrameBig.this.radioGroup.getSelection().getActionCommand());
                switch (cmd) {
                    case 1: {
                        FileFrameBig.this.handleWordValueSearch(true, false);
                        break;
                    }
                    case 2: {
                        FileFrameBig.this.handleWordIndexSearch();
                        FileFrameBig.this.setSliderPosition();
                        break;
                    }
                    case 3: {
                        FileFrameBig.this.setMessage(" ", null, null);
                        FileFrameBig.this.scrollToVisible(true, 1);
                        FileFrameBig.this.setSliderPosition();
                        break;
                    }
                    case 4: {
                        FileFrameBig.this.handleWordValueSearch(true, true);
                        break;
                    }
                    case 5: {
                        EvioHeader node = FileFrameBig.this.handleEventSearchForward();
                        if (node == null) break;
                        FileFrameBig.this.addEventInfoPanel();
                        FileFrameBig.this.updateEventInfoPanel(node);
                        FileFrameBig.this.setSliderPosition();
                        break;
                    }
                    case 6: {
                        FileFrameBig.this.scanBlockErrorEventsForward();
                        break;
                    }
                }
            }
        };
        this.searchButtonNext.addActionListener(al_searchNext);
        searchButtonPanel.add(this.searchButtonNext);
        searchPanel.add(searchButtonPanel);
        JPanel progressButtonPanel = new JPanel();
        progressButtonPanel.setLayout(new GridLayout(1, 2, 3, 0));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.searchButtonStop = new JButton("Stop");
        ActionListener al_searchStop = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFrameBig.this.stopSearch = true;
                int cmd = Integer.parseInt(FileFrameBig.this.radioGroup.getSelection().getActionCommand());
                switch (cmd) {
                    case 3: {
                        FileFrameBig.this.setMessage(" ", null, null);
                        FileFrameBig.this.scrollToVisible(true, 40);
                        FileFrameBig.this.setSliderPosition();
                        break;
                    }
                }
            }
        };
        this.searchButtonStop.addActionListener(al_searchStop);
        this.searchButtonStart = new JButton("Start Scan");
        ActionListener al_searchStart = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileFrameBig.this.stopSearch = false;
                FileFrameBig.this.progressBar.setValue(0);
                FileFrameBig.this.progressBar.setString(null);
                int cmd = Integer.parseInt(FileFrameBig.this.radioGroup.getSelection().getActionCommand());
                switch (cmd) {
                    case 3: {
                        FileFrameBig.this.setMessage(" ", null, null);
                        FileFrameBig.this.scrollToVisible(false, 40);
                        FileFrameBig.this.setSliderPosition();
                        break;
                    }
                    case 6: {
                        FileFrameBig.this.handleErrorSearch();
                        break;
                    }
                }
            }
        };
        this.searchButtonStart.addActionListener(al_searchStart);
        this.searchButtonStart.setEnabled(false);
        progressButtonPanel.add(this.searchButtonStart);
        progressButtonPanel.add(this.searchButtonStop);
        searchPanel.add(Box.createVerticalStrut(3));
        searchPanel.add(progressButtonPanel);
        searchPanel.add(Box.createVerticalStrut(3));
        searchPanel.add(this.progressBar);
        this.controlPanel.add(Box.createVerticalStrut(10));
        this.controlPanel.add(searchPanel);
        this.viewPosition = new JSlider(1, 0, 1000, 0);
        this.viewPosition.setInverted(true);
        this.viewPosition.setEnabled(false);
        this.add((Component)this.viewPosition, "East");
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new GridLayout(2, 1, 0, 0));
        this.fileNameLabel = new JLabel(this.fileName);
        this.fileNameLabel.setBorder(border);
        this.fileNameLabel.setHorizontalAlignment(0);
        this.messageLabel = new JLabel(" ");
        this.messageLabel.setOpaque(true);
        this.messageLabel.setBorder(border);
        this.messageLabel.setForeground(Color.red);
        this.messageLabel.setHorizontalAlignment(0);
        msgPanel.add(this.fileNameLabel);
        msgPanel.add(this.messageLabel);
        this.add((Component)msgPanel, "North");
        containControlPanel.add((Component)this.controlPanel, "North");
        this.add((Component)containControlPanel, "West");
    }

    private void addFileViewPanel(File file) {
        if (file == null) {
            return;
        }
        try {
            this.mappedMemoryHandler = new SimpleMappedMemoryHandler(file, this.order);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dataTableModel = new MyTableModel(this.mappedMemoryHandler.getFileSize());
        this.dataTable = new JTable(this.dataTableModel);
        this.dataTableRenderer = new MyRenderer(8);
        this.dataTableRenderer.setHorizontalAlignment(4);
        this.dataTable.setDefaultRenderer(String.class, this.dataTableRenderer);
        this.dataTable.setSelectionMode(0);
        this.dataTable.setCellSelectionEnabled(true);
        this.dataTable.setSelectionBackground(Color.yellow);
        this.dataTable.getTableHeader().setReorderingAllowed(false);
        this.dataTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!FileFrameBig.this.searchDone) {
                    return;
                }
                FileFrameBig.this.lastSearchedRow = FileFrameBig.this.dataTable.getSelectedRow();
                FileFrameBig.this.lastSearchedCol = FileFrameBig.this.dataTable.getSelectedColumn();
                if (FileFrameBig.this.dataTableModel.isDataColumn(FileFrameBig.this.lastSearchedCol) && FileFrameBig.this.evioEventButton.isSelected()) {
                    long wordIndex = FileFrameBig.this.dataTableModel.getWordIndexOf(FileFrameBig.this.lastSearchedRow, FileFrameBig.this.lastSearchedCol);
                    EvioHeader node = new EvioHeader((int)FileFrameBig.this.dataTableModel.getLongValueAt(wordIndex), (int)FileFrameBig.this.dataTableModel.getLongValueAt(wordIndex + 1L));
                    FileFrameBig.this.addEventInfoPanel();
                    FileFrameBig.this.updateEventInfoPanel(node);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        Font newFont = new Font("Monospaced", 0, this.dataTable.getFont().getSize());
        this.dataTable.setFont(newFont);
        this.tablePane = new JScrollPane(this.dataTable);
        this.setTableData();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.tablePane, "Center");
        this.add((Component)panel, "Center");
    }

    void setTableData() {
        this.dataTableModel.fireTableDataChanged();
    }

    private void sizeToScreen(JFrame frame, double fractionalSize) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d.width = (int)(fractionalSize * 0.7 * (double)d.width);
        d.height = (int)(fractionalSize * (double)d.height);
        frame.setSize(d);
        this.centerComponent(frame);
    }

    private void centerComponent(Component component) {
        if (component == null) {
            return;
        }
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension componentSize = component.getSize();
            if (componentSize.height > screenSize.height) {
                componentSize.height = screenSize.height;
            }
            if (componentSize.width > screenSize.width) {
                componentSize.width = screenSize.width;
            }
            int x = (screenSize.width - componentSize.width) / 2;
            int y = (screenSize.height - componentSize.height) / 2;
            component.setLocation(x, y);
        }
        catch (Exception e) {
            component.setLocation(200, 200);
            e.printStackTrace();
        }
    }

    private void initializeLookAndFeel() {
        UIManager.LookAndFeelInfo[] lnfinfo = UIManager.getInstalledLookAndFeels();
        if (lnfinfo.length < 1) {
            return;
        }
        String desiredLookAndFeel = "Windows";
        for (UIManager.LookAndFeelInfo aLnfinfo : lnfinfo) {
            if (!aLnfinfo.getName().equals(desiredLookAndFeel)) continue;
            try {
                UIManager.setLookAndFeel(aLnfinfo.getClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    final class MyRenderer
    extends DefaultTableCellRenderer {
        private int nthRow;
        private Color alternateRowColor = new Color(235, 245, 255);
        private final HashMap<Long, Color> highlightCells = new HashMap(100);
        private final HashMap<Long, Color> highlightErrors = new HashMap(100);

        public MyRenderer(int nthRow) {
            this.nthRow = nthRow;
        }

        public void clearHighlights() {
            this.highlightCells.clear();
            this.highlightErrors.clear();
        }

        private long getHighlightKey(int map, int row, int col) {
            return ((long)map << 48 | (long)row << 16 | (long)col) & 0xFFF7FFFFFFF00FFL;
        }

        private Color isHighlightCell(int map, int row, int col) {
            Color err = this.highlightErrors.get(this.getHighlightKey(map, row, col));
            if (err != null) {
                return err;
            }
            return this.highlightCells.get(this.getHighlightKey(map, row, col));
        }

        public void setHighlightCell(Color color, int row, int col, boolean isError) {
            if (color == null) {
                color = highlightBlkHdr;
            }
            if (isError) {
                this.highlightErrors.put(this.getHighlightKey(FileFrameBig.this.dataTableModel.getMapIndex(), row, col), color);
            } else {
                this.highlightCells.put(this.getHighlightKey(FileFrameBig.this.dataTableModel.getMapIndex(), row, col), color);
            }
        }

        public void setHighlightCell(Color color, long pos, boolean isError) {
            int[] mrc;
            if (color == null) {
                color = highlightBlkHdr;
            }
            if ((mrc = FileFrameBig.this.dataTableModel.getMapRowCol(pos / 4L)) == null) {
                return;
            }
            if (isError) {
                this.highlightErrors.put(this.getHighlightKey(mrc[0], mrc[1], mrc[2]), color);
            } else {
                this.highlightCells.put(this.getHighlightKey(mrc[0], mrc[1], mrc[2]), color);
            }
        }

        public void removeHighlightCell(int row, int col, boolean isError) {
            if (isError) {
                this.highlightErrors.remove(this.getHighlightKey(FileFrameBig.this.dataTableModel.getMapIndex(), row, col));
            } else {
                this.highlightCells.remove(this.getHighlightKey(FileFrameBig.this.dataTableModel.getMapIndex(), row, col));
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color;
            if (!isSelected) {
                if ((row + 1) % this.nthRow == 0) {
                    super.setBackground(this.alternateRowColor);
                } else {
                    super.setBackground(table.getBackground());
                }
            }
            if ((color = this.isHighlightCell(FileFrameBig.this.dataTableModel.getMapIndex(), row, column)) != null) {
                super.setBackground(color);
            }
            if (isSelected) {
                super.setBackground(table.getSelectionBackground());
            }
            this.setFont(table.getFont());
            this.setValue(value);
            return this;
        }
    }

    final class MyTableModel
    extends AbstractTableModel {
        private long wordOffset;
        private int mapIndex;
        private final long maxWordIndex;
        private final long fileSize;
        private final int mapCount;
        private final int wordsPerRow = 5;
        private final int bytesPerRow = 20;
        private final long maxMapByteSize;
        private final int maxRowsPerMap;
        private final long maxWordsPerMap;
        private long totalRows;
        private final String[] names = new String[]{"Word Position", "+1", "+2", "+3", "+4", "+5", "Comments"};
        private final String[] columnNames = new String[]{this.names[0], this.names[1], this.names[2], this.names[3], this.names[4], this.names[5], this.names[6]};

        public MyTableModel(long fileSize) {
            this.fileSize = fileSize;
            this.maxWordIndex = FileFrameBig.this.mappedMemoryHandler.haveExtraBytes() ? (fileSize - 4L) / 4L + 1L : (fileSize - 4L) / 4L;
            this.mapCount = FileFrameBig.this.mappedMemoryHandler.getMapCount();
            this.maxMapByteSize = FileFrameBig.this.mappedMemoryHandler.getMaxMapSize();
            this.maxWordsPerMap = this.maxMapByteSize / 4L;
            this.maxRowsPerMap = (int)(this.maxWordsPerMap / 5L);
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public SimpleMappedMemoryHandler getMemoryHandler() {
            return FileFrameBig.this.mappedMemoryHandler;
        }

        public ByteOrder order() {
            return FileFrameBig.this.mappedMemoryHandler.getOrder();
        }

        public int getMaxRowsPerMap() {
            return this.maxRowsPerMap;
        }

        public int getMapCount() {
            return this.mapCount;
        }

        public long getTotalRows() {
            if (this.totalRows < 1L) {
                this.totalRows = this.fileSize / 20L;
                int addOne = this.fileSize % 20L > 0L ? 1 : 0;
                this.totalRows += (long)addOne;
            }
            return this.totalRows;
        }

        public int getRowProgress(int currentRow) {
            long rowFromBeginning = this.mapIndex * this.maxRowsPerMap + currentRow;
            int percent = (int)(100L * rowFromBeginning / this.getTotalRows());
            if (percent > 100) {
                return 100;
            }
            return percent;
        }

        public boolean nextMap() {
            if (this.mapIndex == this.mapCount - 1) {
                return false;
            }
            ++this.mapIndex;
            this.wordOffset = (long)this.mapIndex * this.maxWordsPerMap;
            return true;
        }

        public boolean previousMap() {
            if (this.mapIndex == 0) {
                return false;
            }
            --this.mapIndex;
            this.wordOffset = (long)this.mapIndex * this.maxWordsPerMap;
            return true;
        }

        public int getMapIndex() {
            return this.mapIndex;
        }

        public void setMapIndex(int mi) {
            if (mi == this.mapIndex) {
                return;
            }
            this.mapIndex = mi;
            this.wordOffset = (long)this.mapIndex * this.maxWordsPerMap;
            this.fireTableDataChanged();
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        public boolean isDataColumn(int col) {
            return col > 0 && col < this.getColumnCount() - 1;
        }

        public void setWindowData(long wordIndex) {
            long oldMapIndex = this.mapIndex;
            this.mapIndex = FileFrameBig.this.mappedMemoryHandler.getMapIndex(wordIndex);
            if (oldMapIndex == (long)this.mapIndex) {
                return;
            }
            this.fireTableDataChanged();
        }

        public int[] getMapRowCol(long wordIndex) {
            if (wordIndex > this.maxWordIndex || wordIndex < 0L) {
                return null;
            }
            int[] dat = new int[3];
            dat[0] = (int)(wordIndex * 4L / this.maxMapByteSize);
            int byteIndex = (int)(wordIndex * 4L - (long)dat[0] * this.maxMapByteSize);
            dat[1] = byteIndex / 20;
            dat[2] = byteIndex % 20 / 4 + 1;
            return dat;
        }

        public void highLightCell(Color color, int row, int col, boolean isError) {
            FileFrameBig.this.dataTableRenderer.setHighlightCell(color, row, col, isError);
            this.fireTableCellUpdated(row, col);
        }

        public void highLightEventHeader(Color color, int row, int col, boolean isError) {
            FileFrameBig.this.dataTableRenderer.setHighlightCell(color, row, col, isError);
            this.fireTableCellUpdated(row, col);
            if (col != 0) {
                long pos = FileFrameBig.this.dataTableModel.getWordIndexOf(row, col);
                int[] mrc = FileFrameBig.this.dataTableModel.getMapRowCol(pos + 1L);
                if (mrc == null) {
                    return;
                }
                this.setMapIndex(mrc[0]);
                FileFrameBig.this.dataTableRenderer.setHighlightCell(color, mrc[1], mrc[2], isError);
                this.fireTableCellUpdated(mrc[1], mrc[2]);
            }
        }

        public int[] highLightBlockHeader(Color color, int row, int col, boolean isError) {
            int[] blockData = new int[8];
            long index = FileFrameBig.this.dataTableModel.getWordIndexOf(row, col);
            for (int i = 0; i < 8; ++i) {
                blockData[7 - i] = (int)FileFrameBig.this.dataTableModel.getLongValueAt(index - (long)i);
                int[] mrc = FileFrameBig.this.dataTableModel.getMapRowCol(index - (long)i);
                if (mrc == null) {
                    for (int j = 0; j < i; ++j) {
                        int[] mrc2 = FileFrameBig.this.dataTableModel.getMapRowCol(index - (long)j);
                        this.setMapIndex(mrc2[0]);
                        FileFrameBig.this.dataTableRenderer.removeHighlightCell(mrc2[1], mrc2[2], isError);
                        this.fireTableCellUpdated(mrc2[1], mrc2[2]);
                    }
                    return null;
                }
                this.setMapIndex(mrc[0]);
                FileFrameBig.this.dataTableRenderer.setHighlightCell(color, mrc[1], mrc[2], isError);
                this.fireTableCellUpdated(mrc[1], mrc[2]);
            }
            return blockData;
        }

        public void highLightBlockHeader(Color color, long pos, boolean isError) {
            for (int i = 0; i < 8; ++i) {
                FileFrameBig.this.dataTableRenderer.setHighlightCell(color, pos + (long)(4 * i), isError);
            }
        }

        public void highLightEventHeader(Color color, long pos, boolean isError) {
            for (int i = 0; i < 2; ++i) {
                FileFrameBig.this.dataTableRenderer.setHighlightCell(color, pos + (long)(4 * i), isError);
            }
        }

        public void clearHighLights() {
            FileFrameBig.this.dataTableRenderer.clearHighlights();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            int mapCount = FileFrameBig.this.mappedMemoryHandler.getMapCount();
            if (this.mapIndex == mapCount - 1) {
                int mapSize = FileFrameBig.this.mappedMemoryHandler.getMapSize(this.mapIndex);
                int addOne = mapSize % 20 > 0 ? 1 : 0;
                return mapSize / 20 + addOne;
            }
            return this.maxRowsPerMap;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0) {
                return "";
            }
            if (col == 0) {
                return String.format("%,d", this.wordOffset + (long)(row * 5));
            }
            if (col == 6) {
                return FileFrameBig.this.comments.get(row);
            }
            long index = this.wordOffset + (long)(row * 5) + (long)col - 1L;
            if (index > this.maxWordIndex) {
                return "";
            }
            if (index == this.maxWordIndex) {
                switch (FileFrameBig.this.mappedMemoryHandler.getExtraByteCount()) {
                    case 3: {
                        return String.format("0x%06x", FileFrameBig.this.mappedMemoryHandler.getInt(index) & 0xFFFFFF);
                    }
                    case 2: {
                        return String.format("0x%04x", FileFrameBig.this.mappedMemoryHandler.getInt(index) & 0xFFFF);
                    }
                    case 1: {
                        return String.format("0x%02x", FileFrameBig.this.mappedMemoryHandler.getInt(index) & 0xFF);
                    }
                }
            }
            return String.format("0x%08x", FileFrameBig.this.mappedMemoryHandler.getInt(index));
        }

        public long getLongValueAt(int row, int col) {
            if (row < 0 || col == 0 || col == 6) {
                return 0L;
            }
            return this.getLongValueAt(this.wordOffset + (long)(row * 5) + (long)col - 1L);
        }

        public long getLongValueAt(long wordIndex) {
            if (wordIndex < 0L || wordIndex > this.maxWordIndex) {
                return 0L;
            }
            return (long)FileFrameBig.this.mappedMemoryHandler.getInt(wordIndex) & 0xFFFFFFFFL;
        }

        public int getInt(long byteIndex) {
            if (byteIndex < 0L || byteIndex > this.fileSize - 1L) {
                return 0;
            }
            return FileFrameBig.this.mappedMemoryHandler.getIntAtBytePos(byteIndex);
        }

        public int getShort(long byteIndex) {
            if (byteIndex < 0L || byteIndex > this.fileSize - 1L) {
                return 0;
            }
            return FileFrameBig.this.mappedMemoryHandler.getShortAtBytePos(byteIndex);
        }

        public int get(long byteIndex) {
            if (byteIndex < 0L || byteIndex > this.fileSize - 1L) {
                return 0;
            }
            return FileFrameBig.this.mappedMemoryHandler.getByteAtBytePos(byteIndex);
        }

        public long getWordIndexOf(int row, int col) {
            if (col == 0 || col == 6) {
                return 0L;
            }
            return this.wordOffset + (long)(row * 5) + (long)col - 1L;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Long.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 6) {
                FileFrameBig.this.comments.put(row, (String)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    class ErrorScanTask
    extends SwingWorker<Void, Void> {
        @Override
        public Void doInBackground() {
            FileFrameBig.this.enableControlsDuringSearch();
            FileFrameBig.this.addEvioFaultPanel(this);
            return null;
        }

        public void setTaskProgress(int p) {
            this.setProgress(p);
        }

        public boolean stopSearch() {
            return FileFrameBig.this.stopSearch;
        }

        @Override
        public void done() {
            if (this.stopSearch()) {
                FileFrameBig.this.setMessage("Search stopped", Color.red, null);
                FileFrameBig.this.enableControls();
            }
            FileFrameBig.this.searchDone = true;
            FileFrameBig.this.stopSearch = false;
            this.setProgress(0);
            FileFrameBig.this.progressBar.setString("Done");
            FileFrameBig.this.progressBar.setValue(0);
            FileFrameBig.this.setSliderPosition();
            Toolkit.getDefaultToolkit().beep();
            FileFrameBig.this.enableControls();
        }
    }

    class SearchTask
    extends SwingWorker<Void, Void> {
        private final boolean down;
        private final boolean findBlock;
        private final long value;
        private String label;
        private int[] blockData;

        public SearchTask(boolean down, boolean findBlock, long value, String label) {
            this.down = down;
            this.findBlock = findBlock;
            this.value = value;
            this.label = label;
        }

        public int[] getBlockData() {
            return this.blockData;
        }

        @Override
        public Void doInBackground() {
            FileFrameBig.this.enableControlsDuringSearch();
            this.blockData = FileFrameBig.this.scrollToAndHighlight(this.down, this.value, this.findBlock, this.label, this);
            return null;
        }

        public void setTaskProgress(int p) {
            this.setProgress(p);
        }

        @Override
        public void done() {
            FileFrameBig.this.searchDone = true;
            this.setProgress(0);
            FileFrameBig.this.progressBar.setString("Done");
            FileFrameBig.this.progressBar.setValue(0);
            FileFrameBig.this.setSliderPosition();
            if (this.findBlock) {
                if (FileFrameBig.this.blockInfoPanel == null) {
                    FileFrameBig.this.addBlockInfoPanel();
                }
                FileFrameBig.this.updateBlockInfoPanel(this.blockData);
            }
            Toolkit.getDefaultToolkit().beep();
            FileFrameBig.this.enableSearchControls();
        }
    }
}

