/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.eventViewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.tree.TreePath;
import org.jlab.coda.eventViewer.HeaderPanel;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;

public class EventTreePanel
extends JPanel
implements TreeSelectionListener {
    private HeaderPanel headerPanel = new HeaderPanel();
    private JTree tree;
    private JTable dataTable;
    private JTextArea dataText;
    private JScrollPane treePane;
    private JScrollPane tablePane;
    private JScrollPane textPane;
    private JScrollPane dictionaryPane;
    private JSplitPane splitPane;
    private JTextPane dictionaryArea;
    private EvioEvent event;
    private boolean intsInHex;
    private int orientation = 1;
    int verticalDividerPosition = 400;
    int horizontalDividerPosition = 500;
    boolean viewData = true;
    boolean viewText = false;
    LinkedList<SelectionInfo> structureSelection = new LinkedList();

    public EventTreePanel() {
        this.setLayout(new BorderLayout());
        this.addComponents();
    }

    public LinkedList<SelectionInfo> getStructureSelection() {
        return this.structureSelection;
    }

    public void setIntsInHex(boolean intsInHex) {
        this.intsInHex = intsInHex;
    }

    public HeaderPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public void refreshDisplay() {
        this.valueChanged(null);
    }

    public void refreshDescription() {
        this.headerPanel.setDescription((BaseStructure)this.event);
    }

    void setOrientation(int orient) {
        if (orient == this.orientation) {
            return;
        }
        this.splitPane.setOrientation(orient);
        if (orient == 1) {
            this.splitPane.setDividerLocation(this.horizontalDividerPosition);
            this.orientation = 1;
        } else {
            this.splitPane.setDividerLocation(this.verticalDividerPosition);
            this.orientation = 0;
        }
        this.splitPane.updateUI();
    }

    int getOrientation() {
        return this.orientation;
    }

    void switchDataAndDictionary() {
        if (this.viewData) {
            this.splitPane.remove(this.tablePane);
            this.splitPane.add(this.dictionaryPane);
        } else {
            this.splitPane.remove(this.dictionaryPane);
            this.splitPane.add(this.tablePane);
        }
        if (this.orientation == 1) {
            this.splitPane.setDividerLocation(this.horizontalDividerPosition);
        } else {
            this.splitPane.setDividerLocation(this.verticalDividerPosition);
        }
        this.viewData = !this.viewData;
    }

    void switchDataAndText(boolean toText) {
        if (toText) {
            if (this.viewText) {
                return;
            }
            this.splitPane.remove(this.tablePane);
            this.splitPane.add(this.textPane);
            this.viewText = true;
            if (this.orientation == 1) {
                this.splitPane.setDividerLocation(this.horizontalDividerPosition);
            } else {
                this.splitPane.setDividerLocation(this.verticalDividerPosition);
            }
        } else if (this.viewText) {
            this.splitPane.remove(this.textPane);
            this.splitPane.add(this.tablePane);
            this.viewText = false;
            if (this.orientation == 1) {
                this.splitPane.setDividerLocation(this.horizontalDividerPosition);
            } else {
                this.splitPane.setDividerLocation(this.verticalDividerPosition);
            }
        }
    }

    void setDictionaryText(String xml) {
        StyledDocument doc = this.dictionaryArea.getStyledDocument();
        try {
            doc.remove(0, doc.getLength());
            if (xml == null || xml.length() < 1) {
                doc.insertString(0, "No dictionary in use", doc.getStyle("title"));
            } else {
                doc.insertString(0, "Dictionary:\n\n", doc.getStyle("title"));
                doc.insertString(13, xml, doc.getStyle("regular"));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void addTableColumn() {
        MyTableModel model = (MyTableModel)this.dataTable.getModel();
        int colCount = model.getColumnCount();
        if (colCount > 9) {
            return;
        }
        model.columnNames = new String[colCount + 1];
        System.arraycopy(model.names, 0, model.columnNames, 0, colCount + 1);
        if (model.stringData != null && model.stringData.length > 0) {
            int dataItemCount = model.stringData.length;
            int newColCount = colCount + 1;
            int newRowCount = dataItemCount / newColCount;
            newRowCount = dataItemCount % newColCount > 0 ? newRowCount + 1 : newRowCount;
            model.data = new Object[newRowCount][newColCount];
            int counter = 0;
            block0: for (int row = 0; row < newRowCount; ++row) {
                for (int col = 0; col < newColCount; ++col) {
                    model.data[row][col] = model.stringData[counter++];
                    if (counter >= dataItemCount) break block0;
                }
            }
        }
        model.fireTableStructureChanged();
    }

    void removeTableColumn() {
        MyTableModel model = (MyTableModel)this.dataTable.getModel();
        int colCount = model.getColumnCount();
        if (colCount < 2) {
            return;
        }
        model.columnNames = new String[colCount - 1];
        System.arraycopy(model.names, 0, model.columnNames, 0, colCount - 1);
        if (model.stringData != null && model.stringData.length > 0) {
            int dataItemCount = model.stringData.length;
            int newColCount = colCount - 1;
            int newRowCount = dataItemCount / newColCount;
            newRowCount = dataItemCount % newColCount > 0 ? newRowCount + 1 : newRowCount;
            model.data = new Object[newRowCount][newColCount];
            int counter = 0;
            block0: for (int row = 0; row < newRowCount; ++row) {
                for (int col = 0; col < newColCount; ++col) {
                    model.data[row][col] = model.stringData[counter++];
                    if (counter >= dataItemCount) break block0;
                }
            }
        }
        model.fireTableStructureChanged();
    }

    void setTableData(String[] data) {
        MyTableModel model = (MyTableModel)this.dataTable.getModel();
        if (data == null || data.length < 1) {
            model.data = null;
            model.fireTableDataChanged();
            return;
        }
        model.stringData = data;
        int colCount = model.columnNames.length;
        int rowCount = data.length / colCount;
        rowCount = data.length % colCount > 0 ? rowCount + 1 : rowCount;
        model.data = new Object[rowCount][colCount];
        int counter = 0;
        int dataCount = data.length;
        block0: for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                model.data[row][col] = data[counter];
                if (++counter >= dataCount) break block0;
            }
        }
        model.fireTableDataChanged();
    }

    void setTextData(String[] data) {
        this.dataText.setText("");
        if (data == null || data.length < 1) {
            return;
        }
        for (String s : data) {
            this.dataText.append(s);
            this.dataText.append("\n");
        }
        this.dataText.moveCaretPosition(0);
    }

    protected void addComponents() {
        this.treePane = this.createTree();
        this.dictionaryArea = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getSize().width < this.getParent().getSize().width;
            }

            @Override
            public void setSize(Dimension d) {
                if (d.width < this.getParent().getSize().width) {
                    d.width = this.getParent().getSize().width;
                }
                super.setSize(d);
            }
        };
        this.dictionaryPane = new JScrollPane(this.dictionaryArea);
        this.dictionaryArea.setEditable(false);
        StyledDocument doc = this.dictionaryArea.getStyledDocument();
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style s = doc.addStyle("title", regular);
        StyleConstants.setFontSize(s, 14);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, Color.BLUE);
        this.dataText = new JTextArea(50, 50);
        this.dataText.setEditable(false);
        this.textPane = new JScrollPane(this.dataText);
        this.dataTable = new JTable(new MyTableModel());
        MyRenderer renderer = new MyRenderer(5);
        renderer.setHorizontalAlignment(4);
        this.dataTable.setDefaultRenderer(String.class, renderer);
        this.dataTable.setSelectionMode(0);
        Font newFont = new Font("Monospaced", 0, this.dataTable.getFont().getSize());
        this.dataTable.setFont(newFont);
        this.tablePane = new JScrollPane(this.dataTable);
        this.splitPane = new JSplitPane(this.orientation);
        this.splitPane.setLeftComponent(this.treePane);
        this.splitPane.setRightComponent(this.tablePane);
        ComponentAdapter cl = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (EventTreePanel.this.orientation == 1) {
                    EventTreePanel.this.horizontalDividerPosition = EventTreePanel.this.splitPane.getDividerLocation();
                } else {
                    EventTreePanel.this.verticalDividerPosition = EventTreePanel.this.splitPane.getDividerLocation();
                }
            }
        };
        this.treePane.addComponentListener(cl);
        this.splitPane.setDividerLocation(this.horizontalDividerPosition);
        this.splitPane.setPreferredSize(new Dimension(1100, 700));
        this.add((Component)this.splitPane, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.headerPanel, "Center");
        this.add((Component)panel, "South");
    }

    private JScrollPane createTree() {
        this.tree = new JTree();
        this.tree.setModel(null);
        this.tree.setBorder(BorderFactory.createTitledBorder(null, "EVIO event tree", 4, 2, null, Color.blue));
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        return new JScrollPane(this.tree);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        BaseStructure structure = (BaseStructure)this.tree.getLastSelectedPathComponent();
        if (structure == null) {
            return;
        }
        this.headerPanel.setHeader(structure);
        this.structureSelection.clear();
        if (!structure.isLeaf()) {
            this.setTableData(null);
            this.setTextData(null);
        } else {
            Object[] pathItems;
            TreePath selectionPath = this.tree.getSelectionPath();
            if (selectionPath != null && (pathItems = selectionPath.getPath()).length > 0) {
                for (int i = 0; i < pathItems.length; ++i) {
                    BaseStructure bs = (BaseStructure)pathItems[i];
                    int pos = 0;
                    BaseStructure parent = bs.getParent();
                    if (parent != null) {
                        Object iter = parent.getChildrenList().iterator();
                        int j = 0;
                        while (iter.hasNext()) {
                            BaseStructure bsKid = (BaseStructure)iter.next();
                            if (bsKid == bs) {
                                pos = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    this.structureSelection.add(new SelectionInfo(bs.getHeader().getTag(), pos));
                }
            }
            int counter = 0;
            BaseStructureHeader header = structure.getHeader();
            switch (header.getDataType()) {
                case DOUBLE64: {
                    this.switchDataAndText(false);
                    double[] doubledata = structure.getDoubleData();
                    if (doubledata == null) break;
                    String[] stringData = new String[doubledata.length];
                    for (double d : doubledata) {
                        stringData[counter++] = String.format("%15.11e", d);
                    }
                    this.setTableData(stringData);
                    break;
                }
                case FLOAT32: {
                    this.switchDataAndText(false);
                    float[] floatdata = structure.getFloatData();
                    if (floatdata != null) {
                        String[] stringData = new String[floatdata.length];
                        for (float d : floatdata) {
                            stringData[counter++] = String.format("%10.6e", Float.valueOf(d));
                        }
                        this.setTableData(stringData);
                    }
                }
                case LONG64: 
                case ULONG64: {
                    this.switchDataAndText(false);
                    long[] longdata = structure.getLongData();
                    if (longdata == null) break;
                    String[] stringData = new String[longdata.length];
                    for (long i : longdata) {
                        stringData[counter++] = this.intsInHex ? String.format("%#018x", i) : String.format("%4d", i);
                    }
                    this.setTableData(stringData);
                    break;
                }
                case INT32: 
                case UINT32: {
                    this.switchDataAndText(false);
                    int[] intdata = structure.getIntData();
                    if (intdata == null) break;
                    String[] stringData = new String[intdata.length];
                    for (int i : intdata) {
                        stringData[counter++] = this.intsInHex ? String.format("%#010x", i) : String.format("%4d", i);
                    }
                    this.setTableData(stringData);
                    break;
                }
                case SHORT16: 
                case USHORT16: {
                    this.switchDataAndText(false);
                    short[] shortdata = structure.getShortData();
                    if (shortdata == null) break;
                    String[] stringData = new String[shortdata.length];
                    for (short i : shortdata) {
                        stringData[counter++] = this.intsInHex ? String.format("%#06x", i) : String.format("%4d", i);
                    }
                    this.setTableData(stringData);
                    break;
                }
                case CHAR8: 
                case UCHAR8: {
                    this.switchDataAndText(false);
                    byte[] bytedata = structure.getByteData();
                    if (bytedata == null) break;
                    String[] stringData = new String[bytedata.length];
                    for (byte i : bytedata) {
                        stringData[counter++] = String.format("%4d", i);
                    }
                    this.setTableData(stringData);
                    break;
                }
                case CHARSTAR8: {
                    String[] stringData = structure.getStringData();
                    boolean inTable = true;
                    if (stringData != null && stringData.length > 0) {
                        int max;
                        int len = stringData[0].length();
                        int n = max = len > 100 ? 100 : len - 1;
                        if (len > 50 || stringData[0].substring(0, max).contains("\n")) {
                            inTable = false;
                        }
                    }
                    if (inTable) {
                        this.switchDataAndText(false);
                        this.setTableData(structure.getStringData());
                        break;
                    }
                    this.switchDataAndText(true);
                    this.setTextData(stringData);
                    break;
                }
                case COMPOSITE: {
                    try {
                        this.switchDataAndText(true);
                        CompositeData[] cData = structure.getCompositeData();
                        if (cData == null) break;
                        String[] stringData = new String[cData.length];
                        for (CompositeData cd : cData) {
                            stringData[counter++] = cd.toXML(this.intsInHex);
                        }
                        this.setTextData(stringData);
                    }
                    catch (EvioException evioException) {}
                    break;
                }
            }
        }
        this.tree.repaint();
    }

    void repaintTreeAfterNewDictionary() {
        TreePath currentSelection = this.tree.getSelectionPath();
        this.tree.setModel(null);
        if (this.event != null) {
            this.tree.setModel(this.event.getTreeModel());
        }
        this.expandAll();
        this.tree.setSelectionPath(currentSelection);
    }

    TreePath getNewSelectionPath() {
        if (this.structureSelection.size() < 1) {
            return null;
        }
        BaseStructure parent = (BaseStructure)this.event.getTreeModel().getRoot();
        SelectionInfo info = this.structureSelection.get(0);
        if (info.tag != parent.getHeader().getTag()) {
            return null;
        }
        Object[] objs = new Object[this.structureSelection.size()];
        objs[0] = parent;
        for (int i = 1; i < this.structureSelection.size(); ++i) {
            info = this.structureSelection.get(i);
            if (info.pos + 1 > parent.getChildCount()) {
                return null;
            }
            BaseStructure kid = (BaseStructure)parent.getChildren().get(info.pos);
            if (info.tag != kid.getHeader().getTag()) {
                return null;
            }
            parent = kid;
            objs[i] = parent;
        }
        return new TreePath(objs);
    }

    public EvioEvent getEvent() {
        return this.event;
    }

    public void setEvent(EvioEvent event) {
        this.event = event;
        if (event != null) {
            this.tree.setModel(event.getTreeModel());
            this.headerPanel.setHeader((BaseStructure)event);
            this.expandAll();
            TreePath newSelection = this.getNewSelectionPath();
            if (newSelection == null) {
                this.setTableData(null);
                this.setTextData(null);
            } else {
                this.tree.setSelectionPath(newSelection);
            }
        } else {
            this.tree.setModel(null);
            this.headerPanel.setHeader(null);
        }
    }

    public void expandAll() {
        if (this.tree != null) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
        }
    }

    private static class MyRenderer
    extends DefaultTableCellRenderer {
        int nthRow;
        Color alternateRowColor = new Color(225, 235, 245);

        public MyRenderer(int nthRow) {
            this.nthRow = nthRow;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(table.getForeground());
                if ((row + 1) % this.nthRow == 0) {
                    super.setBackground(this.alternateRowColor);
                } else {
                    super.setBackground(table.getBackground());
                }
            }
            this.setFont(table.getFont());
            this.setValue(value);
            return this;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        String[] names = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        String[] columnNames = new String[]{this.names[0], this.names[1], this.names[2], this.names[3], this.names[4]};
        Object[][] data;
        String[] stringData;

        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.data == null) {
                return null;
            }
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    private class SelectionInfo {
        int tag;
        int pos;

        SelectionInfo(int tag, int pos) {
            this.tag = tag;
            this.pos = pos;
        }
    }
}

