/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.eventViewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jlab.coda.eventViewer.EventInfoPanel;
import org.jlab.coda.eventViewer.EventTreeMenu;
import org.jlab.coda.eventViewer.EventTreePanel;

public class EventTreeFrame
extends JFrame {
    public EventTreeFrame() {
        super("Jevio Event Tree");
        this.initializeLookAndFeel();
        WindowAdapter wa = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                System.out.println("Exiting.");
                System.exit(0);
            }
        };
        this.addWindowListener(wa);
        this.addComponents();
        this.sizeToScreen(this, 0.85);
    }

    protected void addComponents() {
        File dictFile;
        this.setLayout(new BorderLayout());
        EventTreePanel eventTreePanel = new EventTreePanel();
        EventInfoPanel eventInfoPanel = new EventInfoPanel();
        EventTreeMenu eventTreeMenu = new EventTreeMenu(eventTreePanel, eventInfoPanel);
        this.addMenus(eventTreeMenu);
        JPanel eventControlPanel = eventTreeMenu.addEventControlPanel();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)eventControlPanel, "West");
        topPanel.add((Component)eventInfoPanel, "Center");
        this.add((Component)eventTreePanel, "Center");
        this.add((Component)topPanel, "North");
        String tmp = System.getProperty("dictionary");
        if (tmp != null && (dictFile = new File(tmp)).exists() && dictFile.isFile()) {
            eventTreeMenu.openDictionaryFile(dictFile);
        }
    }

    protected void addMenus(EventTreeMenu eventTreeMenu) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(eventTreeMenu.createFileMenu());
        menuBar.add(eventTreeMenu.createViewMenu());
        menuBar.add(eventTreeMenu.createDictionaryMenu());
        menuBar.add(eventTreeMenu.createEventMenu());
        menuBar.add(eventTreeMenu.createFilterMenu());
        this.setJMenuBar(menuBar);
    }

    private void sizeToScreen(JFrame frame, double fractionalSize) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d.width = (int)(fractionalSize * 0.65 * (double)d.width);
        d.height = (int)(fractionalSize * (double)d.height);
        frame.setSize(d);
        this.centerComponent(frame);
    }

    private void centerComponent(Component component) {
        if (component == null) {
            return;
        }
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension componentSize = component.getSize();
            if (componentSize.height > screenSize.height) {
                componentSize.height = screenSize.height;
            }
            if (componentSize.width > screenSize.width) {
                componentSize.width = screenSize.width;
            }
            int x = (screenSize.width - componentSize.width) / 2;
            int y = (screenSize.height - componentSize.height) / 2;
            component.setLocation(x, y);
        }
        catch (Exception e) {
            component.setLocation(200, 200);
            e.printStackTrace();
        }
    }

    private void initializeLookAndFeel() {
        UIManager.LookAndFeelInfo[] lnfinfo = UIManager.getInstalledLookAndFeels();
        if (lnfinfo == null || lnfinfo.length < 1) {
            return;
        }
        String desiredLookAndFeel = "Windows";
        for (int i = 0; i < lnfinfo.length; ++i) {
            if (!lnfinfo[i].getName().equals(desiredLookAndFeel)) continue;
            try {
                UIManager.setLookAndFeel(lnfinfo[i].getClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    private static void decodeCommandLine(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("-h") && !arg.equalsIgnoreCase("-help")) continue;
            EventTreeFrame.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java org.jlab.coda.eventViewer.EventTreeFrame\n        [-h]                   print this help\n        [-help]                print this help\n        [-DfilePath=xxx]       set default directory for data files\n        [-DdictionaryPath=xxx] set default dictionary for dictionary files\n        [-Ddictionary=xxx]     set name of default dictionary file\n");
    }

    public static void main(String[] args) {
        EventTreeFrame.decodeCommandLine(args);
        final EventTreeFrame frame = new EventTreeFrame();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }
}

