/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgCallbackAdapter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.cMsgSubscriptionHandle;

public class cMsgTestRcClient {
    private cMsg cmsg;
    private boolean debug;
    private String UDL;

    cMsgTestRcClient(String[] args) {
        this.decodeCommandLine(args);
    }

    public static void main(String[] args) throws cMsgException {
        cMsgTestRcClient client = new cMsgTestRcClient(args);
        client.run();
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgTestRcClient.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            cMsgTestRcClient.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgTestRcClient\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-debug]             turn on printout\n        [-h]                 print this help\n");
    }

    public void run() throws cMsgException {
        String[] ips;
        System.out.println("Starting RC domain test client");
        if (this.UDL == null) {
            this.UDL = "cMsg:rc://multicast/testExpid?connectTO=0";
        }
        this.cmsg = new cMsg(this.UDL, "java rc client", "rc trial");
        this.cmsg.connect();
        System.out.println("CONNECTED");
        cMsgMessage returnMsg = this.cmsg.monitor("3000");
        cMsgPayloadItem ipItem = returnMsg.getPayloadItem("IpAddresses");
        System.out.println("MONITORED: senderHost = " + returnMsg.getSenderHost());
        for (String ip : ips = ipItem.getStringArray()) {
            System.out.println("           payload ip = " + ip);
        }
        this.cmsg.start();
        myCallback cb3 = new myCallback();
        cMsgSubscriptionHandle unsub = this.cmsg.subscribe("rcSubject", "rcType", cb3, null);
        sAndGCallback cb22 = new sAndGCallback();
        cMsgSubscriptionHandle unsub2 = this.cmsg.subscribe("sAndGSubject", "sAndGType", cb22, null);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        cMsgMessage msg = new cMsgMessage();
        msg.setSubject("subby");
        msg.setType("typey");
        msg.setText("Send with TCP");
        cMsgPayloadItem item = new cMsgPayloadItem("severity", "really severe");
        msg.addPayloadItem(item);
        System.out.println("Send subby, typey with TCP");
        this.cmsg.send(msg);
        msg.setText("Send with UDP");
        msg.setReliableSend(false);
        System.out.println("Send subby, typey with UDP");
        this.cmsg.send(msg);
        System.out.println("Sleep for 4 sec");
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.cmsg.stop();
        this.cmsg.unsubscribe(unsub);
        this.cmsg.unsubscribe(unsub2);
        this.cmsg.disconnect();
    }

    class sAndGCallback
    extends cMsgCallbackAdapter {
        sAndGCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            if (!msg.isGetRequest()) {
                System.out.println("Callback received non-sendAndGet msg - ignoring");
                return;
            }
            try {
                cMsgMessage sendMsg;
                try {
                    System.out.println("Callback received sendAndGet msg (" + msg.getSubject() + ", " + msg.getType() + ") - responding");
                    sendMsg = msg.response();
                    cMsgPayloadItem item = new cMsgPayloadItem("payloadItem", "any string you want");
                    sendMsg.addPayloadItem(item);
                }
                catch (cMsgException e) {
                    e.printStackTrace();
                    return;
                }
                sendMsg.setSubject("RESPONDING");
                sendMsg.setType("TO MESSAGE");
                sendMsg.setText("responder's text");
                cMsgTestRcClient.this.cmsg.send(sendMsg);
            }
            catch (cMsgException e) {
                e.printStackTrace();
            }
        }
    }

    class myCallback
    extends cMsgCallbackAdapter {
        myCallback() {
        }

        @Override
        public void callback(cMsgMessage msg, Object userObject) {
            System.out.println("Got msg with sub = " + msg.getSubject() + ", typ = " + msg.getType() + ", msg # = " + msg.getUserInt());
            msg.payloadPrintout(0);
        }
    }
}

