/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.cMsg.test;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.cMsg.cMsgPayloadItem;
import org.jlab.coda.cMsg.common.cMsgMessageFull;

public class cMsgSerializeTest {
    private static String UDL = "cMsg://localhost/cMsg/myNameSpace";
    private static cMsg cmsg = null;
    private static String name = null;
    private static String description = null;
    private static String dir = null;
    private static String base = null;
    private static String fileBase = null;

    public static void main(String[] args) {
        cMsgSerializeTest.decode_command_line(args);
        cMsgMessageFull msg = new cMsgMessageFull();
        msg.setSubject("aSubject");
        msg.setType("aType");
        msg.setText("hello world");
        msg.setUserInt(123);
        byte[] b = new byte[32];
        for (int i = 0; i < 32; ++i) {
            b[i] = (byte)i;
        }
        msg.setByteArray(b);
        try {
            msg.addPayloadItem(new cMsgPayloadItem("anInt", 123));
            msg.addPayloadItem(new cMsgPayloadItem("aFloat", 234.0f));
            msg.addPayloadItem(new cMsgPayloadItem("aDouble", 345.0));
            msg.addPayloadItem(new cMsgPayloadItem("aString", "this is a payload string"));
            msg.addPayloadItem(new cMsgPayloadItem("Int8Array", b));
            cMsgMessage mcopy = new cMsgMessage(msg);
            msg.addPayloadItem(new cMsgPayloadItem("message", mcopy));
        }
        catch (cMsgException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("The message:");
        System.out.println(msg.toString());
        System.out.println("");
        System.out.println("Payload text:");
        System.out.println(msg.getPayloadText());
        System.out.println("");
        msg.compressPayload();
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream("serialize.dat");
            out = new ObjectOutputStream(fos);
            out.writeObject(msg);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream("serialize.dat");
            in = new ObjectInputStream(fis);
            cMsgMessageFull mm = (cMsgMessageFull)in.readObject();
            in.close();
            System.out.println("Deserialized message:");
            System.out.println(mm.toString());
            System.out.println("");
            System.out.println("Payload text:");
            System.out.println(mm.getPayloadText());
            System.out.println("");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    private static void decode_command_line(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-name")) {
                name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-descr")) {
                description = args[i + 1];
                ++i;
                continue;
            }
            if (!args[i].equalsIgnoreCase("-udl")) continue;
            UDL = args[i + 1];
            ++i;
        }
    }
}

